// media/mojo/mojom/video_encode_accelerator.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media {
namespace mojom {
class VideoEncodeAcceleratorSupportedProfileDataView;

class VideoBitrateAllocationDataView;

class SpatialLayerDataView;

class VideoEncodeAcceleratorConfigDataView;

class Vp8MetadataDataView;

class Vp9MetadataDataView;

class BitstreamBufferMetadataDataView;

class CodecMetadataDataView;


}  // namespace mojom
}  // namespace media

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView> {
  using Data = ::media::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoBitrateAllocationDataView> {
  using Data = ::media::mojom::internal::VideoBitrateAllocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SpatialLayerDataView> {
  using Data = ::media::mojom::internal::SpatialLayer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEncodeAcceleratorConfigDataView> {
  using Data = ::media::mojom::internal::VideoEncodeAcceleratorConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::Vp8MetadataDataView> {
  using Data = ::media::mojom::internal::Vp8Metadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::Vp9MetadataDataView> {
  using Data = ::media::mojom::internal::Vp9Metadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BitstreamBufferMetadataDataView> {
  using Data = ::media::mojom::internal::BitstreamBufferMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CodecMetadataDataView> {
  using Data = ::media::mojom::internal::CodecMetadata_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media {
namespace mojom {


enum class VideoEncodeAcceleratorConfig_ContentType : int32_t {
  
  kCamera = 0,
  
  kDisplay = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_ContentType value);
inline bool IsKnownEnumValue(VideoEncodeAcceleratorConfig_ContentType value) {
  return internal::VideoEncodeAcceleratorConfig_ContentType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoEncodeAcceleratorConfig_StorageType : int32_t {
  
  kShmem = 0,
  
  kDmabuf = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_StorageType value);
inline bool IsKnownEnumValue(VideoEncodeAcceleratorConfig_StorageType value) {
  return internal::VideoEncodeAcceleratorConfig_StorageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoEncodeAccelerator_Error : int32_t {
  
  ILLEGAL_STATE = 0,
  
  INVALID_ARGUMENT = 1,
  
  PLATFORM_FAILURE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAccelerator_Error value);
inline bool IsKnownEnumValue(VideoEncodeAccelerator_Error value) {
  return internal::VideoEncodeAccelerator_Error_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VideoEncodeAcceleratorProviderInterfaceBase {};

using VideoEncodeAcceleratorProviderPtrDataView =
    mojo::InterfacePtrDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
using VideoEncodeAcceleratorProviderRequestDataView =
    mojo::InterfaceRequestDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
using VideoEncodeAcceleratorProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
using VideoEncodeAcceleratorProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
class VideoEncodeAcceleratorInterfaceBase {};

using VideoEncodeAcceleratorPtrDataView =
    mojo::InterfacePtrDataView<VideoEncodeAcceleratorInterfaceBase>;
using VideoEncodeAcceleratorRequestDataView =
    mojo::InterfaceRequestDataView<VideoEncodeAcceleratorInterfaceBase>;
using VideoEncodeAcceleratorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEncodeAcceleratorInterfaceBase>;
using VideoEncodeAcceleratorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEncodeAcceleratorInterfaceBase>;
class VideoEncodeAcceleratorClientInterfaceBase {};

using VideoEncodeAcceleratorClientPtrDataView =
    mojo::InterfacePtrDataView<VideoEncodeAcceleratorClientInterfaceBase>;
using VideoEncodeAcceleratorClientRequestDataView =
    mojo::InterfaceRequestDataView<VideoEncodeAcceleratorClientInterfaceBase>;
using VideoEncodeAcceleratorClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEncodeAcceleratorClientInterfaceBase>;
using VideoEncodeAcceleratorClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEncodeAcceleratorClientInterfaceBase>;


class VideoEncodeAcceleratorSupportedProfileDataView {
 public:
  VideoEncodeAcceleratorSupportedProfileDataView() {}

  VideoEncodeAcceleratorSupportedProfileDataView(
      internal::VideoEncodeAcceleratorSupportedProfile_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }

  ::media::mojom::VideoCodecProfile profile() const {
    return static_cast<::media::mojom::VideoCodecProfile>(data_->profile);
  }
  inline void GetMinResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMinResolution(UserType* output) {
    
    auto* pointer = data_->min_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetMaxResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxResolution(UserType* output) {
    
    auto* pointer = data_->max_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  uint32_t max_framerate_numerator() const {
    return data_->max_framerate_numerator;
  }
  uint32_t max_framerate_denominator() const {
    return data_->max_framerate_denominator;
  }
 private:
  internal::VideoEncodeAcceleratorSupportedProfile_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VideoBitrateAllocationDataView {
 public:
  VideoBitrateAllocationDataView() {}

  VideoBitrateAllocationDataView(
      internal::VideoBitrateAllocation_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBitratesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBitrates(UserType* output) {
    
    auto* pointer = data_->bitrates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, context_);
  }
 private:
  internal::VideoBitrateAllocation_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SpatialLayerDataView {
 public:
  SpatialLayerDataView() {}

  SpatialLayerDataView(
      internal::SpatialLayer_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t width() const {
    return data_->width;
  }
  int32_t height() const {
    return data_->height;
  }
  uint32_t bitrate_bps() const {
    return data_->bitrate_bps;
  }
  uint32_t framerate() const {
    return data_->framerate;
  }
  uint8_t max_qp() const {
    return data_->max_qp;
  }
  uint8_t num_of_temporal_layers() const {
    return data_->num_of_temporal_layers;
  }
 private:
  internal::SpatialLayer_Data* data_ = nullptr;
};



class VideoEncodeAcceleratorConfigDataView {
 public:
  VideoEncodeAcceleratorConfigDataView() {}

  VideoEncodeAcceleratorConfigDataView(
      internal::VideoEncodeAcceleratorConfig_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputFormat(UserType* output) const {
    auto data_value = data_->input_format;
    return mojo::internal::Deserialize<::media::mojom::VideoPixelFormat>(
        data_value, output);
  }

  ::media::mojom::VideoPixelFormat input_format() const {
    return static_cast<::media::mojom::VideoPixelFormat>(data_->input_format);
  }
  inline void GetInputVisibleSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputVisibleSize(UserType* output) {
    
    auto* pointer = data_->input_visible_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutputProfile(UserType* output) const {
    auto data_value = data_->output_profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }

  ::media::mojom::VideoCodecProfile output_profile() const {
    return static_cast<::media::mojom::VideoCodecProfile>(data_->output_profile);
  }
  uint32_t initial_bitrate() const {
    return data_->initial_bitrate;
  }
  uint32_t initial_framerate() const {
    return data_->initial_framerate;
  }
  bool has_initial_framerate() const {
    return data_->has_initial_framerate;
  }
  uint32_t gop_length() const {
    return data_->gop_length;
  }
  bool has_gop_length() const {
    return data_->has_gop_length;
  }
  uint8_t h264_output_level() const {
    return data_->h264_output_level;
  }
  bool has_h264_output_level() const {
    return data_->has_h264_output_level;
  }
  bool is_constrained_h264() const {
    return data_->is_constrained_h264;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStorageType(UserType* output) const {
    auto data_value = data_->storage_type;
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>(
        data_value, output);
  }

  VideoEncodeAcceleratorConfig_StorageType storage_type() const {
    return static_cast<VideoEncodeAcceleratorConfig_StorageType>(data_->storage_type);
  }
  bool has_storage_type() const {
    return data_->has_storage_type;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentType(UserType* output) const {
    auto data_value = data_->content_type;
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>(
        data_value, output);
  }

  VideoEncodeAcceleratorConfig_ContentType content_type() const {
    return static_cast<VideoEncodeAcceleratorConfig_ContentType>(data_->content_type);
  }
  inline void GetSpatialLayersDataView(
      mojo::ArrayDataView<SpatialLayerDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSpatialLayers(UserType* output) {
    
    auto* pointer = data_->spatial_layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SpatialLayerDataView>>(
        pointer, output, context_);
  }
 private:
  internal::VideoEncodeAcceleratorConfig_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class Vp8MetadataDataView {
 public:
  Vp8MetadataDataView() {}

  Vp8MetadataDataView(
      internal::Vp8Metadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool non_reference() const {
    return data_->non_reference;
  }
  uint8_t temporal_idx() const {
    return data_->temporal_idx;
  }
  bool layer_sync() const {
    return data_->layer_sync;
  }
 private:
  internal::Vp8Metadata_Data* data_ = nullptr;
};



class Vp9MetadataDataView {
 public:
  Vp9MetadataDataView() {}

  Vp9MetadataDataView(
      internal::Vp9Metadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool has_reference() const {
    return data_->has_reference;
  }
  bool temporal_up_switch() const {
    return data_->temporal_up_switch;
  }
  uint8_t temporal_idx() const {
    return data_->temporal_idx;
  }
  inline void GetPDiffsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPDiffs(UserType* output) {
    
    auto* pointer = data_->p_diffs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
 private:
  internal::Vp9Metadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BitstreamBufferMetadataDataView {
 public:
  BitstreamBufferMetadataDataView() {}

  BitstreamBufferMetadataDataView(
      internal::BitstreamBufferMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t payload_size_bytes() const {
    return data_->payload_size_bytes;
  }
  bool key_frame() const {
    return data_->key_frame;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  inline void GetCodecMetadataDataView(
      CodecMetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCodecMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CodecMetadataDataView, UserType>(),
    "Attempting to read the optional `codec_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCodecMetadata` instead "
    "of `ReadCodecMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->codec_metadata.is_null() ? &data_->codec_metadata : nullptr;
    return mojo::internal::Deserialize<::media::mojom::CodecMetadataDataView>(
        pointer, output, context_);
  }
 private:
  internal::BitstreamBufferMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CodecMetadataDataView {
 public:
  using Tag = internal::CodecMetadata_Data::CodecMetadata_Tag;

  CodecMetadataDataView() {}

  CodecMetadataDataView(
      internal::CodecMetadata_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_vp8() const { return data_->tag == Tag::VP8; }
  inline void GetVp8DataView(
      Vp8MetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVp8(UserType* output) {
    
    DCHECK(is_vp8());
    return mojo::internal::Deserialize<::media::mojom::Vp8MetadataDataView>(
        data_->data.f_vp8.Get(), output, context_);
  }
  bool is_vp9() const { return data_->tag == Tag::VP9; }
  inline void GetVp9DataView(
      Vp9MetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVp9(UserType* output) {
    
    DCHECK(is_vp9());
    return mojo::internal::Deserialize<::media::mojom::Vp9MetadataDataView>(
        data_->data.f_vp9.Get(), output, context_);
  }

 private:
  internal::CodecMetadata_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace media

namespace std {

template <>
struct hash<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoEncodeAcceleratorConfig_ContentType> {};

template <>
struct hash<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoEncodeAcceleratorConfig_StorageType> {};

template <>
struct hash<::media::mojom::VideoEncodeAccelerator_Error>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoEncodeAccelerator_Error> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::media::mojom::VideoEncodeAcceleratorConfig_ContentType, ::media::mojom::VideoEncodeAcceleratorConfig_ContentType> {
  static ::media::mojom::VideoEncodeAcceleratorConfig_ContentType ToMojom(::media::mojom::VideoEncodeAcceleratorConfig_ContentType input) { return input; }
  static bool FromMojom(::media::mojom::VideoEncodeAcceleratorConfig_ContentType input, ::media::mojom::VideoEncodeAcceleratorConfig_ContentType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncodeAcceleratorConfig_ContentType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoEncodeAcceleratorConfig_ContentType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::media::mojom::VideoEncodeAcceleratorConfig_StorageType, ::media::mojom::VideoEncodeAcceleratorConfig_StorageType> {
  static ::media::mojom::VideoEncodeAcceleratorConfig_StorageType ToMojom(::media::mojom::VideoEncodeAcceleratorConfig_StorageType input) { return input; }
  static bool FromMojom(::media::mojom::VideoEncodeAcceleratorConfig_StorageType input, ::media::mojom::VideoEncodeAcceleratorConfig_StorageType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncodeAcceleratorConfig_StorageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoEncodeAcceleratorConfig_StorageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::media::mojom::VideoEncodeAccelerator_Error, ::media::mojom::VideoEncodeAccelerator_Error> {
  static ::media::mojom::VideoEncodeAccelerator_Error ToMojom(::media::mojom::VideoEncodeAccelerator_Error input) { return input; }
  static bool FromMojom(::media::mojom::VideoEncodeAccelerator_Error input, ::media::mojom::VideoEncodeAccelerator_Error* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncodeAccelerator_Error, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoEncodeAccelerator_Error, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::media::mojom::VideoEncodeAccelerator_Error>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile(input), &(*output)->profile);
    decltype(Traits::min_resolution(input)) in_min_resolution = Traits::min_resolution(input);
    typename decltype((*output)->min_resolution)::BaseType::BufferWriter
        min_resolution_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_min_resolution, buffer, &min_resolution_writer, context);
    (*output)->min_resolution.Set(
        min_resolution_writer.is_null() ? nullptr : min_resolution_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->min_resolution.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_resolution in VideoEncodeAcceleratorSupportedProfile struct");
    decltype(Traits::max_resolution(input)) in_max_resolution = Traits::max_resolution(input);
    typename decltype((*output)->max_resolution)::BaseType::BufferWriter
        max_resolution_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_max_resolution, buffer, &max_resolution_writer, context);
    (*output)->max_resolution.Set(
        max_resolution_writer.is_null() ? nullptr : max_resolution_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->max_resolution.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_resolution in VideoEncodeAcceleratorSupportedProfile struct");
    (*output)->max_framerate_numerator = Traits::max_framerate_numerator(input);
    (*output)->max_framerate_denominator = Traits::max_framerate_denominator(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoBitrateAllocationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoBitrateAllocationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::VideoBitrateAllocation_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::bitrates(input)) in_bitrates = Traits::bitrates(input);
    typename decltype((*output)->bitrates)::BaseType::BufferWriter
        bitrates_writer;
    const mojo::internal::ContainerValidateParams bitrates_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_bitrates, buffer, &bitrates_writer, &bitrates_validate_params,
        context);
    (*output)->bitrates.Set(
        bitrates_writer.is_null() ? nullptr : bitrates_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->bitrates.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitrates in VideoBitrateAllocation struct");
  }

  static bool Deserialize(::media::mojom::internal::VideoBitrateAllocation_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoBitrateAllocationDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpatialLayerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpatialLayerDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::SpatialLayer_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->width = Traits::width(input);
    (*output)->height = Traits::height(input);
    (*output)->bitrate_bps = Traits::bitrate_bps(input);
    (*output)->framerate = Traits::framerate(input);
    (*output)->max_qp = Traits::max_qp(input);
    (*output)->num_of_temporal_layers = Traits::num_of_temporal_layers(input);
  }

  static bool Deserialize(::media::mojom::internal::SpatialLayer_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SpatialLayerDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncodeAcceleratorConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncodeAcceleratorConfigDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::VideoEncodeAcceleratorConfig_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
        Traits::input_format(input), &(*output)->input_format);
    decltype(Traits::input_visible_size(input)) in_input_visible_size = Traits::input_visible_size(input);
    typename decltype((*output)->input_visible_size)::BaseType::BufferWriter
        input_visible_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_input_visible_size, buffer, &input_visible_size_writer, context);
    (*output)->input_visible_size.Set(
        input_visible_size_writer.is_null() ? nullptr : input_visible_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->input_visible_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_visible_size in VideoEncodeAcceleratorConfig struct");
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::output_profile(input), &(*output)->output_profile);
    (*output)->initial_bitrate = Traits::initial_bitrate(input);
    (*output)->initial_framerate = Traits::initial_framerate(input);
    (*output)->has_initial_framerate = Traits::has_initial_framerate(input);
    (*output)->gop_length = Traits::gop_length(input);
    (*output)->has_gop_length = Traits::has_gop_length(input);
    (*output)->h264_output_level = Traits::h264_output_level(input);
    (*output)->has_h264_output_level = Traits::has_h264_output_level(input);
    (*output)->is_constrained_h264 = Traits::is_constrained_h264(input);
    mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>(
        Traits::storage_type(input), &(*output)->storage_type);
    (*output)->has_storage_type = Traits::has_storage_type(input);
    mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>(
        Traits::content_type(input), &(*output)->content_type);
    decltype(Traits::spatial_layers(input)) in_spatial_layers = Traits::spatial_layers(input);
    typename decltype((*output)->spatial_layers)::BaseType::BufferWriter
        spatial_layers_writer;
    const mojo::internal::ContainerValidateParams spatial_layers_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SpatialLayerDataView>>(
        in_spatial_layers, buffer, &spatial_layers_writer, &spatial_layers_validate_params,
        context);
    (*output)->spatial_layers.Set(
        spatial_layers_writer.is_null() ? nullptr : spatial_layers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->spatial_layers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spatial_layers in VideoEncodeAcceleratorConfig struct");
  }

  static bool Deserialize(::media::mojom::internal::VideoEncodeAcceleratorConfig_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoEncodeAcceleratorConfigDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::Vp8MetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::Vp8MetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::Vp8Metadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->non_reference = Traits::non_reference(input);
    (*output)->temporal_idx = Traits::temporal_idx(input);
    (*output)->layer_sync = Traits::layer_sync(input);
  }

  static bool Deserialize(::media::mojom::internal::Vp8Metadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::Vp8MetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::Vp9MetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::Vp9MetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::Vp9Metadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->has_reference = Traits::has_reference(input);
    (*output)->temporal_up_switch = Traits::temporal_up_switch(input);
    (*output)->temporal_idx = Traits::temporal_idx(input);
    decltype(Traits::p_diffs(input)) in_p_diffs = Traits::p_diffs(input);
    typename decltype((*output)->p_diffs)::BaseType::BufferWriter
        p_diffs_writer;
    const mojo::internal::ContainerValidateParams p_diffs_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_p_diffs, buffer, &p_diffs_writer, &p_diffs_validate_params,
        context);
    (*output)->p_diffs.Set(
        p_diffs_writer.is_null() ? nullptr : p_diffs_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->p_diffs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null p_diffs in Vp9Metadata struct");
  }

  static bool Deserialize(::media::mojom::internal::Vp9Metadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::Vp9MetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::BitstreamBufferMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::BitstreamBufferMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::BitstreamBufferMetadata_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->payload_size_bytes = Traits::payload_size_bytes(input);
    (*output)->key_frame = Traits::key_frame(input);
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    typename decltype((*output)->timestamp)::BaseType::BufferWriter
        timestamp_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timestamp, buffer, &timestamp_writer, context);
    (*output)->timestamp.Set(
        timestamp_writer.is_null() ? nullptr : timestamp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in BitstreamBufferMetadata struct");
    decltype(Traits::codec_metadata(input)) in_codec_metadata = Traits::codec_metadata(input);
    typename decltype((*output)->codec_metadata)::BufferWriter codec_metadata_writer;
    codec_metadata_writer.AllocateInline(buffer, &(*output)->codec_metadata);
    mojo::internal::Serialize<::media::mojom::CodecMetadataDataView>(
        in_codec_metadata, buffer, &codec_metadata_writer, true, context);
  }

  static bool Deserialize(::media::mojom::internal::BitstreamBufferMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::BitstreamBufferMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CodecMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::CodecMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::CodecMetadata_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::media::mojom::internal::CodecMetadata_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::media::mojom::CodecMetadataDataView::Tag::VP8: {
        decltype(Traits::vp8(input))
            in_vp8 = Traits::vp8(input);
        typename decltype(result->data.f_vp8)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::media::mojom::Vp8MetadataDataView>(
            in_vp8, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null vp8 in CodecMetadata union");
        result->data.f_vp8.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::media::mojom::CodecMetadataDataView::Tag::VP9: {
        decltype(Traits::vp9(input))
            in_vp9 = Traits::vp9(input);
        typename decltype(result->data.f_vp9)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::media::mojom::Vp9MetadataDataView>(
            in_vp9, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null vp9 in CodecMetadata union");
        result->data.f_vp9.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::media::mojom::internal::CodecMetadata_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CodecMetadataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media {
namespace mojom {

inline void VideoEncodeAcceleratorSupportedProfileDataView::GetMinResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void VideoEncodeAcceleratorSupportedProfileDataView::GetMaxResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void VideoBitrateAllocationDataView::GetBitratesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->bitrates.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, context_);
}




inline void VideoEncodeAcceleratorConfigDataView::GetInputVisibleSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->input_visible_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void VideoEncodeAcceleratorConfigDataView::GetSpatialLayersDataView(
    mojo::ArrayDataView<SpatialLayerDataView>* output) {
  auto pointer = data_->spatial_layers.Get();
  *output = mojo::ArrayDataView<SpatialLayerDataView>(pointer, context_);
}




inline void Vp9MetadataDataView::GetPDiffsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->p_diffs.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void BitstreamBufferMetadataDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}
inline void BitstreamBufferMetadataDataView::GetCodecMetadataDataView(
    CodecMetadataDataView* output) {
  auto pointer = &data_->codec_metadata;
  *output = CodecMetadataDataView(pointer, context_);
}


inline void CodecMetadataDataView::GetVp8DataView(
    Vp8MetadataDataView* output) {
  DCHECK(is_vp8());
  *output = Vp8MetadataDataView(data_->data.f_vp8.Get(), context_);
}
inline void CodecMetadataDataView::GetVp9DataView(
    Vp9MetadataDataView* output) {
  DCHECK(is_vp9());
  *output = Vp9MetadataDataView(data_->data.f_vp9.Get(), context_);
}


}  // namespace mojom
}  // namespace media

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SHARED_H_