// media/mojo/mojom/speech_recognition_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace media {
namespace mojom {
class SpeechRecognitionResultDataView;



}  // namespace mojom
}  // namespace media

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::SpeechRecognitionResultDataView> {
  using Data = ::media::mojom::internal::SpeechRecognitionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media {
namespace mojom {
// Interface base classes. They are used for type safety check.
class SpeechRecognitionContextInterfaceBase {};

using SpeechRecognitionContextPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionContextInterfaceBase>;
using SpeechRecognitionContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionContextInterfaceBase>;
class SpeechRecognitionServiceInterfaceBase {};

using SpeechRecognitionServicePtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionServiceInterfaceBase>;
using SpeechRecognitionServiceRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionServiceInterfaceBase>;
using SpeechRecognitionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionServiceInterfaceBase>;
using SpeechRecognitionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionServiceInterfaceBase>;
class SpeechRecognitionServiceClientInterfaceBase {};

using SpeechRecognitionServiceClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionServiceClientInterfaceBase>;
using SpeechRecognitionServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionServiceClientInterfaceBase>;
using SpeechRecognitionServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionServiceClientInterfaceBase>;
using SpeechRecognitionServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionServiceClientInterfaceBase>;
class SpeechRecognitionRecognizerInterfaceBase {};

using SpeechRecognitionRecognizerPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionRecognizerInterfaceBase>;
using SpeechRecognitionRecognizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionRecognizerInterfaceBase>;
class SpeechRecognitionRecognizerClientInterfaceBase {};

using SpeechRecognitionRecognizerClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionRecognizerClientInterfaceBase>;
using SpeechRecognitionRecognizerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionRecognizerClientInterfaceBase>;


class SpeechRecognitionResultDataView {
 public:
  SpeechRecognitionResultDataView() {}

  SpeechRecognitionResultDataView(
      internal::SpeechRecognitionResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTranscriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTranscription(UserType* output) {
    
    auto* pointer = data_->transcription.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool is_final() const {
    return data_->is_final;
  }
 private:
  internal::SpeechRecognitionResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace media

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechRecognitionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpeechRecognitionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::SpeechRecognitionResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::transcription(input)) in_transcription = Traits::transcription(input);
    typename decltype((*output)->transcription)::BaseType::BufferWriter
        transcription_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_transcription, buffer, &transcription_writer, context);
    (*output)->transcription.Set(
        transcription_writer.is_null() ? nullptr : transcription_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->transcription.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transcription in SpeechRecognitionResult struct");
    (*output)->is_final = Traits::is_final(input);
  }

  static bool Deserialize(::media::mojom::internal::SpeechRecognitionResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SpeechRecognitionResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media {
namespace mojom {

inline void SpeechRecognitionResultDataView::GetTranscriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->transcription.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace media

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_SHARED_H_