// gpu/ipc/common/vulkan_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/vulkan_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "gpu/ipc/common/vulkan_types.mojom-params-data.h"
namespace gpu {
namespace mojom {

std::ostream& operator<<(std::ostream& os, VkPhysicalDeviceType value) {
  switch(value) {
    case VkPhysicalDeviceType::INVALID_VALUE:
      return os << "VkPhysicalDeviceType::INVALID_VALUE";
    case VkPhysicalDeviceType::OTHER:
      return os << "VkPhysicalDeviceType::OTHER";
    case VkPhysicalDeviceType::INTEGRATED_GPU:
      return os << "VkPhysicalDeviceType::INTEGRATED_GPU";
    case VkPhysicalDeviceType::DISCRETE_GPU:
      return os << "VkPhysicalDeviceType::DISCRETE_GPU";
    case VkPhysicalDeviceType::VIRTUAL_GPU:
      return os << "VkPhysicalDeviceType::VIRTUAL_GPU";
    case VkPhysicalDeviceType::CPU:
      return os << "VkPhysicalDeviceType::CPU";
    default:
      return os << "Unknown VkPhysicalDeviceType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool VkExtensionProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkExtensionProperties_Data* object = static_cast<const VkExtensionProperties_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensionName, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extensionName_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extensionName, validation_context,
                                         &extensionName_validate_params)) {
    return false;
  }

  return true;
}

VkExtensionProperties_Data::VkExtensionProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkLayerProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkLayerProperties_Data* object = static_cast<const VkLayerProperties_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layerName, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams layerName_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->layerName, validation_context,
                                         &layerName_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

VkLayerProperties_Data::VkLayerProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceLimits_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkPhysicalDeviceLimits_Data* object = static_cast<const VkPhysicalDeviceLimits_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 488 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maxComputeWorkGroupCount, 53, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams maxComputeWorkGroupCount_validate_params(
      3, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->maxComputeWorkGroupCount, validation_context,
                                         &maxComputeWorkGroupCount_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maxComputeWorkGroupSize, 55, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams maxComputeWorkGroupSize_validate_params(
      3, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->maxComputeWorkGroupSize, validation_context,
                                         &maxComputeWorkGroupSize_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maxViewportDimensions, 64, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams maxViewportDimensions_validate_params(
      2, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->maxViewportDimensions, validation_context,
                                         &maxViewportDimensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewportBoundsRange, 65, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams viewportBoundsRange_validate_params(
      2, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->viewportBoundsRange, validation_context,
                                         &viewportBoundsRange_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointSizeRange, 98, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pointSizeRange_validate_params(
      2, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->pointSizeRange, validation_context,
                                         &pointSizeRange_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lineWidthRange, 99, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lineWidthRange_validate_params(
      2, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->lineWidthRange, validation_context,
                                         &lineWidthRange_validate_params)) {
    return false;
  }

  return true;
}

VkPhysicalDeviceLimits_Data::VkPhysicalDeviceLimits_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceSparseProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkPhysicalDeviceSparseProperties_Data* object = static_cast<const VkPhysicalDeviceSparseProperties_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VkPhysicalDeviceSparseProperties_Data::VkPhysicalDeviceSparseProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkPhysicalDeviceProperties_Data* object = static_cast<const VkPhysicalDeviceProperties_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 64 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::gpu::mojom::internal::VkPhysicalDeviceType_Data
        ::Validate(object->deviceType, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deviceName, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams deviceName_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->deviceName, validation_context,
                                         &deviceName_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pipelineCacheUUID, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pipelineCacheUUID_validate_params(
      16, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->pipelineCacheUUID, validation_context,
                                         &pipelineCacheUUID_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->limits, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->limits, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sparseProperties, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sparseProperties, validation_context))
    return false;

  return true;
}

VkPhysicalDeviceProperties_Data::VkPhysicalDeviceProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkPhysicalDeviceFeatures_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkPhysicalDeviceFeatures_Data* object = static_cast<const VkPhysicalDeviceFeatures_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VkPhysicalDeviceFeatures_Data::VkPhysicalDeviceFeatures_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkExtent3D_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkExtent3D_Data* object = static_cast<const VkExtent3D_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VkExtent3D_Data::VkExtent3D_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VkQueueFamilyProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VkQueueFamilyProperties_Data* object = static_cast<const VkQueueFamilyProperties_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minImageTransferGranularity, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minImageTransferGranularity, validation_context))
    return false;

  return true;
}

VkQueueFamilyProperties_Data::VkQueueFamilyProperties_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu