// extensions/common/api/mime_handler.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_H_
#define EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "extensions/common/api/mime_handler.mojom-shared.h"
#include "extensions/common/api/mime_handler.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace extensions {
namespace mime_handler {

class MimeHandlerServiceProxy;

template <typename ImplRefTraits>
class MimeHandlerServiceStub;

class MimeHandlerServiceRequestValidator;
class MimeHandlerServiceResponseValidator;


class  MimeHandlerService
    : public MimeHandlerServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MimeHandlerServiceInterfaceBase;
  using Proxy_ = MimeHandlerServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MimeHandlerServiceStub<ImplRefTraits>;

  using RequestValidator_ = MimeHandlerServiceRequestValidator;
  using ResponseValidator_ = MimeHandlerServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetStreamInfoMinVersion = 0,
  };
  virtual ~MimeHandlerService() {}


  using GetStreamInfoCallback = base::OnceCallback<void(StreamInfoPtr)>;
  
  virtual void GetStreamInfo(GetStreamInfoCallback callback) = 0;
};

class BeforeUnloadControlProxy;

template <typename ImplRefTraits>
class BeforeUnloadControlStub;

class BeforeUnloadControlRequestValidator;
class BeforeUnloadControlResponseValidator;


class  BeforeUnloadControl
    : public BeforeUnloadControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BeforeUnloadControlInterfaceBase;
  using Proxy_ = BeforeUnloadControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = BeforeUnloadControlStub<ImplRefTraits>;

  using RequestValidator_ = BeforeUnloadControlRequestValidator;
  using ResponseValidator_ = BeforeUnloadControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetShowBeforeUnloadDialogMinVersion = 0,
  };
  virtual ~BeforeUnloadControl() {}


  using SetShowBeforeUnloadDialogCallback = base::OnceCallback<void()>;
  
  virtual void SetShowBeforeUnloadDialog(bool show_dialog, SetShowBeforeUnloadDialogCallback callback) = 0;
};



class  MimeHandlerServiceProxy
    : public MimeHandlerService {
 public:
  using InterfaceType = MimeHandlerService;

  explicit MimeHandlerServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetStreamInfo(GetStreamInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BeforeUnloadControlProxy
    : public BeforeUnloadControl {
 public:
  using InterfaceType = BeforeUnloadControl;

  explicit BeforeUnloadControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetShowBeforeUnloadDialog(bool show_dialog, SetShowBeforeUnloadDialogCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MimeHandlerServiceStubDispatch {
 public:
  static bool Accept(MimeHandlerService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MimeHandlerService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MimeHandlerService>>
class MimeHandlerServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MimeHandlerServiceStub() {}
  ~MimeHandlerServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeHandlerServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeHandlerServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BeforeUnloadControlStubDispatch {
 public:
  static bool Accept(BeforeUnloadControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BeforeUnloadControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BeforeUnloadControl>>
class BeforeUnloadControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BeforeUnloadControlStub() {}
  ~BeforeUnloadControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BeforeUnloadControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BeforeUnloadControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MimeHandlerServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BeforeUnloadControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MimeHandlerServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BeforeUnloadControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  StreamInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamInfo, T>::value>;
  using DataView = StreamInfoDataView;
  using Data_ = internal::StreamInfo_Data;

  template <typename... Args>
  static StreamInfoPtr New(Args&&... args) {
    return StreamInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamInfoPtr From(const U& u) {
    return mojo::TypeConverter<StreamInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamInfo>::Convert(*this);
  }


  StreamInfo();

  StreamInfo(
      const std::string& mime_type,
      const std::string& original_url,
      const std::string& stream_url,
      int32_t tab_id,
      const base::flat_map<std::string, std::string>& response_headers,
      bool embedded);

  ~StreamInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamInfoPtr>
  StreamInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamInfo_UnserializedMessageContext<
            UserType, StreamInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<StreamInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return StreamInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamInfo_UnserializedMessageContext<
            UserType, StreamInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string mime_type;
  
  std::string original_url;
  
  std::string stream_url;
  
  int32_t tab_id;
  
  base::flat_map<std::string, std::string> response_headers;
  
  bool embedded;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StreamInfoPtr StreamInfo::Clone() const {
  return New(
      mojo::Clone(mime_type),
      mojo::Clone(original_url),
      mojo::Clone(stream_url),
      mojo::Clone(tab_id),
      mojo::Clone(response_headers),
      mojo::Clone(embedded)
  );
}

template <typename T, StreamInfo::EnableIfSame<T>*>
bool StreamInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->stream_url, other_struct.stream_url))
    return false;
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->response_headers, other_struct.response_headers))
    return false;
  if (!mojo::Equals(this->embedded, other_struct.embedded))
    return false;
  return true;
}

template <typename T, StreamInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mime_type, rhs.mime_type))
    return true;
  if (std::less<>{}(rhs.mime_type, lhs.mime_type))
    return false;
  if (std::less<>{}(lhs.original_url, rhs.original_url))
    return true;
  if (std::less<>{}(rhs.original_url, lhs.original_url))
    return false;
  if (std::less<>{}(lhs.stream_url, rhs.stream_url))
    return true;
  if (std::less<>{}(rhs.stream_url, lhs.stream_url))
    return false;
  if (std::less<>{}(lhs.tab_id, rhs.tab_id))
    return true;
  if (std::less<>{}(rhs.tab_id, lhs.tab_id))
    return false;
  if (std::less<>{}(lhs.response_headers, rhs.response_headers))
    return true;
  if (std::less<>{}(rhs.response_headers, lhs.response_headers))
    return false;
  if (std::less<>{}(lhs.embedded, rhs.embedded))
    return true;
  if (std::less<>{}(rhs.embedded, lhs.embedded))
    return false;
  return false;
}


}  // namespace mime_handler
}  // namespace extensions

namespace mojo {


template <>
struct  StructTraits<::extensions::mime_handler::StreamInfo::DataView,
                                         ::extensions::mime_handler::StreamInfoPtr> {
  static bool IsNull(const ::extensions::mime_handler::StreamInfoPtr& input) { return !input; }
  static void SetToNull(::extensions::mime_handler::StreamInfoPtr* output) { output->reset(); }

  static const decltype(::extensions::mime_handler::StreamInfo::mime_type)& mime_type(
      const ::extensions::mime_handler::StreamInfoPtr& input) {
    return input->mime_type;
  }

  static const decltype(::extensions::mime_handler::StreamInfo::original_url)& original_url(
      const ::extensions::mime_handler::StreamInfoPtr& input) {
    return input->original_url;
  }

  static const decltype(::extensions::mime_handler::StreamInfo::stream_url)& stream_url(
      const ::extensions::mime_handler::StreamInfoPtr& input) {
    return input->stream_url;
  }

  static decltype(::extensions::mime_handler::StreamInfo::tab_id) tab_id(
      const ::extensions::mime_handler::StreamInfoPtr& input) {
    return input->tab_id;
  }

  static const decltype(::extensions::mime_handler::StreamInfo::response_headers)& response_headers(
      const ::extensions::mime_handler::StreamInfoPtr& input) {
    return input->response_headers;
  }

  static decltype(::extensions::mime_handler::StreamInfo::embedded) embedded(
      const ::extensions::mime_handler::StreamInfoPtr& input) {
    return input->embedded;
  }

  static bool Read(::extensions::mime_handler::StreamInfo::DataView input, ::extensions::mime_handler::StreamInfoPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_H_