// content/common/download/mhtml_file_writer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/download/mhtml_file_writer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace content {
namespace mojom {
class SerializeAsMHTMLParamsDataView;

class MhtmlOutputHandleDataView;


}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::SerializeAsMHTMLParamsDataView> {
  using Data = ::content::mojom::internal::SerializeAsMHTMLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::MhtmlOutputHandleDataView> {
  using Data = ::content::mojom::internal::MhtmlOutputHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {


enum class MhtmlSaveStatus : int32_t {
  
  kSuccess = 0,
  
  kFileClosingError = 1,
  
  kFileCreationError = 2,
  
  kFileWritingError = 3,
  
  kFrameNoLongerExists = 4,
  
  kDeprecatedFrameSerializationForbidden = 5,
  
  kRenderProcessExited = 6,
  
  kStreamingError = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, MhtmlSaveStatus value);
inline bool IsKnownEnumValue(MhtmlSaveStatus value) {
  return internal::MhtmlSaveStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MhtmlFileWriterInterfaceBase {};

using MhtmlFileWriterPtrDataView =
    mojo::InterfacePtrDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterRequestDataView =
    mojo::InterfaceRequestDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MhtmlFileWriterInterfaceBase>;


class SerializeAsMHTMLParamsDataView {
 public:
  SerializeAsMHTMLParamsDataView() {}

  SerializeAsMHTMLParamsDataView(
      internal::SerializeAsMHTMLParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMhtmlBoundaryMarkerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMhtmlBoundaryMarker(UserType* output) {
    
    auto* pointer = data_->mhtml_boundary_marker.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool mhtml_binary_encoding() const {
    return data_->mhtml_binary_encoding;
  }
  bool mhtml_popup_overlay_removal() const {
    return data_->mhtml_popup_overlay_removal;
  }
  bool mhtml_problem_detection() const {
    return data_->mhtml_problem_detection;
  }
  inline void GetDigestsOfUrisToSkipDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDigestsOfUrisToSkip(UserType* output) {
    
    auto* pointer = data_->digests_of_uris_to_skip.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetSaltDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSalt(UserType* output) {
    
    auto* pointer = data_->salt.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetOutputHandleDataView(
      MhtmlOutputHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutputHandle(UserType* output) {
    
    auto* pointer = !data_->output_handle.is_null() ? &data_->output_handle : nullptr;
    return mojo::internal::Deserialize<::content::mojom::MhtmlOutputHandleDataView>(
        pointer, output, context_);
  }
 private:
  internal::SerializeAsMHTMLParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MhtmlOutputHandleDataView {
 public:
  using Tag = internal::MhtmlOutputHandle_Data::MhtmlOutputHandle_Tag;

  MhtmlOutputHandleDataView() {}

  MhtmlOutputHandleDataView(
      internal::MhtmlOutputHandle_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file_handle() const { return data_->tag == Tag::FILE_HANDLE; }
  inline void GetFileHandleDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileHandle(UserType* output) {
    
    DCHECK(is_file_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        data_->data.f_file_handle.Get(), output, context_);
  }
  bool is_producer_handle() const { return data_->tag == Tag::PRODUCER_HANDLE; }
  mojo::ScopedDataPipeProducerHandle TakeProducerHandle() {
    DCHECK(is_producer_handle());
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->data.f_producer_handle, &result, context_);
    DCHECK(ret);
    return result;
  }

 private:
  internal::MhtmlOutputHandle_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

template <>
struct hash<::content::mojom::MhtmlSaveStatus>
    : public mojo::internal::EnumHashImpl<::content::mojom::MhtmlSaveStatus> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::content::mojom::MhtmlSaveStatus, ::content::mojom::MhtmlSaveStatus> {
  static ::content::mojom::MhtmlSaveStatus ToMojom(::content::mojom::MhtmlSaveStatus input) { return input; }
  static bool FromMojom(::content::mojom::MhtmlSaveStatus input, ::content::mojom::MhtmlSaveStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::MhtmlSaveStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::MhtmlSaveStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::content::mojom::MhtmlSaveStatus>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SerializeAsMHTMLParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SerializeAsMHTMLParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::SerializeAsMHTMLParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::mhtml_boundary_marker(input)) in_mhtml_boundary_marker = Traits::mhtml_boundary_marker(input);
    typename decltype((*output)->mhtml_boundary_marker)::BaseType::BufferWriter
        mhtml_boundary_marker_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mhtml_boundary_marker, buffer, &mhtml_boundary_marker_writer, context);
    (*output)->mhtml_boundary_marker.Set(
        mhtml_boundary_marker_writer.is_null() ? nullptr : mhtml_boundary_marker_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mhtml_boundary_marker.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mhtml_boundary_marker in SerializeAsMHTMLParams struct");
    (*output)->mhtml_binary_encoding = Traits::mhtml_binary_encoding(input);
    (*output)->mhtml_popup_overlay_removal = Traits::mhtml_popup_overlay_removal(input);
    (*output)->mhtml_problem_detection = Traits::mhtml_problem_detection(input);
    decltype(Traits::digests_of_uris_to_skip(input)) in_digests_of_uris_to_skip = Traits::digests_of_uris_to_skip(input);
    typename decltype((*output)->digests_of_uris_to_skip)::BaseType::BufferWriter
        digests_of_uris_to_skip_writer;
    const mojo::internal::ContainerValidateParams digests_of_uris_to_skip_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_digests_of_uris_to_skip, buffer, &digests_of_uris_to_skip_writer, &digests_of_uris_to_skip_validate_params,
        context);
    (*output)->digests_of_uris_to_skip.Set(
        digests_of_uris_to_skip_writer.is_null() ? nullptr : digests_of_uris_to_skip_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->digests_of_uris_to_skip.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null digests_of_uris_to_skip in SerializeAsMHTMLParams struct");
    decltype(Traits::salt(input)) in_salt = Traits::salt(input);
    typename decltype((*output)->salt)::BaseType::BufferWriter
        salt_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_salt, buffer, &salt_writer, context);
    (*output)->salt.Set(
        salt_writer.is_null() ? nullptr : salt_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->salt.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null salt in SerializeAsMHTMLParams struct");
    decltype(Traits::output_handle(input)) in_output_handle = Traits::output_handle(input);
    typename decltype((*output)->output_handle)::BufferWriter output_handle_writer;
    output_handle_writer.AllocateInline(buffer, &(*output)->output_handle);
    mojo::internal::Serialize<::content::mojom::MhtmlOutputHandleDataView>(
        in_output_handle, buffer, &output_handle_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->output_handle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_handle in SerializeAsMHTMLParams struct");
  }

  static bool Deserialize(::content::mojom::internal::SerializeAsMHTMLParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SerializeAsMHTMLParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::MhtmlOutputHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::content::mojom::MhtmlOutputHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::MhtmlOutputHandle_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::content::mojom::internal::MhtmlOutputHandle_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::content::mojom::MhtmlOutputHandleDataView::Tag::FILE_HANDLE: {
        decltype(Traits::file_handle(input))
            in_file_handle = Traits::file_handle(input);
        typename decltype(result->data.f_file_handle)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
            in_file_handle, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file_handle in MhtmlOutputHandle union");
        result->data.f_file_handle.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::content::mojom::MhtmlOutputHandleDataView::Tag::PRODUCER_HANDLE: {
        decltype(Traits::producer_handle(input))
            in_producer_handle = Traits::producer_handle(input);
        mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
            in_producer_handle, &result->data.f_producer_handle, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(result->data.f_producer_handle),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
            "invalid producer_handle in MhtmlOutputHandle union");
        break;
      }
    }
  }

  static bool Deserialize(::content::mojom::internal::MhtmlOutputHandle_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::MhtmlOutputHandleDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void SerializeAsMHTMLParamsDataView::GetMhtmlBoundaryMarkerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mhtml_boundary_marker.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SerializeAsMHTMLParamsDataView::GetDigestsOfUrisToSkipDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->digests_of_uris_to_skip.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void SerializeAsMHTMLParamsDataView::GetSaltDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->salt.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void SerializeAsMHTMLParamsDataView::GetOutputHandleDataView(
    MhtmlOutputHandleDataView* output) {
  auto pointer = &data_->output_handle;
  *output = MhtmlOutputHandleDataView(pointer, context_);
}


inline void MhtmlOutputHandleDataView::GetFileHandleDataView(
    ::mojo_base::mojom::FileDataView* output) {
  DCHECK(is_file_handle());
  *output = ::mojo_base::mojom::FileDataView(data_->data.f_file_handle.Get(), context_);
}


}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_H_