// content/common/agent_scheduling_group.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/agent_scheduling_group.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "content/common/agent_scheduling_group.mojom-params-data.h"
namespace content {
namespace mojom {

std::ostream& operator<<(std::ostream& os, ViewWidgetType value) {
  switch(value) {
    case ViewWidgetType::kTopLevel:
      return os << "ViewWidgetType::kTopLevel";
    case ViewWidgetType::kGuestView:
      return os << "ViewWidgetType::kGuestView";
    case ViewWidgetType::kPortal:
      return os << "ViewWidgetType::kPortal";
    default:
      return os << "Unknown ViewWidgetType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool CreateViewParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateViewParams_Data* object = static_cast<const CreateViewParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 136 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_preferences, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_preferences, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_preferences, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_preferences, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->main_frame_interface_bundle, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->frame_widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->frame_widget,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->widget,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_storage_namespace_id, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams session_storage_namespace_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->session_storage_namespace_id, validation_context,
                                         &session_storage_namespace_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->opener_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replicated_frame_state, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replicated_frame_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_frame_token, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_main_frame_token, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_main_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_properties, 21, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_properties, validation_context))
    return false;


  if (!::content::mojom::internal::ViewWidgetType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blink_page_broadcast, 24, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blink_page_broadcast,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CreateViewParams_Data::CreateViewParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateFrameWidgetParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateFrameWidgetParams_Data* object = static_cast<const CreateFrameWidgetParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_widget_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_widget, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_widget,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->widget_host, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->widget, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->widget,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_properties, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_properties, validation_context))
    return false;

  return true;
}

CreateFrameWidgetParams_Data::CreateFrameWidgetParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateFrameParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CreateFrameParams_Data* object = static_cast<const CreateFrameParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 88 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->opener_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interface_bundle, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interface_bundle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replication_state, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_owner_properties, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_owner_properties, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->widget_params, validation_context))
    return false;

  return true;
}

CreateFrameParams_Data::CreateFrameParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AgentSchedulingGroup_CreateView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AgentSchedulingGroup_CreateView_Params_Data* object = static_cast<const AgentSchedulingGroup_CreateView_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

AgentSchedulingGroup_CreateView_Params_Data::AgentSchedulingGroup_CreateView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AgentSchedulingGroup_DestroyView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AgentSchedulingGroup_DestroyView_Params_Data* object = static_cast<const AgentSchedulingGroup_DestroyView_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

AgentSchedulingGroup_DestroyView_Params_Data::AgentSchedulingGroup_DestroyView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AgentSchedulingGroup_CreateFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AgentSchedulingGroup_CreateFrame_Params_Data* object = static_cast<const AgentSchedulingGroup_CreateFrame_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

AgentSchedulingGroup_CreateFrame_Params_Data::AgentSchedulingGroup_CreateFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AgentSchedulingGroup_CreateFrameProxy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AgentSchedulingGroup_CreateFrameProxy_Params_Data* object = static_cast<const AgentSchedulingGroup_CreateFrameProxy_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->opener_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replication_state, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_frame_token, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  return true;
}

AgentSchedulingGroup_CreateFrameProxy_Params_Data::AgentSchedulingGroup_CreateFrameProxy_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content