// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/web_authn.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace WebAuthn {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "WebAuthn";
const char Metainfo::commandPrefix[] = "WebAuthn.";
const char Metainfo::version[] = "1.3";


namespace AuthenticatorProtocolEnum {
const char U2f[] = "u2f";
const char Ctap2[] = "ctap2";
} // namespace AuthenticatorProtocolEnum


namespace AuthenticatorTransportEnum {
const char Usb[] = "usb";
const char Nfc[] = "nfc";
const char Ble[] = "ble";
const char Cable[] = "cable";
const char Internal[] = "internal";
} // namespace AuthenticatorTransportEnum


CRDTP_BEGIN_DESERIALIZER(VirtualAuthenticatorOptions)
    CRDTP_DESERIALIZE_FIELD_OPT("automaticPresenceSimulation", m_automaticPresenceSimulation),
    CRDTP_DESERIALIZE_FIELD_OPT("hasResidentKey", m_hasResidentKey),
    CRDTP_DESERIALIZE_FIELD_OPT("hasUserVerification", m_hasUserVerification),
    CRDTP_DESERIALIZE_FIELD_OPT("isUserVerified", m_isUserVerified),
    CRDTP_DESERIALIZE_FIELD("protocol", m_protocol),
    CRDTP_DESERIALIZE_FIELD("transport", m_transport),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(VirtualAuthenticatorOptions)
    CRDTP_SERIALIZE_FIELD("protocol", m_protocol);
    CRDTP_SERIALIZE_FIELD("transport", m_transport);
    CRDTP_SERIALIZE_FIELD("hasResidentKey", m_hasResidentKey);
    CRDTP_SERIALIZE_FIELD("hasUserVerification", m_hasUserVerification);
    CRDTP_SERIALIZE_FIELD("automaticPresenceSimulation", m_automaticPresenceSimulation);
    CRDTP_SERIALIZE_FIELD("isUserVerified", m_isUserVerified);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Credential)
    CRDTP_DESERIALIZE_FIELD("credentialId", m_credentialId),
    CRDTP_DESERIALIZE_FIELD("isResidentCredential", m_isResidentCredential),
    CRDTP_DESERIALIZE_FIELD("privateKey", m_privateKey),
    CRDTP_DESERIALIZE_FIELD_OPT("rpId", m_rpId),
    CRDTP_DESERIALIZE_FIELD("signCount", m_signCount),
    CRDTP_DESERIALIZE_FIELD_OPT("userHandle", m_userHandle),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Credential)
    CRDTP_SERIALIZE_FIELD("credentialId", m_credentialId);
    CRDTP_SERIALIZE_FIELD("isResidentCredential", m_isResidentCredential);
    CRDTP_SERIALIZE_FIELD("rpId", m_rpId);
    CRDTP_SERIALIZE_FIELD("privateKey", m_privateKey);
    CRDTP_SERIALIZE_FIELD("userHandle", m_userHandle);
    CRDTP_SERIALIZE_FIELD("signCount", m_signCount);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void enable(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void addVirtualAuthenticator(const crdtp::Dispatchable& dispatchable);
    void removeVirtualAuthenticator(const crdtp::Dispatchable& dispatchable);
    void addCredential(const crdtp::Dispatchable& dispatchable);
    void getCredential(const crdtp::Dispatchable& dispatchable);
    void getCredentials(const crdtp::Dispatchable& dispatchable);
    void removeCredential(const crdtp::Dispatchable& dispatchable);
    void clearCredentials(const crdtp::Dispatchable& dispatchable);
    void setUserVerified(const crdtp::Dispatchable& dispatchable);
    void setAutomaticPresenceSimulation(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("addCredential"),
          &DomainDispatcherImpl::addCredential
    },
    {
          crdtp::SpanFrom("addVirtualAuthenticator"),
          &DomainDispatcherImpl::addVirtualAuthenticator
    },
    {
          crdtp::SpanFrom("clearCredentials"),
          &DomainDispatcherImpl::clearCredentials
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getCredential"),
          &DomainDispatcherImpl::getCredential
    },
    {
          crdtp::SpanFrom("getCredentials"),
          &DomainDispatcherImpl::getCredentials
    },
    {
          crdtp::SpanFrom("removeCredential"),
          &DomainDispatcherImpl::removeCredential
    },
    {
          crdtp::SpanFrom("removeVirtualAuthenticator"),
          &DomainDispatcherImpl::removeVirtualAuthenticator
    },
    {
          crdtp::SpanFrom("setAutomaticPresenceSimulation"),
          &DomainDispatcherImpl::setAutomaticPresenceSimulation
    },
    {
          crdtp::SpanFrom("setUserVerified"),
          &DomainDispatcherImpl::setUserVerified
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct addVirtualAuthenticatorParams : public crdtp::DeserializableProtocolObject<addVirtualAuthenticatorParams> {
    std::unique_ptr<protocol::WebAuthn::VirtualAuthenticatorOptions> options;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addVirtualAuthenticatorParams)
    CRDTP_DESERIALIZE_FIELD("options", options),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addVirtualAuthenticator(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addVirtualAuthenticatorParams params;
    addVirtualAuthenticatorParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    String out_authenticatorId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->AddVirtualAuthenticator(std::move(params.options), &out_authenticatorId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.addVirtualAuthenticator"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("authenticatorId"), out_authenticatorId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct removeVirtualAuthenticatorParams : public crdtp::DeserializableProtocolObject<removeVirtualAuthenticatorParams> {
    String authenticatorId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeVirtualAuthenticatorParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeVirtualAuthenticator(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeVirtualAuthenticatorParams params;
    removeVirtualAuthenticatorParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->RemoveVirtualAuthenticator(params.authenticatorId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.removeVirtualAuthenticator"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct addCredentialParams : public crdtp::DeserializableProtocolObject<addCredentialParams> {
    String authenticatorId;
    std::unique_ptr<protocol::WebAuthn::Credential> credential;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addCredentialParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
    CRDTP_DESERIALIZE_FIELD("credential", credential),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addCredential(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addCredentialParams params;
    addCredentialParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->AddCredential(params.authenticatorId, std::move(params.credential));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.addCredential"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getCredentialParams : public crdtp::DeserializableProtocolObject<getCredentialParams> {
    String authenticatorId;
    Binary credentialId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getCredentialParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
    CRDTP_DESERIALIZE_FIELD("credentialId", credentialId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getCredential(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getCredentialParams params;
    getCredentialParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    std::unique_ptr<protocol::WebAuthn::Credential> out_credential;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->GetCredential(params.authenticatorId, params.credentialId, &out_credential);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.getCredential"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("credential"), out_credential);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getCredentialsParams : public crdtp::DeserializableProtocolObject<getCredentialsParams> {
    String authenticatorId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getCredentialsParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getCredentials(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getCredentialsParams params;
    getCredentialsParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::WebAuthn::Credential>> out_credentials;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->GetCredentials(params.authenticatorId, &out_credentials);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.getCredentials"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("credentials"), out_credentials);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct removeCredentialParams : public crdtp::DeserializableProtocolObject<removeCredentialParams> {
    String authenticatorId;
    Binary credentialId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeCredentialParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
    CRDTP_DESERIALIZE_FIELD("credentialId", credentialId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeCredential(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeCredentialParams params;
    removeCredentialParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->RemoveCredential(params.authenticatorId, params.credentialId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.removeCredential"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct clearCredentialsParams : public crdtp::DeserializableProtocolObject<clearCredentialsParams> {
    String authenticatorId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearCredentialsParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearCredentials(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearCredentialsParams params;
    clearCredentialsParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ClearCredentials(params.authenticatorId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.clearCredentials"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setUserVerifiedParams : public crdtp::DeserializableProtocolObject<setUserVerifiedParams> {
    String authenticatorId;
    bool isUserVerified;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setUserVerifiedParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
    CRDTP_DESERIALIZE_FIELD("isUserVerified", isUserVerified),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setUserVerified(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setUserVerifiedParams params;
    setUserVerifiedParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetUserVerified(params.authenticatorId, params.isUserVerified);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.setUserVerified"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setAutomaticPresenceSimulationParams : public crdtp::DeserializableProtocolObject<setAutomaticPresenceSimulationParams> {
    String authenticatorId;
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAutomaticPresenceSimulationParams)
    CRDTP_DESERIALIZE_FIELD("authenticatorId", authenticatorId),
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAutomaticPresenceSimulation(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAutomaticPresenceSimulationParams params;
    setAutomaticPresenceSimulationParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetAutomaticPresenceSimulation(params.authenticatorId, params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAuthn.setAutomaticPresenceSimulation"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("WebAuthn"), SortedRedirects(), std::move(dispatcher));
}

} // WebAuthn
} // namespace content
} // namespace protocol
