// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/storage.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Storage {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Storage";
const char Metainfo::commandPrefix[] = "Storage.";
const char Metainfo::version[] = "1.3";

namespace StorageTypeEnum {
const char Appcache[] = "appcache";
const char Cookies[] = "cookies";
const char File_systems[] = "file_systems";
const char Indexeddb[] = "indexeddb";
const char Local_storage[] = "local_storage";
const char Shader_cache[] = "shader_cache";
const char Websql[] = "websql";
const char Service_workers[] = "service_workers";
const char Cache_storage[] = "cache_storage";
const char All[] = "all";
const char Other[] = "other";
} // namespace StorageTypeEnum


CRDTP_BEGIN_DESERIALIZER(UsageForType)
    CRDTP_DESERIALIZE_FIELD("storageType", m_storageType),
    CRDTP_DESERIALIZE_FIELD("usage", m_usage),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UsageForType)
    CRDTP_SERIALIZE_FIELD("storageType", m_storageType);
    CRDTP_SERIALIZE_FIELD("usage", m_usage);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::CacheStorageContentUpdated(const String& origin, const String& cacheName)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("cacheName"), cacheName);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.cacheStorageContentUpdated", serializer.Finish()));
}

void Frontend::CacheStorageListUpdated(const String& origin)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.cacheStorageListUpdated", serializer.Finish()));
}

void Frontend::IndexedDBContentUpdated(const String& origin, const String& databaseName, const String& objectStoreName)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("databaseName"), databaseName);
    serializer.AddField(crdtp::MakeSpan("objectStoreName"), objectStoreName);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.indexedDBContentUpdated", serializer.Finish()));
}

void Frontend::IndexedDBListUpdated(const String& origin)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.indexedDBListUpdated", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void clearDataForOrigin(const crdtp::Dispatchable& dispatchable);
    void getCookies(const crdtp::Dispatchable& dispatchable);
    void setCookies(const crdtp::Dispatchable& dispatchable);
    void clearCookies(const crdtp::Dispatchable& dispatchable);
    void getUsageAndQuota(const crdtp::Dispatchable& dispatchable);
    void trackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable);
    void trackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable);
    void untrackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable);
    void untrackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("clearCookies"),
          &DomainDispatcherImpl::clearCookies
    },
    {
          crdtp::SpanFrom("clearDataForOrigin"),
          &DomainDispatcherImpl::clearDataForOrigin
    },
    {
          crdtp::SpanFrom("getCookies"),
          &DomainDispatcherImpl::getCookies
    },
    {
          crdtp::SpanFrom("getUsageAndQuota"),
          &DomainDispatcherImpl::getUsageAndQuota
    },
    {
          crdtp::SpanFrom("setCookies"),
          &DomainDispatcherImpl::setCookies
    },
    {
          crdtp::SpanFrom("trackCacheStorageForOrigin"),
          &DomainDispatcherImpl::trackCacheStorageForOrigin
    },
    {
          crdtp::SpanFrom("trackIndexedDBForOrigin"),
          &DomainDispatcherImpl::trackIndexedDBForOrigin
    },
    {
          crdtp::SpanFrom("untrackCacheStorageForOrigin"),
          &DomainDispatcherImpl::untrackCacheStorageForOrigin
    },
    {
          crdtp::SpanFrom("untrackIndexedDBForOrigin"),
          &DomainDispatcherImpl::untrackIndexedDBForOrigin
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class ClearDataForOriginCallbackImpl : public Backend::ClearDataForOriginCallback, public DomainDispatcher::Callback {
public:
    ClearDataForOriginCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.clearDataForOrigin"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct clearDataForOriginParams : public crdtp::DeserializableProtocolObject<clearDataForOriginParams> {
    String origin;
    String storageTypes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearDataForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
    CRDTP_DESERIALIZE_FIELD("storageTypes", storageTypes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearDataForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearDataForOriginParams params;
    clearDataForOriginParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->ClearDataForOrigin(params.origin, params.storageTypes, std::make_unique<ClearDataForOriginCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetCookiesCallbackImpl : public Backend::GetCookiesCallback, public DomainDispatcher::Callback {
public:
    GetCookiesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.getCookies"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::Network::Cookie>> cookies) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("cookies"), cookies);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getCookiesParams : public crdtp::DeserializableProtocolObject<getCookiesParams> {
    Maybe<String> browserContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getCookiesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getCookiesParams params;
    getCookiesParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->GetCookies(std::move(params.browserContextId), std::make_unique<GetCookiesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class SetCookiesCallbackImpl : public Backend::SetCookiesCallback, public DomainDispatcher::Callback {
public:
    SetCookiesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.setCookies"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct setCookiesParams : public crdtp::DeserializableProtocolObject<setCookiesParams> {
    std::unique_ptr<protocol::Array<protocol::Network::CookieParam>> cookies;
    Maybe<String> browserContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setCookiesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
    CRDTP_DESERIALIZE_FIELD("cookies", cookies),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setCookiesParams params;
    setCookiesParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->SetCookies(std::move(params.cookies), std::move(params.browserContextId), std::make_unique<SetCookiesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class ClearCookiesCallbackImpl : public Backend::ClearCookiesCallback, public DomainDispatcher::Callback {
public:
    ClearCookiesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.clearCookies"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct clearCookiesParams : public crdtp::DeserializableProtocolObject<clearCookiesParams> {
    Maybe<String> browserContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearCookiesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearCookiesParams params;
    clearCookiesParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->ClearCookies(std::move(params.browserContextId), std::make_unique<ClearCookiesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetUsageAndQuotaCallbackImpl : public Backend::GetUsageAndQuotaCallback, public DomainDispatcher::Callback {
public:
    GetUsageAndQuotaCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.getUsageAndQuota"), message) { }

    void sendSuccess(double usage, double quota, std::unique_ptr<protocol::Array<protocol::Storage::UsageForType>> usageBreakdown) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("usage"), usage);
        serializer.AddField(crdtp::MakeSpan("quota"), quota);
        serializer.AddField(crdtp::MakeSpan("usageBreakdown"), usageBreakdown);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getUsageAndQuotaParams : public crdtp::DeserializableProtocolObject<getUsageAndQuotaParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getUsageAndQuotaParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getUsageAndQuota(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getUsageAndQuotaParams params;
    getUsageAndQuotaParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->GetUsageAndQuota(params.origin, std::make_unique<GetUsageAndQuotaCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct trackCacheStorageForOriginParams : public crdtp::DeserializableProtocolObject<trackCacheStorageForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackCacheStorageForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackCacheStorageForOriginParams params;
    trackCacheStorageForOriginParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->TrackCacheStorageForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.trackCacheStorageForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct trackIndexedDBForOriginParams : public crdtp::DeserializableProtocolObject<trackIndexedDBForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackIndexedDBForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackIndexedDBForOriginParams params;
    trackIndexedDBForOriginParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->TrackIndexedDBForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.trackIndexedDBForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct untrackCacheStorageForOriginParams : public crdtp::DeserializableProtocolObject<untrackCacheStorageForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(untrackCacheStorageForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::untrackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    untrackCacheStorageForOriginParams params;
    untrackCacheStorageForOriginParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->UntrackCacheStorageForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.untrackCacheStorageForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct untrackIndexedDBForOriginParams : public crdtp::DeserializableProtocolObject<untrackIndexedDBForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(untrackIndexedDBForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::untrackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    untrackIndexedDBForOriginParams params;
    untrackIndexedDBForOriginParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->UntrackIndexedDBForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.untrackIndexedDBForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Storage"), SortedRedirects(), std::move(dispatcher));
}

} // Storage
} // namespace content
} // namespace protocol
