// components/schema_org/common/metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_BLINK_H_
#define COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/schema_org/common/metadata.mojom-shared.h"
#include "components/schema_org/common/metadata.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace schema_org {
namespace mojom {
namespace blink {







class  Values {
 public:
  using DataView = ValuesDataView;
  using Data_ = internal::Values_Data;
  using Tag = Data_::Values_Tag;

  static ValuesPtr New() {
    return ValuesPtr(base::in_place);
  }
  // Construct an instance holding |bool_values|.
  static ValuesPtr
  NewBoolValues(
      WTF::Vector<bool> bool_values) {
    auto result = ValuesPtr(base::in_place);
    result->set_bool_values(std::move(bool_values));
    return result;
  }
  // Construct an instance holding |long_values|.
  static ValuesPtr
  NewLongValues(
      WTF::Vector<int64_t> long_values) {
    auto result = ValuesPtr(base::in_place);
    result->set_long_values(std::move(long_values));
    return result;
  }
  // Construct an instance holding |string_values|.
  static ValuesPtr
  NewStringValues(
      WTF::Vector<WTF::String> string_values) {
    auto result = ValuesPtr(base::in_place);
    result->set_string_values(std::move(string_values));
    return result;
  }
  // Construct an instance holding |entity_values|.
  static ValuesPtr
  NewEntityValues(
      WTF::Vector<EntityPtr> entity_values) {
    auto result = ValuesPtr(base::in_place);
    result->set_entity_values(std::move(entity_values));
    return result;
  }

  template <typename U>
  static ValuesPtr From(const U& u) {
    return mojo::TypeConverter<ValuesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Values>::Convert(*this);
  }

  Values();
  ~Values();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ValuesPtr>
  ValuesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Values>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_bool_values() const { return tag_ == Tag::BOOL_VALUES; }

  
  WTF::Vector<bool>& get_bool_values() const {
    DCHECK(tag_ == Tag::BOOL_VALUES);
    return *(data_.bool_values);
  }

  
  void set_bool_values(
      WTF::Vector<bool> bool_values);
  
  bool is_long_values() const { return tag_ == Tag::LONG_VALUES; }

  
  WTF::Vector<int64_t>& get_long_values() const {
    DCHECK(tag_ == Tag::LONG_VALUES);
    return *(data_.long_values);
  }

  
  void set_long_values(
      WTF::Vector<int64_t> long_values);
  
  bool is_string_values() const { return tag_ == Tag::STRING_VALUES; }

  
  WTF::Vector<WTF::String>& get_string_values() const {
    DCHECK(tag_ == Tag::STRING_VALUES);
    return *(data_.string_values);
  }

  
  void set_string_values(
      WTF::Vector<WTF::String> string_values);
  
  bool is_entity_values() const { return tag_ == Tag::ENTITY_VALUES; }

  
  WTF::Vector<EntityPtr>& get_entity_values() const {
    DCHECK(tag_ == Tag::ENTITY_VALUES);
    return *(data_.entity_values);
  }

  
  void set_entity_values(
      WTF::Vector<EntityPtr> entity_values);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Values::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Values::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    WTF::Vector<bool>* bool_values;
    WTF::Vector<int64_t>* long_values;
    WTF::Vector<WTF::String>* string_values;
    WTF::Vector<EntityPtr>* entity_values;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Property {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Property, T>::value>;
  using DataView = PropertyDataView;
  using Data_ = internal::Property_Data;

  template <typename... Args>
  static PropertyPtr New(Args&&... args) {
    return PropertyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PropertyPtr From(const U& u) {
    return mojo::TypeConverter<PropertyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Property>::Convert(*this);
  }


  Property();

  Property(
      const WTF::String& name,
      ValuesPtr values);

  ~Property();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PropertyPtr>
  PropertyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Property::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Property::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Property::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Property_UnserializedMessageContext<
            UserType, Property::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Property::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return Property::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Property_UnserializedMessageContext<
            UserType, Property::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Property::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String name;
  
  ValuesPtr values;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(Property);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Property::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Entity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Entity, T>::value>;
  using DataView = EntityDataView;
  using Data_ = internal::Entity_Data;

  template <typename... Args>
  static EntityPtr New(Args&&... args) {
    return EntityPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EntityPtr From(const U& u) {
    return mojo::TypeConverter<EntityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Entity>::Convert(*this);
  }


  Entity();

  Entity(
      const WTF::String& type,
      WTF::Vector<PropertyPtr> properties);

  ~Entity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EntityPtr>
  EntityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Entity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Entity::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Entity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Entity_UnserializedMessageContext<
            UserType, Entity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Entity::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return Entity::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Entity_UnserializedMessageContext<
            UserType, Entity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Entity::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String type;
  
  WTF::Vector<PropertyPtr> properties;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(Entity);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Entity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ValuesPtr Values::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::BOOL_VALUES:
      rv->set_bool_values(mojo::Clone(*data_.bool_values));
      break;
    case Tag::LONG_VALUES:
      rv->set_long_values(mojo::Clone(*data_.long_values));
      break;
    case Tag::STRING_VALUES:
      rv->set_string_values(mojo::Clone(*data_.string_values));
      break;
    case Tag::ENTITY_VALUES:
      rv->set_entity_values(mojo::Clone(*data_.entity_values));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Values>::value>::type*>
bool Values::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::BOOL_VALUES:
      return mojo::Equals(*(data_.bool_values), *(other.data_.bool_values));
    case Tag::LONG_VALUES:
      return mojo::Equals(*(data_.long_values), *(other.data_.long_values));
    case Tag::STRING_VALUES:
      return mojo::Equals(*(data_.string_values), *(other.data_.string_values));
    case Tag::ENTITY_VALUES:
      return mojo::Equals(*(data_.entity_values), *(other.data_.entity_values));
  }

  return false;
}
template <typename StructPtrType>
PropertyPtr Property::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(values)
  );
}

template <typename T, Property::EnableIfSame<T>*>
bool Property::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->values, other_struct.values))
    return false;
  return true;
}

template <typename T, Property::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.values, rhs.values))
    return true;
  if (std::less<>{}(rhs.values, lhs.values))
    return false;
  return false;
}
template <typename StructPtrType>
EntityPtr Entity::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(properties)
  );
}

template <typename T, Entity::EnableIfSame<T>*>
bool Entity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  return true;
}

template <typename T, Entity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.properties, rhs.properties))
    return true;
  if (std::less<>{}(rhs.properties, lhs.properties))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace schema_org

namespace mojo {


template <>
struct  StructTraits<::schema_org::mojom::blink::Property::DataView,
                                         ::schema_org::mojom::blink::PropertyPtr> {
  static bool IsNull(const ::schema_org::mojom::blink::PropertyPtr& input) { return !input; }
  static void SetToNull(::schema_org::mojom::blink::PropertyPtr* output) { output->reset(); }

  static const decltype(::schema_org::mojom::blink::Property::name)& name(
      const ::schema_org::mojom::blink::PropertyPtr& input) {
    return input->name;
  }

  static const decltype(::schema_org::mojom::blink::Property::values)& values(
      const ::schema_org::mojom::blink::PropertyPtr& input) {
    return input->values;
  }

  static bool Read(::schema_org::mojom::blink::Property::DataView input, ::schema_org::mojom::blink::PropertyPtr* output);
};


template <>
struct  StructTraits<::schema_org::mojom::blink::Entity::DataView,
                                         ::schema_org::mojom::blink::EntityPtr> {
  static bool IsNull(const ::schema_org::mojom::blink::EntityPtr& input) { return !input; }
  static void SetToNull(::schema_org::mojom::blink::EntityPtr* output) { output->reset(); }

  static const decltype(::schema_org::mojom::blink::Entity::type)& type(
      const ::schema_org::mojom::blink::EntityPtr& input) {
    return input->type;
  }

  static const decltype(::schema_org::mojom::blink::Entity::properties)& properties(
      const ::schema_org::mojom::blink::EntityPtr& input) {
    return input->properties;
  }

  static bool Read(::schema_org::mojom::blink::Entity::DataView input, ::schema_org::mojom::blink::EntityPtr* output);
};


template <>
struct  UnionTraits<::schema_org::mojom::blink::Values::DataView,
                                        ::schema_org::mojom::blink::ValuesPtr> {
  static bool IsNull(const ::schema_org::mojom::blink::ValuesPtr& input) { return !input; }
  static void SetToNull(::schema_org::mojom::blink::ValuesPtr* output) { output->reset(); }

  static ::schema_org::mojom::blink::Values::Tag GetTag(const ::schema_org::mojom::blink::ValuesPtr& input) {
    return input->which();
  }

  static const WTF::Vector<bool>& bool_values(const ::schema_org::mojom::blink::ValuesPtr& input) {
    return input->get_bool_values();
  }

  static const WTF::Vector<int64_t>& long_values(const ::schema_org::mojom::blink::ValuesPtr& input) {
    return input->get_long_values();
  }

  static const WTF::Vector<WTF::String>& string_values(const ::schema_org::mojom::blink::ValuesPtr& input) {
    return input->get_string_values();
  }

  static const WTF::Vector<::schema_org::mojom::blink::EntityPtr>& entity_values(const ::schema_org::mojom::blink::ValuesPtr& input) {
    return input->get_entity_values();
  }

  static bool Read(::schema_org::mojom::blink::Values::DataView input, ::schema_org::mojom::blink::ValuesPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_BLINK_H_