# Copyright 2021 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
"""TensorFlow Probability experimental PSD kernels package."""

from tensorflow_probability.substrates.numpy.experimental.psd_kernels.additive_kernel import AdditiveKernel
from tensorflow_probability.substrates.numpy.experimental.psd_kernels.feature_scaled_with_categorical import ContinuousAndCategoricalValues
from tensorflow_probability.substrates.numpy.experimental.psd_kernels.feature_scaled_with_categorical import FeatureScaledWithCategorical
from tensorflow_probability.substrates.numpy.experimental.psd_kernels.feature_scaled_with_embedded_categorical import FeatureScaledWithEmbeddedCategorical
from tensorflow_probability.substrates.numpy.experimental.psd_kernels.multitask_kernel import Independent
from tensorflow_probability.substrates.numpy.experimental.psd_kernels.multitask_kernel import MultiTaskKernel
from tensorflow_probability.substrates.numpy.experimental.psd_kernels.multitask_kernel import Separable
from tensorflow_probability.python.internal import all_util


_allowed_symbols = [
    'AdditiveKernel',
    'ContinuousAndCategoricalValues',
    'FeatureScaledWithCategorical',
    'FeatureScaledWithEmbeddedCategorical',
    'Independent',
    'MultiTaskKernel',
    'Separable',
]

all_util.remove_undocumented(__name__, _allowed_symbols)


# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
# This file is auto-generated by substrates/meta/rewrite.py
# It will be surfaced by the build system as a symlink at:
#   `tensorflow_probability/substrates/numpy/experimental/psd_kernels/__init__.py`
# For more info, see substrate_runfiles_symlinks in build_defs.bzl
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
