from typing import Any, ClassVar, Optional, Union

from typing import overload
import io
import lief # type: ignore
import lief.PE # type: ignore
import lief.PE.Attribute # type: ignore
import lief.PE.Binary # type: ignore
import lief.PE.CodeView # type: ignore
import lief.PE.ContentInfo # type: ignore
import lief.PE.DataDirectory # type: ignore
import lief.PE.Debug # type: ignore
import lief.PE.DelayImport # type: ignore
import lief.PE.Export # type: ignore
import lief.PE.ExportEntry # type: ignore
import lief.PE.Header # type: ignore
import lief.PE.Import # type: ignore
import lief.PE.LoadConfiguration # type: ignore
import lief.PE.LoadConfigurationV1 # type: ignore
import lief.PE.MsCounterSign # type: ignore
import lief.PE.OptionalHeader # type: ignore
import lief.PE.Pogo # type: ignore
import lief.PE.Relocation # type: ignore
import lief.PE.RelocationEntry # type: ignore
import lief.PE.ResourceDialog # type: ignore
import lief.PE.ResourceNode # type: ignore
import lief.PE.ResourcesManager # type: ignore
import lief.PE.RichHeader # type: ignore
import lief.PE.Section # type: ignore
import lief.PE.Signature # type: ignore
import lief.PE.SignerInfo # type: ignore
import lief.PE.x509 # type: ignore
import os

class ACCELERATOR_FLAGS:
    END: ClassVar[ACCELERATOR_FLAGS] = ...
    FALT: ClassVar[ACCELERATOR_FLAGS] = ...
    FCONTROL: ClassVar[ACCELERATOR_FLAGS] = ...
    FNOINVERT: ClassVar[ACCELERATOR_FLAGS] = ...
    FSHIFT: ClassVar[ACCELERATOR_FLAGS] = ...
    FVIRTKEY: ClassVar[ACCELERATOR_FLAGS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.ACCELERATOR_FLAGS: ...
    def __abs__(self) -> Any: ...
    def __add__(self, other) -> Any: ...
    @overload
    def __and__(self, arg: int, /) -> int: ...
    @overload
    def __and__(self, arg: lief.PE.ACCELERATOR_FLAGS, /) -> int: ...
    def __floordiv__(self, other) -> Any: ...
    def __ge__(self, arg: int, /) -> bool: ...
    def __gt__(self, arg: int, /) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> int: ...
    def __le__(self, arg: int, /) -> bool: ...
    def __lshift__(self, other) -> Any: ...
    def __lt__(self, arg: int, /) -> bool: ...
    def __mul__(self, other) -> Any: ...
    def __neg__(self) -> Any: ...
    @overload
    def __or__(self, arg: int, /) -> int: ...
    @overload
    def __or__(self, arg: lief.PE.ACCELERATOR_FLAGS, /) -> lief.PE.ACCELERATOR_FLAGS: ...
    def __radd__(self, other) -> Any: ...
    def __rand__(self, arg: int, /) -> int: ...
    def __rfloordiv__(self, other) -> Any: ...
    def __rlshift__(self, other) -> Any: ...
    def __rmul__(self, other) -> Any: ...
    def __ror__(self, arg: int, /) -> int: ...
    def __rrshift__(self, other) -> Any: ...
    def __rshift__(self, other) -> Any: ...
    def __rsub__(self, other) -> Any: ...
    def __rxor__(self, arg: int, /) -> int: ...
    def __sub__(self, other) -> Any: ...
    @overload
    def __xor__(self, arg: int, /) -> int: ...
    @overload
    def __xor__(self, arg: lief.PE.ACCELERATOR_FLAGS, /) -> int: ...
    @property
    def value(self) -> int: ...

class ACCELERATOR_VK_CODES:
    VK_0: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_3: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_9: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_A: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ACCEPT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ADD: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_APPS: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ATTN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_B: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_BACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_FAVORITES: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_FORWARD: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_HOME: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_REFRESH: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_SEARCH: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_STOP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_C: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CANCEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CAPITAL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CLEAR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CONTROL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CONVERT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CRSEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_D: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DECIMAL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DELETE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DIVIDE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DOWN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_E: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_END: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_EREOF: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ESCAPE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_EXECUTE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_EXSEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F10: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F11: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F12: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F13: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F14: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F15: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F16: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F17: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F18: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F19: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F20: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F21: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F22: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F23: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F24: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F3: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F9: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_FINAL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_G: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_H: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HANGUEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HANGUL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HANJA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HELP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HOME: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_I: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_IME_OFF: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_IME_ON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_INSERT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_J: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_JUNJA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_K: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_KANA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_KANJI: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_L: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_APP1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_APP2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_MAIL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_MEDIA_SELECT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LBUTTON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LCONTROL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LEFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LMENU: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LSHIFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LWIN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_M: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MBUTTON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_NEXT_TRACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_PLAY_PAUSE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_PREV_TRACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_STOP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MENU: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MODECHANGE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MULTIPLY: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_N: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NEXT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NONAME: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NONCONVERT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMLOCK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD0: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD3: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD9: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_O: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_102: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_CLEAR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_COMMA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_MINUS: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_PERIOD: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_PLUS: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_P: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PA1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PACKET: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PAUSE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PLAY: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PRINT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PRIOR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PROCESSKEY: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_Q: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_R: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RBUTTON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RCONTROL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RETURN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RIGHT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RMENU: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RSHIFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RWIN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_S: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SCROLL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SELECT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SEPARATOR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SHIFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SLEEP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SNAPSHOT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SPACE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SUBTRACT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_T: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_TAB: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_U: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_UP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_V: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_VOLUME_DOWN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_VOLUME_MUTE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_VOLUME_UP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_W: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_X: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_XBUTTON1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_XBUTTON2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_Y: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_Z: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ZOOM: ClassVar[ACCELERATOR_VK_CODES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.ACCELERATOR_VK_CODES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class ALGORITHMS:
    EC: ClassVar[ALGORITHMS] = ...
    MD2: ClassVar[ALGORITHMS] = ...
    MD4: ClassVar[ALGORITHMS] = ...
    MD5: ClassVar[ALGORITHMS] = ...
    MD5_RSA: ClassVar[ALGORITHMS] = ...
    RSA: ClassVar[ALGORITHMS] = ...
    SHA1_DSA: ClassVar[ALGORITHMS] = ...
    SHA1_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA1_RSA: ClassVar[ALGORITHMS] = ...
    SHA_1: ClassVar[ALGORITHMS] = ...
    SHA_256: ClassVar[ALGORITHMS] = ...
    SHA_256_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA_256_RSA: ClassVar[ALGORITHMS] = ...
    SHA_384: ClassVar[ALGORITHMS] = ...
    SHA_384_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA_384_RSA: ClassVar[ALGORITHMS] = ...
    SHA_512: ClassVar[ALGORITHMS] = ...
    SHA_512_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA_512_RSA: ClassVar[ALGORITHMS] = ...
    UNKNOWN: ClassVar[ALGORITHMS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.ALGORITHMS: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class Attribute(lief.Object):
    class TYPE:
        CONTENT_TYPE: ClassVar[Attribute.TYPE] = ...
        GENERIC_TYPE: ClassVar[Attribute.TYPE] = ...
        MS_COUNTER_SIGN: ClassVar[Attribute.TYPE] = ...
        MS_PLATFORM_MANIFEST_BINARY_ID: ClassVar[Attribute.TYPE] = ...
        MS_SPC_NESTED_SIGN: ClassVar[Attribute.TYPE] = ...
        MS_SPC_STATEMENT_TYPE: ClassVar[Attribute.TYPE] = ...
        PKCS9_AT_SEQUENCE_NUMBER: ClassVar[Attribute.TYPE] = ...
        PKCS9_COUNTER_SIGNATURE: ClassVar[Attribute.TYPE] = ...
        PKCS9_MESSAGE_DIGEST: ClassVar[Attribute.TYPE] = ...
        PKCS9_SIGNING_TIME: ClassVar[Attribute.TYPE] = ...
        SIGNING_CERTIFICATE_V2: ClassVar[Attribute.TYPE] = ...
        SPC_RELAXED_PE_MARKER_CHECK: ClassVar[Attribute.TYPE] = ...
        SPC_SP_OPUS_INFO: ClassVar[Attribute.TYPE] = ...
        UNKNOWN: ClassVar[Attribute.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Attribute.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def type(self) -> lief.PE.Attribute.TYPE: ...

class Binary(lief.Binary):
    class it_const_signatures:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Signature: ...
        def __iter__(self) -> lief.PE.Binary.it_const_signatures: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Signature: ...

    class it_data_directories:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.DataDirectory: ...
        def __iter__(self) -> lief.PE.Binary.it_data_directories: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.DataDirectory: ...

    class it_debug:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Debug: ...
        def __iter__(self) -> lief.PE.Binary.it_debug: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Debug: ...

    class it_delay_imports:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.DelayImport: ...
        def __iter__(self) -> lief.PE.Binary.it_delay_imports: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.DelayImport: ...

    class it_imports:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Import: ...
        def __iter__(self) -> lief.PE.Binary.it_imports: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Import: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Relocation: ...
        def __iter__(self) -> lief.PE.Binary.it_relocations: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Relocation: ...

    class it_section:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Section: ...
        def __iter__(self) -> lief.PE.Binary.it_section: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Section: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Symbol: ...
        def __iter__(self) -> lief.PE.Binary.it_symbols: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Symbol: ...
    dos_stub: memoryview
    rich_header: lief.PE.RichHeader
    tls: lief.PE.TLS
    def __init__(self, type: lief.PE.PE_TYPE) -> None: ...
    def add_import_function(self, import_name: str, function_name: str) -> lief.PE.ImportEntry: ...
    def add_library(self, import_name: str) -> lief.PE.Import: ...
    def add_relocation(self, relocation: lief.PE.Relocation) -> lief.PE.Relocation: ...
    def add_section(self, section: lief.PE.Section, type: lief.PE.SECTION_TYPES = ...) -> lief.PE.Section: ...
    def authentihash(self, algorithm: lief.PE.ALGORITHMS) -> bytes: ...
    def compute_checksum(self) -> int: ...
    def data_directory(self, type: lief.PE.DataDirectory.TYPES) -> lief.PE.DataDirectory: ...
    def get_delay_import(self, import_name: str) -> lief.PE.DelayImport: ...
    def get_export(self) -> lief.PE.Export: ...
    def get_import(self, import_name: str) -> lief.PE.Import: ...
    def get_section(self, section_name: str) -> lief.PE.Section: ...
    def has_delay_import(self, import_name: str) -> bool: ...
    def has_import(self, import_name: str) -> bool: ...
    def predict_function_rva(self, library: str, function: str) -> int: ...
    def remove(self, section: lief.PE.Section, clear: bool = ...) -> None: ...
    def remove_all_libraries(self) -> None: ...
    def remove_all_relocations(self) -> None: ...
    def remove_library(self, import_name: str) -> None: ...
    def rva_to_offset(self, rva_address: int) -> int: ...
    def section_from_offset(self, offset: int) -> lief.PE.Section: ...
    def section_from_rva(self, rva: int) -> lief.PE.Section: ...
    def va_to_offset(self, va_address: int) -> int: ...
    @overload
    def verify_signature(self, checks: lief.PE.Signature.VERIFICATION_CHECKS = ...) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    @overload
    def verify_signature(self, signature: lief.PE.Signature, checks: lief.PE.Signature.VERIFICATION_CHECKS = ...) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    def write(self, output_path: str) -> None: ...
    @property
    def authentihash_md5(self) -> bytes: ...
    @property
    def authentihash_sha1(self) -> bytes: ...
    @property
    def authentihash_sha256(self) -> bytes: ...
    @property
    def authentihash_sha512(self) -> bytes: ...
    @property
    def codeview_pdb(self) -> lief.PE.CodeViewPDB: ...
    @property
    def data_directories(self) -> lief.PE.Binary.it_data_directories: ...
    @property
    def debug(self) -> lief.PE.Binary.it_debug: ...
    @property
    def delay_imports(self) -> lief.PE.Binary.it_delay_imports: ...
    @property
    def dos_header(self) -> lief.PE.DosHeader: ...
    @property
    def exception_functions(self) -> list[lief.Function]: ...
    @property
    def functions(self) -> list[lief.Function]: ...
    @property
    def has_configuration(self) -> bool: ...
    @property
    def has_debug(self) -> bool: ...
    @property
    def has_delay_imports(self) -> bool: ...
    @property
    def has_exceptions(self) -> bool: ...
    @property
    def has_exports(self) -> bool: ...
    @property
    def has_imports(self) -> bool: ...
    @property
    def has_relocations(self) -> bool: ...
    @property
    def has_resources(self) -> bool: ...
    @property
    def has_rich_header(self) -> bool: ...
    @property
    def has_signatures(self) -> bool: ...
    @property
    def has_tls(self) -> bool: ...
    @property
    def header(self) -> lief.PE.Header: ...  # type: ignore
    @property
    def imports(self) -> lief.PE.Binary.it_imports: ...
    @property
    def is_reproducible_build(self) -> bool: ...
    @property
    def load_configuration(self) -> lief.PE.LoadConfiguration: ...
    @property
    def optional_header(self) -> lief.PE.OptionalHeader: ...
    @property
    def overlay(self) -> memoryview: ...
    @property
    def overlay_offset(self) -> int: ...
    @property
    def relocations(self) -> lief.PE.Binary.it_relocations: ...  # type: ignore
    @property
    def resources(self) -> lief.PE.ResourceNode: ...
    @property
    def resources_manager(self) -> Union[lief.PE.ResourcesManager,lief.lief_errors]: ...
    @property
    def sections(self) -> lief.PE.Binary.it_section: ...  # type: ignore
    @property
    def signatures(self) -> lief.PE.Binary.it_const_signatures: ...
    @property
    def sizeof_headers(self) -> int: ...
    @property
    def symbols(self) -> list[lief.PE.Symbol]: ...  # type: ignore
    @property
    def virtual_size(self) -> int: ...

class Builder:
    def __init__(self, pe_binary: lief.PE.Binary) -> None: ...
    def build(self) -> Union[lief.ok_t,lief.lief_errors]: ...
    def build_dos_stub(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_imports(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_overlay(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_relocations(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_resources(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_tls(self, enable: bool = ...) -> lief.PE.Builder: ...
    def get_build(self) -> list[int]: ...
    def patch_imports(self, enable: bool = ...) -> lief.PE.Builder: ...
    def write(self, output: str) -> None: ...

class CODE_PAGES:
    ASMO_708: ClassVar[CODE_PAGES] = ...
    BIG5: ClassVar[CODE_PAGES] = ...
    CP1025: ClassVar[CODE_PAGES] = ...
    CP866: ClassVar[CODE_PAGES] = ...
    CP875: ClassVar[CODE_PAGES] = ...
    CSISO2022JP: ClassVar[CODE_PAGES] = ...
    DOS_720: ClassVar[CODE_PAGES] = ...
    DOS_862: ClassVar[CODE_PAGES] = ...
    EUC_CN: ClassVar[CODE_PAGES] = ...
    EUC_JP: ClassVar[CODE_PAGES] = ...
    EUC_JP_JIS: ClassVar[CODE_PAGES] = ...
    EUC_KR: ClassVar[CODE_PAGES] = ...
    GB18030: ClassVar[CODE_PAGES] = ...
    GB2312: ClassVar[CODE_PAGES] = ...
    HZ_GB_2312: ClassVar[CODE_PAGES] = ...
    IBM00858: ClassVar[CODE_PAGES] = ...
    IBM00924: ClassVar[CODE_PAGES] = ...
    IBM01047: ClassVar[CODE_PAGES] = ...
    IBM01140: ClassVar[CODE_PAGES] = ...
    IBM01141: ClassVar[CODE_PAGES] = ...
    IBM01142: ClassVar[CODE_PAGES] = ...
    IBM01143: ClassVar[CODE_PAGES] = ...
    IBM01144: ClassVar[CODE_PAGES] = ...
    IBM01145: ClassVar[CODE_PAGES] = ...
    IBM01146: ClassVar[CODE_PAGES] = ...
    IBM01147: ClassVar[CODE_PAGES] = ...
    IBM01148: ClassVar[CODE_PAGES] = ...
    IBM01149: ClassVar[CODE_PAGES] = ...
    IBM037: ClassVar[CODE_PAGES] = ...
    IBM1026: ClassVar[CODE_PAGES] = ...
    IBM273: ClassVar[CODE_PAGES] = ...
    IBM277: ClassVar[CODE_PAGES] = ...
    IBM278: ClassVar[CODE_PAGES] = ...
    IBM280: ClassVar[CODE_PAGES] = ...
    IBM284: ClassVar[CODE_PAGES] = ...
    IBM285: ClassVar[CODE_PAGES] = ...
    IBM290: ClassVar[CODE_PAGES] = ...
    IBM297: ClassVar[CODE_PAGES] = ...
    IBM420: ClassVar[CODE_PAGES] = ...
    IBM423: ClassVar[CODE_PAGES] = ...
    IBM424: ClassVar[CODE_PAGES] = ...
    IBM437: ClassVar[CODE_PAGES] = ...
    IBM500: ClassVar[CODE_PAGES] = ...
    IBM737: ClassVar[CODE_PAGES] = ...
    IBM775: ClassVar[CODE_PAGES] = ...
    IBM850: ClassVar[CODE_PAGES] = ...
    IBM852: ClassVar[CODE_PAGES] = ...
    IBM855: ClassVar[CODE_PAGES] = ...
    IBM857: ClassVar[CODE_PAGES] = ...
    IBM860: ClassVar[CODE_PAGES] = ...
    IBM861: ClassVar[CODE_PAGES] = ...
    IBM863: ClassVar[CODE_PAGES] = ...
    IBM864: ClassVar[CODE_PAGES] = ...
    IBM865: ClassVar[CODE_PAGES] = ...
    IBM869: ClassVar[CODE_PAGES] = ...
    IBM870: ClassVar[CODE_PAGES] = ...
    IBM871: ClassVar[CODE_PAGES] = ...
    IBM880: ClassVar[CODE_PAGES] = ...
    IBM905: ClassVar[CODE_PAGES] = ...
    IBM_THAI: ClassVar[CODE_PAGES] = ...
    ISO_2022_JP: ClassVar[CODE_PAGES] = ...
    ISO_2022_JP_JIS: ClassVar[CODE_PAGES] = ...
    ISO_2022_KR: ClassVar[CODE_PAGES] = ...
    ISO_8859_1: ClassVar[CODE_PAGES] = ...
    ISO_8859_13: ClassVar[CODE_PAGES] = ...
    ISO_8859_15: ClassVar[CODE_PAGES] = ...
    ISO_8859_2: ClassVar[CODE_PAGES] = ...
    ISO_8859_3: ClassVar[CODE_PAGES] = ...
    ISO_8859_4: ClassVar[CODE_PAGES] = ...
    ISO_8859_5: ClassVar[CODE_PAGES] = ...
    ISO_8859_6: ClassVar[CODE_PAGES] = ...
    ISO_8859_7: ClassVar[CODE_PAGES] = ...
    ISO_8859_8: ClassVar[CODE_PAGES] = ...
    ISO_8859_8_I: ClassVar[CODE_PAGES] = ...
    ISO_8859_9: ClassVar[CODE_PAGES] = ...
    JOHAB: ClassVar[CODE_PAGES] = ...
    KOI8_R: ClassVar[CODE_PAGES] = ...
    KOI8_U: ClassVar[CODE_PAGES] = ...
    KS_C_5601_1987: ClassVar[CODE_PAGES] = ...
    MACINTOSH: ClassVar[CODE_PAGES] = ...
    SHIFT_JIS: ClassVar[CODE_PAGES] = ...
    UNICODEFFFE: ClassVar[CODE_PAGES] = ...
    US_ASCII: ClassVar[CODE_PAGES] = ...
    UTF_16: ClassVar[CODE_PAGES] = ...
    UTF_32: ClassVar[CODE_PAGES] = ...
    UTF_32BE: ClassVar[CODE_PAGES] = ...
    UTF_7: ClassVar[CODE_PAGES] = ...
    UTF_8: ClassVar[CODE_PAGES] = ...
    WINDOWS_1250: ClassVar[CODE_PAGES] = ...
    WINDOWS_1251: ClassVar[CODE_PAGES] = ...
    WINDOWS_1252: ClassVar[CODE_PAGES] = ...
    WINDOWS_1253: ClassVar[CODE_PAGES] = ...
    WINDOWS_1254: ClassVar[CODE_PAGES] = ...
    WINDOWS_1255: ClassVar[CODE_PAGES] = ...
    WINDOWS_1256: ClassVar[CODE_PAGES] = ...
    WINDOWS_1257: ClassVar[CODE_PAGES] = ...
    WINDOWS_1258: ClassVar[CODE_PAGES] = ...
    WINDOWS_874: ClassVar[CODE_PAGES] = ...
    X_CHINESE_CNS: ClassVar[CODE_PAGES] = ...
    X_CHINESE_ETEN: ClassVar[CODE_PAGES] = ...
    X_CP20001: ClassVar[CODE_PAGES] = ...
    X_CP20003: ClassVar[CODE_PAGES] = ...
    X_CP20004: ClassVar[CODE_PAGES] = ...
    X_CP20005: ClassVar[CODE_PAGES] = ...
    X_CP20261: ClassVar[CODE_PAGES] = ...
    X_CP20269: ClassVar[CODE_PAGES] = ...
    X_CP20936: ClassVar[CODE_PAGES] = ...
    X_CP20949: ClassVar[CODE_PAGES] = ...
    X_CP50227: ClassVar[CODE_PAGES] = ...
    X_EBCDIC_KOREANEXTENDED: ClassVar[CODE_PAGES] = ...
    X_EUROPA: ClassVar[CODE_PAGES] = ...
    X_IA5: ClassVar[CODE_PAGES] = ...
    X_IA5_GERMAN: ClassVar[CODE_PAGES] = ...
    X_IA5_NORWEGIAN: ClassVar[CODE_PAGES] = ...
    X_IA5_SWEDISH: ClassVar[CODE_PAGES] = ...
    X_ISCII_AS: ClassVar[CODE_PAGES] = ...
    X_ISCII_BE: ClassVar[CODE_PAGES] = ...
    X_ISCII_DE: ClassVar[CODE_PAGES] = ...
    X_ISCII_GU: ClassVar[CODE_PAGES] = ...
    X_ISCII_KA: ClassVar[CODE_PAGES] = ...
    X_ISCII_MA: ClassVar[CODE_PAGES] = ...
    X_ISCII_OR: ClassVar[CODE_PAGES] = ...
    X_ISCII_PA: ClassVar[CODE_PAGES] = ...
    X_ISCII_TA: ClassVar[CODE_PAGES] = ...
    X_ISCII_TE: ClassVar[CODE_PAGES] = ...
    X_MAC_ARABIC: ClassVar[CODE_PAGES] = ...
    X_MAC_CE: ClassVar[CODE_PAGES] = ...
    X_MAC_CHINESESIMP: ClassVar[CODE_PAGES] = ...
    X_MAC_CHINESETRAD: ClassVar[CODE_PAGES] = ...
    X_MAC_CROATIAN: ClassVar[CODE_PAGES] = ...
    X_MAC_CYRILLIC: ClassVar[CODE_PAGES] = ...
    X_MAC_GREEK: ClassVar[CODE_PAGES] = ...
    X_MAC_HEBREW: ClassVar[CODE_PAGES] = ...
    X_MAC_ICELANDIC: ClassVar[CODE_PAGES] = ...
    X_MAC_JAPANESE: ClassVar[CODE_PAGES] = ...
    X_MAC_KOREAN: ClassVar[CODE_PAGES] = ...
    X_MAC_ROMANIAN: ClassVar[CODE_PAGES] = ...
    X_MAC_THAI: ClassVar[CODE_PAGES] = ...
    X_MAC_TURKISH: ClassVar[CODE_PAGES] = ...
    X_MAC_UKRAINIAN: ClassVar[CODE_PAGES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.CODE_PAGES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class CodeIntegrity(lief.Object):
    catalog: int
    catalog_offset: int
    flags: int
    reserved: int
    def __init__(self) -> None: ...

class CodeView(Debug):
    class SIGNATURES:
        CV_41: ClassVar[CodeView.SIGNATURES] = ...
        CV_50: ClassVar[CodeView.SIGNATURES] = ...
        PDB_20: ClassVar[CodeView.SIGNATURES] = ...
        PDB_70: ClassVar[CodeView.SIGNATURES] = ...
        UNKNOWN: ClassVar[CodeView.SIGNATURES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.CodeView.SIGNATURES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: lief.PE.CodeView.SIGNATURES, /) -> None: ...
    @property
    def cv_signature(self) -> lief.PE.CodeView.SIGNATURES: ...

class CodeViewPDB(CodeView):
    age: int
    filename: Union[str,bytes]
    signature: list[int]
    def __init__(self) -> None: ...
    @property
    def guid(self) -> str: ...
    @property
    def parent(self) -> lief.PE.CodeView: ...

class ContentInfo(lief.Object):
    class Content(lief.Object):
        def __init__(self, *args, **kwargs) -> None: ...
        def copy(self) -> Optional[lief.PE.ContentInfo.Content]: ...
        @property
        def content_type(self) -> str: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def copy(self) -> lief.PE.ContentInfo: ...
    @property
    def content_type(self) -> str: ...
    @property
    def digest(self) -> bytes: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def value(self) -> lief.PE.ContentInfo.Content: ...

class ContentType(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def oid(self) -> str: ...

class DIALOG_BOX_STYLES:
    ABSALIGN: ClassVar[DIALOG_BOX_STYLES] = ...
    CENTER: ClassVar[DIALOG_BOX_STYLES] = ...
    CENTERMOUSE: ClassVar[DIALOG_BOX_STYLES] = ...
    CONTEXTHELP: ClassVar[DIALOG_BOX_STYLES] = ...
    CONTROL: ClassVar[DIALOG_BOX_STYLES] = ...
    D3DLOOK: ClassVar[DIALOG_BOX_STYLES] = ...
    FIXEDSYS: ClassVar[DIALOG_BOX_STYLES] = ...
    LOCALEDIT: ClassVar[DIALOG_BOX_STYLES] = ...
    MODALFRAME: ClassVar[DIALOG_BOX_STYLES] = ...
    NOFAILCREATE: ClassVar[DIALOG_BOX_STYLES] = ...
    NOIDLEMSG: ClassVar[DIALOG_BOX_STYLES] = ...
    SETFONT: ClassVar[DIALOG_BOX_STYLES] = ...
    SETFOREGROUND: ClassVar[DIALOG_BOX_STYLES] = ...
    SHELLFONT: ClassVar[DIALOG_BOX_STYLES] = ...
    SYSMODAL: ClassVar[DIALOG_BOX_STYLES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.DIALOG_BOX_STYLES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class DataDirectory(lief.Object):
    class TYPES:
        ARCHITECTURE: ClassVar[DataDirectory.TYPES] = ...
        BASE_RELOCATION_TABLE: ClassVar[DataDirectory.TYPES] = ...
        BOUND_IMPORT: ClassVar[DataDirectory.TYPES] = ...
        CERTIFICATE_TABLE: ClassVar[DataDirectory.TYPES] = ...
        CLR_RUNTIME_HEADER: ClassVar[DataDirectory.TYPES] = ...
        DEBUG_DIR: ClassVar[DataDirectory.TYPES] = ...
        DELAY_IMPORT_DESCRIPTOR: ClassVar[DataDirectory.TYPES] = ...
        EXCEPTION_TABLE: ClassVar[DataDirectory.TYPES] = ...
        EXPORT_TABLE: ClassVar[DataDirectory.TYPES] = ...
        GLOBAL_PTR: ClassVar[DataDirectory.TYPES] = ...
        IAT: ClassVar[DataDirectory.TYPES] = ...
        IMPORT_TABLE: ClassVar[DataDirectory.TYPES] = ...
        LOAD_CONFIG_TABLE: ClassVar[DataDirectory.TYPES] = ...
        RESERVED: ClassVar[DataDirectory.TYPES] = ...
        RESOURCE_TABLE: ClassVar[DataDirectory.TYPES] = ...
        TLS_TABLE: ClassVar[DataDirectory.TYPES] = ...
        UNKNOWN: ClassVar[DataDirectory.TYPES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.DataDirectory.TYPES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    rva: int
    size: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.DataDirectory: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def section(self) -> lief.PE.Section: ...
    @property
    def type(self) -> lief.PE.DataDirectory.TYPES: ...

class Debug(lief.Object):
    class TYPES:
        BORLAND: ClassVar[Debug.TYPES] = ...
        CLSID: ClassVar[Debug.TYPES] = ...
        CODEVIEW: ClassVar[Debug.TYPES] = ...
        COFF: ClassVar[Debug.TYPES] = ...
        EXCEPTION: ClassVar[Debug.TYPES] = ...
        EX_DLLCHARACTERISTICS: ClassVar[Debug.TYPES] = ...
        FIXUP: ClassVar[Debug.TYPES] = ...
        FPO: ClassVar[Debug.TYPES] = ...
        ILTCG: ClassVar[Debug.TYPES] = ...
        MISC: ClassVar[Debug.TYPES] = ...
        MPX: ClassVar[Debug.TYPES] = ...
        OMAP_FROM_SRC: ClassVar[Debug.TYPES] = ...
        OMAP_TO_SRC: ClassVar[Debug.TYPES] = ...
        POGO: ClassVar[Debug.TYPES] = ...
        REPRO: ClassVar[Debug.TYPES] = ...
        RESERVED: ClassVar[Debug.TYPES] = ...
        UNKNOWN: ClassVar[Debug.TYPES] = ...
        VC_FEATURE: ClassVar[Debug.TYPES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Debug.TYPES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    addressof_rawdata: int
    characteristics: int
    major_version: int
    minor_version: int
    pointerto_rawdata: int
    sizeof_data: int
    timestamp: int
    def __init__(self) -> None: ...
    def copy(self) -> Optional[lief.PE.Debug]: ...
    @property
    def type(self) -> lief.PE.Debug.TYPES: ...

class DelayImport(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.DelayImportEntry: ...
        def __iter__(self) -> lief.PE.DelayImport.it_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.DelayImportEntry: ...
    attribute: int
    biat: int
    handle: int
    iat: int
    name: Union[str,bytes]
    names_table: int
    timestamp: int
    uiat: int
    def __init__(self, library_name: str) -> None: ...
    def copy(self) -> lief.PE.DelayImport: ...
    @property
    def entries(self) -> lief.PE.DelayImport.it_entries: ...

class DelayImportEntry(lief.Symbol):
    data: int
    name: Union[str,bytes]
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.DelayImportEntry: ...
    @property
    def hint(self) -> int: ...
    @property
    def iat_value(self) -> int: ...
    @property
    def is_ordinal(self) -> bool: ...
    @property
    def ordinal(self) -> int: ...

class DosHeader(lief.Object):
    addressof_new_exeheader: int
    addressof_relocation_table: int
    checksum: int
    file_size_in_pages: int
    header_size_in_paragraphs: int
    initial_ip: int
    initial_relative_cs: int
    initial_relative_ss: int
    initial_sp: int
    magic: int
    maximum_extra_paragraphs: int
    minimum_extra_paragraphs: int
    numberof_relocation: int
    oem_id: int
    oem_info: int
    overlay_number: int
    used_bytes_in_last_page: int
    def __init__(self, *args, **kwargs) -> None: ...
    def copy(self) -> lief.PE.DosHeader: ...
    @staticmethod
    def create(arg: lief.PE.PE_TYPE, /) -> lief.PE.DosHeader: ...

class EXTENDED_WINDOW_STYLES:
    ACCEPTFILES: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    APPWINDOW: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    CLIENTEDGE: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    CONTEXTHELP: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    CONTROLPARENT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    DLGMODALFRAME: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    LEFT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    LEFTSCROLLBAR: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    LTRREADING: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    MDICHILD: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    NOPARENTNOTIFY: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    RIGHT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    RIGHTSCROLLBAR: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    RTLREADING: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    STATICEDGE: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    TOOLWINDOW: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    TOPMOST: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    TRANSPARENT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    WINDOWEDGE: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.EXTENDED_WINDOW_STYLES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class Export(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ExportEntry: ...
        def __iter__(self) -> lief.PE.Export.it_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ExportEntry: ...
    export_flags: int
    major_version: int
    minor_version: int
    name: Union[str,bytes]
    ordinal_base: int
    timestamp: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.Export: ...
    @property
    def entries(self) -> lief.PE.Export.it_entries: ...

class ExportEntry(lief.Symbol):
    class forward_information_t:
        function: str
        library: str
        def __init__(self, *args, **kwargs) -> None: ...
    address: int
    is_extern: bool
    name: Union[str,bytes]
    ordinal: int
    def __init__(self) -> None: ...
    @property
    def forward_information(self) -> lief.PE.ExportEntry.forward_information_t: ...
    @property
    def function_rva(self) -> int: ...
    @property
    def is_forwarded(self) -> bool: ...

class FIXED_VERSION_FILE_FLAGS:
    DEBUG: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    INFOINFERRED: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    PATCHED: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    PRERELEASE: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    PRIVATEBUILD: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    SPECIALBUILD: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.FIXED_VERSION_FILE_FLAGS: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class FIXED_VERSION_FILE_SUB_TYPES:
    DRV_COMM: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_DISPLAY: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_INSTALLABLE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_KEYBOARD: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_LANGUAGE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_MOUSE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_NETWORK: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_PRINTER: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_SOUND: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_SYSTEM: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_VERSIONED_PRINTER: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    FONT_RASTER: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    FONT_TRUETYPE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    FONT_VECTOR: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    UNKNOWN: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.FIXED_VERSION_FILE_SUB_TYPES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class FIXED_VERSION_FILE_TYPES:
    APP: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    DLL: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    DRV: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    FONT: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    STATIC_LIB: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    UNKNOWN: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    VXD: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.FIXED_VERSION_FILE_TYPES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class FIXED_VERSION_OS:
    DOS: ClassVar[FIXED_VERSION_OS] = ...
    DOS_WINDOWS16: ClassVar[FIXED_VERSION_OS] = ...
    DOS_WINDOWS32: ClassVar[FIXED_VERSION_OS] = ...
    NT: ClassVar[FIXED_VERSION_OS] = ...
    NT_WINDOWS32: ClassVar[FIXED_VERSION_OS] = ...
    OS216: ClassVar[FIXED_VERSION_OS] = ...
    OS216_PM16: ClassVar[FIXED_VERSION_OS] = ...
    OS232: ClassVar[FIXED_VERSION_OS] = ...
    OS232_PM32: ClassVar[FIXED_VERSION_OS] = ...
    PM16: ClassVar[FIXED_VERSION_OS] = ...
    PM32: ClassVar[FIXED_VERSION_OS] = ...
    UNKNOWN: ClassVar[FIXED_VERSION_OS] = ...
    WINDOWS16: ClassVar[FIXED_VERSION_OS] = ...
    WINDOWS32: ClassVar[FIXED_VERSION_OS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.FIXED_VERSION_OS: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class GenericContent(ContentInfo.Content):
    def __init__(self, *args, **kwargs) -> None: ...

class GenericType(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def oid(self) -> str: ...
    @property
    def raw_content(self) -> memoryview: ...

class Header(lief.Object):
    class CHARACTERISTICS:
        AGGRESSIVE_WS_TRIM: ClassVar[Header.CHARACTERISTICS] = ...
        BYTES_REVERSED_HI: ClassVar[Header.CHARACTERISTICS] = ...
        BYTES_REVERSED_LO: ClassVar[Header.CHARACTERISTICS] = ...
        DEBUG_STRIPPED: ClassVar[Header.CHARACTERISTICS] = ...
        DLL: ClassVar[Header.CHARACTERISTICS] = ...
        EXECUTABLE_IMAGE: ClassVar[Header.CHARACTERISTICS] = ...
        LARGE_ADDRESS_AWARE: ClassVar[Header.CHARACTERISTICS] = ...
        LINE_NUMS_STRIPPED: ClassVar[Header.CHARACTERISTICS] = ...
        LOCAL_SYMS_STRIPPED: ClassVar[Header.CHARACTERISTICS] = ...
        NEED_32BIT_MACHINE: ClassVar[Header.CHARACTERISTICS] = ...
        NET_RUN_FROM_SWAP: ClassVar[Header.CHARACTERISTICS] = ...
        RELOCS_STRIPPED: ClassVar[Header.CHARACTERISTICS] = ...
        REMOVABLE_RUN_FROM_SWAP: ClassVar[Header.CHARACTERISTICS] = ...
        SYSTEM: ClassVar[Header.CHARACTERISTICS] = ...
        UP_SYSTEM_ONLY: ClassVar[Header.CHARACTERISTICS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Header.CHARACTERISTICS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.Header.CHARACTERISTICS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.Header.CHARACTERISTICS, /) -> lief.PE.Header.CHARACTERISTICS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.Header.CHARACTERISTICS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class MACHINE_TYPES:
        AM33: ClassVar[Header.MACHINE_TYPES] = ...
        AMD64: ClassVar[Header.MACHINE_TYPES] = ...
        ARM: ClassVar[Header.MACHINE_TYPES] = ...
        ARM64: ClassVar[Header.MACHINE_TYPES] = ...
        ARMNT: ClassVar[Header.MACHINE_TYPES] = ...
        EBC: ClassVar[Header.MACHINE_TYPES] = ...
        I386: ClassVar[Header.MACHINE_TYPES] = ...
        IA64: ClassVar[Header.MACHINE_TYPES] = ...
        M32R: ClassVar[Header.MACHINE_TYPES] = ...
        MIPS16: ClassVar[Header.MACHINE_TYPES] = ...
        MIPSFPU: ClassVar[Header.MACHINE_TYPES] = ...
        MIPSFPU16: ClassVar[Header.MACHINE_TYPES] = ...
        POWERPC: ClassVar[Header.MACHINE_TYPES] = ...
        POWERPCFP: ClassVar[Header.MACHINE_TYPES] = ...
        R4000: ClassVar[Header.MACHINE_TYPES] = ...
        SH3: ClassVar[Header.MACHINE_TYPES] = ...
        SH3DSP: ClassVar[Header.MACHINE_TYPES] = ...
        SH4: ClassVar[Header.MACHINE_TYPES] = ...
        SH5: ClassVar[Header.MACHINE_TYPES] = ...
        THUMB: ClassVar[Header.MACHINE_TYPES] = ...
        UNKNOWN: ClassVar[Header.MACHINE_TYPES] = ...
        WCEMIPSV2: ClassVar[Header.MACHINE_TYPES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Header.MACHINE_TYPES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    characteristics: int
    machine: lief.PE.Header.MACHINE_TYPES
    numberof_sections: int
    numberof_symbols: int
    pointerto_symbol_table: int
    signature: list[int]
    sizeof_optional_header: int
    time_date_stamps: int
    def __init__(self, *args, **kwargs) -> None: ...
    def add_characteristic(self, characteristic: lief.PE.Header.CHARACTERISTICS) -> None: ...
    def copy(self) -> lief.PE.Header: ...
    @staticmethod
    def create(type: lief.PE.PE_TYPE) -> lief.PE.Header: ...
    def has_characteristic(self, characteristic: lief.PE.Header.CHARACTERISTICS) -> bool: ...
    def remove_characteristic(self, characteristic: lief.PE.Header.CHARACTERISTICS) -> None: ...
    @property
    def characteristics_list(self) -> list[lief.PE.Header.CHARACTERISTICS]: ...

class IMPHASH_MODE:
    DEFAULT: ClassVar[IMPHASH_MODE] = ...
    LIEF: ClassVar[IMPHASH_MODE] = ...
    PEFILE: ClassVar[IMPHASH_MODE] = ...
    VT: ClassVar[IMPHASH_MODE] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...

class Import(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ImportEntry: ...
        def __iter__(self) -> lief.PE.Import.it_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ImportEntry: ...
    import_address_table_rva: int
    import_lookup_table_rva: int
    name: Union[str,bytes]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, library_name: str) -> None: ...
    @overload
    def add_entry(self, entry: lief.PE.ImportEntry) -> lief.PE.ImportEntry: ...
    @overload
    def add_entry(self, function_name: str) -> lief.PE.ImportEntry: ...
    def get_entry(self, function_name: str) -> lief.PE.ImportEntry: ...
    def get_function_rva_from_iat(self, function_name: str) -> Union[int,lief.lief_errors]: ...
    @property
    def directory(self) -> lief.PE.DataDirectory: ...
    @property
    def entries(self) -> lief.PE.Import.it_entries: ...
    @property
    def forwarder_chain(self) -> int: ...
    @property
    def iat_directory(self) -> lief.PE.DataDirectory: ...
    @property
    def timedatestamp(self) -> int: ...

class ImportEntry(lief.Symbol):
    data: int
    name: Union[str,bytes]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, import_name: str) -> None: ...
    @overload
    def __init__(self, data: int, name: str = ...) -> None: ...
    @overload
    def __init__(self, data: int, type: lief.PE.PE_TYPE, name: str = ...) -> None: ...
    @overload
    def __init__(self, name: str, type: lief.PE.PE_TYPE) -> None: ...
    def copy(self) -> lief.PE.ImportEntry: ...
    @property
    def hint(self) -> int: ...
    @property
    def iat_address(self) -> int: ...
    @property
    def iat_value(self) -> int: ...
    @property
    def is_ordinal(self) -> bool: ...
    @property
    def ordinal(self) -> int: ...

class LangCodeItem(lief.Object):
    code_page: lief.PE.CODE_PAGES
    items: dict
    key: str
    lang: int
    sublang: int
    type: int
    def __init__(self, *args, **kwargs) -> None: ...

class LoadConfiguration(lief.Object):
    class VERSION:
        SEH: ClassVar[LoadConfiguration.VERSION] = ...
        UNKNOWN: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_14286: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_14383: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_14901: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_15002: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_16237: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_18362: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_19534: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_9879: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_MSVC_2019: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_10_0_MSVC_2019_16: ClassVar[LoadConfiguration.VERSION] = ...
        WIN_8_1: ClassVar[LoadConfiguration.VERSION] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.LoadConfiguration.VERSION: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    characteristics: int
    critical_section_default_timeout: int
    csd_version: int
    decommit_free_block_threshold: int
    decommit_total_free_threshold: int
    dependent_load_flags: int
    editlist: int
    global_flags_clear: int
    global_flags_set: int
    lock_prefix_table: int
    major_version: int
    maximum_allocation_size: int
    minor_version: int
    process_affinity_mask: int
    process_heap_flags: int
    reserved1: int
    security_cookie: int
    timedatestamp: int
    virtual_memory_threshold: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfiguration: ...
    @property
    def size(self) -> int: ...
    @property
    def version(self) -> lief.PE.LoadConfiguration.VERSION: ...

class LoadConfigurationV0(LoadConfiguration):
    se_handler_count: int
    se_handler_table: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV0: ...

class LoadConfigurationV1(LoadConfigurationV0):
    class IMAGE_GUARD:
        CFW_INSTRUMENTED: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        CF_ENABLE_EXPORT_SUPPRESSION: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        CF_EXPORT_SUPPRESSION_INFO_PRESENT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        CF_FUNCTION_TABLE_PRESENT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        CF_INSTRUMENTED: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        CF_LONGJUMP_TABLE_PRESENT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        DELAYLOAD_IAT_IN_ITS_OWN_SECTION: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        EH_CONTINUATION_TABLE_PRESENT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        NONE: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        PROTECT_DELAYLOAD_IAT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        RETPOLINE_PRESENT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        RF_ENABLE: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        RF_INSTRUMENTED: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        RF_STRICT: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        SECURITY_COOKIE_UNUSED: ClassVar[LoadConfigurationV1.IMAGE_GUARD] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.LoadConfigurationV1.IMAGE_GUARD: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.LoadConfigurationV1.IMAGE_GUARD, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.LoadConfigurationV1.IMAGE_GUARD, /) -> lief.PE.LoadConfigurationV1.IMAGE_GUARD: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.LoadConfigurationV1.IMAGE_GUARD, /) -> int: ...
        @property
        def value(self) -> int: ...
    guard_cf_check_function_pointer: int
    guard_cf_dispatch_function_pointer: int
    guard_cf_function_count: int
    guard_cf_function_table: int
    guard_flags: lief.PE.LoadConfigurationV1.IMAGE_GUARD
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV1: ...
    def has(self, flag: lief.PE.LoadConfigurationV1.IMAGE_GUARD) -> bool: ...
    def __contains__(self, arg: lief.PE.LoadConfigurationV1.IMAGE_GUARD, /) -> bool: ...
    @property
    def guard_cf_flags_list(self) -> list[lief.PE.LoadConfigurationV1.IMAGE_GUARD]: ...

class LoadConfigurationV10(LoadConfigurationV9):
    guard_xfg_check_function_pointer: int
    guard_xfg_dispatch_function_pointer: int
    guard_xfg_table_dispatch_function_pointer: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV10: ...

class LoadConfigurationV11(LoadConfigurationV10):
    cast_guard_os_determined_failure_mode: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV11: ...

class LoadConfigurationV2(LoadConfigurationV1):
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV2: ...
    @property
    def code_integrity(self) -> lief.PE.CodeIntegrity: ...

class LoadConfigurationV3(LoadConfigurationV2):
    guard_address_taken_iat_entry_count: int
    guard_address_taken_iat_entry_table: int
    guard_long_jump_target_count: int
    guard_long_jump_target_table: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV3: ...

class LoadConfigurationV4(LoadConfigurationV3):
    dynamic_value_reloc_table: int
    hybrid_metadata_pointer: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV4: ...

class LoadConfigurationV5(LoadConfigurationV4):
    dynamic_value_reloctable_offset: int
    dynamic_value_reloctable_section: int
    guard_rf_failure_routine: int
    guard_rf_failure_routine_function_pointer: int
    reserved2: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV5: ...

class LoadConfigurationV6(LoadConfigurationV5):
    guard_rf_verify_stackpointer_function_pointer: int
    hotpatch_table_offset: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV6: ...

class LoadConfigurationV7(LoadConfigurationV6):
    addressof_unicode_string: int
    reserved3: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV7: ...

class LoadConfigurationV8(LoadConfigurationV7):
    volatile_metadata_pointer: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV8: ...

class LoadConfigurationV9(LoadConfigurationV8):
    guard_eh_continuation_count: int
    guard_eh_continuation_table: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.LoadConfigurationV9: ...

class MsCounterSign(Attribute):
    class it_const_crt:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.x509: ...
        def __iter__(self) -> lief.PE.MsCounterSign.it_const_crt: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.x509: ...

    class it_const_signers_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.SignerInfo: ...
        def __iter__(self) -> lief.PE.MsCounterSign.it_const_signers_t: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.SignerInfo: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def certificates(self) -> lief.PE.MsCounterSign.it_const_crt: ...
    @property
    def content_info(self) -> lief.PE.ContentInfo: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def signers(self) -> lief.PE.MsCounterSign.it_const_signers_t: ...
    @property
    def version(self) -> int: ...

class MsManifestBinaryID(Attribute):
    manifest_id: str
    def __init__(self, *args, **kwargs) -> None: ...

class MsSpcNestedSignature(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def signature(self) -> lief.PE.Signature: ...

class MsSpcStatementType(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def oid(self) -> str: ...

class OptionalHeader(lief.Object):
    class DLL_CHARACTERISTICS:
        APPCONTAINER: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        DYNAMIC_BASE: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        FORCE_INTEGRITY: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        GUARD_CF: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        HIGH_ENTROPY_VA: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        NO_BIND: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        NO_ISOLATION: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        NO_SEH: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        NX_COMPAT: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        TERMINAL_SERVER_AWARE: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        WDM_DRIVER: ClassVar[OptionalHeader.DLL_CHARACTERISTICS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.OptionalHeader.DLL_CHARACTERISTICS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.OptionalHeader.DLL_CHARACTERISTICS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.OptionalHeader.DLL_CHARACTERISTICS, /) -> lief.PE.OptionalHeader.DLL_CHARACTERISTICS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.OptionalHeader.DLL_CHARACTERISTICS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class SUBSYSTEM:
        EFI_APPLICATION: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        EFI_BOOT_SERVICE_DRIVER: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        EFI_ROM: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        EFI_RUNTIME_DRIVER: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        NATIVE: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        NATIVE_WINDOWS: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        OS2_CUI: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        POSIX_CUI: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        UNKNOWN: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        WINDOWS_BOOT_APPLICATION: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        WINDOWS_CE_GUI: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        WINDOWS_CUI: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        WINDOWS_GUI: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        XBOX: ClassVar[OptionalHeader.SUBSYSTEM] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.OptionalHeader.SUBSYSTEM: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    addressof_entrypoint: int
    baseof_code: int
    baseof_data: int
    checksum: int
    dll_characteristics: int
    file_alignment: int
    imagebase: int
    loader_flags: int
    magic: lief.PE.PE_TYPE
    major_image_version: int
    major_linker_version: int
    major_operating_system_version: int
    major_subsystem_version: int
    minor_image_version: int
    minor_linker_version: int
    minor_operating_system_version: int
    minor_subsystem_version: int
    numberof_rva_and_size: int
    section_alignment: int
    sizeof_code: int
    sizeof_headers: int
    sizeof_heap_commit: int
    sizeof_heap_reserve: int
    sizeof_image: int
    sizeof_initialized_data: int
    sizeof_stack_commit: int
    sizeof_stack_reserve: int
    sizeof_uninitialized_data: int
    subsystem: lief.PE.OptionalHeader.SUBSYSTEM
    win32_version_value: int
    def __init__(self, *args, **kwargs) -> None: ...
    def add(self, characteristic: lief.PE.OptionalHeader.DLL_CHARACTERISTICS) -> None: ...
    def copy(self) -> lief.PE.OptionalHeader: ...
    @staticmethod
    def create(type: lief.PE.PE_TYPE) -> lief.PE.OptionalHeader: ...
    def has(self, characteristics: lief.PE.OptionalHeader.DLL_CHARACTERISTICS) -> bool: ...
    def remove(self, characteristic: lief.PE.OptionalHeader.DLL_CHARACTERISTICS) -> None: ...
    def __contains__(self, arg: lief.PE.OptionalHeader.DLL_CHARACTERISTICS, /) -> bool: ...
    def __iadd__(self, arg: lief.PE.OptionalHeader.DLL_CHARACTERISTICS, /) -> lief.PE.OptionalHeader: ...
    def __isub__(self, arg: lief.PE.OptionalHeader.DLL_CHARACTERISTICS, /) -> lief.PE.OptionalHeader: ...
    @property
    def dll_characteristics_lists(self) -> list[lief.PE.OptionalHeader.DLL_CHARACTERISTICS]: ...

class PE_TYPE:
    PE32: ClassVar[PE_TYPE] = ...
    PE32_PLUS: ClassVar[PE_TYPE] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.PE_TYPE: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class PKCS9AtSequenceNumber(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def number(self) -> int: ...

class PKCS9CounterSignature(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def signer(self) -> lief.PE.SignerInfo: ...

class PKCS9MessageDigest(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def digest(self) -> bytes: ...

class PKCS9SigningTime(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def time(self) -> list[int]: ...

class PKCS9TSTInfo(ContentInfo.Content):
    def __init__(self, *args, **kwargs) -> None: ...

class ParserConfig:
    parse_exports: bool
    parse_imports: bool
    parse_reloc: bool
    parse_rsrc: bool
    parse_signature: bool
    def __init__(self) -> None: ...
    @property
    def all(self) -> lief.PE.ParserConfig: ...

class Pogo(Debug):
    class SIGNATURES:
        LCTG: ClassVar[Pogo.SIGNATURES] = ...
        PGI: ClassVar[Pogo.SIGNATURES] = ...
        UNKNOWN: ClassVar[Pogo.SIGNATURES] = ...
        ZERO: ClassVar[Pogo.SIGNATURES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Pogo.SIGNATURES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.PogoEntry: ...
        def __iter__(self) -> lief.PE.Pogo.it_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.PogoEntry: ...
    def __init__(self) -> None: ...
    @property
    def entries(self) -> lief.PE.Pogo.it_entries: ...
    @property
    def signature(self) -> lief.PE.Pogo.SIGNATURES: ...

class PogoEntry(lief.Object):
    name: Union[str,bytes]
    size: int
    start_rva: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.PogoEntry: ...

class RESOURCE_LANGS:
    AFRIKAANS: ClassVar[RESOURCE_LANGS] = ...
    ALBANIAN: ClassVar[RESOURCE_LANGS] = ...
    ARABIC: ClassVar[RESOURCE_LANGS] = ...
    ARMENIAN: ClassVar[RESOURCE_LANGS] = ...
    ASSAMESE: ClassVar[RESOURCE_LANGS] = ...
    AZERI: ClassVar[RESOURCE_LANGS] = ...
    BANGLA: ClassVar[RESOURCE_LANGS] = ...
    BASQUE: ClassVar[RESOURCE_LANGS] = ...
    BELARUSIAN: ClassVar[RESOURCE_LANGS] = ...
    BOSNIAN: ClassVar[RESOURCE_LANGS] = ...
    BRETON: ClassVar[RESOURCE_LANGS] = ...
    BULGARIAN: ClassVar[RESOURCE_LANGS] = ...
    CATALAN: ClassVar[RESOURCE_LANGS] = ...
    CHINESE: ClassVar[RESOURCE_LANGS] = ...
    CORNISH: ClassVar[RESOURCE_LANGS] = ...
    CROATIAN: ClassVar[RESOURCE_LANGS] = ...
    CZECH: ClassVar[RESOURCE_LANGS] = ...
    DANISH: ClassVar[RESOURCE_LANGS] = ...
    DIVEHI: ClassVar[RESOURCE_LANGS] = ...
    DUTCH: ClassVar[RESOURCE_LANGS] = ...
    ENGLISH: ClassVar[RESOURCE_LANGS] = ...
    ESPERANTO: ClassVar[RESOURCE_LANGS] = ...
    ESTONIAN: ClassVar[RESOURCE_LANGS] = ...
    FAEROESE: ClassVar[RESOURCE_LANGS] = ...
    FARSI: ClassVar[RESOURCE_LANGS] = ...
    FINNISH: ClassVar[RESOURCE_LANGS] = ...
    FRENCH: ClassVar[RESOURCE_LANGS] = ...
    GAELIC: ClassVar[RESOURCE_LANGS] = ...
    GALICIAN: ClassVar[RESOURCE_LANGS] = ...
    GEORGIAN: ClassVar[RESOURCE_LANGS] = ...
    GERMAN: ClassVar[RESOURCE_LANGS] = ...
    GREEK: ClassVar[RESOURCE_LANGS] = ...
    GUJARATI: ClassVar[RESOURCE_LANGS] = ...
    HEBREW: ClassVar[RESOURCE_LANGS] = ...
    HINDI: ClassVar[RESOURCE_LANGS] = ...
    HUNGARIAN: ClassVar[RESOURCE_LANGS] = ...
    ICELANDIC: ClassVar[RESOURCE_LANGS] = ...
    INDONESIAN: ClassVar[RESOURCE_LANGS] = ...
    INUKTITUT: ClassVar[RESOURCE_LANGS] = ...
    INVARIANT: ClassVar[RESOURCE_LANGS] = ...
    IRISH: ClassVar[RESOURCE_LANGS] = ...
    ITALIAN: ClassVar[RESOURCE_LANGS] = ...
    JAPANESE: ClassVar[RESOURCE_LANGS] = ...
    KANNADA: ClassVar[RESOURCE_LANGS] = ...
    KASHMIRI: ClassVar[RESOURCE_LANGS] = ...
    KAZAK: ClassVar[RESOURCE_LANGS] = ...
    KONKANI: ClassVar[RESOURCE_LANGS] = ...
    KOREAN: ClassVar[RESOURCE_LANGS] = ...
    KYRGYZ: ClassVar[RESOURCE_LANGS] = ...
    LATVIAN: ClassVar[RESOURCE_LANGS] = ...
    LITHUANIAN: ClassVar[RESOURCE_LANGS] = ...
    LOWER_SORBIAN: ClassVar[RESOURCE_LANGS] = ...
    MACEDONIAN: ClassVar[RESOURCE_LANGS] = ...
    MALAY: ClassVar[RESOURCE_LANGS] = ...
    MALAYALAM: ClassVar[RESOURCE_LANGS] = ...
    MALTESE: ClassVar[RESOURCE_LANGS] = ...
    MANIPURI: ClassVar[RESOURCE_LANGS] = ...
    MAORI: ClassVar[RESOURCE_LANGS] = ...
    MARATHI: ClassVar[RESOURCE_LANGS] = ...
    MONGOLIAN: ClassVar[RESOURCE_LANGS] = ...
    NEPALI: ClassVar[RESOURCE_LANGS] = ...
    NEUTRAL: ClassVar[RESOURCE_LANGS] = ...
    NORWEGIAN: ClassVar[RESOURCE_LANGS] = ...
    ORIYA: ClassVar[RESOURCE_LANGS] = ...
    POLISH: ClassVar[RESOURCE_LANGS] = ...
    PORTUGUESE: ClassVar[RESOURCE_LANGS] = ...
    PULAR: ClassVar[RESOURCE_LANGS] = ...
    PUNJABI: ClassVar[RESOURCE_LANGS] = ...
    QUECHUA: ClassVar[RESOURCE_LANGS] = ...
    RHAETO_ROMANCE: ClassVar[RESOURCE_LANGS] = ...
    ROMANIAN: ClassVar[RESOURCE_LANGS] = ...
    RUSSIAN: ClassVar[RESOURCE_LANGS] = ...
    SAMI: ClassVar[RESOURCE_LANGS] = ...
    SANSKRIT: ClassVar[RESOURCE_LANGS] = ...
    SERBIAN: ClassVar[RESOURCE_LANGS] = ...
    SINDHI: ClassVar[RESOURCE_LANGS] = ...
    SLOVAK: ClassVar[RESOURCE_LANGS] = ...
    SLOVENIAN: ClassVar[RESOURCE_LANGS] = ...
    SORBIAN: ClassVar[RESOURCE_LANGS] = ...
    SPANISH: ClassVar[RESOURCE_LANGS] = ...
    SUTU: ClassVar[RESOURCE_LANGS] = ...
    SWAHILI: ClassVar[RESOURCE_LANGS] = ...
    SWEDISH: ClassVar[RESOURCE_LANGS] = ...
    SYRIAC: ClassVar[RESOURCE_LANGS] = ...
    TAMAZIGHT: ClassVar[RESOURCE_LANGS] = ...
    TAMIL: ClassVar[RESOURCE_LANGS] = ...
    TATAR: ClassVar[RESOURCE_LANGS] = ...
    TELUGU: ClassVar[RESOURCE_LANGS] = ...
    THAI: ClassVar[RESOURCE_LANGS] = ...
    TIGRINYA: ClassVar[RESOURCE_LANGS] = ...
    TSONGA: ClassVar[RESOURCE_LANGS] = ...
    TSWANA: ClassVar[RESOURCE_LANGS] = ...
    TURKISH: ClassVar[RESOURCE_LANGS] = ...
    UKRAINIAN: ClassVar[RESOURCE_LANGS] = ...
    URDU: ClassVar[RESOURCE_LANGS] = ...
    UZBEK: ClassVar[RESOURCE_LANGS] = ...
    VALENCIAN: ClassVar[RESOURCE_LANGS] = ...
    VENDA: ClassVar[RESOURCE_LANGS] = ...
    VIETNAMESE: ClassVar[RESOURCE_LANGS] = ...
    WALON: ClassVar[RESOURCE_LANGS] = ...
    WELSH: ClassVar[RESOURCE_LANGS] = ...
    XHOSA: ClassVar[RESOURCE_LANGS] = ...
    ZULU: ClassVar[RESOURCE_LANGS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.RESOURCE_LANGS: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class Relocation(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.RelocationEntry: ...
        def __iter__(self) -> lief.PE.Relocation.it_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.RelocationEntry: ...
    block_size: int
    virtual_address: int
    def __init__(self) -> None: ...
    def add_entry(self, new_entry: lief.PE.RelocationEntry) -> lief.PE.RelocationEntry: ...
    def copy(self) -> lief.PE.Relocation: ...
    @property
    def entries(self) -> lief.PE.Relocation.it_entries: ...

class RelocationEntry(lief.Relocation):
    class BASE_TYPES:
        ABS: ClassVar[RelocationEntry.BASE_TYPES] = ...
        ARM_MOV32: ClassVar[RelocationEntry.BASE_TYPES] = ...
        ARM_MOV32A: ClassVar[RelocationEntry.BASE_TYPES] = ...
        ARM_MOV32T: ClassVar[RelocationEntry.BASE_TYPES] = ...
        DIR64: ClassVar[RelocationEntry.BASE_TYPES] = ...
        HIGH: ClassVar[RelocationEntry.BASE_TYPES] = ...
        HIGH3ADJ: ClassVar[RelocationEntry.BASE_TYPES] = ...
        HIGHADJ: ClassVar[RelocationEntry.BASE_TYPES] = ...
        HIGHLOW: ClassVar[RelocationEntry.BASE_TYPES] = ...
        IA64_IMM64: ClassVar[RelocationEntry.BASE_TYPES] = ...
        LOW: ClassVar[RelocationEntry.BASE_TYPES] = ...
        MIPS_JMPADDR: ClassVar[RelocationEntry.BASE_TYPES] = ...
        MIPS_JMPADDR16: ClassVar[RelocationEntry.BASE_TYPES] = ...
        REL: ClassVar[RelocationEntry.BASE_TYPES] = ...
        RISCV_HI20: ClassVar[RelocationEntry.BASE_TYPES] = ...
        RISCV_LOW12I: ClassVar[RelocationEntry.BASE_TYPES] = ...
        RISCV_LOW12S: ClassVar[RelocationEntry.BASE_TYPES] = ...
        SECTION: ClassVar[RelocationEntry.BASE_TYPES] = ...
        THUMB_MOV32: ClassVar[RelocationEntry.BASE_TYPES] = ...
        UNKNOWN: ClassVar[RelocationEntry.BASE_TYPES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.RelocationEntry.BASE_TYPES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    data: int
    position: int
    type: lief.PE.RelocationEntry.BASE_TYPES
    def __init__(self) -> None: ...

class Repro(Debug):
    hash: memoryview
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceAccelerator(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def ansi(self) -> int: ...
    @property
    def flags(self) -> int: ...
    @property
    def id(self) -> int: ...
    @property
    def padding(self) -> int: ...

class ResourceData(ResourceNode):
    code_page: int
    content: memoryview
    reserved: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, content: list[int], code_page: int) -> None: ...
    @property
    def offset(self) -> int: ...

class ResourceDialog(lief.Object):
    class it_const_items:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ResourceDialogItem: ...
        def __iter__(self) -> lief.PE.ResourceDialog.it_const_items: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceDialogItem: ...
    lang: int
    sub_lang: int
    def __init__(self, *args, **kwargs) -> None: ...
    def has_dialogbox_style(self, style: lief.PE.DIALOG_BOX_STYLES) -> bool: ...
    def has_extended_style(self, style: lief.PE.EXTENDED_WINDOW_STYLES) -> bool: ...
    def has_style(self, style: lief.PE.WINDOW_STYLES) -> bool: ...
    @property
    def charset(self) -> int: ...
    @property
    def cx(self) -> int: ...
    @property
    def cy(self) -> int: ...
    @property
    def dialogbox_style_list(self) -> set[lief.PE.DIALOG_BOX_STYLES]: ...
    @property
    def extended_style(self) -> int: ...
    @property
    def extended_style_list(self) -> set[lief.PE.DIALOG_BOX_STYLES]: ...
    @property
    def help_id(self) -> int: ...
    @property
    def is_extended(self) -> bool: ...
    @property
    def items(self) -> lief.PE.ResourceDialog.it_const_items: ...
    @property
    def point_size(self) -> int: ...
    @property
    def signature(self) -> int: ...
    @property
    def style(self) -> int: ...
    @property
    def style_list(self) -> set[lief.PE.WINDOW_STYLES]: ...
    @property
    def title(self) -> str: ...
    @property
    def typeface(self) -> str: ...
    @property
    def version(self) -> int: ...
    @property
    def weight(self) -> int: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class ResourceDialogItem(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def cx(self) -> int: ...
    @property
    def cy(self) -> int: ...
    @property
    def extended_style(self) -> int: ...
    @property
    def help_id(self) -> int: ...
    @property
    def id(self) -> int: ...
    @property
    def is_extended(self) -> bool: ...
    @property
    def style(self) -> int: ...
    @property
    def title(self) -> str: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class ResourceDirectory(ResourceNode):
    characteristics: int
    major_version: int
    minor_version: int
    numberof_id_entries: int
    numberof_name_entries: int
    time_date_stamp: int
    def __init__(self) -> None: ...

class ResourceFixedFileInfo(lief.Object):
    file_date_LS: int
    file_date_MS: int
    file_flags: int
    file_flags_mask: int
    file_os: lief.PE.FIXED_VERSION_OS
    file_subtype: lief.PE.FIXED_VERSION_FILE_SUB_TYPES
    file_type: lief.PE.FIXED_VERSION_FILE_TYPES
    file_version_LS: int
    file_version_MS: int
    product_version_LS: int
    product_version_MS: int
    signature: int
    struct_version: int
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceIcon(lief.Object):
    bit_count: int
    color_count: int
    height: int
    id: int
    lang: int
    pixels: memoryview
    planes: int
    reserved: int
    sublang: int
    width: int
    def __init__(self, *args, **kwargs) -> None: ...
    def save(self, filepath: str) -> None: ...

class ResourceNode(lief.Object):
    class it_childs:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ResourceNode: ...
        def __iter__(self) -> lief.PE.ResourceNode.it_childs: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceNode: ...
    id: int
    name: Union[str,bytes]
    def __init__(self, *args, **kwargs) -> None: ...
    def add_data_node(self, resource_data: lief.PE.ResourceData) -> lief.PE.ResourceNode: ...
    def add_directory_node(self, resource_directory: lief.PE.ResourceDirectory) -> lief.PE.ResourceNode: ...
    def copy(self) -> Optional[lief.PE.ResourceNode]: ...
    @overload
    def delete_child(self, node: lief.PE.ResourceNode) -> None: ...
    @overload
    def delete_child(self, id: int) -> None: ...
    @property
    def childs(self) -> lief.PE.ResourceNode.it_childs: ...
    @property
    def depth(self) -> int: ...
    @property
    def has_name(self) -> bool: ...
    @property
    def is_data(self) -> bool: ...
    @property
    def is_directory(self) -> bool: ...

class ResourceStringFileInfo(lief.Object):
    key: str
    langcode_items: list[lief.PE.LangCodeItem]
    type: int
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceStringTable(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def length(self) -> int: ...
    @property
    def name(self) -> str: ...

class ResourceVarFileInfo(lief.Object):
    key: str
    translations: list[int]
    type: int
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceVersion(lief.Object):
    fixed_file_info: lief.PE.ResourceFixedFileInfo
    key: str
    string_file_info: lief.PE.ResourceStringFileInfo
    type: int
    var_file_info: lief.PE.ResourceVarFileInfo
    def __init__(self, *args, **kwargs) -> None: ...
    def remove_fixed_file_info(self) -> None: ...
    def remove_string_file_info(self) -> None: ...
    def remove_var_file_info(self) -> None: ...
    @property
    def has_fixed_file_info(self) -> bool: ...
    @property
    def has_string_file_info(self) -> bool: ...
    @property
    def has_var_file_info(self) -> bool: ...

class ResourcesManager(lief.Object):
    class TYPE:
        ACCELERATOR: ClassVar[ResourcesManager.TYPE] = ...
        ANICURSOR: ClassVar[ResourcesManager.TYPE] = ...
        ANIICON: ClassVar[ResourcesManager.TYPE] = ...
        BITMAP: ClassVar[ResourcesManager.TYPE] = ...
        CURSOR: ClassVar[ResourcesManager.TYPE] = ...
        DIALOG: ClassVar[ResourcesManager.TYPE] = ...
        DLGINCLUDE: ClassVar[ResourcesManager.TYPE] = ...
        FONT: ClassVar[ResourcesManager.TYPE] = ...
        FONTDIR: ClassVar[ResourcesManager.TYPE] = ...
        GROUP_CURSOR: ClassVar[ResourcesManager.TYPE] = ...
        GROUP_ICON: ClassVar[ResourcesManager.TYPE] = ...
        HTML: ClassVar[ResourcesManager.TYPE] = ...
        ICON: ClassVar[ResourcesManager.TYPE] = ...
        MANIFEST: ClassVar[ResourcesManager.TYPE] = ...
        MENU: ClassVar[ResourcesManager.TYPE] = ...
        MESSAGETABLE: ClassVar[ResourcesManager.TYPE] = ...
        PLUGPLAY: ClassVar[ResourcesManager.TYPE] = ...
        RCDATA: ClassVar[ResourcesManager.TYPE] = ...
        STRING: ClassVar[ResourcesManager.TYPE] = ...
        VERSION: ClassVar[ResourcesManager.TYPE] = ...
        VXD: ClassVar[ResourcesManager.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.ResourcesManager.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_const_accelerators:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ResourceAccelerator: ...
        def __iter__(self) -> lief.PE.ResourcesManager.it_const_accelerators: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceAccelerator: ...

    class it_const_dialogs:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ResourceDialog: ...
        def __iter__(self) -> lief.PE.ResourcesManager.it_const_dialogs: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceDialog: ...

    class it_const_icons:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ResourceIcon: ...
        def __iter__(self) -> lief.PE.ResourcesManager.it_const_icons: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceIcon: ...

    class it_const_strings_table:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.ResourceStringTable: ...
        def __iter__(self) -> lief.PE.ResourcesManager.it_const_strings_table: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceStringTable: ...
    manifest: Union[str,bytes]
    def __init__(self, arg: lief.PE.ResourceNode, /) -> None: ...
    def add_icon(self, icon: lief.PE.ResourceIcon) -> None: ...
    def change_icon(self, old_one: lief.PE.ResourceIcon, new_one: lief.PE.ResourceIcon) -> None: ...
    def get_node_type(self, type: lief.PE.ResourcesManager.TYPE) -> lief.PE.ResourceNode: ...
    def has_type(self, type: lief.PE.ResourcesManager.TYPE) -> bool: ...
    @property
    def accelerator(self) -> lief.PE.ResourcesManager.it_const_accelerators: ...
    @property
    def dialogs(self) -> lief.PE.ResourcesManager.it_const_dialogs: ...
    @property
    def has_accelerator(self) -> bool: ...
    @property
    def has_dialogs(self) -> bool: ...
    @property
    def has_html(self) -> bool: ...
    @property
    def has_icons(self) -> bool: ...
    @property
    def has_manifest(self) -> bool: ...
    @property
    def has_string_table(self) -> bool: ...
    @property
    def has_version(self) -> bool: ...
    @property
    def html(self) -> list[str]: ...
    @property
    def icons(self) -> lief.PE.ResourcesManager.it_const_icons: ...
    @property
    def string_table(self) -> lief.PE.ResourcesManager.it_const_strings_table: ...
    @property
    def types(self) -> list[lief.PE.ResourcesManager.TYPE]: ...
    @property
    def version(self) -> Union[lief.PE.ResourceVersion,lief.lief_errors]: ...

class RichEntry(lief.Object):
    build_id: int
    count: int
    id: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, id: int, build_id: int, count: int) -> None: ...
    def copy(self) -> lief.PE.RichEntry: ...

class RichHeader(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.RichEntry: ...
        def __iter__(self) -> lief.PE.RichHeader.it_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.RichEntry: ...
    key: int
    def __init__(self) -> None: ...
    @overload
    def add_entry(self, entry: lief.PE.RichEntry) -> None: ...
    @overload
    def add_entry(self, id: int, build_id: int, count: int) -> None: ...
    def copy(self) -> lief.PE.RichHeader: ...
    @overload
    def hash(self, algo: lief.PE.ALGORITHMS) -> list[int]: ...
    @overload
    def hash(self, algo: lief.PE.ALGORITHMS, xor_key: int) -> list[int]: ...
    @overload
    def raw(self) -> list[int]: ...
    @overload
    def raw(self, xor_key: int) -> list[int]: ...
    @property
    def entries(self) -> lief.PE.RichHeader.it_entries: ...

class RsaInfo:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def D(self) -> bytes: ...
    @property
    def E(self) -> bytes: ...
    @property
    def N(self) -> bytes: ...
    @property
    def P(self) -> bytes: ...
    @property
    def Q(self) -> bytes: ...
    @property
    def has_private_key(self) -> bool: ...
    @property
    def has_public_key(self) -> bool: ...
    @property
    def key_size(self) -> int: ...
    @property
    def __len__(self) -> int: ...

class SECTION_TYPES:
    BSS: ClassVar[SECTION_TYPES] = ...
    DATA: ClassVar[SECTION_TYPES] = ...
    EXPORT: ClassVar[SECTION_TYPES] = ...
    IDATA: ClassVar[SECTION_TYPES] = ...
    RELOCATION: ClassVar[SECTION_TYPES] = ...
    RESOURCE: ClassVar[SECTION_TYPES] = ...
    TEXT: ClassVar[SECTION_TYPES] = ...
    TLS_: ClassVar[SECTION_TYPES] = ...
    UNKNOWN: ClassVar[SECTION_TYPES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.SECTION_TYPES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class SYMBOL_BASE_TYPES:
    BYTE: ClassVar[SYMBOL_BASE_TYPES] = ...
    CHAR: ClassVar[SYMBOL_BASE_TYPES] = ...
    DOUBLE: ClassVar[SYMBOL_BASE_TYPES] = ...
    DWORD: ClassVar[SYMBOL_BASE_TYPES] = ...
    ENUM: ClassVar[SYMBOL_BASE_TYPES] = ...
    FLOAT: ClassVar[SYMBOL_BASE_TYPES] = ...
    INT: ClassVar[SYMBOL_BASE_TYPES] = ...
    LONG: ClassVar[SYMBOL_BASE_TYPES] = ...
    MOE: ClassVar[SYMBOL_BASE_TYPES] = ...
    NULL: ClassVar[SYMBOL_BASE_TYPES] = ...
    SHORT: ClassVar[SYMBOL_BASE_TYPES] = ...
    STRUCT: ClassVar[SYMBOL_BASE_TYPES] = ...
    UINT: ClassVar[SYMBOL_BASE_TYPES] = ...
    UNION: ClassVar[SYMBOL_BASE_TYPES] = ...
    VOID: ClassVar[SYMBOL_BASE_TYPES] = ...
    WORD: ClassVar[SYMBOL_BASE_TYPES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.SYMBOL_BASE_TYPES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class SYMBOL_COMPLEX_TYPES:
    ARRAY: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    COMPLEX_TYPE_SHIFT: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    FUNCTION: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    NULL: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    POINTER: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.SYMBOL_COMPLEX_TYPES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class SYMBOL_SECTION_NUMBER:
    ABSOLUTE: ClassVar[SYMBOL_SECTION_NUMBER] = ...
    DEBUG: ClassVar[SYMBOL_SECTION_NUMBER] = ...
    UNDEFINED: ClassVar[SYMBOL_SECTION_NUMBER] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.SYMBOL_SECTION_NUMBER: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class SYMBOL_STORAGE_CLASS:
    AUTOMATIC: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    BIT_FIELD: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    BLOCK: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    CLR_TOKEN: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    END_OF_FUNCTION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    END_OF_STRUCT: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    ENUM_TAG: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    EXTERNAL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    EXTERNAL_DEF: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    FILE: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    FUNCTION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    LABEL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    MEMBER_OF_ENUM: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    MEMBER_OF_STRUCT: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    NULL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    REGISTER: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    REGISTER_PARAM: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    SECTION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    STATIC: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    TYPE_DEFINITION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    UDEFINED_STATIC: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    UNDEFINED_LABEL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    UNION_TAG: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    WEAK_EXTERNAL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.SYMBOL_STORAGE_CLASS: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class Section(lief.Section):
    class CHARACTERISTICS:
        ALIGN_1024BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_128BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_16BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_1BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_2048BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_256BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_2BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_32BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_4096BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_4BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_512BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_64BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_8192BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        ALIGN_8BYTES: ClassVar[Section.CHARACTERISTICS] = ...
        CNT_CODE: ClassVar[Section.CHARACTERISTICS] = ...
        CNT_INITIALIZED_DATA: ClassVar[Section.CHARACTERISTICS] = ...
        CNT_UNINITIALIZED_DATA: ClassVar[Section.CHARACTERISTICS] = ...
        GPREL: ClassVar[Section.CHARACTERISTICS] = ...
        LNK_COMDAT: ClassVar[Section.CHARACTERISTICS] = ...
        LNK_INFO: ClassVar[Section.CHARACTERISTICS] = ...
        LNK_NRELOC_OVFL: ClassVar[Section.CHARACTERISTICS] = ...
        LNK_OTHER: ClassVar[Section.CHARACTERISTICS] = ...
        LNK_REMOVE: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_16BIT: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_DISCARDABLE: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_EXECUTE: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_LOCKED: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_NOT_CACHED: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_NOT_PAGED: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_PRELOAD: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_PURGEABLE: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_READ: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_SHARED: ClassVar[Section.CHARACTERISTICS] = ...
        MEM_WRITE: ClassVar[Section.CHARACTERISTICS] = ...
        TYPE_NO_PAD: ClassVar[Section.CHARACTERISTICS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Section.CHARACTERISTICS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.Section.CHARACTERISTICS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.Section.CHARACTERISTICS, /) -> lief.PE.Section.CHARACTERISTICS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.Section.CHARACTERISTICS, /) -> int: ...
        @property
        def value(self) -> int: ...
    characteristics: int
    numberof_line_numbers: int
    numberof_relocations: int
    pointerto_line_numbers: int
    pointerto_raw_data: int
    pointerto_relocation: int
    sizeof_raw_data: int
    virtual_size: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, content: list[int], name: str = ..., characteristics: int = ...) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    def copy(self) -> lief.PE.Section: ...
    def has_characteristic(self, characteristic: lief.PE.Section.CHARACTERISTICS) -> bool: ...
    @property
    def characteristics_lists(self) -> list[lief.PE.Section.CHARACTERISTICS]: ...
    @property
    def padding(self) -> bytes: ...

class Signature(lief.Object):
    class VERIFICATION_CHECKS:
        DEFAULT: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        HASH_ONLY: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        LIFETIME_SIGNING: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        SKIP_CERT_TIME: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Signature.VERIFICATION_CHECKS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.Signature.VERIFICATION_CHECKS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.Signature.VERIFICATION_CHECKS, /) -> lief.PE.Signature.VERIFICATION_CHECKS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.Signature.VERIFICATION_CHECKS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class VERIFICATION_FLAGS:
        BAD_DIGEST: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        BAD_SIGNATURE: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CERT_EXPIRED: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CERT_FUTURE: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CERT_NOT_FOUND: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CORRUPTED_AUTH_DATA: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CORRUPTED_CONTENT_INFO: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        INCONSISTENT_DIGEST_ALGORITHM: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        INVALID_SIGNER: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        MISSING_PKCS9_MESSAGE_DIGEST: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        NO_SIGNATURE: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        OK: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        UNSUPPORTED_ALGORITHM: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.Signature.VERIFICATION_FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.Signature.VERIFICATION_FLAGS, /) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.Signature.VERIFICATION_FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class it_const_crt:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.x509: ...
        def __iter__(self) -> lief.PE.Signature.it_const_crt: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.x509: ...

    class it_const_signers_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.SignerInfo: ...
        def __iter__(self) -> lief.PE.Signature.it_const_signers_t: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.SignerInfo: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def check(self, checks: lief.PE.Signature.VERIFICATION_CHECKS = ...) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    def find_crt(self, serialno: list[int]) -> lief.PE.x509: ...
    @overload
    def find_crt_issuer(self, issuer: str) -> lief.PE.x509: ...
    @overload
    def find_crt_issuer(self, issuer: str, serialno: list[int]) -> lief.PE.x509: ...
    @overload
    def find_crt_subject(self, subject: str) -> lief.PE.x509: ...
    @overload
    def find_crt_subject(self, subject: str, serialno: list[int]) -> lief.PE.x509: ...
    @overload
    @staticmethod
    def parse(path: str) -> Optional[lief.PE.Signature]: ...
    @overload
    @staticmethod
    def parse(raw: list[int], skip_header: bool = ...) -> Optional[lief.PE.Signature]: ...
    @property
    def certificates(self) -> lief.PE.Signature.it_const_crt: ...
    @property
    def content_info(self) -> lief.PE.ContentInfo: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def raw_der(self) -> memoryview: ...
    @property
    def signers(self) -> lief.PE.Signature.it_const_signers_t: ...
    @property
    def version(self) -> int: ...

class SignerInfo(lief.Object):
    class it_const_attributes_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.PE.Attribute: ...
        def __iter__(self) -> lief.PE.SignerInfo.it_const_attributes_t: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Attribute: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_attribute(self, type: lief.PE.Attribute.TYPE) -> lief.PE.Attribute: ...
    def get_auth_attribute(self, type: lief.PE.Attribute.TYPE) -> lief.PE.Attribute: ...
    def get_unauth_attribute(self, type: lief.PE.Attribute.TYPE) -> lief.PE.Attribute: ...
    @property
    def authenticated_attributes(self) -> lief.PE.SignerInfo.it_const_attributes_t: ...
    @property
    def cert(self) -> lief.PE.x509: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def encrypted_digest(self) -> bytes: ...
    @property
    def encryption_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def issuer(self) -> Union[str,bytes]: ...
    @property
    def serial_number(self) -> bytes: ...
    @property
    def unauthenticated_attributes(self) -> lief.PE.SignerInfo.it_const_attributes_t: ...
    @property
    def version(self) -> int: ...

class SigningCertificateV2(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...

class SpcIndirectData(ContentInfo.Content):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def digest(self) -> memoryview: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def file(self) -> str: ...

class SpcRelaxedPeMarkerCheck(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def value(self) -> int: ...

class SpcSpOpusInfo(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def more_info(self) -> Union[str,bytes]: ...
    @property
    def program_name(self) -> Union[str,bytes]: ...

class Symbol(lief.Symbol):
    name: str
    def __init__(self) -> None: ...
    @property
    def base_type(self) -> lief.PE.SYMBOL_BASE_TYPES: ...
    @property
    def complex_type(self) -> lief.PE.SYMBOL_COMPLEX_TYPES: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def numberof_aux_symbols(self) -> int: ...
    @property
    def section(self) -> lief.PE.Section: ...
    @property
    def section_number(self) -> int: ...
    @property
    def storage_class(self) -> lief.PE.SYMBOL_STORAGE_CLASS: ...
    @property
    def type(self) -> int: ...

class TLS(lief.Object):
    addressof_callbacks: int
    addressof_index: int
    addressof_raw_data: tuple[int,int]
    callbacks: list[int]
    characteristics: int
    data_template: memoryview
    sizeof_zero_fill: int
    def __init__(self) -> None: ...
    def copy(self) -> lief.PE.TLS: ...
    @property
    def directory(self) -> lief.PE.DataDirectory: ...
    @property
    def has_data_directory(self) -> bool: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def section(self) -> lief.PE.Section: ...

class WINDOW_STYLES:
    BORDER: ClassVar[WINDOW_STYLES] = ...
    CAPTION: ClassVar[WINDOW_STYLES] = ...
    CHILD: ClassVar[WINDOW_STYLES] = ...
    CLIPCHILDREN: ClassVar[WINDOW_STYLES] = ...
    CLIPSIBLINGS: ClassVar[WINDOW_STYLES] = ...
    DISABLED: ClassVar[WINDOW_STYLES] = ...
    DLGFRAME: ClassVar[WINDOW_STYLES] = ...
    GROUP: ClassVar[WINDOW_STYLES] = ...
    HSCROLL: ClassVar[WINDOW_STYLES] = ...
    MAXIMIZE: ClassVar[WINDOW_STYLES] = ...
    MAXIMIZEBOX: ClassVar[WINDOW_STYLES] = ...
    MINIMIZE: ClassVar[WINDOW_STYLES] = ...
    MINIMIZEBOX: ClassVar[WINDOW_STYLES] = ...
    OVERLAPPED: ClassVar[WINDOW_STYLES] = ...
    POPUP: ClassVar[WINDOW_STYLES] = ...
    SYSMENU: ClassVar[WINDOW_STYLES] = ...
    TABSTOP: ClassVar[WINDOW_STYLES] = ...
    THICKFRAME: ClassVar[WINDOW_STYLES] = ...
    VISIBLE: ClassVar[WINDOW_STYLES] = ...
    VSCROLL: ClassVar[WINDOW_STYLES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.PE.WINDOW_STYLES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class x509(lief.Object):
    class KEY_TYPES:
        ECDSA: ClassVar[x509.KEY_TYPES] = ...
        ECKEY: ClassVar[x509.KEY_TYPES] = ...
        ECKEY_DH: ClassVar[x509.KEY_TYPES] = ...
        NONE: ClassVar[x509.KEY_TYPES] = ...
        RSA: ClassVar[x509.KEY_TYPES] = ...
        RSASSA_PSS: ClassVar[x509.KEY_TYPES] = ...
        RSA_ALT: ClassVar[x509.KEY_TYPES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.x509.KEY_TYPES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class KEY_USAGE:
        CRL_SIGN: ClassVar[x509.KEY_USAGE] = ...
        DATA_ENCIPHERMENT: ClassVar[x509.KEY_USAGE] = ...
        DECIPHER_ONLY: ClassVar[x509.KEY_USAGE] = ...
        DIGITAL_SIGNATURE: ClassVar[x509.KEY_USAGE] = ...
        ENCIPHER_ONLY: ClassVar[x509.KEY_USAGE] = ...
        KEY_AGREEMENT: ClassVar[x509.KEY_USAGE] = ...
        KEY_CERT_SIGN: ClassVar[x509.KEY_USAGE] = ...
        KEY_ENCIPHERMENT: ClassVar[x509.KEY_USAGE] = ...
        NON_REPUDIATION: ClassVar[x509.KEY_USAGE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.x509.KEY_USAGE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class VERIFICATION_FLAGS:
        BADCERT_BAD_KEY: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_BAD_MD: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_BAD_PK: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_CN_MISMATCH: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_EXPIRED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_EXT_KEY_USAGE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_FUTURE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_KEY_USAGE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_MISSING: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_NOT_TRUSTED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_NS_CERT_TYPE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_OTHERNATURE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_REVOKED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_SKIP_VERIFY: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_BAD_KEY: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_BAD_MD: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_BAD_PK: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_EXPIRED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_FUTURE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_NOT_TRUSTED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        OK: ClassVar[x509.VERIFICATION_FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.PE.x509.VERIFICATION_FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.PE.x509.VERIFICATION_FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.PE.x509.VERIFICATION_FLAGS, /) -> lief.PE.x509.VERIFICATION_FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.PE.x509.VERIFICATION_FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def is_trusted_by(self, ca_list: list[lief.PE.x509]) -> lief.PE.x509.VERIFICATION_FLAGS: ...
    @overload
    @staticmethod
    def parse(path: str) -> list[lief.PE.x509]: ...
    @overload
    @staticmethod
    def parse(raw: list[int]) -> list[lief.PE.x509]: ...
    def verify(self, ca: lief.PE.x509) -> lief.PE.x509.VERIFICATION_FLAGS: ...
    @property
    def certificate_policies(self) -> list[str]: ...
    @property
    def ext_key_usage(self) -> list[str]: ...
    @property
    def is_ca(self) -> bool: ...
    @property
    def issuer(self) -> Union[str,bytes]: ...
    @property
    def key_type(self) -> lief.PE.x509.KEY_TYPES: ...
    @property
    def key_usage(self) -> list[lief.PE.x509.KEY_USAGE]: ...
    @property
    def raw(self) -> bytes: ...
    @property
    def rsa_info(self) -> Optional[lief.PE.RsaInfo]: ...
    @property
    def serial_number(self) -> bytes: ...
    @property
    def signature(self) -> bytes: ...
    @property
    def signature_algorithm(self) -> str: ...
    @property
    def subject(self) -> Union[str,bytes]: ...
    @property
    def valid_from(self) -> list[int]: ...
    @property
    def valid_to(self) -> list[int]: ...
    @property
    def version(self) -> int: ...

def get_imphash(binary: lief.PE.Binary, mode: lief.PE.IMPHASH_MODE = ...) -> str: ...
@overload
def get_type(file: str) -> Union[lief.PE.PE_TYPE,lief.lief_errors]: ...
@overload
def get_type(raw: list[int]) -> Union[lief.PE.PE_TYPE,lief.lief_errors]: ...
def oid_to_string(arg: str, /) -> str: ...
@overload
def parse(filename: str, config: lief.PE.ParserConfig = ...) -> Optional[lief.PE.Binary]: ...
@overload
def parse(raw: list[int], config: lief.PE.ParserConfig = ...) -> Optional[lief.PE.Binary]: ...
@overload
def parse(obj: Union[io.IOBase|os.PathLike], config: lief.PE.ParserConfig = ...) -> Optional[lief.PE.Binary]: ...
def resolve_ordinals(imp: lief.PE.Import, strict: bool = ..., use_std: bool = ...) -> Union[lief.PE.Import,lief.lief_errors]: ...
