from typing import Any, ClassVar, Optional, Union

from typing import overload
import io
import lief # type: ignore
import lief.MachO # type: ignore
import lief.MachO.Binary # type: ignore
import lief.MachO.BuildToolVersion # type: ignore
import lief.MachO.BuildVersion # type: ignore
import lief.MachO.Builder # type: ignore
import lief.MachO.DataCodeEntry # type: ignore
import lief.MachO.DyldBindingInfo # type: ignore
import lief.MachO.DyldChainedFixups # type: ignore
import lief.MachO.DyldInfo # type: ignore
import lief.MachO.ExportInfo # type: ignore
import lief.MachO.FatBinary # type: ignore
import lief.MachO.Header # type: ignore
import lief.MachO.LoadCommand # type: ignore
import lief.MachO.Relocation # type: ignore
import lief.MachO.Section # type: ignore
import lief.MachO.SegmentCommand # type: ignore
import lief.MachO.Symbol # type: ignore
import lief.MachO.TwoLevelHints # type: ignore
import lief.objc # type: ignore
import os

class ARM64_RELOCATION:
    ADDEND: ClassVar[ARM64_RELOCATION] = ...
    BRANCH26: ClassVar[ARM64_RELOCATION] = ...
    GOT_LOAD_PAGE21: ClassVar[ARM64_RELOCATION] = ...
    GOT_LOAD_PAGEOFF12: ClassVar[ARM64_RELOCATION] = ...
    PAGE21: ClassVar[ARM64_RELOCATION] = ...
    PAGEOFF12: ClassVar[ARM64_RELOCATION] = ...
    POINTER_TO_GOT: ClassVar[ARM64_RELOCATION] = ...
    SUBTRACTOR: ClassVar[ARM64_RELOCATION] = ...
    TLVP_LOAD_PAGE21: ClassVar[ARM64_RELOCATION] = ...
    TLVP_LOAD_PAGEOFF12: ClassVar[ARM64_RELOCATION] = ...
    UNSIGNED: ClassVar[ARM64_RELOCATION] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.ARM64_RELOCATION: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class ARM_RELOCATION:
    BR24: ClassVar[ARM_RELOCATION] = ...
    HALF: ClassVar[ARM_RELOCATION] = ...
    HALF_SECTDIFF: ClassVar[ARM_RELOCATION] = ...
    LOCAL_SECTDIFF: ClassVar[ARM_RELOCATION] = ...
    PAIR: ClassVar[ARM_RELOCATION] = ...
    PB_LA_PTR: ClassVar[ARM_RELOCATION] = ...
    SECTDIFF: ClassVar[ARM_RELOCATION] = ...
    THUMB_32BIT_BRANCH: ClassVar[ARM_RELOCATION] = ...
    THUMB_RELOC_BR22: ClassVar[ARM_RELOCATION] = ...
    VANILLA: ClassVar[ARM_RELOCATION] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.ARM_RELOCATION: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class Binary(lief.Binary):
    class it_commands:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.LoadCommand: ...
        def __iter__(self) -> lief.MachO.Binary.it_commands: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.LoadCommand: ...

    class it_filter_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Symbol: ...
        def __iter__(self) -> lief.MachO.Binary.it_filter_symbols: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Symbol: ...

    class it_libraries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.DylibCommand: ...
        def __iter__(self) -> lief.MachO.Binary.it_libraries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.DylibCommand: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Relocation: ...
        def __iter__(self) -> lief.MachO.Binary.it_relocations: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Relocation: ...

    class it_rpaths:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.RPathCommand: ...
        def __iter__(self) -> lief.MachO.Binary.it_rpaths: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.RPathCommand: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Section: ...
        def __iter__(self) -> lief.MachO.Binary.it_sections: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Section: ...

    class it_segments:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.SegmentCommand: ...
        def __iter__(self) -> lief.MachO.Binary.it_segments: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.SegmentCommand: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Symbol: ...
        def __iter__(self) -> lief.MachO.Binary.it_symbols: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Symbol: ...

    class range_t:
        end: int
        start: int
        def __init__(self, *args, **kwargs) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def add(self, dylib_command: lief.MachO.DylibCommand) -> lief.MachO.LoadCommand: ...
    @overload
    def add(self, segment: lief.MachO.SegmentCommand) -> lief.MachO.LoadCommand: ...
    @overload
    def add(self, load_command: lief.MachO.LoadCommand) -> lief.MachO.LoadCommand: ...
    @overload
    def add(self, load_command: lief.MachO.LoadCommand, index: int) -> lief.MachO.LoadCommand: ...
    def add_exported_function(self, address: int, name: str) -> lief.MachO.ExportInfo: ...
    def add_library(self, library_name: str) -> lief.MachO.LoadCommand: ...
    def add_local_symbol(self, address: int, name: str) -> lief.MachO.Symbol: ...
    @overload
    def add_section(self, segment: lief.MachO.SegmentCommand, section: lief.MachO.Section) -> lief.MachO.Section: ...
    @overload
    def add_section(self, section: lief.MachO.Section) -> lief.MachO.Section: ...
    def can_remove(self, symbol: lief.MachO.Symbol) -> bool: ...
    def can_remove_symbol(self, symbol_name: str) -> bool: ...
    def extend(self, load_command: lief.MachO.LoadCommand, size: int) -> bool: ...
    def extend_segment(self, segment_command: lief.MachO.SegmentCommand, size: int) -> bool: ...
    def get(self, type: lief.MachO.LoadCommand.TYPE) -> lief.MachO.LoadCommand: ...
    @overload
    def get_section(self, name: str) -> lief.MachO.Section: ...
    @overload
    def get_section(self, segname: str, secname: str) -> lief.MachO.Section: ...
    def get_segment(self, name: str) -> lief.MachO.SegmentCommand: ...
    def get_symbol(self, name: str) -> lief.MachO.Symbol: ...
    def has(self, type: lief.MachO.LoadCommand.TYPE) -> bool: ...
    def has_section(self, name: str) -> bool: ...
    def has_segment(self, name: str) -> bool: ...
    def has_symbol(self, name: str) -> bool: ...
    def is_valid_addr(self, address: int) -> bool: ...
    @overload
    def remove(self, load_command: lief.MachO.LoadCommand) -> bool: ...
    @overload
    def remove(self, type: lief.MachO.LoadCommand.TYPE) -> bool: ...
    @overload
    def remove(self, symbol: lief.MachO.Symbol) -> bool: ...
    def remove_command(self, index: int) -> bool: ...
    @overload
    def remove_section(self, name: str, clear: bool = ...) -> None: ...
    @overload
    def remove_section(self, segname: str, secname: str, clear: bool = ...) -> None: ...
    def remove_signature(self) -> bool: ...
    def remove_symbol(self, name: str) -> bool: ...
    def section_from_offset(self, arg: int, /) -> lief.MachO.Section: ...
    def section_from_virtual_address(self, arg: int, /) -> lief.MachO.Section: ...
    def segment_from_offset(self, arg: int, /) -> lief.MachO.SegmentCommand: ...
    def segment_from_virtual_address(self, arg: int, /) -> lief.MachO.SegmentCommand: ...
    def shift(self, value: int) -> Union[lief.ok_t,lief.lief_errors]: ...
    def shift_linkedit(self, value: int) -> Union[lief.ok_t,lief.lief_errors]: ...
    @overload
    def unexport(self, name: str) -> bool: ...
    @overload
    def unexport(self, symbol: lief.MachO.Symbol) -> bool: ...
    def virtual_address_to_offset(self, virtual_address: int) -> Union[int,lief.lief_errors]: ...
    def write(self, output: str) -> None: ...
    def __contains__(self, arg: lief.MachO.LoadCommand.TYPE, /) -> bool: ...
    def __getitem__(self, arg: lief.MachO.LoadCommand.TYPE, /) -> lief.MachO.LoadCommand: ...
    @property
    def build_version(self) -> lief.MachO.BuildVersion: ...
    @property
    def code_signature(self) -> lief.MachO.CodeSignature: ...
    @property
    def code_signature_dir(self) -> lief.MachO.CodeSignatureDir: ...
    @property
    def commands(self) -> lief.MachO.Binary.it_commands: ...
    @property
    def data_in_code(self) -> lief.MachO.DataInCode: ...
    @property
    def dyld_chained_fixups(self) -> lief.MachO.DyldChainedFixups: ...
    @property
    def dyld_environment(self) -> lief.MachO.DyldEnvironment: ...
    @property
    def dyld_exports_trie(self) -> lief.MachO.DyldExportsTrie: ...
    @property
    def dyld_info(self) -> lief.MachO.DyldInfo: ...
    @property
    def dylinker(self) -> lief.MachO.DylinkerCommand: ...
    @property
    def dynamic_symbol_command(self) -> lief.MachO.DynamicSymbolCommand: ...
    @property
    def encryption_info(self) -> lief.MachO.EncryptionInfo: ...
    @property
    def exported_symbols(self) -> lief.MachO.Binary.it_filter_symbols: ...
    @property
    def fat_offset(self) -> int: ...
    @property
    def fileset_name(self) -> str: ...
    @property
    def filesets(self) -> lief.MachO.FatBinary.it_binaries: ...
    @property
    def function_starts(self) -> lief.MachO.FunctionStarts: ...
    @property
    def functions(self) -> list[lief.Function]: ...
    @property
    def has_build_version(self) -> bool: ...
    @property
    def has_code_signature(self) -> bool: ...
    @property
    def has_code_signature_dir(self) -> bool: ...
    @property
    def has_data_in_code(self) -> bool: ...
    @property
    def has_dyld_chained_fixups(self) -> bool: ...
    @property
    def has_dyld_environment(self) -> bool: ...
    @property
    def has_dyld_exports_trie(self) -> bool: ...
    @property
    def has_dyld_info(self) -> bool: ...
    @property
    def has_dylinker(self) -> bool: ...
    @property
    def has_dynamic_symbol_command(self) -> bool: ...
    @property
    def has_encryption_info(self) -> bool: ...
    @property
    def has_entrypoint(self) -> bool: ...
    @property
    def has_filesets(self) -> bool: ...
    @property
    def has_function_starts(self) -> bool: ...
    @property
    def has_linker_opt_hint(self) -> bool: ...
    @property
    def has_main_command(self) -> bool: ...
    @property
    def has_nx_heap(self) -> bool: ...
    @property
    def has_nx_stack(self) -> bool: ...
    @property
    def has_rpath(self) -> bool: ...
    @property
    def has_segment_split_info(self) -> bool: ...
    @property
    def has_source_version(self) -> bool: ...
    @property
    def has_sub_framework(self) -> bool: ...
    @property
    def has_symbol_command(self) -> bool: ...
    @property
    def has_thread_command(self) -> bool: ...
    @property
    def has_two_level_hints(self) -> bool: ...
    @property
    def has_uuid(self) -> bool: ...
    @property
    def has_version_min(self) -> bool: ...
    @property
    def header(self) -> lief.MachO.Header: ...  # type: ignore
    @property
    def imagebase(self) -> int: ...
    @property
    def imported_symbols(self) -> lief.MachO.Binary.it_filter_symbols: ...
    @property
    def libraries(self) -> lief.MachO.Binary.it_libraries: ...  # type: ignore
    @property
    def linker_opt_hint(self) -> lief.MachO.LinkerOptHint: ...
    @property
    def main_command(self) -> lief.MachO.MainCommand: ...
    @property
    def objc_metadata(self) -> Optional[lief.objc.Metadata]: ...
    @property
    def off_ranges(self) -> lief.MachO.Binary.range_t: ...
    @property
    def overlay(self) -> memoryview: ...
    @property
    def page_size(self) -> int: ...
    @property
    def relocations(self) -> lief.MachO.Binary.it_relocations: ...  # type: ignore
    @property
    def rpath(self) -> lief.MachO.RPathCommand: ...
    @property
    def rpaths(self) -> lief.MachO.Binary.it_rpaths: ...
    @property
    def sections(self) -> lief.MachO.Binary.it_sections: ...  # type: ignore
    @property
    def segment_split_info(self) -> lief.MachO.SegmentSplitInfo: ...
    @property
    def segments(self) -> lief.MachO.Binary.it_segments: ...
    @property
    def source_version(self) -> lief.MachO.SourceVersion: ...
    @property
    def sub_framework(self) -> lief.MachO.SubFramework: ...
    @property
    def support_arm64_ptr_auth(self) -> bool: ...
    @property
    def symbol_command(self) -> lief.MachO.SymbolCommand: ...
    @property
    def symbols(self) -> lief.MachO.Binary.it_symbols: ...  # type: ignore
    @property
    def thread_command(self) -> lief.MachO.ThreadCommand: ...
    @property
    def two_level_hints(self) -> lief.MachO.TwoLevelHints: ...
    @property
    def unwind_functions(self) -> list[lief.Function]: ...
    @property
    def uuid(self) -> lief.MachO.UUIDCommand: ...
    @property
    def va_ranges(self) -> lief.MachO.Binary.range_t: ...
    @property
    def version_min(self) -> lief.MachO.VersionMin: ...
    @property
    def virtual_size(self) -> int: ...

class BindingInfo(lief.Object):
    addend: int
    address: int
    library_ordinal: int
    weak_import: bool
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def has_library(self) -> bool: ...
    @property
    def has_segment(self) -> bool: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def library(self) -> lief.MachO.DylibCommand: ...
    @property
    def segment(self) -> lief.MachO.SegmentCommand: ...
    @property
    def symbol(self) -> lief.MachO.Symbol: ...

class BuildToolVersion(lief.Object):
    class TOOLS:
        CLANG: ClassVar[BuildToolVersion.TOOLS] = ...
        LD: ClassVar[BuildToolVersion.TOOLS] = ...
        SWIFT: ClassVar[BuildToolVersion.TOOLS] = ...
        UNKNOWN: ClassVar[BuildToolVersion.TOOLS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.BuildToolVersion.TOOLS: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def tool(self) -> lief.MachO.BuildToolVersion.TOOLS: ...
    @property
    def version(self) -> list[int]: ...

class BuildVersion(LoadCommand):
    class PLATFORMS:
        IOS: ClassVar[BuildVersion.PLATFORMS] = ...
        MACOS: ClassVar[BuildVersion.PLATFORMS] = ...
        TVOS: ClassVar[BuildVersion.PLATFORMS] = ...
        UNKNOWN: ClassVar[BuildVersion.PLATFORMS] = ...
        WATCHOS: ClassVar[BuildVersion.PLATFORMS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.BuildVersion.PLATFORMS: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    minos: list[int]
    platform: lief.MachO.BuildVersion.PLATFORMS
    sdk: list[int]
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def tools(self) -> list[lief.MachO.BuildToolVersion]: ...

class Builder:
    class config_t:
        linkedit: bool
        def __init__(self) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    @staticmethod
    def write(binary: lief.MachO.Binary, output: str) -> Union[lief.ok_t,lief.lief_errors]: ...
    @overload
    @staticmethod
    def write(binary: lief.MachO.Binary, output: str, config: lief.MachO.Builder.config_t) -> Union[lief.ok_t,lief.lief_errors]: ...
    @overload
    @staticmethod
    def write(fat_binary: lief.MachO.FatBinary, output: str) -> Union[lief.ok_t,lief.lief_errors]: ...
    @overload
    @staticmethod
    def write(fat_binary: lief.MachO.FatBinary, output: str, config: lief.MachO.Builder.config_t) -> Union[lief.ok_t,lief.lief_errors]: ...

class ChainedBindingInfo(BindingInfo):
    offset: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def format(self) -> lief.MachO.DYLD_CHAINED_FORMAT: ...
    @property
    def ptr_format(self) -> lief.MachO.DYLD_CHAINED_PTR_FORMAT: ...
    @property
    def sign_extended_addend(self) -> int: ...

class CodeSignature(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class CodeSignatureDir(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class DYLD_CHAINED_FORMAT:
    IMPORT: ClassVar[DYLD_CHAINED_FORMAT] = ...
    IMPORT_ADDEND: ClassVar[DYLD_CHAINED_FORMAT] = ...
    IMPORT_ADDEND64: ClassVar[DYLD_CHAINED_FORMAT] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.DYLD_CHAINED_FORMAT: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class DYLD_CHAINED_PTR_FORMAT:
    PTR_32: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_32_CACHE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_32_FIRMWARE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_64: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_64_KERNEL_CACHE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_64_OFFSET: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_FIRMWARE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_KERNEL: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_USERLAND: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_USERLAND24: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_X86_64_KERNEL_CACHE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.DYLD_CHAINED_PTR_FORMAT: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class DataCodeEntry(lief.Object):
    class TYPES:
        ABS_JUMP_TABLE_32: ClassVar[DataCodeEntry.TYPES] = ...
        DATA: ClassVar[DataCodeEntry.TYPES] = ...
        JUMP_TABLE_16: ClassVar[DataCodeEntry.TYPES] = ...
        JUMP_TABLE_32: ClassVar[DataCodeEntry.TYPES] = ...
        JUMP_TABLE_8: ClassVar[DataCodeEntry.TYPES] = ...
        UNKNOWN: ClassVar[DataCodeEntry.TYPES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.DataCodeEntry.TYPES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    length: int
    offset: int
    type: lief.MachO.DataCodeEntry.TYPES
    def __init__(self, *args, **kwargs) -> None: ...

class DataInCode(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    def add(self, entry: lief.MachO.DataCodeEntry) -> lief.MachO.DataInCode: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def entries(self) -> lief.MachO.it_data_in_code_entries: ...

class DyldBindingInfo(BindingInfo):
    class CLASS:
        LAZY: ClassVar[DyldBindingInfo.CLASS] = ...
        STANDARD: ClassVar[DyldBindingInfo.CLASS] = ...
        THREADED: ClassVar[DyldBindingInfo.CLASS] = ...
        WEAK: ClassVar[DyldBindingInfo.CLASS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.DyldBindingInfo.CLASS: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        POINTER: ClassVar[DyldBindingInfo.TYPE] = ...
        TEXT_ABSOLUTE32: ClassVar[DyldBindingInfo.TYPE] = ...
        TEXT_PCREL32: ClassVar[DyldBindingInfo.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.DyldBindingInfo.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    binding_class: lief.MachO.DyldBindingInfo.CLASS
    binding_type: lief.MachO.DyldBindingInfo.TYPE
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def original_offset(self) -> int: ...

class DyldChainedFixups(LoadCommand):
    class chained_starts_in_segment:
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def max_valid_pointer(self) -> int: ...
        @property
        def offset(self) -> int: ...
        @property
        def page_count(self) -> int: ...
        @property
        def page_size(self) -> int: ...
        @property
        def page_start(self) -> list[int]: ...
        @property
        def pointer_format(self) -> lief.MachO.DYLD_CHAINED_PTR_FORMAT: ...
        @property
        def segment(self) -> lief.MachO.SegmentCommand: ...
        @property
        def segment_offset(self) -> int: ...
        @property
        def size(self) -> int: ...

    class it_binding_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.ChainedBindingInfo: ...
        def __iter__(self) -> lief.MachO.DyldChainedFixups.it_binding_info: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.ChainedBindingInfo: ...

    class it_chained_starts_in_segments_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.DyldChainedFixups.chained_starts_in_segment: ...
        def __iter__(self) -> lief.MachO.DyldChainedFixups.it_chained_starts_in_segments_t: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.DyldChainedFixups.chained_starts_in_segment: ...
    data_offset: int
    data_size: int
    fixups_version: int
    imports_count: int
    imports_format: lief.MachO.DYLD_CHAINED_FORMAT
    imports_offset: int
    starts_offset: int
    symbols_format: int
    symbols_offset: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def bindings(self) -> lief.MachO.DyldChainedFixups.it_binding_info: ...
    @property
    def chained_starts_in_segments(self) -> lief.MachO.DyldChainedFixups.it_chained_starts_in_segments_t: ...

class DyldEnvironment(LoadCommand):
    value: str
    def __init__(self, *args, **kwargs) -> None: ...

class DyldExportsTrie(LoadCommand):
    class it_export_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.ExportInfo: ...
        def __iter__(self) -> lief.MachO.DyldInfo.it_export_info: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.ExportInfo: ...
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    def show_export_trie(self) -> str: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def exports(self) -> lief.MachO.DyldInfo.it_export_info: ...

class DyldInfo(LoadCommand):
    class BIND_OPCODES:
        ADD_ADDR_ULEB: ClassVar[DyldInfo.BIND_OPCODES] = ...
        DONE: ClassVar[DyldInfo.BIND_OPCODES] = ...
        DO_BIND: ClassVar[DyldInfo.BIND_OPCODES] = ...
        DO_BIND_ADD_ADDR_IMM_SCALED: ClassVar[DyldInfo.BIND_OPCODES] = ...
        DO_BIND_ADD_ADDR_ULEB: ClassVar[DyldInfo.BIND_OPCODES] = ...
        DO_BIND_ULEB_TIMES_SKIPPING_ULEB: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_ADDEND_SLEB: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_DYLIB_ORDINAL_IMM: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_DYLIB_ORDINAL_ULEB: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_DYLIB_SPECIAL_IMM: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_SEGMENT_AND_OFFSET_ULEB: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_SYMBOL_TRAILING_FLAGS_IMM: ClassVar[DyldInfo.BIND_OPCODES] = ...
        SET_TYPE_IMM: ClassVar[DyldInfo.BIND_OPCODES] = ...
        THREADED: ClassVar[DyldInfo.BIND_OPCODES] = ...
        THREADED_APPLY: ClassVar[DyldInfo.BIND_OPCODES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.DyldInfo.BIND_OPCODES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class REBASE_OPCODES:
        ADD_ADDR_IMM_SCALED: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        ADD_ADDR_ULEB: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        DONE: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        DO_REBASE_ADD_ADDR_ULEB: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        DO_REBASE_IMM_TIMES: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        DO_REBASE_ULEB_TIMES: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        DO_REBASE_ULEB_TIMES_SKIPPING_ULEB: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        SET_SEGMENT_AND_OFFSET_ULEB: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        SET_TYPE_IMM: ClassVar[DyldInfo.REBASE_OPCODES] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.DyldInfo.REBASE_OPCODES: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class REBASE_TYPE:
        POINTER: ClassVar[DyldInfo.REBASE_TYPE] = ...
        TEXT_ABSOLUTE32: ClassVar[DyldInfo.REBASE_TYPE] = ...
        TEXT_PCREL32: ClassVar[DyldInfo.REBASE_TYPE] = ...
        THREADED: ClassVar[DyldInfo.REBASE_TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.DyldInfo.REBASE_TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_binding_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.DyldBindingInfo: ...
        def __iter__(self) -> lief.MachO.DyldInfo.it_binding_info: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.DyldBindingInfo: ...

    class it_export_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.ExportInfo: ...
        def __iter__(self) -> lief.MachO.DyldInfo.it_export_info: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.ExportInfo: ...
    bind: tuple[int,int]
    bind_opcodes: memoryview
    export_info: tuple[int,int]
    export_trie: memoryview
    lazy_bind: tuple[int,int]
    lazy_bind_opcodes: memoryview
    rebase: tuple[int,int]
    rebase_opcodes: memoryview
    weak_bind: tuple[int,int]
    weak_bind_opcodes: memoryview
    def __init__(self, *args, **kwargs) -> None: ...
    def set_bind_offset(self, offset: int) -> None: ...
    def set_bind_size(self, size: int) -> None: ...
    def set_export_offset(self, offset: int) -> None: ...
    def set_export_size(self, size: int) -> None: ...
    def set_lazy_bind_offset(self, offset: int) -> None: ...
    def set_lazy_bind_size(self, size: int) -> None: ...
    def set_rebase_offset(self, offset: int) -> None: ...
    def set_rebase_size(self, size: int) -> None: ...
    def set_weak_bind_offset(self, offset: int) -> None: ...
    def set_weak_bind_size(self, size: int) -> None: ...
    @property
    def bindings(self) -> lief.MachO.DyldInfo.it_binding_info: ...
    @property
    def exports(self) -> lief.MachO.DyldInfo.it_export_info: ...
    @property
    def show_bind_opcodes(self) -> str: ...
    @property
    def show_export_trie(self) -> str: ...
    @property
    def show_lazy_bind_opcodes(self) -> str: ...
    @property
    def show_rebases_opcodes(self) -> str: ...
    @property
    def show_weak_bind_opcodes(self) -> str: ...

class DylibCommand(LoadCommand):
    compatibility_version: list[int]
    current_version: list[int]
    name: str
    timestamp: int
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def id_dylib(name: str, timestamp: int = ..., current_version: int = ..., compat_version: int = ...) -> lief.MachO.DylibCommand: ...
    @staticmethod
    def lazy_load_dylib(name: str, timestamp: int = ..., current_version: int = ..., compat_version: int = ...) -> lief.MachO.DylibCommand: ...
    @staticmethod
    def load_dylib(name: str, timestamp: int = ..., current_version: int = ..., compat_version: int = ...) -> lief.MachO.DylibCommand: ...
    @staticmethod
    def load_upward_dylib(name: str, timestamp: int = ..., current_version: int = ..., compat_version: int = ...) -> lief.MachO.DylibCommand: ...
    @staticmethod
    def reexport_dylib(name: str, timestamp: int = ..., current_version: int = ..., compat_version: int = ...) -> lief.MachO.DylibCommand: ...
    @staticmethod
    def weak_lib(name: str, timestamp: int = ..., current_version: int = ..., compat_version: int = ...) -> lief.MachO.DylibCommand: ...

class DylinkerCommand(LoadCommand):
    name: str
    def __init__(self, arg: str, /) -> None: ...

class DynamicSymbolCommand(LoadCommand):
    external_reference_symbol_offset: int
    external_relocation_offset: int
    idx_external_define_symbol: int
    idx_local_symbol: int
    idx_undefined_symbol: int
    indirect_symbol_offset: int
    local_relocation_offset: int
    module_table_offset: int
    nb_external_define_symbols: int
    nb_external_reference_symbols: int
    nb_external_relocations: int
    nb_indirect_symbols: int
    nb_local_relocations: int
    nb_local_symbols: int
    nb_module_table: int
    nb_toc: int
    nb_undefined_symbols: int
    toc_offset: int
    def __init__(self, *args, **kwargs) -> None: ...

class EncryptionInfo(LoadCommand):
    crypt_id: int
    crypt_offset: int
    crypt_size: int
    def __init__(self, *args, **kwargs) -> None: ...

class ExportInfo(lief.Object):
    class FLAGS:
        REEXPORT: ClassVar[ExportInfo.FLAGS] = ...
        STUB_AND_RESOLVER: ClassVar[ExportInfo.FLAGS] = ...
        WEAK_DEFINITION: ClassVar[ExportInfo.FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.ExportInfo.FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.MachO.ExportInfo.FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.MachO.ExportInfo.FLAGS, /) -> lief.MachO.ExportInfo.FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.MachO.ExportInfo.FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class KIND:
        ABSOLUTE_KIND: ClassVar[ExportInfo.KIND] = ...
        REGULAR: ClassVar[ExportInfo.KIND] = ...
        THREAD_LOCAL_KIND: ClassVar[ExportInfo.KIND] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.ExportInfo.KIND: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    address: int
    flags: int
    def __init__(self, *args, **kwargs) -> None: ...
    def has(self, flag: lief.MachO.ExportInfo.FLAGS) -> bool: ...
    @property
    def alias(self) -> lief.MachO.Symbol: ...
    @property
    def alias_library(self) -> lief.MachO.DylibCommand: ...
    @property
    def flags_list(self) -> list[lief.MachO.ExportInfo.FLAGS]: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def kind(self) -> lief.MachO.ExportInfo.KIND: ...
    @property
    def node_offset(self) -> int: ...
    @property
    def symbol(self) -> lief.MachO.Symbol: ...

class FatBinary:
    class it_binaries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Binary: ...
        def __iter__(self) -> lief.MachO.FatBinary.it_binaries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Binary: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def at(self, index: int) -> lief.MachO.Binary: ...
    def raw(self) -> list[int]: ...
    def take(self, cpu: lief.MachO.Header.CPU_TYPE) -> Optional[lief.MachO.Binary]: ...
    def write(self, filename: str) -> None: ...
    def __getitem__(self, arg: int, /) -> lief.MachO.Binary: ...
    def __iter__(self) -> lief.MachO.FatBinary.it_binaries: ...
    def __len__(self) -> int: ...
    @property
    def size(self) -> int: ...

class FilesetCommand(LoadCommand):
    file_offset: int
    name: str
    virtual_address: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def binary(self) -> lief.MachO.Binary: ...

class FunctionStarts(LoadCommand):
    data_offset: int
    data_size: int
    functions: list[int]
    def __init__(self, *args, **kwargs) -> None: ...
    def add_function(self, address: int) -> None: ...
    @property
    def content(self) -> memoryview: ...

class Header(lief.Object):
    class CPU_TYPE:
        ANY: ClassVar[Header.CPU_TYPE] = ...
        ARM: ClassVar[Header.CPU_TYPE] = ...
        ARM64: ClassVar[Header.CPU_TYPE] = ...
        MC98000: ClassVar[Header.CPU_TYPE] = ...
        MIPS: ClassVar[Header.CPU_TYPE] = ...
        POWERPC: ClassVar[Header.CPU_TYPE] = ...
        POWERPC64: ClassVar[Header.CPU_TYPE] = ...
        SPARC: ClassVar[Header.CPU_TYPE] = ...
        X86: ClassVar[Header.CPU_TYPE] = ...
        X86_64: ClassVar[Header.CPU_TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Header.CPU_TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class FILE_TYPE:
        BUNDLE: ClassVar[Header.FILE_TYPE] = ...
        CORE: ClassVar[Header.FILE_TYPE] = ...
        DSYM: ClassVar[Header.FILE_TYPE] = ...
        DYLIB: ClassVar[Header.FILE_TYPE] = ...
        DYLIB_STUB: ClassVar[Header.FILE_TYPE] = ...
        DYLINKER: ClassVar[Header.FILE_TYPE] = ...
        EXECUTE: ClassVar[Header.FILE_TYPE] = ...
        FVMLIB: ClassVar[Header.FILE_TYPE] = ...
        KEXT_BUNDLE: ClassVar[Header.FILE_TYPE] = ...
        OBJECT: ClassVar[Header.FILE_TYPE] = ...
        PRELOAD: ClassVar[Header.FILE_TYPE] = ...
        UNKNOWN: ClassVar[Header.FILE_TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Header.FILE_TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class FLAGS:
        ALLMODSBOUND: ClassVar[Header.FLAGS] = ...
        ALLOW_STACK_EXECUTION: ClassVar[Header.FLAGS] = ...
        APP_EXTENSION_SAFE: ClassVar[Header.FLAGS] = ...
        BINDATLOAD: ClassVar[Header.FLAGS] = ...
        BINDS_TO_WEAK: ClassVar[Header.FLAGS] = ...
        CANONICAL: ClassVar[Header.FLAGS] = ...
        DEAD_STRIPPABLE_DYLIB: ClassVar[Header.FLAGS] = ...
        DYLDLINK: ClassVar[Header.FLAGS] = ...
        FORCE_FLAT: ClassVar[Header.FLAGS] = ...
        HAS_TLV_DESCRIPTORS: ClassVar[Header.FLAGS] = ...
        INCRLINK: ClassVar[Header.FLAGS] = ...
        LAZY_INIT: ClassVar[Header.FLAGS] = ...
        NOFIXPREBINDING: ClassVar[Header.FLAGS] = ...
        NOMULTIDEFS: ClassVar[Header.FLAGS] = ...
        NOUNDEFS: ClassVar[Header.FLAGS] = ...
        NO_HEAP_EXECUTION: ClassVar[Header.FLAGS] = ...
        NO_REEXPORTED_DYLIBS: ClassVar[Header.FLAGS] = ...
        PIE: ClassVar[Header.FLAGS] = ...
        PREBINDABLE: ClassVar[Header.FLAGS] = ...
        PREBOUND: ClassVar[Header.FLAGS] = ...
        ROOT_SAFE: ClassVar[Header.FLAGS] = ...
        SETUID_SAFE: ClassVar[Header.FLAGS] = ...
        SPLIT_SEGS: ClassVar[Header.FLAGS] = ...
        SUBSECTIONS_VIA_SYMBOLS: ClassVar[Header.FLAGS] = ...
        TWOLEVEL: ClassVar[Header.FLAGS] = ...
        WEAK_DEFINES: ClassVar[Header.FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Header.FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.MachO.Header.FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.MachO.Header.FLAGS, /) -> lief.MachO.Header.FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.MachO.Header.FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...
    cpu_subtype: int
    cpu_type: lief.MachO.Header.CPU_TYPE
    file_type: lief.MachO.Header.FILE_TYPE
    flags: int
    magic: lief.MachO.MACHO_TYPES
    nb_cmds: int
    reserved: int
    sizeof_cmds: int
    def __init__(self) -> None: ...
    def add(self, flag: lief.MachO.Header.FLAGS) -> None: ...
    def has(self, flag: lief.MachO.Header.FLAGS) -> bool: ...
    def remove(self, flag: lief.MachO.Header.FLAGS) -> None: ...
    def __contains__(self, arg: lief.MachO.Header.FLAGS, /) -> bool: ...
    def __iadd__(self, arg: lief.MachO.Header.FLAGS, /) -> lief.MachO.Header: ...
    def __isub__(self, arg: lief.MachO.Header.FLAGS, /) -> lief.MachO.Header: ...
    @property
    def flags_list(self) -> list[lief.MachO.Header.FLAGS]: ...

class LinkEdit(SegmentCommand):
    def __init__(self, *args, **kwargs) -> None: ...

class LinkerOptHint(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class LoadCommand(lief.Object):
    class TYPE:
        BUILD_VERSION: ClassVar[LoadCommand.TYPE] = ...
        CODE_SIGNATURE: ClassVar[LoadCommand.TYPE] = ...
        DATA_IN_CODE: ClassVar[LoadCommand.TYPE] = ...
        DYLD_CHAINED_FIXUPS: ClassVar[LoadCommand.TYPE] = ...
        DYLD_ENVIRONMENT: ClassVar[LoadCommand.TYPE] = ...
        DYLD_EXPORTS_TRIE: ClassVar[LoadCommand.TYPE] = ...
        DYLD_INFO: ClassVar[LoadCommand.TYPE] = ...
        DYLD_INFO_ONLY: ClassVar[LoadCommand.TYPE] = ...
        DYLIB_CODE_SIGN_DRS: ClassVar[LoadCommand.TYPE] = ...
        DYSYMTAB: ClassVar[LoadCommand.TYPE] = ...
        ENCRYPTION_INFO: ClassVar[LoadCommand.TYPE] = ...
        ENCRYPTION_INFO_64: ClassVar[LoadCommand.TYPE] = ...
        FILESET_ENTRY: ClassVar[LoadCommand.TYPE] = ...
        FUNCTION_STARTS: ClassVar[LoadCommand.TYPE] = ...
        FVMFILE: ClassVar[LoadCommand.TYPE] = ...
        IDENT: ClassVar[LoadCommand.TYPE] = ...
        IDFVMLIB: ClassVar[LoadCommand.TYPE] = ...
        ID_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        ID_DYLINKER: ClassVar[LoadCommand.TYPE] = ...
        LAZY_LOAD_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        LIEF_UNKNOWN: ClassVar[LoadCommand.TYPE] = ...
        LINKER_OPTIMIZATION_HINT: ClassVar[LoadCommand.TYPE] = ...
        LINKER_OPTION: ClassVar[LoadCommand.TYPE] = ...
        LOADFVMLIB: ClassVar[LoadCommand.TYPE] = ...
        LOAD_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        LOAD_DYLINKER: ClassVar[LoadCommand.TYPE] = ...
        LOAD_UPWARD_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        LOAD_WEAK_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        MAIN: ClassVar[LoadCommand.TYPE] = ...
        NOTE: ClassVar[LoadCommand.TYPE] = ...
        PREBIND_CKSUM: ClassVar[LoadCommand.TYPE] = ...
        PREBOUND_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        PREPAGE: ClassVar[LoadCommand.TYPE] = ...
        REEXPORT_DYLIB: ClassVar[LoadCommand.TYPE] = ...
        ROUTINES: ClassVar[LoadCommand.TYPE] = ...
        ROUTINES_64: ClassVar[LoadCommand.TYPE] = ...
        RPATH: ClassVar[LoadCommand.TYPE] = ...
        SEGMENT: ClassVar[LoadCommand.TYPE] = ...
        SEGMENT_64: ClassVar[LoadCommand.TYPE] = ...
        SEGMENT_SPLIT_INFO: ClassVar[LoadCommand.TYPE] = ...
        SOURCE_VERSION: ClassVar[LoadCommand.TYPE] = ...
        SUB_CLIENT: ClassVar[LoadCommand.TYPE] = ...
        SUB_FRAMEWORK: ClassVar[LoadCommand.TYPE] = ...
        SUB_LIBRARY: ClassVar[LoadCommand.TYPE] = ...
        SUB_UMBRELLA: ClassVar[LoadCommand.TYPE] = ...
        SYMSEG: ClassVar[LoadCommand.TYPE] = ...
        SYMTAB: ClassVar[LoadCommand.TYPE] = ...
        THREAD: ClassVar[LoadCommand.TYPE] = ...
        TWOLEVEL_HINTS: ClassVar[LoadCommand.TYPE] = ...
        UNIXTHREAD: ClassVar[LoadCommand.TYPE] = ...
        UNKNOWN: ClassVar[LoadCommand.TYPE] = ...
        UUID: ClassVar[LoadCommand.TYPE] = ...
        VERSION_MIN_IPHONEOS: ClassVar[LoadCommand.TYPE] = ...
        VERSION_MIN_MACOSX: ClassVar[LoadCommand.TYPE] = ...
        VERSION_MIN_TVOS: ClassVar[LoadCommand.TYPE] = ...
        VERSION_MIN_WATCHOS: ClassVar[LoadCommand.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.LoadCommand.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    command: lief.MachO.LoadCommand.TYPE
    command_offset: int
    data: memoryview
    size: int
    def __init__(self) -> None: ...

class MACHO_TYPES:
    CIGAM: ClassVar[MACHO_TYPES] = ...
    CIGAM_64: ClassVar[MACHO_TYPES] = ...
    FAT_CIGAM: ClassVar[MACHO_TYPES] = ...
    FAT_MAGIC: ClassVar[MACHO_TYPES] = ...
    MAGIC: ClassVar[MACHO_TYPES] = ...
    MAGIC_64: ClassVar[MACHO_TYPES] = ...
    NEURAL_MODEL: ClassVar[MACHO_TYPES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.MACHO_TYPES: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class MainCommand(LoadCommand):
    entrypoint: int
    stack_size: int
    def __init__(self, arg0: int, arg1: int, /) -> None: ...

class PPC_RELOCATION:
    BR14: ClassVar[PPC_RELOCATION] = ...
    BR24: ClassVar[PPC_RELOCATION] = ...
    HA16: ClassVar[PPC_RELOCATION] = ...
    HA16_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    HI16: ClassVar[PPC_RELOCATION] = ...
    HI16_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    JBSR: ClassVar[PPC_RELOCATION] = ...
    LO14: ClassVar[PPC_RELOCATION] = ...
    LO14_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    LO16: ClassVar[PPC_RELOCATION] = ...
    LO16_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    LOCAL_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    PAIR: ClassVar[PPC_RELOCATION] = ...
    PB_LA_PTR: ClassVar[PPC_RELOCATION] = ...
    SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    VANILLA: ClassVar[PPC_RELOCATION] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.PPC_RELOCATION: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class ParserConfig:
    fix_from_memory: bool
    parse_dyld_bindings: bool
    parse_dyld_exports: bool
    parse_dyld_rebases: bool
    def __init__(self) -> None: ...
    def full_dyldinfo(self, flag: bool) -> lief.MachO.ParserConfig: ...
    @property
    def deep(self) -> lief.MachO.ParserConfig: ...
    @property
    def quick(self) -> lief.MachO.ParserConfig: ...

class RPathCommand(LoadCommand):
    path: str
    def __init__(self, *args, **kwargs) -> None: ...

class Relocation(lief.Relocation):
    class ORIGIN:
        CHAINED_FIXUPS: ClassVar[Relocation.ORIGIN] = ...
        DYLDINFO: ClassVar[Relocation.ORIGIN] = ...
        RELOC_TABLE: ClassVar[Relocation.ORIGIN] = ...
        UNKNOWN: ClassVar[Relocation.ORIGIN] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Relocation.ORIGIN: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    address: int
    pc_relative: bool
    type: Union[lief.MachO.X86_RELOCATION,lief.MachO.X86_64_RELOCATION,lief.MachO.PPC_RELOCATION,lief.MachO.ARM_RELOCATION,lief.MachO.ARM64_RELOCATION,lief.MachO.DyldInfo.REBASE_TYPE,]
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def architecture(self) -> lief.MachO.Header.CPU_TYPE: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def has_segment(self) -> bool: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def origin(self) -> lief.MachO.Relocation.ORIGIN: ...
    @property
    def section(self) -> lief.MachO.Section: ...
    @property
    def segment(self) -> lief.MachO.SegmentCommand: ...
    @property
    def symbol(self) -> lief.MachO.Symbol: ...

class RelocationDyld(Relocation):
    def __init__(self, *args, **kwargs) -> None: ...
    def __ge__(self, arg: lief.MachO.RelocationDyld, /) -> bool: ...
    def __gt__(self, arg: lief.MachO.RelocationDyld, /) -> bool: ...
    def __le__(self, arg: lief.MachO.RelocationDyld, /) -> bool: ...
    def __lt__(self, arg: lief.MachO.RelocationDyld, /) -> bool: ...

class RelocationFixup(Relocation):
    target: int
    def __init__(self, *args, **kwargs) -> None: ...

class RelocationObject(Relocation):
    value: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def is_scattered(self) -> bool: ...

class Section(lief.Section):
    class FLAGS:
        DEBUG_INFO: ClassVar[Section.FLAGS] = ...
        EXT_RELOC: ClassVar[Section.FLAGS] = ...
        LIVE_SUPPORT: ClassVar[Section.FLAGS] = ...
        LOC_RELOC: ClassVar[Section.FLAGS] = ...
        NO_DEAD_STRIP: ClassVar[Section.FLAGS] = ...
        NO_TOC: ClassVar[Section.FLAGS] = ...
        PURE_INSTRUCTIONS: ClassVar[Section.FLAGS] = ...
        SELF_MODIFYING_CODE: ClassVar[Section.FLAGS] = ...
        SOME_INSTRUCTIONS: ClassVar[Section.FLAGS] = ...
        STRIP_STATIC_SYMS: ClassVar[Section.FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Section.FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.MachO.Section.FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.MachO.Section.FLAGS, /) -> lief.MachO.Section.FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.MachO.Section.FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        COALESCED: ClassVar[Section.TYPE] = ...
        CSTRING_LITERALS: ClassVar[Section.TYPE] = ...
        DTRACE_DOF: ClassVar[Section.TYPE] = ...
        GB_ZEROFILL: ClassVar[Section.TYPE] = ...
        INIT_FUNC_OFFSETS: ClassVar[Section.TYPE] = ...
        INTERPOSING: ClassVar[Section.TYPE] = ...
        LAZY_DYLIB_SYMBOL_POINTERS: ClassVar[Section.TYPE] = ...
        LAZY_SYMBOL_POINTERS: ClassVar[Section.TYPE] = ...
        LITERAL_POINTERS: ClassVar[Section.TYPE] = ...
        MOD_INIT_FUNC_POINTERS: ClassVar[Section.TYPE] = ...
        MOD_TERM_FUNC_POINTERS: ClassVar[Section.TYPE] = ...
        NON_LAZY_SYMBOL_POINTERS: ClassVar[Section.TYPE] = ...
        REGULAR: ClassVar[Section.TYPE] = ...
        SYMBOL_STUBS: ClassVar[Section.TYPE] = ...
        S_16BYTE_LITERALS: ClassVar[Section.TYPE] = ...
        S_4BYTE_LITERALS: ClassVar[Section.TYPE] = ...
        S_8BYTE_LITERALS: ClassVar[Section.TYPE] = ...
        THREAD_LOCAL_INIT_FUNCTION_POINTERS: ClassVar[Section.TYPE] = ...
        THREAD_LOCAL_REGULAR: ClassVar[Section.TYPE] = ...
        THREAD_LOCAL_VARIABLES: ClassVar[Section.TYPE] = ...
        THREAD_LOCAL_VARIABLE_POINTERS: ClassVar[Section.TYPE] = ...
        THREAD_LOCAL_ZEROFILL: ClassVar[Section.TYPE] = ...
        ZEROFILL: ClassVar[Section.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Section.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Relocation: ...
        def __iter__(self) -> lief.MachO.SegmentCommand.it_relocations: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Relocation: ...
    alignment: int
    flags: lief.MachO.Section.FLAGS
    numberof_relocations: int
    relocation_offset: int
    reserved1: int
    reserved2: int
    reserved3: int
    segment_name: str
    type: lief.MachO.Section.TYPE
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, section_name: str) -> None: ...
    @overload
    def __init__(self, section_name: str, content: list[int]) -> None: ...
    def add(self, flag: lief.MachO.Section.FLAGS) -> None: ...
    def has(self, flag: lief.MachO.Section.FLAGS) -> bool: ...
    def remove(self, flag: lief.MachO.Section.FLAGS) -> None: ...
    def __contains__(self, arg: lief.MachO.Section.FLAGS, /) -> bool: ...
    def __iadd__(self, arg: lief.MachO.Section.FLAGS, /) -> lief.MachO.Section: ...
    def __isub__(self, arg: lief.MachO.Section.FLAGS, /) -> lief.MachO.Section: ...
    @property
    def flags_list(self) -> list[lief.MachO.Section.FLAGS]: ...
    @property
    def has_segment(self) -> bool: ...
    @property
    def relocations(self) -> lief.MachO.SegmentCommand.it_relocations: ...
    @property
    def segment(self) -> lief.MachO.SegmentCommand: ...

class SegmentCommand(LoadCommand):
    class FLAGS:
        FVMLIB: ClassVar[SegmentCommand.FLAGS] = ...
        HIGHVM: ClassVar[SegmentCommand.FLAGS] = ...
        NORELOC: ClassVar[SegmentCommand.FLAGS] = ...
        PROTECTED_VERSION_1: ClassVar[SegmentCommand.FLAGS] = ...
        READ_ONLY: ClassVar[SegmentCommand.FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.SegmentCommand.FLAGS: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class VM_PROTECTIONS:
        R: ClassVar[SegmentCommand.VM_PROTECTIONS] = ...
        W: ClassVar[SegmentCommand.VM_PROTECTIONS] = ...
        X: ClassVar[SegmentCommand.VM_PROTECTIONS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.SegmentCommand.VM_PROTECTIONS: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Relocation: ...
        def __iter__(self) -> lief.MachO.SegmentCommand.it_relocations: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Relocation: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.MachO.Section: ...
        def __iter__(self) -> lief.MachO.SegmentCommand.it_sections: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Section: ...
    content: memoryview
    file_offset: int
    file_size: int
    flags: int
    init_protection: int
    max_protection: int
    name: Union[str,bytes]
    numberof_sections: int
    virtual_address: int
    virtual_size: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: str, /) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: list[int], /) -> None: ...
    def add_section(self, section: lief.MachO.Section) -> lief.MachO.Section: ...
    def get_section(self, name: str) -> lief.MachO.Section: ...
    def has(self, section: lief.MachO.Section) -> bool: ...
    def has_section(self, section_name: str) -> bool: ...
    @property
    def index(self) -> int: ...
    @property
    def relocations(self) -> lief.MachO.SegmentCommand.it_relocations: ...
    @property
    def sections(self) -> lief.MachO.SegmentCommand.it_sections: ...

class SegmentSplitInfo(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class SourceVersion(LoadCommand):
    version: list[int]
    def __init__(self, *args, **kwargs) -> None: ...

class SubFramework(LoadCommand):
    umbrella: str
    def __init__(self, *args, **kwargs) -> None: ...

class Symbol(lief.Symbol):
    class CATEGORY:
        EXTERNAL: ClassVar[Symbol.CATEGORY] = ...
        INDIRECT_ABS: ClassVar[Symbol.CATEGORY] = ...
        INDIRECT_LOCAL: ClassVar[Symbol.CATEGORY] = ...
        LOCAL: ClassVar[Symbol.CATEGORY] = ...
        NONE: ClassVar[Symbol.CATEGORY] = ...
        UNDEFINED: ClassVar[Symbol.CATEGORY] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Symbol.CATEGORY: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class ORIGIN:
        DYLD_BIND: ClassVar[Symbol.ORIGIN] = ...
        DYLD_EXPORT: ClassVar[Symbol.ORIGIN] = ...
        LC_SYMTAB: ClassVar[Symbol.ORIGIN] = ...
        UNKNOWN: ClassVar[Symbol.ORIGIN] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Symbol.ORIGIN: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        ABSOLUTE_SYM: ClassVar[Symbol.TYPE] = ...
        INDIRECT: ClassVar[Symbol.TYPE] = ...
        PREBOUND: ClassVar[Symbol.TYPE] = ...
        SECTION: ClassVar[Symbol.TYPE] = ...
        UNDEFINED: ClassVar[Symbol.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.MachO.Symbol.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    description: int
    numberof_sections: int
    raw_type: int
    def __init__(self) -> None: ...
    @property
    def binding_info(self) -> lief.MachO.BindingInfo: ...
    @property
    def category(self) -> lief.MachO.Symbol.CATEGORY: ...
    @property
    def demangled_name(self) -> str: ...
    @property
    def export_info(self) -> lief.MachO.ExportInfo: ...
    @property
    def has_binding_info(self) -> bool: ...
    @property
    def has_export_info(self) -> bool: ...
    @property
    def origin(self) -> lief.MachO.Symbol.ORIGIN: ...
    @property
    def type(self) -> lief.MachO.Symbol.TYPE: ...

class SymbolCommand(LoadCommand):
    numberof_symbols: int
    strings_offset: int
    strings_size: int
    symbol_offset: int
    def __init__(self) -> None: ...

class ThreadCommand(LoadCommand):
    architecture: lief.MachO.Header.CPU_TYPE
    count: int
    flavor: int
    state: memoryview
    def __init__(self, arg0: int, arg1: int, arg2: lief.MachO.Header.CPU_TYPE, /) -> None: ...
    @property
    def pc(self) -> int: ...

class TwoLevelHints(LoadCommand):
    class it_hints_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> int: ...
        def __iter__(self) -> lief.MachO.TwoLevelHints.it_hints_t: ...
        def __len__(self) -> int: ...
        def __next__(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def hints(self) -> lief.MachO.TwoLevelHints.it_hints_t: ...

class UUIDCommand(LoadCommand):
    uuid: list[int]
    def __init__(self, *args, **kwargs) -> None: ...

class UnknownCommand(LoadCommand):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def original_command(self) -> int: ...

class VersionMin(LoadCommand):
    sdk: list[int]
    version: list[int]
    def __init__(self, *args, **kwargs) -> None: ...

class X86_64_RELOCATION:
    BRANCH: ClassVar[X86_64_RELOCATION] = ...
    GOT: ClassVar[X86_64_RELOCATION] = ...
    GOT_LOAD: ClassVar[X86_64_RELOCATION] = ...
    SIGNED: ClassVar[X86_64_RELOCATION] = ...
    SIGNED_1: ClassVar[X86_64_RELOCATION] = ...
    SIGNED_2: ClassVar[X86_64_RELOCATION] = ...
    SIGNED_4: ClassVar[X86_64_RELOCATION] = ...
    SUBTRACTOR: ClassVar[X86_64_RELOCATION] = ...
    TLV: ClassVar[X86_64_RELOCATION] = ...
    UNSIGNED: ClassVar[X86_64_RELOCATION] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.X86_64_RELOCATION: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class X86_RELOCATION:
    LOCAL_SECTDIFF: ClassVar[X86_RELOCATION] = ...
    PAIR: ClassVar[X86_RELOCATION] = ...
    PB_LA_PTR: ClassVar[X86_RELOCATION] = ...
    SECTDIFF: ClassVar[X86_RELOCATION] = ...
    TLV: ClassVar[X86_RELOCATION] = ...
    VANILLA: ClassVar[X86_RELOCATION] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.MachO.X86_RELOCATION: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class it_data_in_code_entries:
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, arg: int, /) -> lief.MachO.DataCodeEntry: ...
    def __iter__(self) -> lief.MachO.it_data_in_code_entries: ...
    def __len__(self) -> int: ...
    def __next__(self) -> lief.MachO.DataCodeEntry: ...

@overload
def check_layout(file: lief.MachO.Binary) -> tuple[bool,str]: ...
@overload
def check_layout(file: lief.MachO.FatBinary) -> tuple[bool,str]: ...
def is_64(file: str) -> bool: ...
def is_fat(file: str) -> bool: ...
@overload
def parse(filename: str, config: lief.MachO.ParserConfig = ...) -> Optional[lief.MachO.FatBinary]: ...
@overload
def parse(raw: list[int], config: lief.MachO.ParserConfig = ...) -> Optional[lief.MachO.FatBinary]: ...
@overload
def parse(obj: Union[io.IOBase|os.PathLike], config: lief.MachO.ParserConfig = ...) -> Optional[lief.MachO.FatBinary]: ...
def parse_from_memory(address: int, config: lief.MachO.ParserConfig = ...) -> Optional[lief.MachO.FatBinary]: ...
