from typing import Any, ClassVar, Optional, Union

from typing import overload
import io
import lief.ART # type: ignore
import lief.Android # type: ignore
import os

class File(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def header(self) -> lief.ART.Header: ...

class Header(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def boot_image_begin(self) -> int: ...
    @property
    def boot_image_size(self) -> int: ...
    @property
    def boot_oat_begin(self) -> int: ...
    @property
    def boot_oat_size(self) -> int: ...
    @property
    def compile_pic(self) -> bool: ...
    @property
    def data_size(self) -> int: ...
    @property
    def image_begin(self) -> int: ...
    @property
    def image_roots(self) -> int: ...
    @property
    def image_size(self) -> int: ...
    @property
    def magic(self) -> list[int]: ...
    @property
    def nb_methods(self) -> int: ...
    @property
    def nb_sections(self) -> int: ...
    @property
    def oat_checksum(self) -> int: ...
    @property
    def oat_data_end(self) -> int: ...
    @property
    def oat_file_begin(self) -> int: ...
    @property
    def oat_file_end(self) -> int: ...
    @property
    def patch_delta(self) -> int: ...
    @property
    def pointer_size(self) -> int: ...
    @property
    def storage_mode(self) -> lief.ART.STORAGE_MODES: ...
    @property
    def version(self) -> int: ...

class STORAGE_MODES:
    LZ4: ClassVar[STORAGE_MODES] = ...
    LZ4HC: ClassVar[STORAGE_MODES] = ...
    UNCOMPRESSED: ClassVar[STORAGE_MODES] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...

def android_version(art_version: int) -> lief.Android.ANDROID_VERSIONS: ...
@overload
def parse(filename: str) -> Optional[lief.ART.File]: ...
@overload
def parse(raw: list[int], name: str = ...) -> Optional[lief.ART.File]: ...
@overload
def parse(obj: Union[io.IOBase|os.PathLike], name: str = ...) -> Optional[lief.ART.File]: ...
@overload
def version(file: str) -> int: ...
@overload
def version(raw: list[int]) -> int: ...
