# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpgradeNotification(Model):
    """Properties of upgrade notification.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of upgrade notification.
    :vartype name: str
    :ivar timestamp: Timestamp when upgrade notification occurred.
    :vartype timestamp: datetime
    :ivar upsell_notification: Details about this upgrade notification
    :vartype upsell_notification: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'timestamp': {'readonly': True},
        'upsell_notification': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'upsell_notification': {'key': 'upsellNotification', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(UpgradeNotification, self).__init__(**kwargs)
        self.name = None
        self.timestamp = None
        self.upsell_notification = None
