# Generated by Django 5.1.14 on 2025-11-19 13:03

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0059_compliance_overview_summary"),
    ]

    operations = [
        migrations.CreateModel(
            name="AttackSurfaceOverview",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                (
                    "attack_surface_type",
                    models.CharField(
                        choices=[
                            ("internet-exposed", "Internet Exposed"),
                            ("secrets", "Exposed Secrets"),
                            ("privilege-escalation", "Privilege Escalation"),
                            ("ec2-imdsv1", "EC2 IMDSv1 Enabled"),
                        ],
                        max_length=50,
                    ),
                ),
                ("total_findings", models.IntegerField(default=0)),
                ("failed_findings", models.IntegerField(default=0)),
                ("muted_failed_findings", models.IntegerField(default=0)),
            ],
            options={
                "db_table": "attack_surface_overviews",
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="attacksurfaceoverview",
            name="scan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="attack_surface_overviews",
                related_query_name="attack_surface_overview",
                to="api.scan",
            ),
        ),
        migrations.AddField(
            model_name="attacksurfaceoverview",
            name="tenant",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
            ),
        ),
        migrations.AddIndex(
            model_name="attacksurfaceoverview",
            index=models.Index(
                fields=["tenant_id", "scan_id"], name="attack_surf_tenant_scan_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="attacksurfaceoverview",
            constraint=models.UniqueConstraint(
                fields=("tenant_id", "scan_id", "attack_surface_type"),
                name="unique_attack_surface_per_scan",
            ),
        ),
        migrations.AddConstraint(
            model_name="attacksurfaceoverview",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_attacksurfaceoverview",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
