# Generated by Django 5.1.13 on 2025-10-22 11:56

import uuid

import django.contrib.postgres.fields
import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0051_oraclecloud_provider"),
    ]

    operations = [
        migrations.CreateModel(
            name="MuteRule",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(
                        help_text="Human-readable name for this rule",
                        max_length=100,
                        validators=[django.core.validators.MinLengthValidator(3)],
                    ),
                ),
                (
                    "reason",
                    models.TextField(
                        help_text="Reason for muting",
                        max_length=500,
                        validators=[django.core.validators.MinLengthValidator(3)],
                    ),
                ),
                (
                    "enabled",
                    models.BooleanField(
                        default=True, help_text="Whether this rule is currently enabled"
                    ),
                ),
                (
                    "finding_uids",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=255),
                        help_text="List of finding UIDs to mute",
                        size=None,
                    ),
                ),
            ],
            options={
                "db_table": "mute_rules",
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="finding",
            name="muted_at",
            field=models.DateTimeField(
                blank=True, help_text="Timestamp when this finding was muted", null=True
            ),
        ),
        migrations.AlterField(
            model_name="tenantapikey",
            name="name",
            field=models.CharField(
                max_length=100,
                validators=[django.core.validators.MinLengthValidator(3)],
            ),
        ),
        migrations.AddField(
            model_name="muterule",
            name="created_by",
            field=models.ForeignKey(
                help_text="User who created this rule",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="created_mute_rules",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="muterule",
            name="tenant",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
            ),
        ),
        migrations.AddConstraint(
            model_name="muterule",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_muterule",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddConstraint(
            model_name="muterule",
            constraint=models.UniqueConstraint(
                fields=("tenant_id", "name"), name="unique_mute_rule_name_per_tenant"
            ),
        ),
    ]
