/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.ir.attributes.RecordAttribute;
import com.strobel.assembler.ir.attributes.RecordComponentInfo;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BytecodeConstant;
import com.strobel.decompiler.languages.java.ast.ClassType;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InlinedBytecodeExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.patterns.AllMatch;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.IdentifierBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.ParameterReferenceNode;
import com.strobel.decompiler.patterns.Repeat;
import com.strobel.decompiler.patterns.TypedNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class RewriteRecordClassesTransform
extends ContextTrackingVisitor<Void> {
    protected static final Map<String, String> GENERATED_METHOD_SIGNATURES;
    protected static final BlockStatement INVOKE_DYNAMIC_BODY;
    protected static final ExpressionStatement ASSIGNMENT_PATTERN;
    protected static final ExpressionStatement SUPER_CONSTRUCTOR_CALL;
    protected static final ExpressionStatement THIS_CONSTRUCTOR_CALL;
    protected static final MethodDeclaration ACCESSOR;
    private RecordState _currentRecord;

    public RewriteRecordClassesTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        if (this.context.isSupported(LanguageFeature.RECORD_CLASSES)) {
            super.run(compilationUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void visitTypeDeclarationOverride(TypeDeclaration typeDeclaration, Void p) {
        RecordState recordState;
        RecordState oldRecord = this._currentRecord;
        TypeDefinition definition = typeDeclaration.getUserData(Keys.TYPE_DEFINITION);
        RecordAttribute recordAttribute = definition != null && definition.isRecord() ? (RecordAttribute)SourceAttribute.find("Record", definition.getSourceAttributes()) : null;
        this._currentRecord = recordState = recordAttribute != null ? new RecordState(definition, recordAttribute, typeDeclaration) : null;
        try {
            super.visitTypeDeclarationOverride(typeDeclaration, p);
            if (recordState != null) {
                recordState.tryRewrite();
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this._currentRecord = oldRecord;
        }
    }

    @Override
    protected Void visitMethodDeclarationOverride(MethodDeclaration node, Void p) {
        RecordComponentInfo componentInfo;
        DynamicCallSite callSite;
        Match indyMatch;
        MethodDefinition method;
        RecordState recordState = this._currentRecord;
        super.visitMethodDeclarationOverride(node, p);
        if (recordState == null || (method = this.context.getCurrentMethod()) == null) {
            return null;
        }
        String expectedSignature = GENERATED_METHOD_SIGNATURES.get(method.getName());
        if (expectedSignature != null && StringUtilities.equals(expectedSignature, method.getErasedSignature()) && (indyMatch = INVOKE_DYNAMIC_BODY.match(node.getBody())).success() && (callSite = ((InvocationExpression)CollectionUtilities.first(indyMatch.get("invocation"))).getUserData(Keys.DYNAMIC_CALL_SITE)) != null && CommonTypeReferences.ObjectMethods.isEquivalentTo(callSite.getBootstrapMethod().getDeclaringType())) {
            recordState.removableMethods.add(node);
            return null;
        }
        if (ACCESSOR.matches(node) && (componentInfo = recordState.recordComponents.get(node.getName())) != null && MetadataHelper.isSameType(componentInfo.getType(), node.getReturnType().toTypeReference())) {
            recordState.removableAccessors.put(componentInfo, node);
        }
        return null;
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
        super.visitFieldDeclaration(node, data);
        RecordState recordState = this._currentRecord;
        if (recordState == null) {
            return null;
        }
        RecordComponentInfo componentInfo = recordState.recordComponents.get(node.getName());
        if (componentInfo != null && MetadataHelper.isSameType(componentInfo.getType(), node.getReturnType().toTypeReference())) {
            recordState.removableFields.put(componentInfo, node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        RecordState.Constructor oldConstructor;
        RecordState recordState = this._currentRecord;
        RecordState.Constructor constructor = oldConstructor = recordState != null ? recordState.currentConstructor : null;
        if (recordState != null) {
            RecordState.Constructor recordConstructor = recordState.constructors.get(node);
            if (recordConstructor == null) {
                recordConstructor = new RecordState.Constructor(node);
                recordState.constructors.put(node, recordConstructor);
            }
            recordState.currentConstructor = recordConstructor;
        }
        try {
            Void void_ = (Void)super.visitConstructorDeclaration(node, p);
            return void_;
        }
        finally {
            if (recordState != null) {
                recordState.currentConstructor = oldConstructor;
            }
        }
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatement node, Void data) {
        RecordState.Constructor recordConstructor;
        super.visitExpressionStatement(node, data);
        RecordState recordState = this._currentRecord;
        RecordState.Constructor constructor = recordConstructor = recordState != null ? recordState.currentConstructor : null;
        if (recordConstructor == null || !recordState.constructors.containsKey(recordConstructor.constructor)) {
            return null;
        }
        if (SUPER_CONSTRUCTOR_CALL.matches(node)) {
            recordConstructor.removableSuperCall.set(node);
            return null;
        }
        if (THIS_CONSTRUCTOR_CALL.matches(node)) {
            recordState.constructors.remove(recordConstructor.constructor);
            return null;
        }
        Match match = ASSIGNMENT_PATTERN.match(node);
        if (!match.success()) {
            return null;
        }
        MemberReferenceExpression f = (MemberReferenceExpression)CollectionUtilities.first(match.get("assignment"));
        final IdentifierExpression p = (IdentifierExpression)CollectionUtilities.first(match.get("parameter"));
        RecordComponentInfo componentInfo = recordState.recordComponents.get(f.getMemberName());
        if (componentInfo != null) {
            recordConstructor.removableAssignments.put(componentInfo, node);
            ConstructorDeclaration constructor2 = recordConstructor.constructor;
            ParameterDeclaration parameter = CollectionUtilities.firstOrDefault(constructor2.getParameters(), new Predicate<ParameterDeclaration>(){

                @Override
                public boolean test(ParameterDeclaration declaration) {
                    return StringUtilities.equals(declaration.getName(), p.getIdentifier());
                }
            });
            if (parameter != null) {
                recordConstructor.removableParameters.put(componentInfo, parameter);
            }
        }
        return null;
    }

    static {
        INVOKE_DYNAMIC_BODY = new BlockStatement(new ReturnStatement(new NamedNode("invocation", new InvocationExpression((Expression)new InlinedBytecodeExpression(AstCode.InvokeDynamic, new TypedNode(BytecodeConstant.class).toExpression()), new Repeat(new AnyNode()).toExpression())).toExpression()));
        ASSIGNMENT_PATTERN = new ExpressionStatement(new AssignmentExpression(new NamedNode("assignment", new MemberReferenceExpression((Expression)new ThisReferenceExpression(-34), "$any$", new AstType[0])).toExpression(), AssignmentOperatorType.ASSIGN, new ParameterReferenceNode(-1, "parameter").toExpression()));
        SUPER_CONSTRUCTOR_CALL = new ExpressionStatement(new InvocationExpression((Expression)new SuperReferenceExpression(-34), new Expression[0]));
        THIS_CONSTRUCTOR_CALL = new ExpressionStatement(new InvocationExpression((Expression)new ThisReferenceExpression(-34), new Repeat(new AnyNode()).toExpression()));
        HashMap<String, String> generatedMethodNames = new HashMap<String, String>();
        generatedMethodNames.put("toString", "()Ljava/lang/String;");
        generatedMethodNames.put("hashCode", "()I");
        generatedMethodNames.put("equals", "(Ljava/lang/Object;)Z");
        GENERATED_METHOD_SIGNATURES = Collections.unmodifiableMap(generatedMethodNames);
        MethodDeclaration accessor = new MethodDeclaration();
        accessor.setName("$any$");
        accessor.addModifier(Modifier.PUBLIC);
        accessor.setReturnType(new AnyNode().toType());
        accessor.setBody(new BlockStatement(new ReturnStatement(new AllMatch(new MemberReferenceExpression((Expression)new ThisReferenceExpression(), "$any$", new AstType[0]), new IdentifierBackReference("accessor")).toExpression())));
        ACCESSOR = new NamedNode("accessor", accessor).toMethodDeclaration();
    }

    protected static final class RecordState {
        @NotNull
        final TypeDefinition recordDefinition;
        @NotNull
        final RecordAttribute recordAttribute;
        @NotNull
        final TypeDeclaration recordDeclaration;
        @NotNull
        final Map<ConstructorDeclaration, Constructor> constructors;
        @NotNull
        final List<MethodDeclaration> removableMethods;
        @NotNull
        final Map<RecordComponentInfo, MethodDeclaration> removableAccessors;
        @NotNull
        final Map<RecordComponentInfo, FieldDeclaration> removableFields;
        @NotNull
        final Map<String, RecordComponentInfo> recordComponents;
        Constructor currentConstructor;

        public RecordState(TypeDefinition recordDefinition, RecordAttribute recordAttribute, TypeDeclaration recordDeclaration) {
            this.recordDefinition = recordDefinition;
            this.recordAttribute = recordAttribute;
            this.recordDeclaration = recordDeclaration;
            this.constructors = new HashMap<ConstructorDeclaration, Constructor>();
            this.removableAccessors = new HashMap<RecordComponentInfo, MethodDeclaration>();
            this.removableFields = new HashMap<RecordComponentInfo, FieldDeclaration>();
            this.removableMethods = new ArrayList<MethodDeclaration>();
            LinkedHashMap<String, RecordComponentInfo> recordComponents = new LinkedHashMap<String, RecordComponentInfo>();
            for (RecordComponentInfo component : recordAttribute.getComponents()) {
                recordComponents.put(component.getName(), component);
            }
            this.recordComponents = Collections.unmodifiableMap(recordComponents);
        }

        public final boolean tryRewrite() {
            if (this.canRewrite()) {
                this.rewrite0();
                return true;
            }
            return false;
        }

        public final boolean canRewrite() {
            List<RecordComponentInfo> components = this.recordAttribute.getComponents();
            int componentCount = components.size();
            return this.removableAccessors.size() <= componentCount && this.removableFields.size() == componentCount && this.constructors.size() == 1 && CollectionUtilities.single(this.constructors.values()).removableSuperCall.get() != null;
        }

        private void rewrite0() {
            this.recordDeclaration.getBaseType().remove();
            this.recordDeclaration.setClassType(ClassType.RECORD);
            this.recordDeclaration.getModifiers().clear();
            for (MethodDeclaration accessor : this.removableAccessors.values()) {
                accessor.remove();
            }
            Constructor constructor = CollectionUtilities.single(this.constructors.values());
            ExpressionStatement superCall = constructor.removableSuperCall.get();
            if (superCall != null) {
                superCall.remove();
            }
            if (constructor.removableParameters.size() == this.recordComponents.size() && constructor.removableAssignments.size() == this.recordComponents.size()) {
                for (ExpressionStatement expressionStatement : constructor.removableAssignments.values()) {
                    expressionStatement.remove();
                }
                for (ParameterDeclaration parameterDeclaration : constructor.removableParameters.values()) {
                    parameterDeclaration.remove();
                    parameterDeclaration.getModifiers().clear();
                }
            }
            boolean generatedConstructor = constructor.removableParameters.size() == this.recordComponents.size();
            for (RecordComponentInfo recordComponentInfo : this.recordComponents.values()) {
                ParameterDeclaration p;
                ParameterDeclaration parameterDeclaration = p = generatedConstructor ? constructor.removableParameters.get(recordComponentInfo) : null;
                if (p == null) {
                    FieldDeclaration f = this.removableFields.get(recordComponentInfo);
                    p = new ParameterDeclaration(f.getName(), f.getReturnType().clone());
                }
                this.recordDeclaration.addChild(p, EntityDeclaration.RECORD_COMPONENT);
            }
            for (MethodDeclaration methodDeclaration : this.removableMethods) {
                methodDeclaration.remove();
            }
            for (MethodDeclaration methodDeclaration : this.removableAccessors.values()) {
                methodDeclaration.remove();
            }
            for (Map.Entry<RecordComponentInfo, FieldDeclaration> entry : this.removableFields.entrySet()) {
                FieldDeclaration field = entry.getValue();
                field.remove();
                ParameterDeclaration parameter = constructor.removableParameters.get(entry.getKey());
                if (parameter == null) continue;
                for (Annotation annotation : field.getChildrenByRole(Roles.ANNOTATION)) {
                    if (parameter.getChildrenByRole(Roles.ANNOTATION).anyMatch(annotation)) continue;
                    annotation.remove();
                    parameter.addChild(annotation, Roles.ANNOTATION);
                }
            }
            ConstructorDeclaration constructorDeclaration = CollectionUtilities.single(this.constructors.keySet());
            if (constructorDeclaration.getBody().getStatements().isEmpty()) {
                constructorDeclaration.remove();
            }
        }

        public static final class Constructor {
            @NotNull
            final ConstructorDeclaration constructor;
            @NotNull
            final Map<RecordComponentInfo, ParameterDeclaration> removableParameters;
            @NotNull
            final Map<RecordComponentInfo, ExpressionStatement> removableAssignments;
            @NotNull
            final StrongBox<ExpressionStatement> removableSuperCall;

            Constructor(ConstructorDeclaration constructor) {
                this.constructor = VerifyArgument.notNull(constructor, "constructor");
                this.removableParameters = new HashMap<RecordComponentInfo, ParameterDeclaration>();
                this.removableAssignments = new HashMap<RecordComponentInfo, ExpressionStatement>();
                this.removableSuperCall = new StrongBox();
            }
        }
    }
}

