/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.EntityType;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;

public abstract class EntityDeclaration
extends AstNode {
    public static final Role<Annotation> ANNOTATION_ROLE = Roles.ANNOTATION;
    public static final Role<Annotation> UNATTACHED_ANNOTATION_ROLE = new Role<Annotation>("UnattachedAnnotation", Annotation.class);
    public static final Role<JavaModifierToken> MODIFIER_ROLE = new Role<JavaModifierToken>("Modifier", JavaModifierToken.class);
    public static final Role<AstType> PRIVATE_IMPLEMENTATION_TYPE_ROLE = new Role<AstType>("PrivateImplementationType", AstType.class, AstType.NULL);
    public static final Role<ParameterDeclaration> RECORD_COMPONENT = new Role<ParameterDeclaration>("ParameterDeclaration", ParameterDeclaration.class);
    private boolean _anyModifiers;

    public final boolean isAnyModifiers() {
        return this._anyModifiers;
    }

    public final void setAnyModifiers(boolean value) {
        this.verifyNotFrozen();
        this._anyModifiers = value;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MEMBER;
    }

    public Role<? extends EntityDeclaration> getRole() {
        return super.getRole();
    }

    public abstract EntityType getEntityType();

    public final AstNodeCollection<Annotation> getAnnotations() {
        return this.getChildrenByRole(ANNOTATION_ROLE);
    }

    public final boolean hasModifier(Modifier modifier) {
        for (JavaModifierToken modifierToken : this.getModifiers()) {
            if (modifierToken.getModifier() != modifier) continue;
            return true;
        }
        return false;
    }

    public final AstNodeCollection<JavaModifierToken> getModifiers() {
        return this.getChildrenByRole(MODIFIER_ROLE);
    }

    public final String getName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setName(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setNameToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final AstType getReturnType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setReturnType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    @Override
    public EntityDeclaration clone() {
        EntityDeclaration copy = (EntityDeclaration)super.clone();
        copy._anyModifiers = this._anyModifiers;
        return copy;
    }

    protected final boolean matchAnnotationsAndModifiers(EntityDeclaration other, Match match) {
        return other != null && !other.isNull() && (this.isAnyModifiers() || this.getModifiers().matches(other.getModifiers(), match)) && this.getAnnotations().matches(other.getAnnotations(), match);
    }

    public final void addModifier(Modifier modifier) {
        EntityDeclaration.addModifier(this, modifier);
    }

    public final void removeModifier(Modifier modifier) {
        EntityDeclaration.removeModifier(this, modifier);
    }

    public final void setModifiers(List<Modifier> modifiers) {
        EntityDeclaration.setModifiers(this, modifiers);
    }

    static List<Modifier> getModifiers(AstNode node) {
        ArrayList<Modifier> modifiers = null;
        for (JavaModifierToken modifierToken : node.getChildrenByRole(MODIFIER_ROLE)) {
            if (modifiers == null) {
                modifiers = new ArrayList<Modifier>();
            }
            modifiers.add(modifierToken.getModifier());
        }
        return modifiers != null ? Collections.unmodifiableList(modifiers) : Collections.emptyList();
    }

    static void setModifiers(AstNode node, Collection<Modifier> modifiers) {
        AstNodeCollection<JavaModifierToken> modifierTokens = node.getChildrenByRole(MODIFIER_ROLE);
        modifierTokens.clear();
        for (Modifier modifier : modifiers) {
            modifierTokens.add(new JavaModifierToken(TextLocation.EMPTY, modifier));
        }
    }

    static void addModifier(AstNode node, Modifier modifier) {
        List<Modifier> modifiers = EntityDeclaration.getModifiers(node);
        if (modifiers.contains((Object)modifier)) {
            return;
        }
        node.addChild(new JavaModifierToken(TextLocation.EMPTY, modifier), MODIFIER_ROLE);
    }

    static boolean removeModifier(AstNode node, Modifier modifier) {
        AstNodeCollection<JavaModifierToken> modifierTokens = node.getChildrenByRole(MODIFIER_ROLE);
        for (JavaModifierToken modifierToken : modifierTokens) {
            if (modifierToken.getModifier() != modifier) continue;
            modifierToken.remove();
            return true;
        }
        return false;
    }
}

