/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public enum CompilerTarget {
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JDK1_5("1.5", 49, 0),
    JDK1_6("1.6", 50, 0),
    JDK1_7("1.7", 51, 0),
    JDK1_8("1.8", 52, 0),
    JDK9("9", 53, 0),
    JDK10("10", 54, 0),
    JDK11("11", 55, 0),
    JDK12("12", 56, 0),
    JDK13("13", 57, 0),
    JDK14("14", 58, 0),
    JDK15("15", 59, 0),
    JDK16("16", 60, 0);

    private static final CompilerTarget[] VALUES;
    private static final CompilerTarget MIN;
    private static final CompilerTarget MIN_DEFAULT;
    private static final CompilerTarget MAX;
    private static final Map<String, CompilerTarget> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final CompilerTarget DEFAULT;

    public static CompilerTarget MIN() {
        return MIN;
    }

    public static CompilerTarget MAX() {
        return MAX;
    }

    private CompilerTarget(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static CompilerTarget lookup(String name) {
        CompilerTarget target = tab.get(name);
        if (target != null) {
            return target;
        }
        return CompilerTarget.tryParseVersion(name);
    }

    public static CompilerTarget lookup(int majorVersion, int minorVersion) {
        for (CompilerTarget target : VALUES) {
            if (majorVersion < target.majorVersion) {
                return target;
            }
            if (minorVersion > target.minorVersion || majorVersion != target.majorVersion) continue;
            return target;
        }
        return MAX;
    }

    @Nullable
    private static CompilerTarget tryParseVersion(String s) {
        CompilerTarget majorMinor;
        int finalDelimiter;
        int end = s.length();
        int minorDelimiter = s.indexOf(46);
        if (minorDelimiter < 0) {
            if (end < 1 || !Character.isDigit(s.charAt(0))) {
                return null;
            }
            return tab.get(s);
        }
        int n = finalDelimiter = minorDelimiter < end - 1 ? s.indexOf(46, minorDelimiter + 1) : end;
        if (finalDelimiter > minorDelimiter && (majorMinor = tab.get(s.substring(0, finalDelimiter))) != null) {
            return majorMinor;
        }
        return tab.get(s.substring(0, minorDelimiter));
    }

    private static int parse(String s, int start, int end) {
        try {
            if (start > 0 || end < s.length() - 1) {
                return Integer.parseInt(s.substring(start, end));
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean requiresIProxy() {
        return this.compareTo(JDK1_1) <= 0;
    }

    public boolean initializeFieldsBeforeSuper() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean obeyBinaryCompatibility() {
        return this.compareTo(JDK1_2) >= 0;
    }

    public boolean arrayBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean interfaceFieldsBinaryCompatibility() {
        return this.compareTo(JDK1_2) > 0;
    }

    public boolean interfaceObjectOverridesBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean usePrivateSyntheticFields() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean useInnerCacheClass() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean generateCLDCStackMap() {
        return false;
    }

    public boolean generateStackMapTable() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean isPackageInfoSynthetic() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean generateEmptyAfterBig() {
        return false;
    }

    public boolean useStringBuilder() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useSyntheticFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useEnumFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useAnnotationFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useVarargsFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useBridgeFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasClassLiterals() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasInvokeDynamic() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean hasMethodHandles() {
        return this.hasInvokeDynamic();
    }

    public boolean classLiteralsNoInit() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasInitCause() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean boxWithConstructors() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean hasIterable() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasEnclosingMethodAttribute() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasMethodParameters() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean hasStringConcatFactory() {
        return this.compareTo(JDK9) >= 0;
    }

    public String multiReleaseValue() {
        return Integer.toString(this.ordinal() - JDK1_1.ordinal() + 1);
    }

    public boolean allApiModulesAreRoots() {
        return this.compareTo(JDK11) >= 0;
    }

    public boolean hasNestmateAccess() {
        return this.compareTo(JDK11) >= 0;
    }

    public boolean runtimeUseNestAccess() {
        return this.compareTo(JDK15) >= 0;
    }

    public boolean hasVirtualPrivateInvoke() {
        return this.compareTo(JDK11) >= 0;
    }

    public boolean hasSealedClasses() {
        return this.compareTo(JDK15) >= 0;
    }

    static {
        VALUES = CompilerTarget.values();
        MIN = VALUES[0];
        MIN_DEFAULT = JDK1_7;
        MAX = VALUES[VALUES.length - 1];
        tab = new HashMap<String, CompilerTarget>();
        for (CompilerTarget t : CompilerTarget.values()) {
            tab.put(t.name, t);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        tab.put("8", JDK1_8);
        CompilerTarget target = CompilerTarget.tryParseVersion(System.getProperty("java.version"));
        DEFAULT = target != null ? target : MIN_DEFAULT;
    }
}

