# $Id: racketpart.rb 14 2008-03-02 05:42:30Z warchild $
#
# Copyright (c) 2008, Jon Hart 
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the <organization> nor the
#       names of its contributors may be used to endorse or promote products
#       derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY Jon Hart ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL Jon Hart BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#require 'rubygems'
require File.dirname(__FILE__) + '/../../bit-struct/bit-struct.rb'

module Racket
# Every Racket object is made up of numerous sub-parts, namely layers of the OSI stack.
class RacketPart < BitStruct

  # Boolean indicating whether or not this instance should be
  # automatically "fixed" prior to be packed and sent.
  attr_accessor :autofix

  # Should this instance be automatically fixed 
  # prior to being packed and sent?
  def autofix?
    @autofix
  end

  def initialize(*args)
    @autofix = true
    super(*args)
  end


  # Print out all of the fields and all of their values
  def pretty
    s  = ""
    self.fields.each do |f|
      unless (f.name == "payload")
        s += "#{f.name}=#{self.send(f.name)} "
      end
    end
    s.gsub(/ $/, '')
  end
 
  def fix!
  end
end
end
# vim: set ts=2 et sw=2:
