"use strict";

var _react = _interopRequireDefault(require("react"));

var _ink = require("ink");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _stringWidth = _interopRequireDefault(require("string-width"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Helpers
const getSideDividerWidth = (width, titleWidth) => (width - titleWidth) / 2;

const getNumberOfCharsPerWidth = (char, width) => width / (0, _stringWidth.default)(char);

const PAD = ' '; // Divider

const Divider = ({
  title,
  width,
  padding,
  titlePadding,
  titleColor,
  dividerChar,
  dividerColor
}) => {
  const titleString = title ? `${PAD.repeat(titlePadding) + title + PAD.repeat(titlePadding)}` : '';
  const titleWidth = (0, _stringWidth.default)(titleString);
  const dividerWidth = getSideDividerWidth(width, titleWidth);
  const numberOfCharsPerSide = getNumberOfCharsPerWidth(dividerChar, dividerWidth);
  const dividerSideString = dividerChar.repeat(numberOfCharsPerSide);
  const paddingString = PAD.repeat(padding);
  return _react.default.createElement(_ink.Box, {
    flexDirection: "row"
  }, paddingString, _react.default.createElement(_ink.Color, {
    keyword: dividerColor
  }, dividerSideString), _react.default.createElement(_ink.Color, {
    keyword: titleColor
  }, titleString), _react.default.createElement(_ink.Color, {
    keyword: dividerColor
  }, dividerSideString), paddingString);
};

Divider.propTypes = {
  title: _propTypes.default.string,
  width: _propTypes.default.number,
  padding: _propTypes.default.number,
  titlePadding: _propTypes.default.number,
  titleColor: _propTypes.default.string,
  dividerChar: _propTypes.default.string,
  dividerColor: _propTypes.default.string
};
Divider.defaultProps = {
  title: null,
  width: 50,
  padding: 1,
  titlePadding: 1,
  titleColor: 'white',
  dividerChar: '─',
  dividerColor: 'grey'
};
module.exports = Divider;