/*
 * Decompiled with CFR 0.152.
 */
package cqure.repeng;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ExpHtml {
    private ReportTree m_oTree;

    public ExpHtml(ReportTree oTree) {
        this.m_oTree = oTree;
    }

    public void setTree(ReportTree oTree) {
        this.m_oTree = oTree;
    }

    public void doTab(int nCount) {
        int i = 0;
        while (i < nCount) {
            System.out.print("&nbsp;");
            ++i;
        }
    }

    private void htmlMarkupLevelStart(int nLevel) {
        int nSize = 6 - nLevel;
        if (nSize < 1) {
            nSize = 1;
        }
        System.out.print("<font size=\"" + nSize + "\">");
    }

    private void htmlMarkupLevelEnd() {
        System.out.println("</font><br>");
    }

    public void visitAllNodes() {
        TreeNode root = (TreeNode)this.m_oTree.getRoot();
        this.visitAllNodes(root);
    }

    public void visitAllNodes(TreeNode node) {
        ReportObject oRo = null;
        Hashtable oH = null;
        Enumeration oE = null;
        if (node instanceof ReportObject) {
            oRo = (ReportObject)node;
            int nLevel = ((DefaultMutableTreeNode)node).getLevel();
            this.htmlMarkupLevelStart(nLevel);
            System.out.print(oRo.toString());
            this.htmlMarkupLevelEnd();
            if (oRo.getPropertyCount() > 0) {
                oH = oRo.getProperties();
                System.out.println("<ul>");
                oE = oH.keys();
                while (oE.hasMoreElements()) {
                    String sKey = (String)oE.nextElement();
                    if (oH.get(sKey) == null || ((String)oH.get(sKey)).length() <= 0) continue;
                    System.out.print("<li>" + sKey + ": " + oH.get(sKey) + "</li>");
                }
                System.out.println("</ul>");
            }
        }
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.visitAllNodes(n);
            }
        }
    }

    public void createHeader(String sFile) {
    }

    public void createFooter(String sFile) {
    }

    public void createHeader() {
        System.out.println("<html>");
        System.out.println("    <body>");
    }

    public void createFooter() {
        System.out.println("    </body>");
        System.out.println("</html>");
    }

    public boolean export(String sFile) {
        this.createHeader();
        this.visitAllNodes();
        this.createFooter();
        return true;
    }
}

