/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Logger {
    private boolean m_bLogToScreen = true;
    private PrintStream m_oOut = null;
    private PrintStream m_oOutDebug = System.out;
    public static final int LOG_DEBUG = 5;
    public static final int LOG_TRACE = 4;
    public static final int LOG_WARNING = 3;
    public static final int LOG_INFO = 2;
    public static final int LOG_ERROR = 1;
    public static final int ERROR_FILE_ACCESS = -100;
    public static final int OK = 0;
    private int m_nLogLevel = 1;

    public int setLogFile(String sLogFile) {
        try {
            this.m_oOut = new PrintStream(new FileOutputStream(sLogFile));
        }
        catch (FileNotFoundException e) {
            return -100;
        }
        return 0;
    }

    public boolean isAvailable() {
        return this.m_oOut != null;
    }

    public void setLogLevel(int n) {
        this.m_nLogLevel = n;
    }

    public void trace(String sMsg) {
        if (this.m_nLogLevel >= 4) {
            this.m_oOutDebug.println(sMsg);
        }
    }

    public void info(String sMsg) {
        if (this.m_nLogLevel >= 2) {
            this.m_oOutDebug.println("INFO: " + sMsg);
        }
    }

    public void debug(String sMsg) {
        if (this.m_nLogLevel == 5) {
            this.m_oOutDebug.println(sMsg);
        }
    }

    public void log(String sMsg) {
        if (this.m_oOut != null) {
            this.m_oOut.println(sMsg);
        }
        if (this.m_bLogToScreen) {
            System.out.println(sMsg);
        }
    }
}

