/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util.cmd;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.util.cmd.CmdLineOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmdLineOptions {
    private final Map<String, CmdLineOption> map = new HashMap<String, CmdLineOption>();
    private final List<CmdLineOption> list = new ArrayList<CmdLineOption>();

    public void add(CmdLineOption option) {
        this.map.put(option.getName(), option);
        this.list.add(option);
        if (option.getAltName() != null) {
            this.map.put(option.getAltName(), option);
        }
    }

    public void add(String name, String altName, int type, boolean takesArg) {
        this.add(new CmdLineOption(name, altName, type, takesArg));
    }

    public CmdLineOption getOption(String name) {
        return this.map.get(name);
    }

    public CmdLineOption getOption(int index) {
        return this.list.get(index);
    }

    public String getStringValue(String name) {
        CmdLineOption option = this.getOption(name);
        return option == null ? null : option.getValue().trim();
    }

    public Integer getIntegerValue(String name, String errNamespace, int errCode) throws OpenStegoException {
        String val = this.getStringValue(name);
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfEx) {
            throw new OpenStegoException((Throwable)nfEx, errNamespace, errCode, val);
        }
    }

    public Boolean getBooleanValue(String name, String errNamespace, int errCode) throws OpenStegoException {
        String val = this.getStringValue(name);
        if (val == null) {
            return null;
        }
        if ("t".equals(val = val.toLowerCase()) || "true".equals(val) || "y".equals(val) || "yes".equals(val) || "1".equals(val)) {
            return true;
        }
        if ("f".equals(val) || "false".equals(val) || "n".equals(val) || "no".equals(val) || "0".equals(val)) {
            return false;
        }
        throw new OpenStegoException(null, errNamespace, errCode, val);
    }

    public List<CmdLineOption> getList() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }
}

