/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.ui;

import com.openstego.desktop.util.LabelUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;

public class HelpAboutDialog
extends JDialog {
    private static final long serialVersionUID = 2707372931999569066L;
    private static final LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
    private JEditorPane content;
    private JButton okButton;

    public JEditorPane getContent() {
        if (this.content == null) {
            String buf = "<html>  <table width=100% cellspacing=0 cellpadding=0 style='font:serif;'>    <tr style='background-color:white'>      <td align=left style='padding-left:8px'>        <span style='font-size:24px; font-weight:bold'>          " + labelUtil.getString("appName") + "</span>        <p style='font-size:10px; margin-top:6px'>          " + labelUtil.getString("appVersion") + "</p>      </td>      <td align=right>        <img src='" + Objects.requireNonNull(this.getClass().getResource("/images/About.png")) + "'/>      </td>    </tr>    <tr>      <td colspan=2 style='padding:5px;font-size:10px'>        <p>" + labelUtil.getString("copyright") + "</p><br/>        <p>" + labelUtil.getString("gui.label.help.sitelink") + "</p><br/>        <p><b>" + labelUtil.getString("gui.label.help.ackHeader") + "</b></p>        <ol style='margin-left:10px; margin-top:2px;'>          <li>" + labelUtil.getString("gui.label.help.acknowledgement") + "</li>        </ol>      </td>    </tr>  </table></html>";
            this.content = new JEditorPane("text/html", buf);
            this.content.setEditable(false);
            this.content.setBorder(BorderFactory.createEmptyBorder());
            this.content.setBackground(this.getBackground());
            this.content.setPreferredSize(new Dimension(450, 320));
            this.content.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e.getURL() == null) {
                        this.openURL(labelUtil.getString("homepage"), pane);
                    } else {
                        this.openURL(e.getURL().toString(), pane);
                    }
                }
            });
        }
        return this.content;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(e -> this.setVisible(false));
        }
        return this.okButton;
    }

    public HelpAboutDialog(Frame parent) {
        super(parent, "About OpenStego", true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridy = 0;
        g.weighty = 1.0;
        g.fill = 1;
        this.getContentPane().add((Component)this.getContent(), g);
        g = new GridBagConstraints();
        g.gridy = 1;
        g.weighty = 0.0;
        g.anchor = 13;
        g.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.getOkButton(), g);
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -4890560722044735566L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                HelpAboutDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.pack();
        this.setResizable(false);
        Dimension parentSize = parent.getSize();
        this.setLocation(parent.getLocation().x + parentSize.width / 2 - this.getWidth() / 2, parent.getLocation().y + parentSize.height / 2 - this.getHeight() / 2);
    }

    private void openURL(String url, JComponent parent) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception ignore) {
            JOptionPane.showMessageDialog(parent, labelUtil.getString("gui.msg.err.browserLaunch"), labelUtil.getString("gui.msg.title.err"), 0);
        }
    }
}

