/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.randlsb;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.plugin.lsb.LSBPlugin;
import com.openstego.desktop.plugin.randlsb.RandomLSBInputStream;
import com.openstego.desktop.plugin.randlsb.RandomLSBOutputStream;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.LabelUtil;
import java.io.IOException;

public class RandomLSBPlugin
extends LSBPlugin {
    public static final String NAMESPACE = "RandomLSB";
    private static final LabelUtil labelUtil = LabelUtil.getInstance("RandomLSB");

    public RandomLSBPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "i18n.RandomLSBPluginLabels");
    }

    @Override
    public String getName() {
        return NAMESPACE;
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        try {
            ImageHolder image;
            if (cover == null) {
                int numOfPixels = (int)((double)(LSBDataHeader.getMaxHeaderSize() * 8) / 3.0);
                image = ImageUtil.generateRandomImage(numOfPixels += (int)((double)(msg.length * 8) / (3.0 * (double)((LSBConfig)this.config).getMaxBitsUsedPerChannel())));
            } else {
                image = ImageUtil.byteArrayToImage(cover, coverFileName);
            }
            try (RandomLSBOutputStream lsbOS = new RandomLSBOutputStream(image, msg.length, msgFileName, this.config);){
                lsbOS.write(msg);
                lsbOS.flush();
                image = lsbOS.getImage();
            }
            return ImageUtil.imageToByteArray(image, stegoFileName, this);
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    @Override
    public String extractMsgFileName(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        String string;
        ImageHolder imgHolder = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        RandomLSBInputStream lsbIS = new RandomLSBInputStream(imgHolder, this.config);
        try {
            string = lsbIS.getDataHeader().getFileName();
        }
        catch (Throwable throwable) {
            try {
                try {
                    lsbIS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioEx) {
                throw new OpenStegoException(ioEx);
            }
        }
        lsbIS.close();
        return string;
    }

    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        byte[] byArray;
        ImageHolder imgHolder = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        RandomLSBInputStream lsbIS = new RandomLSBInputStream(imgHolder, this.config);
        try {
            LSBDataHeader header = lsbIS.getDataHeader();
            byte[] data = new byte[header.getDataLength()];
            int bytesRead = lsbIS.read(data, 0, data.length);
            if (bytesRead != data.length) {
                throw new OpenStegoException(null, "LSB", 1);
            }
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    lsbIS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new OpenStegoException(ex);
            }
        }
        lsbIS.close();
        return byArray;
    }

    @Override
    public String getUsage() {
        LSBConfig defaultConfig = new LSBConfig();
        return labelUtil.getString("plugin.usage", defaultConfig.getMaxBitsUsedPerChannel());
    }
}

