/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.util.CommonUtil;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class LSBDataHeader {
    public static final byte[] DATA_STAMP = "OPENSTEGO".getBytes(StandardCharsets.UTF_8);
    public static final byte[] HEADER_VERSION = new byte[]{2};
    private static final int FIXED_HEADER_LENGTH = 8;
    private static final int CRYPT_ALGO_LENGTH = 8;
    private final int dataLength;
    private int channelBitsUsed;
    private final byte[] fileName;
    private final OpenStegoConfig config;

    public LSBDataHeader(int dataLength, int channelBitsUsed, String fileName, OpenStegoConfig config) {
        this.dataLength = dataLength;
        this.channelBitsUsed = channelBitsUsed;
        this.config = config;
        this.fileName = fileName == null ? new byte[0] : fileName.getBytes(StandardCharsets.UTF_8);
    }

    public LSBDataHeader(InputStream dataInStream, OpenStegoConfig config) throws OpenStegoException {
        int channelBits;
        int stampLen = DATA_STAMP.length;
        int versionLen = HEADER_VERSION.length;
        byte[] header = new byte[8];
        byte[] cryptAlgo = new byte[8];
        byte[] stamp = new byte[stampLen];
        byte[] version = new byte[versionLen];
        try {
            int n = dataInStream.read(stamp, 0, stampLen);
            if (n == -1 || !new String(stamp).equals(new String(DATA_STAMP))) {
                throw new OpenStegoException(null, "LSB", 6);
            }
            n = dataInStream.read(version, 0, versionLen);
            if (n == -1 || !new String(version).equals(new String(HEADER_VERSION))) {
                throw new OpenStegoException(null, "LSB", 7);
            }
            n = dataInStream.read(header, 0, 8);
            if (n < 8) {
                throw new OpenStegoException(null, "LSB", 6);
            }
            this.dataLength = CommonUtil.byteToInt(header[0]) + (CommonUtil.byteToInt(header[1]) << 8) + (CommonUtil.byteToInt(header[2]) << 16) + (CommonUtil.byteToInt(header[3]) << 24);
            channelBits = header[4];
            byte fileNameLen = header[5];
            config.setUseCompression(header[6] == 1);
            config.setUseEncryption(header[7] == 1);
            n = dataInStream.read(cryptAlgo, 0, 8);
            if (n < 8) {
                throw new OpenStegoException(null, "LSB", 6);
            }
            config.setEncryptionAlgorithm(new String(cryptAlgo).trim());
            if (fileNameLen == 0) {
                this.fileName = new byte[0];
            } else {
                this.fileName = new byte[fileNameLen];
                n = dataInStream.read(this.fileName, 0, fileNameLen);
                if (n < fileNameLen) {
                    throw new OpenStegoException(null, "LSB", 6);
                }
            }
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        this.channelBitsUsed = channelBits;
        this.config = config;
    }

    public byte[] getHeaderData() {
        int currIndex = 0;
        int stampLen = DATA_STAMP.length;
        int versionLen = HEADER_VERSION.length;
        byte[] out = new byte[stampLen + versionLen + 8 + 8 + this.fileName.length];
        System.arraycopy(DATA_STAMP, 0, out, currIndex, stampLen);
        System.arraycopy(HEADER_VERSION, 0, out, currIndex += stampLen, versionLen);
        currIndex += versionLen;
        out[currIndex++] = (byte)(this.dataLength & 0xFF);
        out[currIndex++] = (byte)((this.dataLength & 0xFF00) >> 8);
        out[currIndex++] = (byte)((this.dataLength & 0xFF0000) >> 16);
        out[currIndex++] = (byte)((this.dataLength & 0xFF000000) >> 24);
        out[currIndex++] = (byte)this.channelBitsUsed;
        out[currIndex++] = (byte)this.fileName.length;
        out[currIndex++] = (byte)(this.config.isUseCompression() ? 1 : 0);
        out[currIndex++] = (byte)(this.config.isUseEncryption() ? 1 : 0);
        if (this.config.getEncryptionAlgorithm() != null) {
            byte[] encAlgo = this.config.getEncryptionAlgorithm().getBytes(StandardCharsets.UTF_8);
            System.arraycopy(encAlgo, 0, out, currIndex, encAlgo.length);
        }
        currIndex += 8;
        if (this.fileName.length > 0) {
            System.arraycopy(this.fileName, 0, out, currIndex, this.fileName.length);
        }
        return out;
    }

    public int getChannelBitsUsed() {
        return this.channelBitsUsed;
    }

    public void setChannelBitsUsed(int channelBitsUsed) {
        this.channelBitsUsed = channelBitsUsed;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getFileName() {
        String name = new String(this.fileName, StandardCharsets.UTF_8);
        return name;
    }

    public int getHeaderSize() {
        return DATA_STAMP.length + HEADER_VERSION.length + 8 + 8 + this.fileName.length;
    }

    public static int getMaxHeaderSize() {
        return DATA_STAMP.length + HEADER_VERSION.length + 8 + 8 + 256;
    }
}

