/** @file cmdlineCreateNG.h.in
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINECREATENG_H
#define CMDLINECREATENG_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "createNG"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "createNG"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "0.3.2"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * iPwdList_arg;	/**< @brief Password list to create nGrams..  */
  char * iPwdList_orig;	/**< @brief Password list to create nGrams. original value given at command line.  */
  const char *iPwdList_help; /**< @brief Password list to create nGrams. help description.  */
  char * cPout_arg;	/**< @brief Changes output filename for conditional probabilities. (default='CP').  */
  char * cPout_orig;	/**< @brief Changes output filename for conditional probabilities. original value given at command line.  */
  const char *cPout_help; /**< @brief Changes output filename for conditional probabilities. help description.  */
  char * iPout_arg;	/**< @brief Changes output filename for initial probabilities. (default='IP').  */
  char * iPout_orig;	/**< @brief Changes output filename for initial probabilities. original value given at command line.  */
  const char *iPout_help; /**< @brief Changes output filename for initial probabilities. help description.  */
  char * ePout_arg;	/**< @brief Changes output filename for end probabilities (default='EP').  */
  char * ePout_orig;	/**< @brief Changes output filename for end probabilities original value given at command line.  */
  const char *ePout_help; /**< @brief Changes output filename for end probabilities help description.  */
  char * lenout_arg;	/**< @brief Changes output filename for password lengths levels (default='LN').  */
  char * lenout_orig;	/**< @brief Changes output filename for password lengths levels original value given at command line.  */
  const char *lenout_help; /**< @brief Changes output filename for password lengths levels help description.  */
  char * config_arg;	/**< @brief Changes config filename (default='createConfig').  */
  char * config_orig;	/**< @brief Changes config filename original value given at command line.  */
  const char *config_help; /**< @brief Changes config filename help description.  */
  char * prefix_arg;	/**< @brief Adds given prefix to all output files.  */
  char * prefix_orig;	/**< @brief Adds given prefix to all output files original value given at command line.  */
  const char *prefix_help; /**< @brief Adds given prefix to all output files help description.  */
  char * suffix_arg;	/**< @brief Adds given suffix to all output files.  */
  char * suffix_orig;	/**< @brief Adds given suffix to all output files original value given at command line.  */
  const char *suffix_help; /**< @brief Adds given suffix to all output files help description.  */
  int datefix_flag;	/**< @brief Adds the current date and time as suffix to all output files (default=off).  */
  const char *datefix_help; /**< @brief Adds the current date and time as suffix to all output files help description.  */
  int ngram_arg;	/**< @brief Changes the size of the nGram n (default='4').  */
  char * ngram_orig;	/**< @brief Changes the size of the nGram n original value given at command line.  */
  const char *ngram_help; /**< @brief Changes the size of the nGram n help description.  */
  int maxLevel_arg;	/**< @brief Changes the maximum level in range 2 to 101 (default='11').  */
  char * maxLevel_orig;	/**< @brief Changes the maximum level in range 2 to 101 original value given at command line.  */
  const char *maxLevel_help; /**< @brief Changes the maximum level in range 2 to 101 help description.  */
  char * alphabet_arg;	/**< @brief Changes the used alphabet to the given <string>.  */
  char * alphabet_orig;	/**< @brief Changes the used alphabet to the given <string> original value given at command line.  */
  const char *alphabet_help; /**< @brief Changes the used alphabet to the given <string> help description.  */
  char * fAlphabet_arg;	/**< @brief Changes the used alphabet to the alphabet found in <filename>..  */
  char * fAlphabet_orig;	/**< @brief Changes the used alphabet to the alphabet found in <filename>. original value given at command line.  */
  const char *fAlphabet_help; /**< @brief Changes the used alphabet to the alphabet found in <filename>. help description.  */
  char * smoothing_arg;	/**< @brief Changes the used smoothing function to the one defined in <filename>..  */
  char * smoothing_orig;	/**< @brief Changes the used smoothing function to the one defined in <filename>. original value given at command line.  */
  const char *smoothing_help; /**< @brief Changes the used smoothing function to the one defined in <filename>. help description.  */
  int verbose_flag;	/**< @brief Gain information about settings and results during run time. (default=off).  */
  const char *verbose_help; /**< @brief Gain information about settings and results during run time. help description.  */
  int verboseFile_flag;	/**< @brief Gain detailed information in the output files. (default=off).  */
  const char *verboseFile_help; /**< @brief Gain detailed information in the output files. help description.  */
  int printWarnings_flag;	/**< @brief Prints any warning (if verbose mode is active). (default=off).  */
  const char *printWarnings_help; /**< @brief Prints any warning (if verbose mode is active). help description.  */
  int withCount_flag;	/**< @brief The given password list is counted (like this: #count password). (default=off).  */
  const char *withCount_help; /**< @brief The given password list is counted (like this: #count password). help description.  */

  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int iPwdList_given ;	/**< @brief Whether iPwdList was given.  */
  unsigned int cPout_given ;	/**< @brief Whether cPout was given.  */
  unsigned int iPout_given ;	/**< @brief Whether iPout was given.  */
  unsigned int ePout_given ;	/**< @brief Whether ePout was given.  */
  unsigned int lenout_given ;	/**< @brief Whether lenout was given.  */
  unsigned int config_given ;	/**< @brief Whether config was given.  */
  unsigned int prefix_given ;	/**< @brief Whether prefix was given.  */
  unsigned int suffix_given ;	/**< @brief Whether suffix was given.  */
  unsigned int datefix_given ;	/**< @brief Whether datefix was given.  */
  unsigned int ngram_given ;	/**< @brief Whether ngram was given.  */
  unsigned int maxLevel_given ;	/**< @brief Whether maxLevel was given.  */
  unsigned int alphabet_given ;	/**< @brief Whether alphabet was given.  */
  unsigned int fAlphabet_given ;	/**< @brief Whether fAlphabet was given.  */
  unsigned int smoothing_given ;	/**< @brief Whether smoothing was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int verboseFile_given ;	/**< @brief Whether verboseFile was given.  */
  unsigned int printWarnings_given ;	/**< @brief Whether printWarnings was given.  */
  unsigned int withCount_given ;	/**< @brief Whether withCount was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_ngram_values[];  /**< @brief Possible values for ngram. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINECREATENG_H */
