/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.mailer.AsyncResponse;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.concurrent.AsyncResponseImpl;
import org.simplejavamail.internal.util.concurrent.NamedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncOperationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncOperationHelper.class);

    private AsyncOperationHelper() {
    }

    public static AsyncResponse executeAsync(@NotNull String processName, @NotNull Runnable operation) {
        return AsyncOperationHelper.executeAsync(Executors.newSingleThreadExecutor(), processName, operation, true);
    }

    public static AsyncResponse executeAsync(@NotNull ExecutorService executorService, @NotNull String processName, @NotNull Runnable operation) {
        return AsyncOperationHelper.executeAsync(executorService, processName, operation, false);
    }

    private static AsyncResponse executeAsync(final @NotNull ExecutorService executorService, final @NotNull String processName, final @NotNull Runnable operation, final boolean shutDownExecutorService) {
        final AtomicReference<AsyncResponseImpl> asyncResponseRef = new AtomicReference<AsyncResponseImpl>();
        Preconditions.assumeTrue(!executorService.isShutdown(), "cannot send async email, executor service is already shut down!");
        asyncResponseRef.set(new AsyncResponseImpl(executorService.submit(new NamedRunnable(processName){

            @Override
            public void run() {
                try {
                    operation.run();
                    ((AsyncResponseImpl)asyncResponseRef.get()).delegateSuccessHandling();
                }
                catch (Exception e2) {
                    LOGGER.error("Failed to run " + processName, e2);
                    ((AsyncResponseImpl)asyncResponseRef.get()).delegateExceptionHandling(e2);
                    throw e2;
                }
                finally {
                    if (shutDownExecutorService) {
                        executorService.shutdown();
                    }
                }
            }
        })));
        return (AsyncResponse)asyncResponseRef.get();
    }
}

