/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducer;

class MimeMessageProducerMixedRelated
extends MimeMessageProducer {
    MimeMessageProducerMixedRelated() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        return MimeMessageProducerMixedRelated.emailContainsMixedContent(email) && MimeMessageProducerMixedRelated.emailContainsRelatedContent(email) && !MimeMessageProducerMixedRelated.emailContainsAlternativeContent(email);
    }

    @Override
    public void populateMimeMessageMultipartStructure(@NotNull MimeMessage message, @NotNull Email email) throws MessagingException {
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, multipartStructureWrapper.multipartRelated);
        MimeMessageHelper.configureForwarding(email, multipartStructureWrapper.multipartRootMixed);
        MimeMessageHelper.setEmbeddedImages(email, multipartStructureWrapper.multipartRelated);
        MimeMessageHelper.setAttachments(email, multipartStructureWrapper.multipartRootMixed);
        message.setContent(multipartStructureWrapper.multipartRootMixed);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootMixed = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;

        private MultipartStructureWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            try {
                this.multipartRootMixed.addBodyPart(contentRelated);
                contentRelated.setContent(this.multipartRelated);
            }
            catch (MessagingException e2) {
                throw new MimeMessageProduceException(e2.getMessage(), e2);
            }
        }
    }
}

