/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.nio.charset.Charset;
import org.postgresql.core.Encoding;
import org.postgresql.util.GT;

abstract class OptimizedUTF8Encoder
extends Encoding {
    static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final int MIN_2_BYTES = 128;
    private static final int MIN_3_BYTES = 2048;
    private static final int MIN_4_BYTES = 65536;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private final int thresholdSize = 8192;
    private char[] decoderArray = new char[1024];

    OptimizedUTF8Encoder() {
        super(UTF_8_CHARSET, true);
    }

    char[] getCharArray(int size) {
        if (size <= this.decoderArray.length) {
            return this.decoderArray;
        }
        char[] chars = new char[size];
        if (size <= 8192) {
            this.decoderArray = chars;
        }
        return chars;
    }

    synchronized String charDecode(byte[] encodedString, int offset, int length) throws IOException {
        char[] chars = this.getCharArray(length);
        int out = 0;
        int j2 = offset + length;
        for (int i2 = offset; i2 < j2; ++i2) {
            if (encodedString[i2] < 0) {
                return OptimizedUTF8Encoder.decodeToChars(encodedString, i2, j2 - i2, chars, out);
            }
            chars[out++] = (char)encodedString[i2];
        }
        return new String(chars, 0, out);
    }

    static String decodeToChars(byte[] data, int offset, int length, char[] chars, int out) throws IOException {
        int in2 = offset;
        int end = length + offset;
        try {
            while (in2 < end) {
                int ch2;
                if ((ch2 = data[in2++] & 0xFF) >= 128) {
                    if (ch2 < 192) {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "10xxxxxx", ch2));
                    }
                    if (ch2 < 224) {
                        ch2 = (ch2 & 0x1F) << 6;
                        OptimizedUTF8Encoder.checkByte(data[in2], 2, 2);
                        OptimizedUTF8Encoder.checkMinimal(ch2 |= data[in2++] & 0x3F, 128);
                    } else if (ch2 < 240) {
                        ch2 = (ch2 & 0xF) << 12;
                        OptimizedUTF8Encoder.checkByte(data[in2], 2, 3);
                        ch2 |= (data[in2++] & 0x3F) << 6;
                        OptimizedUTF8Encoder.checkByte(data[in2], 3, 3);
                        OptimizedUTF8Encoder.checkMinimal(ch2 |= data[in2++] & 0x3F, 2048);
                    } else if (ch2 < 248) {
                        ch2 = (ch2 & 7) << 18;
                        OptimizedUTF8Encoder.checkByte(data[in2], 2, 4);
                        ch2 |= (data[in2++] & 0x3F) << 12;
                        OptimizedUTF8Encoder.checkByte(data[in2], 3, 4);
                        ch2 |= (data[in2++] & 0x3F) << 6;
                        OptimizedUTF8Encoder.checkByte(data[in2], 4, 4);
                        OptimizedUTF8Encoder.checkMinimal(ch2 |= data[in2++] & 0x3F, 65536);
                    } else {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "11111xxx", ch2));
                    }
                }
                if (ch2 > 0x10FFFF) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is out of range: {0}", ch2));
                }
                if (ch2 > 65535) {
                    chars[out++] = (char)(55296 + ((ch2 -= 65536) >> 10));
                    chars[out++] = (char)(56320 + (ch2 & 0x3FF));
                    continue;
                }
                if (ch2 >= 55296 && ch2 < 57344) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is a surrogate value: {0}", ch2));
                }
                chars[out++] = (char)ch2;
            }
        }
        catch (ArrayIndexOutOfBoundsException a2) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        return new String(chars, 0, out);
    }

    private static void checkByte(int ch2, int pos, int len) throws IOException {
        if ((ch2 & 0xC0) != 128) {
            throw new IOException(GT.tr("Illegal UTF-8 sequence: byte {0} of {1} byte sequence is not 10xxxxxx: {2}", pos, len, ch2));
        }
    }

    private static void checkMinimal(int ch2, int minValue) throws IOException {
        int expectedLen;
        int actualLen;
        if (ch2 >= minValue) {
            return;
        }
        switch (minValue) {
            case 128: {
                actualLen = 2;
                break;
            }
            case 2048: {
                actualLen = 3;
                break;
            }
            case 65536: {
                actualLen = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected minValue passed to checkMinimal: " + minValue);
            }
        }
        if (ch2 < 128) {
            expectedLen = 1;
        } else if (ch2 < 2048) {
            expectedLen = 2;
        } else if (ch2 < 65536) {
            expectedLen = 3;
        } else {
            throw new IllegalArgumentException("unexpected ch passed to checkMinimal: " + ch2);
        }
        throw new IOException(GT.tr("Illegal UTF-8 sequence: {0} bytes used to encode a {1} byte value: {2}", actualLen, expectedLen, ch2));
    }
}

