/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RadiotapDataPad;
import org.pcap4j.packet.RadiotapPresentBitmask;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.RadiotapPresentBitNumber;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RadiotapPacket
extends AbstractPacket {
    private static final long serialVersionUID = 4121827899399388949L;
    private static final Logger logger = LoggerFactory.getLogger(RadiotapPacket.class);
    private final RadiotapHeader header;
    private final Packet payload;

    public static RadiotapPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapPacket(rawData, offset, length);
    }

    private RadiotapPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new RadiotapHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(rawData, offset + this.header.length(), payloadLength, DataLinkType.IEEE802_11) : null;
    }

    private RadiotapPacket(Builder builder) {
        if (builder == null || builder.presentBitmasks == null || builder.dataFields == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.presentBitmasks: ").append(builder.presentBitmasks).append(" builder.dataFields: ").append(builder.dataFields);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new RadiotapHeader(builder);
    }

    @Override
    public RadiotapHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static interface RadiotapData
    extends Serializable {
        public int length();

        public byte[] getRawData();

        public String toString(String var1);
    }

    public static final class RadiotapHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -5384412750993783312L;
        private static final int VERSION_OFFSET = 0;
        private static final int VERSION_SIZE = 1;
        private static final int PAD_OFFSET = 1;
        private static final int PAD_SIZE = 1;
        private static final int LENGTH_OFFSET = 2;
        private static final int LENGTH_SIZE = 2;
        private static final int PRESENT_OFFSET = 4;
        private static final int PRESENT_SIZE = 4;
        private static final int MIN_RADIOTAP_HEADER_SIZE = 8;
        private final byte version;
        private final byte pad;
        private final short length;
        private final List<RadiotapPresentBitmask> presentBitmasks;
        private final List<RadiotapData> dataFields;

        private RadiotapHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 8) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build a RadiotapHeader (").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.version = ByteArrays.getByte(rawData, 0 + offset);
            this.pad = ByteArrays.getByte(rawData, 1 + offset);
            this.length = ByteArrays.getShort(rawData, 2 + offset, ByteOrder.LITTLE_ENDIAN);
            this.presentBitmasks = new ArrayList<RadiotapPresentBitmask>();
            if (length < this.getLengthAsInt()) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build a RadiotapHeader (").append(this.getLengthAsInt()).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (this.getLengthAsInt() < 8) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The value of the length field is too small to build a RadiotapHeader (").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            String namespace = "";
            int bitNumOffset = 0;
            int remainingLength = this.getLengthAsInt() - 4;
            int nextPresentOffset = offset + 4;
            while (true) {
                if (remainingLength < 4) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("Something went wrong during parsing present bitmasks. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                    throw new IllegalRawDataException(sb.toString());
                }
                RadiotapPresentBitmask mask = RadiotapPresentBitmask.newInstance(rawData, nextPresentOffset, remainingLength, bitNumOffset, namespace);
                this.presentBitmasks.add(mask);
                nextPresentOffset += 4;
                remainingLength -= 4;
                if (!mask.isAnotherBitmapFollows()) break;
                if (mask.isRadiotapNamespaceNext()) {
                    namespace = "";
                    bitNumOffset = 0;
                    continue;
                }
                if (mask.isVendorNamespaceNext()) {
                    namespace = "unknown";
                    bitNumOffset = 0;
                    continue;
                }
                bitNumOffset += 32;
            }
            this.dataFields = new ArrayList<RadiotapData>();
            int nextFieldOffset = nextPresentOffset;
            PacketFactory<RadiotapData, RadiotapPresentBitNumber> factory2 = PacketFactories.getFactory(RadiotapData.class, RadiotapPresentBitNumber.class);
            Class<RadiotapData> unknownDataFieldClass = factory2.getTargetClass();
            boolean breaking = false;
            try {
                block3: for (RadiotapPresentBitmask mask : this.presentBitmasks) {
                    if (!breaking) {
                        for (RadiotapPresentBitNumber num : mask.getBitNumbers()) {
                            StringBuilder sb;
                            int alignment = num.getRequiredAlignment();
                            int padSize = alignment - (nextFieldOffset - offset) % alignment;
                            if (padSize != alignment) {
                                if (remainingLength < padSize) {
                                    sb = new StringBuilder(200);
                                    sb.append("Not enough length for a RadiotapDataPad: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                                    throw new IllegalRawDataException(sb.toString());
                                }
                                RadiotapDataPad pad = RadiotapDataPad.newInstance(rawData, nextFieldOffset, padSize);
                                this.dataFields.add(pad);
                                nextFieldOffset += padSize;
                                remainingLength -= padSize;
                            }
                            if (remainingLength <= 0) {
                                sb = new StringBuilder(200);
                                sb.append("No data is remaining for a RadiotapDataField: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                                throw new IllegalRawDataException(sb.toString());
                            }
                            RadiotapData field = factory2.newInstance(rawData, nextFieldOffset, remainingLength, num);
                            this.dataFields.add(field);
                            int fieldLen = field.length();
                            nextFieldOffset += fieldLen;
                            remainingLength -= fieldLen;
                            if (!field.getClass().equals(unknownDataFieldClass)) continue;
                            breaking = true;
                            continue block3;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e2) {
                logger.error("Exception occurred during analyzing Radiotap data fields: ", e2);
            }
            if (remainingLength != 0) {
                this.dataFields.add(factory2.newInstance(rawData, nextFieldOffset, remainingLength));
            }
        }

        private RadiotapHeader(Builder builder) {
            this.version = builder.version;
            this.pad = builder.pad;
            this.presentBitmasks = new ArrayList<RadiotapPresentBitmask>(builder.presentBitmasks);
            this.dataFields = new ArrayList<RadiotapData>(builder.dataFields);
            this.length = builder.correctLengthAtBuild ? (short)this.calcLength() : builder.length;
        }

        public byte getVersion() {
            return this.version;
        }

        public int getVersionAsInt() {
            return this.version & 0xFF;
        }

        public byte getPad() {
            return this.pad;
        }

        public short getLength() {
            return this.length;
        }

        public int getLengthAsInt() {
            return 0xFFFF & this.length;
        }

        public ArrayList<RadiotapPresentBitmask> getPresentBitmasks() {
            return new ArrayList<RadiotapPresentBitmask>(this.presentBitmasks);
        }

        public ArrayList<RadiotapData> getDataFields() {
            return new ArrayList<RadiotapData>(this.dataFields);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.version));
            rawFields.add(ByteArrays.toByteArray(this.pad));
            rawFields.add(ByteArrays.toByteArray(this.length, ByteOrder.LITTLE_ENDIAN));
            for (RadiotapPresentBitmask mask : this.presentBitmasks) {
                rawFields.add(mask.getRawData());
            }
            for (RadiotapData field : this.dataFields) {
                rawFields.add(field.getRawData());
            }
            return rawFields;
        }

        @Override
        public int calcLength() {
            int len = 4;
            len += this.presentBitmasks.size() * 4;
            for (RadiotapData field : this.dataFields) {
                len += field.length();
            }
            return len;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb.append("[Radiotap header (").append(this.length()).append(" bytes)]").append(ls2);
            sb.append("  Version: ").append(this.getVersionAsInt()).append(ls2);
            sb.append("  Pad: ").append(this.pad).append(ls2);
            sb.append("  Length: ").append(this.getLengthAsInt()).append(ls2);
            for (RadiotapPresentBitmask mask : this.presentBitmasks) {
                sb.append(mask.toString("  "));
            }
            sb.append("  Data Fields: ").append(ls2);
            for (RadiotapData field : this.dataFields) {
                sb.append(field.toString("    "));
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            RadiotapHeader other = (RadiotapHeader)obj;
            return this.length == other.length && this.version == other.version && this.pad == other.pad && this.presentBitmasks.equals(other.presentBitmasks) && this.dataFields.equals(other.dataFields);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.version;
            result = 31 * result + this.pad;
            result = 31 * result + this.length;
            result = 31 * result + this.presentBitmasks.hashCode();
            result = 31 * result + this.dataFields.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<RadiotapPacket> {
        private byte version;
        private byte pad;
        private short length;
        private List<RadiotapPresentBitmask> presentBitmasks;
        private List<RadiotapData> dataFields;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(RadiotapPacket packet) {
            this.version = packet.header.version;
            this.pad = packet.header.pad;
            this.length = packet.header.length;
            this.presentBitmasks = packet.header.presentBitmasks;
            this.dataFields = packet.header.dataFields;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder version(byte version) {
            this.version = version;
            return this;
        }

        public Builder pad(byte pad) {
            this.pad = pad;
            return this;
        }

        public Builder length(short length) {
            this.length = length;
            return this;
        }

        public Builder presentBitmasks(List<RadiotapPresentBitmask> presentBitmasks) {
            this.presentBitmasks = presentBitmasks;
            return this;
        }

        public Builder dataFields(List<RadiotapData> dataFields) {
            this.dataFields = dataFields;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public RadiotapPacket build() {
            return new RadiotapPacket(this);
        }
    }
}

