/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapFecType;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.namednumber.RadiotapVhtBandwidth;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataVht
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -7423738690741454273L;
    private static final int LENGTH = 12;
    private final boolean stbcKnown;
    private final boolean txopPsNotAllowedKnown;
    private final boolean guardIntervalKnown;
    private final boolean shortGiNsymDisambiguationKnown;
    private final boolean ldpcExtraOfdmSymbolKnown;
    private final boolean beamformedKnown;
    private final boolean bandwidthKnown;
    private final boolean groupIdKnown;
    private final boolean partialAidKnown;
    private final boolean seventhMsbOfKnown;
    private final boolean sixthMsbOfKnown;
    private final boolean fifthMsbOfKnown;
    private final boolean fourthMsbOfKnown;
    private final boolean thirdMsbOfKnown;
    private final boolean secondMsbOfKnown;
    private final boolean msbOfKnown;
    private final boolean stbc;
    private final boolean txopPsNotAllowed;
    private final boolean shortGuardInterval;
    private final boolean shortGiNsymDisambiguation;
    private final boolean ldpcExtraOfdmSymbol;
    private final boolean beamformed;
    private final boolean secondMsbOfFlags;
    private final boolean msbOfFlags;
    private final RadiotapVhtBandwidth bandwidth;
    private final byte[] mcses;
    private final byte[] nsses;
    private final RadiotapFecType[] fecTypes;
    private final byte unusedInCoding;
    private final byte groupId;
    private final short partialAid;

    public static RadiotapDataVht newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataVht(rawData, offset, length);
    }

    private RadiotapDataVht(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int i2;
        if (length < 12) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapVht (").append(12).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.stbcKnown = (rawData[offset] & 1) != 0;
        this.txopPsNotAllowedKnown = (rawData[offset] & 2) != 0;
        this.guardIntervalKnown = (rawData[offset] & 4) != 0;
        this.shortGiNsymDisambiguationKnown = (rawData[offset] & 8) != 0;
        this.ldpcExtraOfdmSymbolKnown = (rawData[offset] & 0x10) != 0;
        this.beamformedKnown = (rawData[offset] & 0x20) != 0;
        this.bandwidthKnown = (rawData[offset] & 0x40) != 0;
        this.groupIdKnown = (rawData[offset] & 0x80) != 0;
        this.partialAidKnown = (rawData[offset + 1] & 1) != 0;
        this.seventhMsbOfKnown = (rawData[offset + 1] & 2) != 0;
        this.sixthMsbOfKnown = (rawData[offset + 1] & 4) != 0;
        this.fifthMsbOfKnown = (rawData[offset + 1] & 8) != 0;
        this.fourthMsbOfKnown = (rawData[offset + 1] & 0x10) != 0;
        this.thirdMsbOfKnown = (rawData[offset + 1] & 0x20) != 0;
        this.secondMsbOfKnown = (rawData[offset + 1] & 0x40) != 0;
        this.msbOfKnown = (rawData[offset + 1] & 0x80) != 0;
        this.stbc = (rawData[offset + 2] & 1) != 0;
        this.txopPsNotAllowed = (rawData[offset + 2] & 2) != 0;
        this.shortGuardInterval = (rawData[offset + 2] & 4) != 0;
        this.shortGiNsymDisambiguation = (rawData[offset + 2] & 8) != 0;
        this.ldpcExtraOfdmSymbol = (rawData[offset + 2] & 0x10) != 0;
        this.beamformed = (rawData[offset + 2] & 0x20) != 0;
        this.secondMsbOfFlags = (rawData[offset + 2] & 0x40) != 0;
        this.msbOfFlags = (rawData[offset + 2] & 0x80) != 0;
        this.bandwidth = RadiotapVhtBandwidth.getInstance(rawData[offset + 3]);
        this.mcses = new byte[4];
        this.nsses = new byte[4];
        for (i2 = 0; i2 < 4; ++i2) {
            byte mcsNss = rawData[offset + 4 + i2];
            this.mcses[i2] = (byte)(mcsNss >> 4 & 0xF);
            this.nsses[i2] = (byte)(mcsNss & 0xF);
        }
        this.fecTypes = new RadiotapFecType[4];
        block4: for (i2 = 0; i2 < 4; ++i2) {
            switch (rawData[offset + 8] >> i2 & 1) {
                case 0: {
                    this.fecTypes[i2] = RadiotapFecType.BCC;
                    continue block4;
                }
                default: {
                    this.fecTypes[i2] = RadiotapFecType.LDPC;
                }
            }
        }
        this.unusedInCoding = (byte)(rawData[offset + 8] >> 4 & 0xF);
        this.groupId = rawData[offset + 9];
        this.partialAid = ByteArrays.getShort(rawData, offset + 10, ByteOrder.LITTLE_ENDIAN);
    }

    private RadiotapDataVht(Builder builder) {
        if (builder == null || builder.bandwidth == null || builder.mcses == null || builder.nsses == null || builder.fecTypes == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.bandwidth: ").append(builder.bandwidth).append(" builder.mcses: ").append(builder.mcses).append(" builder.nsses: ").append(builder.nsses).append(" builder.fecTypes: ").append(builder.fecTypes);
            throw new NullPointerException(sb.toString());
        }
        if ((builder.unusedInCoding & 0xF0) != 0) {
            throw new IllegalArgumentException("builder.unusedInCoding & 0xF0 must be 0. builder.unusedInCoding: " + builder.unusedInCoding);
        }
        if (builder.mcses.length != 4) {
            throw new IllegalArgumentException("builder.mcses.length must be 4. builder.mcses: " + Arrays.toString(builder.mcses));
        }
        if (builder.nsses.length != 4) {
            throw new IllegalArgumentException("builder.nsses.length must be 4. builder.nsses: " + Arrays.toString(builder.nsses));
        }
        if (builder.fecTypes.length != 4) {
            throw new IllegalArgumentException("builder.fecTypes.length must be 4. builder.fecTypes: " + Arrays.toString((Object[])builder.fecTypes));
        }
        for (byte mcs : builder.mcses) {
            if ((mcs & 0xF0) == 0) continue;
            throw new IllegalArgumentException("(mcs & 0xF0) must be zero. builder.mcses: " + Arrays.toString(builder.mcses));
        }
        for (byte nss : builder.nsses) {
            if ((nss & 0xF0) == 0) continue;
            throw new IllegalArgumentException("(nss & 0xF0) must be zero. builder.nsses: " + Arrays.toString(builder.nsses));
        }
        this.stbcKnown = builder.stbcKnown;
        this.txopPsNotAllowedKnown = builder.txopPsNotAllowedKnown;
        this.guardIntervalKnown = builder.guardIntervalKnown;
        this.shortGiNsymDisambiguationKnown = builder.shortGiNsymDisambiguationKnown;
        this.ldpcExtraOfdmSymbolKnown = builder.ldpcExtraOfdmSymbolKnown;
        this.beamformedKnown = builder.beamformedKnown;
        this.bandwidthKnown = builder.bandwidthKnown;
        this.groupIdKnown = builder.groupIdKnown;
        this.partialAidKnown = builder.partialAidKnown;
        this.seventhMsbOfKnown = builder.seventhMsbOfKnown;
        this.sixthMsbOfKnown = builder.sixthMsbOfKnown;
        this.fifthMsbOfKnown = builder.fifthMsbOfKnown;
        this.fourthMsbOfKnown = builder.fourthMsbOfKnown;
        this.thirdMsbOfKnown = builder.thirdMsbOfKnown;
        this.secondMsbOfKnown = builder.secondMsbOfKnown;
        this.msbOfKnown = builder.msbOfKnown;
        this.stbc = builder.stbc;
        this.txopPsNotAllowed = builder.txopPsNotAllowed;
        this.shortGuardInterval = builder.shortGuardInterval;
        this.shortGiNsymDisambiguation = builder.shortGiNsymDisambiguation;
        this.ldpcExtraOfdmSymbol = builder.ldpcExtraOfdmSymbol;
        this.beamformed = builder.beamformed;
        this.secondMsbOfFlags = builder.secondMsbOfFlags;
        this.msbOfFlags = builder.msbOfFlags;
        this.bandwidth = builder.bandwidth;
        this.mcses = ByteArrays.clone(builder.mcses);
        this.nsses = ByteArrays.clone(builder.nsses);
        this.fecTypes = (RadiotapFecType[])builder.fecTypes.clone();
        this.unusedInCoding = builder.unusedInCoding;
        this.groupId = builder.groupId;
        this.partialAid = builder.partialAid;
    }

    public boolean isStbcKnown() {
        return this.stbcKnown;
    }

    public boolean isTxopPsNotAllowedKnown() {
        return this.txopPsNotAllowedKnown;
    }

    public boolean isGuardIntervalKnown() {
        return this.guardIntervalKnown;
    }

    public boolean isShortGiNsymDisambiguationKnown() {
        return this.shortGiNsymDisambiguationKnown;
    }

    public boolean isLdpcExtraOfdmSymbolKnown() {
        return this.ldpcExtraOfdmSymbolKnown;
    }

    public boolean isBeamformedKnown() {
        return this.beamformedKnown;
    }

    public boolean isBandwidthKnown() {
        return this.bandwidthKnown;
    }

    public boolean isGroupIdKnown() {
        return this.groupIdKnown;
    }

    public boolean isPartialAidKnown() {
        return this.partialAidKnown;
    }

    public boolean getSeventhMsbOfKnown() {
        return this.seventhMsbOfKnown;
    }

    public boolean getSixthMsbOfKnown() {
        return this.sixthMsbOfKnown;
    }

    public boolean getFifthMsbOfKnown() {
        return this.fifthMsbOfKnown;
    }

    public boolean getFourthMsbOfKnown() {
        return this.fourthMsbOfKnown;
    }

    public boolean getThirdMsbOfKnown() {
        return this.thirdMsbOfKnown;
    }

    public boolean getSecondMsbOfKnown() {
        return this.secondMsbOfKnown;
    }

    public boolean getMsbOfKnown() {
        return this.msbOfKnown;
    }

    public boolean isStbc() {
        return this.stbc;
    }

    public boolean isTxopPsNotAllowed() {
        return this.txopPsNotAllowed;
    }

    public boolean isShortGuardInterval() {
        return this.shortGuardInterval;
    }

    public boolean isShortGiNsymDisambiguation() {
        return this.shortGiNsymDisambiguation;
    }

    public boolean isLdpcExtraOfdmSymbol() {
        return this.ldpcExtraOfdmSymbol;
    }

    public boolean isBeamformed() {
        return this.beamformed;
    }

    public boolean getSecondMsbOfFlags() {
        return this.secondMsbOfFlags;
    }

    public boolean getMsbOfFlags() {
        return this.msbOfFlags;
    }

    public RadiotapVhtBandwidth getBandwidth() {
        return this.bandwidth;
    }

    public byte[] getMcses() {
        return ByteArrays.clone(this.mcses);
    }

    public byte[] getNsses() {
        return ByteArrays.clone(this.nsses);
    }

    public RadiotapFecType[] getFecTypes() {
        return (RadiotapFecType[])this.fecTypes.clone();
    }

    public byte getUnusedInCoding() {
        return this.unusedInCoding;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public int getGroupIdAsInt() {
        return this.groupId & 0xFF;
    }

    public short getPartialAid() {
        return this.partialAid;
    }

    public int getPartialAidAsInt() {
        return this.partialAid & 0xFFFF;
    }

    @Override
    public int length() {
        return 12;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[12];
        if (this.stbcKnown) {
            data[0] = (byte)(data[0] | 1);
        }
        if (this.txopPsNotAllowedKnown) {
            data[0] = (byte)(data[0] | 2);
        }
        if (this.guardIntervalKnown) {
            data[0] = (byte)(data[0] | 4);
        }
        if (this.shortGiNsymDisambiguationKnown) {
            data[0] = (byte)(data[0] | 8);
        }
        if (this.ldpcExtraOfdmSymbolKnown) {
            data[0] = (byte)(data[0] | 0x10);
        }
        if (this.beamformedKnown) {
            data[0] = (byte)(data[0] | 0x20);
        }
        if (this.bandwidthKnown) {
            data[0] = (byte)(data[0] | 0x40);
        }
        if (this.groupIdKnown) {
            data[0] = (byte)(data[0] | 0x80);
        }
        if (this.partialAidKnown) {
            data[1] = (byte)(data[1] | 1);
        }
        if (this.seventhMsbOfKnown) {
            data[1] = (byte)(data[1] | 2);
        }
        if (this.sixthMsbOfKnown) {
            data[1] = (byte)(data[1] | 4);
        }
        if (this.fifthMsbOfKnown) {
            data[1] = (byte)(data[1] | 8);
        }
        if (this.fourthMsbOfKnown) {
            data[1] = (byte)(data[1] | 0x10);
        }
        if (this.thirdMsbOfKnown) {
            data[1] = (byte)(data[1] | 0x20);
        }
        if (this.secondMsbOfKnown) {
            data[1] = (byte)(data[1] | 0x40);
        }
        if (this.msbOfKnown) {
            data[1] = (byte)(data[1] | 0x80);
        }
        if (this.stbc) {
            data[2] = (byte)(data[2] | 1);
        }
        if (this.txopPsNotAllowed) {
            data[2] = (byte)(data[2] | 2);
        }
        if (this.shortGuardInterval) {
            data[2] = (byte)(data[2] | 4);
        }
        if (this.shortGiNsymDisambiguation) {
            data[2] = (byte)(data[2] | 8);
        }
        if (this.ldpcExtraOfdmSymbol) {
            data[2] = (byte)(data[2] | 0x10);
        }
        if (this.beamformed) {
            data[2] = (byte)(data[2] | 0x20);
        }
        if (this.secondMsbOfFlags) {
            data[2] = (byte)(data[2] | 0x40);
        }
        if (this.msbOfFlags) {
            data[2] = (byte)(data[2] | 0x80);
        }
        data[3] = (Byte)this.bandwidth.value();
        for (int i2 = 0; i2 < 4; ++i2) {
            data[4 + i2] = (byte)(this.nsses[i2] | this.mcses[i2] << 4);
        }
        data[8] = (byte)(this.unusedInCoding << 4);
        if (this.fecTypes[0] == RadiotapFecType.LDPC) {
            data[8] = (byte)(data[8] | 1);
        }
        if (this.fecTypes[1] == RadiotapFecType.LDPC) {
            data[8] = (byte)(data[8] | 2);
        }
        if (this.fecTypes[2] == RadiotapFecType.LDPC) {
            data[8] = (byte)(data[8] | 4);
        }
        if (this.fecTypes[3] == RadiotapFecType.LDPC) {
            data[8] = (byte)(data[8] | 8);
        }
        data[9] = this.groupId;
        System.arraycopy(ByteArrays.toByteArray(this.partialAid, ByteOrder.LITTLE_ENDIAN), 0, data, 10, 2);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        int i2;
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("VHT: ").append(ls2).append(indent).append("  STBC known: ").append(this.stbcKnown).append(ls2).append(indent).append("  TXOP_PS_NOT_ALLOWED known: ").append(this.txopPsNotAllowedKnown).append(ls2).append(indent).append("  Guard interval known: ").append(this.guardIntervalKnown).append(ls2).append(indent).append("  Short GI NSYM disambiguation known: ").append(this.shortGiNsymDisambiguationKnown).append(ls2).append(indent).append("  LDPC extra OFDM symbol known: ").append(this.ldpcExtraOfdmSymbolKnown).append(ls2).append(indent).append("  Beamformed known: ").append(this.beamformedKnown).append(ls2).append(indent).append("  Bandwidth known: ").append(this.bandwidthKnown).append(ls2).append(indent).append("  Group ID known: ").append(this.groupIdKnown).append(ls2).append(indent).append("  Partial AID known: ").append(this.partialAidKnown).append(ls2).append(indent).append("  7th MSB of known: ").append(this.seventhMsbOfKnown).append(ls2).append(indent).append("  6th MSB of known: ").append(this.sixthMsbOfKnown).append(ls2).append(indent).append("  5th MSB of known: ").append(this.fifthMsbOfKnown).append(ls2).append(indent).append("  4th MSB of known: ").append(this.fourthMsbOfKnown).append(ls2).append(indent).append("  3rd MSB of known: ").append(this.thirdMsbOfKnown).append(ls2).append(indent).append("  2nd MSB of known: ").append(this.secondMsbOfKnown).append(ls2).append(indent).append("  MSB of known: ").append(this.msbOfKnown).append(ls2).append(indent).append("  STBC: ").append(this.stbc).append(ls2).append(indent).append("  TXOP_PS_NOT_ALLOWED: ").append(this.txopPsNotAllowed).append(ls2).append(indent).append("  Short Guard interval: ").append(this.shortGuardInterval).append(ls2).append(indent).append("  Short GI NSYM disambiguation: ").append(this.shortGiNsymDisambiguation).append(ls2).append(indent).append("  LDPC extra OFDM symbol: ").append(this.ldpcExtraOfdmSymbol).append(ls2).append(indent).append("  Beamformed: ").append(this.beamformed).append(ls2).append(indent).append("  2nd MSB of flags: ").append(this.secondMsbOfFlags).append(ls2).append(indent).append("  MSB of flags: ").append(this.msbOfFlags).append(ls2).append(indent).append("  Bandwidth: ").append(this.bandwidth).append(ls2);
        for (i2 = 0; i2 < 4; ++i2) {
            sb.append(indent).append("  NSS-").append(i2).append(": ").append(this.nsses[i2]).append(ls2);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            sb.append(indent).append("  MCS-").append(i2).append(": ").append(this.mcses[i2]).append(ls2);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            sb.append(indent).append("  FEC-").append(i2).append(": ").append((Object)this.fecTypes[i2]).append(ls2);
        }
        sb.append(indent).append("  Group ID: ").append(this.getGroupIdAsInt()).append(ls2).append(indent).append("  Partial AID: ").append(this.getPartialAidAsInt()).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bandwidth.hashCode();
        result = 31 * result + (this.bandwidthKnown ? 1231 : 1237);
        result = 31 * result + (this.beamformed ? 1231 : 1237);
        result = 31 * result + (this.beamformedKnown ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode((Object[])this.fecTypes);
        result = 31 * result + (this.fifthMsbOfKnown ? 1231 : 1237);
        result = 31 * result + (this.fourthMsbOfKnown ? 1231 : 1237);
        result = 31 * result + this.groupId;
        result = 31 * result + (this.groupIdKnown ? 1231 : 1237);
        result = 31 * result + (this.guardIntervalKnown ? 1231 : 1237);
        result = 31 * result + (this.ldpcExtraOfdmSymbol ? 1231 : 1237);
        result = 31 * result + (this.ldpcExtraOfdmSymbolKnown ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.mcses);
        result = 31 * result + (this.msbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.msbOfKnown ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.nsses);
        result = 31 * result + this.partialAid;
        result = 31 * result + (this.partialAidKnown ? 1231 : 1237);
        result = 31 * result + (this.secondMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.secondMsbOfKnown ? 1231 : 1237);
        result = 31 * result + (this.seventhMsbOfKnown ? 1231 : 1237);
        result = 31 * result + (this.shortGiNsymDisambiguation ? 1231 : 1237);
        result = 31 * result + (this.shortGiNsymDisambiguationKnown ? 1231 : 1237);
        result = 31 * result + (this.shortGuardInterval ? 1231 : 1237);
        result = 31 * result + (this.sixthMsbOfKnown ? 1231 : 1237);
        result = 31 * result + (this.stbc ? 1231 : 1237);
        result = 31 * result + (this.stbcKnown ? 1231 : 1237);
        result = 31 * result + (this.thirdMsbOfKnown ? 1231 : 1237);
        result = 31 * result + (this.txopPsNotAllowed ? 1231 : 1237);
        result = 31 * result + (this.txopPsNotAllowedKnown ? 1231 : 1237);
        result = 31 * result + this.unusedInCoding;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataVht other = (RadiotapDataVht)obj;
        if (!this.bandwidth.equals(other.bandwidth)) {
            return false;
        }
        if (this.bandwidthKnown != other.bandwidthKnown) {
            return false;
        }
        if (this.beamformed != other.beamformed) {
            return false;
        }
        if (this.beamformedKnown != other.beamformedKnown) {
            return false;
        }
        if (!Arrays.equals((Object[])this.fecTypes, (Object[])other.fecTypes)) {
            return false;
        }
        if (this.fifthMsbOfKnown != other.fifthMsbOfKnown) {
            return false;
        }
        if (this.fourthMsbOfKnown != other.fourthMsbOfKnown) {
            return false;
        }
        if (this.groupId != other.groupId) {
            return false;
        }
        if (this.groupIdKnown != other.groupIdKnown) {
            return false;
        }
        if (this.guardIntervalKnown != other.guardIntervalKnown) {
            return false;
        }
        if (this.ldpcExtraOfdmSymbol != other.ldpcExtraOfdmSymbol) {
            return false;
        }
        if (this.ldpcExtraOfdmSymbolKnown != other.ldpcExtraOfdmSymbolKnown) {
            return false;
        }
        if (!Arrays.equals(this.mcses, other.mcses)) {
            return false;
        }
        if (this.msbOfFlags != other.msbOfFlags) {
            return false;
        }
        if (this.msbOfKnown != other.msbOfKnown) {
            return false;
        }
        if (!Arrays.equals(this.nsses, other.nsses)) {
            return false;
        }
        if (this.partialAid != other.partialAid) {
            return false;
        }
        if (this.partialAidKnown != other.partialAidKnown) {
            return false;
        }
        if (this.secondMsbOfFlags != other.secondMsbOfFlags) {
            return false;
        }
        if (this.secondMsbOfKnown != other.secondMsbOfKnown) {
            return false;
        }
        if (this.seventhMsbOfKnown != other.seventhMsbOfKnown) {
            return false;
        }
        if (this.shortGiNsymDisambiguation != other.shortGiNsymDisambiguation) {
            return false;
        }
        if (this.shortGiNsymDisambiguationKnown != other.shortGiNsymDisambiguationKnown) {
            return false;
        }
        if (this.shortGuardInterval != other.shortGuardInterval) {
            return false;
        }
        if (this.sixthMsbOfKnown != other.sixthMsbOfKnown) {
            return false;
        }
        if (this.stbc != other.stbc) {
            return false;
        }
        if (this.stbcKnown != other.stbcKnown) {
            return false;
        }
        if (this.thirdMsbOfKnown != other.thirdMsbOfKnown) {
            return false;
        }
        if (this.txopPsNotAllowed != other.txopPsNotAllowed) {
            return false;
        }
        if (this.txopPsNotAllowedKnown != other.txopPsNotAllowedKnown) {
            return false;
        }
        return this.unusedInCoding == other.unusedInCoding;
    }

    public static final class Builder {
        private boolean stbcKnown;
        private boolean txopPsNotAllowedKnown;
        private boolean guardIntervalKnown;
        private boolean shortGiNsymDisambiguationKnown;
        private boolean ldpcExtraOfdmSymbolKnown;
        private boolean beamformedKnown;
        private boolean bandwidthKnown;
        private boolean groupIdKnown;
        private boolean partialAidKnown;
        private boolean seventhMsbOfKnown;
        private boolean sixthMsbOfKnown;
        private boolean fifthMsbOfKnown;
        private boolean fourthMsbOfKnown;
        private boolean thirdMsbOfKnown;
        private boolean secondMsbOfKnown;
        private boolean msbOfKnown;
        private boolean stbc;
        private boolean txopPsNotAllowed;
        private boolean shortGuardInterval;
        private boolean shortGiNsymDisambiguation;
        private boolean ldpcExtraOfdmSymbol;
        private boolean beamformed;
        private boolean secondMsbOfFlags;
        private boolean msbOfFlags;
        private RadiotapVhtBandwidth bandwidth;
        private byte[] mcses;
        private byte[] nsses;
        private RadiotapFecType[] fecTypes;
        private byte unusedInCoding;
        private byte groupId;
        private short partialAid;

        public Builder() {
        }

        private Builder(RadiotapDataVht obj) {
            this.stbcKnown = obj.stbcKnown;
            this.txopPsNotAllowedKnown = obj.txopPsNotAllowedKnown;
            this.guardIntervalKnown = obj.guardIntervalKnown;
            this.shortGiNsymDisambiguationKnown = obj.shortGiNsymDisambiguationKnown;
            this.ldpcExtraOfdmSymbolKnown = obj.ldpcExtraOfdmSymbolKnown;
            this.beamformedKnown = obj.beamformedKnown;
            this.bandwidthKnown = obj.bandwidthKnown;
            this.groupIdKnown = obj.groupIdKnown;
            this.partialAidKnown = obj.partialAidKnown;
            this.seventhMsbOfKnown = obj.seventhMsbOfKnown;
            this.sixthMsbOfKnown = obj.sixthMsbOfKnown;
            this.fifthMsbOfKnown = obj.fifthMsbOfKnown;
            this.fourthMsbOfKnown = obj.fourthMsbOfKnown;
            this.thirdMsbOfKnown = obj.thirdMsbOfKnown;
            this.secondMsbOfKnown = obj.secondMsbOfKnown;
            this.msbOfKnown = obj.msbOfKnown;
            this.stbc = obj.stbc;
            this.txopPsNotAllowed = obj.txopPsNotAllowed;
            this.shortGuardInterval = obj.shortGuardInterval;
            this.shortGiNsymDisambiguation = obj.shortGiNsymDisambiguation;
            this.ldpcExtraOfdmSymbol = obj.ldpcExtraOfdmSymbol;
            this.beamformed = obj.beamformed;
            this.secondMsbOfFlags = obj.secondMsbOfFlags;
            this.msbOfFlags = obj.msbOfFlags;
            this.bandwidth = obj.bandwidth;
            this.mcses = obj.mcses;
            this.nsses = obj.nsses;
            this.fecTypes = obj.fecTypes;
            this.unusedInCoding = obj.unusedInCoding;
            this.groupId = obj.groupId;
            this.partialAid = obj.partialAid;
        }

        public Builder stbcKnown(boolean stbcKnown) {
            this.stbcKnown = stbcKnown;
            return this;
        }

        public Builder txopPsNotAllowedKnown(boolean txopPsNotAllowedKnown) {
            this.txopPsNotAllowedKnown = txopPsNotAllowedKnown;
            return this;
        }

        public Builder guardIntervalKnown(boolean guardIntervalKnown) {
            this.guardIntervalKnown = guardIntervalKnown;
            return this;
        }

        public Builder shortGiNsymDisambiguationKnown(boolean shortGiNsymDisambiguationKnown) {
            this.shortGiNsymDisambiguationKnown = shortGiNsymDisambiguationKnown;
            return this;
        }

        public Builder ldpcExtraOfdmSymbolKnown(boolean ldpcExtraOfdmSymbolKnown) {
            this.ldpcExtraOfdmSymbolKnown = ldpcExtraOfdmSymbolKnown;
            return this;
        }

        public Builder beamformedKnown(boolean beamformedKnown) {
            this.beamformedKnown = beamformedKnown;
            return this;
        }

        public Builder bandwidthKnown(boolean bandwidthKnown) {
            this.bandwidthKnown = bandwidthKnown;
            return this;
        }

        public Builder groupIdKnown(boolean groupIdKnown) {
            this.groupIdKnown = groupIdKnown;
            return this;
        }

        public Builder partialAidKnown(boolean partialAidKnown) {
            this.partialAidKnown = partialAidKnown;
            return this;
        }

        public Builder seventhMsbOfKnown(boolean seventhMsbOfKnown) {
            this.seventhMsbOfKnown = seventhMsbOfKnown;
            return this;
        }

        public Builder sixthMsbOfKnown(boolean sixthMsbOfKnown) {
            this.sixthMsbOfKnown = sixthMsbOfKnown;
            return this;
        }

        public Builder fifthMsbOfKnown(boolean fifthMsbOfKnown) {
            this.fifthMsbOfKnown = fifthMsbOfKnown;
            return this;
        }

        public Builder fourthMsbOfKnown(boolean fourthMsbOfKnown) {
            this.fourthMsbOfKnown = fourthMsbOfKnown;
            return this;
        }

        public Builder thirdMsbOfKnown(boolean thirdMsbOfKnown) {
            this.thirdMsbOfKnown = thirdMsbOfKnown;
            return this;
        }

        public Builder secondMsbOfKnown(boolean secondMsbOfKnown) {
            this.secondMsbOfKnown = secondMsbOfKnown;
            return this;
        }

        public Builder msbOfKnown(boolean msbOfKnown) {
            this.msbOfKnown = msbOfKnown;
            return this;
        }

        public Builder stbc(boolean stbc) {
            this.stbc = stbc;
            return this;
        }

        public Builder txopPsNotAllowed(boolean txopPsNotAllowed) {
            this.txopPsNotAllowed = txopPsNotAllowed;
            return this;
        }

        public Builder shortGuardInterval(boolean shortGuardInterval) {
            this.shortGuardInterval = shortGuardInterval;
            return this;
        }

        public Builder shortGiNsymDisambiguation(boolean shortGiNsymDisambiguation) {
            this.shortGiNsymDisambiguation = shortGiNsymDisambiguation;
            return this;
        }

        public Builder ldpcExtraOfdmSymbol(boolean ldpcExtraOfdmSymbol) {
            this.ldpcExtraOfdmSymbol = ldpcExtraOfdmSymbol;
            return this;
        }

        public Builder beamformed(boolean beamformed) {
            this.beamformed = beamformed;
            return this;
        }

        public Builder secondMsbOfFlags(boolean secondMsbOfFlags) {
            this.secondMsbOfFlags = secondMsbOfFlags;
            return this;
        }

        public Builder msbOfFlags(boolean msbOfFlags) {
            this.msbOfFlags = msbOfFlags;
            return this;
        }

        public Builder bandwidth(RadiotapVhtBandwidth bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public Builder mcses(byte[] mcses) {
            this.mcses = mcses;
            return this;
        }

        public Builder nsses(byte[] nsses) {
            this.nsses = nsses;
            return this;
        }

        public Builder fecTypes(RadiotapFecType[] fecTypes) {
            this.fecTypes = fecTypes;
            return this;
        }

        public Builder unusedInCoding(byte unusedInCoding) {
            this.unusedInCoding = unusedInCoding;
            return this;
        }

        public Builder groupId(byte groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder partialAid(short partialAid) {
            this.partialAid = partialAid;
            return this;
        }

        public RadiotapDataVht build() {
            return new RadiotapDataVht(this);
        }
    }
}

