/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataMb
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -7237273314471356977L;
    private final DnsDomainName maDName;

    public static DnsRDataMb newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataMb(rawData, offset, length);
    }

    private DnsRDataMb(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.maDName = DnsDomainName.newInstance(rawData, offset, length);
    }

    private DnsRDataMb(Builder builder) {
        if (builder == null || builder.maDName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.maDName: ").append(builder.maDName);
            throw new NullPointerException(sb.toString());
        }
        this.maDName = builder.maDName;
    }

    public DnsDomainName getMaDName() {
        return this.maDName;
    }

    @Override
    public int length() {
        return this.maDName.length();
    }

    @Override
    public byte[] getRawData() {
        return this.maDName.getRawData();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("MB RDATA:").append(ls2).append(indent).append("  MADNAME: ").append(headerRawData != null ? this.maDName.toString(headerRawData) : this.maDName.toString()).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        return this.maDName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataMb other = (DnsRDataMb)obj;
        return this.maDName.equals(other.maDName);
    }

    public static final class Builder {
        private DnsDomainName maDName;

        public Builder() {
        }

        private Builder(DnsRDataMb obj) {
            this.maDName = obj.maDName;
        }

        public Builder maDName(DnsDomainName maDName) {
            this.maDName = maDName;
            return this;
        }

        public DnsRDataMb build() {
            return new DnsRDataMb(this);
        }
    }
}

