/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePartial;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter,
DurationConverter,
PeriodConverter,
IntervalConverter {
    static final StringConverter INSTANCE = new StringConverter();

    protected StringConverter() {
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        String string = (String)object;
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        return dateTimeFormatter.withChronology(chronology).parseMillis(string);
    }

    @Override
    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter.getZone() != null) {
            chronology = chronology.withZone(dateTimeFormatter.getZone());
        }
        long l2 = dateTimeFormatter.withChronology(chronology).parseMillis((String)object);
        return chronology.get(readablePartial, l2);
    }

    @Override
    public long getDurationMillis(Object object) {
        int n2;
        String string = (String)object;
        String string2 = string;
        int n3 = string2.length();
        if (n3 < 4 || string2.charAt(0) != 'P' && string2.charAt(0) != 'p' || string2.charAt(1) != 'T' && string2.charAt(1) != 't' || string2.charAt(n3 - 1) != 'S' && string2.charAt(n3 - 1) != 's') {
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
        string2 = string2.substring(2, n3 - 1);
        int n4 = -1;
        boolean bl2 = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) >= '0' && string2.charAt(i2) <= '9') continue;
            if (i2 == 0 && string2.charAt(0) == '-') {
                bl2 = true;
                continue;
            }
            if (i2 > (bl2 ? 1 : 0) && string2.charAt(i2) == '.' && n4 == -1) {
                n4 = i2;
                continue;
            }
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
        long l2 = 0L;
        long l3 = 0L;
        int n5 = n2 = bl2 ? 1 : 0;
        if (n4 > 0) {
            l3 = Long.parseLong(string2.substring(n2, n4));
            if ((string2 = string2.substring(n4 + 1)).length() != 3) {
                string2 = (string2 + "000").substring(0, 3);
            }
            l2 = Integer.parseInt(string2);
        } else {
            l3 = bl2 ? Long.parseLong(string2.substring(n2, string2.length())) : Long.parseLong(string2);
        }
        if (bl2) {
            return FieldUtils.safeAdd(FieldUtils.safeMultiply(-l3, 1000), -l2);
        }
        return FieldUtils.safeAdd(FieldUtils.safeMultiply(l3, 1000), l2);
    }

    @Override
    public void setInto(ReadWritablePeriod readWritablePeriod, Object object, Chronology chronology) {
        String string = (String)object;
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        readWritablePeriod.clear();
        int n2 = periodFormatter.parseInto(readWritablePeriod, string, 0);
        if (n2 < string.length()) {
            if (n2 < 0) {
                periodFormatter.withParseType(readWritablePeriod.getPeriodType()).parseMutablePeriod(string);
            }
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
    }

    @Override
    public void setInto(ReadWritableInterval readWritableInterval, Object object, Chronology chronology) {
        DateTime dateTime;
        String string = (String)object;
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + string);
        }
        String string2 = string.substring(0, n2);
        if (string2.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string);
        }
        String string3 = string.substring(n2 + 1);
        if (string3.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string);
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        dateTimeFormatter = dateTimeFormatter.withChronology(chronology);
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        long l2 = 0L;
        long l3 = 0L;
        Period period = null;
        Chronology chronology2 = null;
        char c2 = string2.charAt(0);
        if (c2 == 'P' || c2 == 'p') {
            period = periodFormatter.withParseType(this.getPeriodType(string2)).parsePeriod(string2);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string2);
            l2 = dateTime.getMillis();
            chronology2 = dateTime.getChronology();
        }
        c2 = string3.charAt(0);
        if (c2 == 'P' || c2 == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + string);
            }
            period = periodFormatter.withParseType(this.getPeriodType(string3)).parsePeriod(string3);
            chronology = chronology != null ? chronology : chronology2;
            l3 = chronology.add(period, l2, 1);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string3);
            l3 = dateTime.getMillis();
            chronology2 = chronology2 != null ? chronology2 : dateTime.getChronology();
            Chronology chronology3 = chronology = chronology != null ? chronology : chronology2;
            if (period != null) {
                l2 = chronology.add(period, l3, -1);
            }
        }
        readWritableInterval.setInterval(l2, l3);
        readWritableInterval.setChronology(chronology);
    }

    @Override
    public Class<?> getSupportedType() {
        return String.class;
    }
}

