/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.math.BigDecimal;
import java.time.Duration;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ObjectArgument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.postgresql.util.PGInterval;

public class DurationArgumentFactory
extends AbstractArgumentFactory<Duration> {
    public DurationArgumentFactory() {
        super(1111);
    }

    @Override
    public Argument build(Duration duration, ConfigRegistry config) {
        long days;
        Duration d2 = duration;
        boolean isNegative = d2.isNegative();
        if (isNegative) {
            d2 = d2.negated();
        }
        if ((days = d2.toDays()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("duration %s too large to be represented unambiguously as postgres interval", d2));
        }
        d2 = d2.minusDays(days);
        int hours = (int)d2.toHours();
        d2 = d2.minusHours(hours);
        int minutes = (int)d2.toMinutes();
        if ((d2 = d2.minusMinutes(minutes)).getNano() % 1000 != 0) {
            throw new IllegalArgumentException(String.format("duration %s too precise to represented as postgres interval", d2));
        }
        double seconds = BigDecimal.valueOf(d2.getSeconds()).add(BigDecimal.valueOf(d2.getNano()).movePointLeft(9)).doubleValue();
        PGInterval interval = new PGInterval(0, 0, (int)days, hours, minutes, seconds);
        if (isNegative) {
            interval.scale(-1);
        }
        return ObjectArgument.of(interval, 1111);
    }
}

