/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Instant;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.statement.SqlLoggable;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;

class SqlLoggerUtil {
    private SqlLoggerUtil() {
        throw new UtilityClassException();
    }

    static <T> T wrap(SqlLoggable<T> r2, StatementContext ctx, SqlLogger logger) throws SQLException {
        try {
            ctx.setExecutionMoment(Instant.now());
            logger.logBeforeExecution(ctx);
            T result = r2.invoke();
            ctx.setCompletionMoment(Instant.now());
            logger.logAfterExecution(ctx);
            return result;
        }
        catch (SQLException e2) {
            ctx.setExceptionMoment(Instant.now());
            logger.logException(ctx, e2);
            throw e2;
        }
    }
}

