/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.internal.SqlScriptParser;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.SqlStatements;

public class Script
extends SqlStatement<Script> {
    private final Handle handle;
    private final String sql;

    public Script(Handle h2, String sql) {
        super(h2, sql);
        this.handle = h2;
        this.sql = sql;
    }

    public int[] execute() {
        List<String> statements = this.getStatements();
        Batch b2 = this.handle.createBatch();
        statements.forEach(b2::add);
        return b2.execute();
    }

    public void executeAsSeparateStatements() {
        for (String s2 : this.getStatements()) {
            this.handle.execute(s2, new Object[0]);
        }
    }

    public List<String> getStatements() {
        return this.splitToStatements(this.getConfig(SqlStatements.class).getTemplateEngine().render(this.sql, this.getContext()));
    }

    private List<String> splitToStatements(String script) {
        ArrayList<String> statements = new ArrayList<String>();
        String lastStatement = new SqlScriptParser((t2, sb) -> {
            this.addStatement(sb.toString(), statements);
            sb.setLength(0);
        }).parse(CharStreams.fromString(script));
        this.addStatement(lastStatement, statements);
        return statements;
    }

    private void addStatement(String statement, List<String> statements) {
        String trimmedStatement = statement.trim();
        if (trimmedStatement.isEmpty()) {
            return;
        }
        statements.add(trimmedStatement);
    }
}

