/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.BaseStatement;
import org.jdbi.v3.core.statement.SqlLoggerUtil;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch
extends BaseStatement<Batch> {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private final List<String> parts = new ArrayList<String>();

    public Batch(Handle handle) {
        super(handle);
    }

    public Batch add(String sql) {
        this.parts.add(sql);
        return this;
    }

    public int[] execute() {
        if (this.parts.isEmpty()) {
            return new int[0];
        }
        try {
            Statement stmt;
            try {
                stmt = this.getHandle().getStatementBuilder().create(this.getHandle().getConnection(), this.getContext());
                this.addCleanable(stmt::close);
                this.getConfig(SqlStatements.class).customize(stmt);
            }
            catch (SQLException e2) {
                throw new UnableToCreateStatementException(e2, this.getContext());
            }
            LOG.trace("Execute batch [");
            try {
                for (String part : this.parts) {
                    String sql = this.getConfig(SqlStatements.class).getTemplateEngine().render(part, this.getContext());
                    LOG.trace(" {}", (Object)sql);
                    stmt.addBatch(sql);
                }
            }
            catch (SQLException e3) {
                throw new UnableToExecuteStatementException("Unable to configure JDBC statement", e3, this.getContext());
            }
            try {
                Object e2 = SqlLoggerUtil.wrap(stmt::executeBatch, this.getContext(), this.getConfig(SqlStatements.class).getSqlLogger());
                return e2;
            }
            catch (SQLException e4) {
                throw new UnableToExecuteStatementException(Batch.mungeBatchException(e4), this.getContext());
            }
        }
        finally {
            this.close();
        }
    }

    static SQLException mungeBatchException(SQLException e2) {
        for (SQLException next = e2.getNextException(); next != null; next = next.getNextException()) {
            e2.addSuppressed(next);
        }
        return e2;
    }
}

