/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.mapper.reflect.ConstructorInstanceFactory;
import org.jdbi.v3.core.mapper.reflect.InstanceFactory;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.core.mapper.reflect.StaticMethodInstanceFactory;

public class JdbiConstructors {
    private JdbiConstructors() {
        throw new UtilityClassException();
    }

    static <T> InstanceFactory<T> findFactoryFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List explicitConstructors = Stream.of(constructors).filter(constructor -> constructor.isAnnotationPresent(JdbiConstructor.class)).filter(constructor -> !constructor.isSynthetic()).collect(Collectors.toList());
        List explicitFactoryMethods = Stream.of(type.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(JdbiConstructor.class)).collect(Collectors.toList());
        if (explicitConstructors.size() + explicitFactoryMethods.size() > 1) {
            throw new IllegalArgumentException(type + " may have at most one constructor or static factory method annotated @JdbiConstructor");
        }
        if (explicitConstructors.size() == 1) {
            return new ConstructorInstanceFactory((Constructor)explicitConstructors.get(0));
        }
        if (explicitFactoryMethods.size() == 1) {
            return new StaticMethodInstanceFactory<T>(type, (Method)explicitFactoryMethods.get(0));
        }
        return new ConstructorInstanceFactory<T>(JdbiConstructors.findImplicitConstructorFor(type));
    }

    public static <T> Constructor<T> findConstructorFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List annotatedConstructors = Stream.of(constructors).filter(c2 -> c2.isAnnotationPresent(JdbiConstructor.class)).collect(Collectors.toList());
        if (annotatedConstructors.size() > 1) {
            throw new IllegalArgumentException(type + " may have at most one constructor annotated @JdbiConstructor");
        }
        if (annotatedConstructors.size() == 1) {
            return (Constructor)annotatedConstructors.get(0);
        }
        return JdbiConstructors.findImplicitConstructorFor(type);
    }

    private static <T> Constructor<T> findImplicitConstructorFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List annotatedConstructors = Stream.of(constructors).filter(c2 -> c2.isAnnotationPresent(ConstructorProperties.class)).collect(Collectors.toList());
        if (annotatedConstructors.size() > 1) {
            throw new IllegalArgumentException(type + " may have at most one constructor annotated @ConstructorProperties");
        }
        if (annotatedConstructors.size() == 1) {
            return (Constructor)annotatedConstructors.get(0);
        }
        if (constructors.length != 1) {
            throw new IllegalArgumentException(type + " must have exactly one constructor, or specify it with @JdbiConstructor or @ConstructorProperties");
        }
        return constructors[0];
    }
}

