/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnGetter;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.result.UnableToProduceResultException;

class PrimitiveMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    PrimitiveMapperFactory() {
        this.mappers.put(Boolean.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getBoolean));
        this.mappers.put(Byte.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getByte));
        this.mappers.put(Character.TYPE, PrimitiveMapperFactory.primitiveMapper(PrimitiveMapperFactory::getChar));
        this.mappers.put(Short.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getShort));
        this.mappers.put(Integer.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getInt));
        this.mappers.put(Long.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getLong));
        this.mappers.put(Float.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getFloat));
        this.mappers.put(Double.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getDouble));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(rawType));
    }

    private static <T> ColumnMapper<T> primitiveMapper(ColumnGetter<T> getter) {
        return (r2, i2, ctx) -> {
            Object value = getter.get(r2, i2);
            if (r2.wasNull() && !ctx.getConfig(ColumnMappers.class).getCoalesceNullPrimitivesToDefaults()) {
                String msg = String.format("Database null values are not allowed for Java primitives by the current configuration: could not map column %s (%s). Change your result type to a boxed primitive to resolve.", i2, r2.getMetaData().getColumnLabel(i2));
                throw new UnableToProduceResultException(msg);
            }
            return value;
        };
    }

    private static char getChar(ResultSet r2, int i2) throws SQLException {
        Character character = PrimitiveMapperFactory.getCharacter(r2, i2);
        return character == null ? (char)'\u0000' : character.charValue();
    }

    private static Character getCharacter(ResultSet r2, int i2) throws SQLException {
        String s2 = r2.getString(i2);
        if (s2 != null && !s2.isEmpty()) {
            return Character.valueOf(s2.charAt(0));
        }
        return null;
    }
}

