/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

class ArrayColumnMapper
implements ColumnMapper<Object> {
    private static final CopyOnWriteArraySet<Integer> UNSUPPORTED_TYPES = new CopyOnWriteArraySet();
    private final ColumnMapper<?> elementMapper;
    private final Class<?> componentType;

    ArrayColumnMapper(ColumnMapper<?> elementMapper, Class<?> componentType) {
        this.elementMapper = elementMapper;
        this.componentType = componentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object map(ResultSet r2, int columnNumber, StatementContext ctx) throws SQLException {
        java.sql.Array array = r2.getArray(columnNumber);
        if (array == null) {
            return null;
        }
        try {
            Object object = this.buildArray(array, ctx);
            return object;
        }
        finally {
            array.free();
        }
    }

    private Object buildArray(java.sql.Array array, StatementContext ctx) throws SQLException {
        if (!UNSUPPORTED_TYPES.contains(array.getBaseType())) {
            try {
                Object ary = array.getArray();
                if (this.componentType.equals(ary.getClass().getComponentType())) {
                    return ary;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        UNSUPPORTED_TYPES.add(array.getBaseType());
        return this.buildFromResultSet(array, ctx);
    }

    private Object buildFromResultSet(java.sql.Array array, StatementContext ctx) throws SQLException {
        ArrayList list = new ArrayList();
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                list.add(this.elementMapper.map(rs, 2, ctx));
            }
        }
        Object ary = Array.newInstance(this.componentType, list.size());
        if (this.componentType.isPrimitive()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Array.set(ary, i2, list.get(i2));
            }
            return ary;
        }
        return list.toArray((Object[])ary);
    }
}

