/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.DelegatingArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

class OptionalArgumentFactory
extends DelegatingArgumentFactory {
    OptionalArgumentFactory() {
        this.register(OptionalInt.class, 4, (p2, i2, v2) -> {
            if (v2.isPresent()) {
                p2.setInt(i2, v2.getAsInt());
            } else {
                p2.setNull(i2, 4);
            }
        });
        this.register(OptionalLong.class, -5, (p2, i2, v2) -> {
            if (v2.isPresent()) {
                p2.setLong(i2, v2.getAsLong());
            } else {
                p2.setNull(i2, -5);
            }
        });
        this.register(OptionalDouble.class, 8, (p2, i2, v2) -> {
            if (v2.isPresent()) {
                p2.setDouble(i2, v2.getAsDouble());
            } else {
                p2.setNull(i2, 8);
            }
        });
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        if (value instanceof Optional) {
            Object nestedValue = ((Optional)value).orElse(null);
            Type nestedType = OptionalArgumentFactory.findOptionalType(expectedType, nestedValue);
            return config.get(Arguments.class).findFor(nestedType, nestedValue);
        }
        return super.build(expectedType, value, config);
    }

    @Override
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        if (Optional.class.equals(GenericTypes.getErasedType(type))) {
            return config.get(Arguments.class).prepareFor(OptionalArgumentFactory.findOptionalType(type, null)).map(af2 -> opt -> (Argument)af2.apply(((Optional)opt).orElse(null)));
        }
        return super.prepare(type, config);
    }

    private static Type findOptionalType(Type wrapperType, Object nestedValue) {
        Optional<Type> nestedType;
        if (GenericTypes.getErasedType(wrapperType).equals(Optional.class) && (nestedType = GenericTypes.findGenericParameter(wrapperType, Optional.class)).isPresent()) {
            return nestedType.get();
        }
        return nestedValue == null ? Object.class : nestedValue.getClass();
    }
}

