/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.TypedValue;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.StatementContext;

@Deprecated
public class ObjectMethodArguments
extends ObjectPropertyNamedArgumentFinder {
    private static final JdbiCache<Class<?>, Map<String, Function<Object, TypedValue>>> NULLARY_METHOD_CACHE = JdbiCaches.declare(ObjectMethodArguments::load);

    public ObjectMethodArguments(String prefix, Object object) {
        super(prefix, object);
    }

    private static Map<String, Function<Object, TypedValue>> load(ConfigRegistry config, Class<?> type) {
        HashMap<String, Function<Object, TypedValue>> methodMap = new HashMap<String, Function<Object, TypedValue>>();
        if (Modifier.isPublic(type.getModifiers())) {
            Arrays.stream(type.getMethods()).filter(m3 -> m3.getParameterCount() == 0).collect(Collectors.toMap(Method::getName, Function.identity(), ObjectMethodArguments::bridgeMethodMerge)).forEach((name, method) -> {
                QualifiedType<?> qualifiedType = QualifiedType.of(method.getGenericReturnType()).withAnnotations(config.get(Qualifiers.class).findFor((AnnotatedElement)method));
                MethodHandle mh = Unchecked.function(MethodHandles.lookup()::unreflect).apply((Method)method);
                methodMap.put((String)name, Unchecked.function(value -> new TypedValue(qualifiedType, mh.invoke(value))));
            });
        } else {
            Optional.ofNullable(type.getSuperclass()).ifPresent(superclass -> methodMap.putAll(ObjectMethodArguments.load(config, superclass)));
            Arrays.stream(type.getInterfaces()).forEach(interfaceClass -> methodMap.putAll(ObjectMethodArguments.load(config, interfaceClass)));
        }
        return methodMap;
    }

    @Override
    protected Optional<TypedValue> getValue(String name, StatementContext ctx) {
        return this.getter(name, ctx.getConfig()).map(m3 -> (TypedValue)m3.apply(this.obj));
    }

    public Optional<Function<Object, TypedValue>> getter(String name, ConfigRegistry config) {
        return Optional.ofNullable(NULLARY_METHOD_CACHE.get(this.obj.getClass(), config).get(name));
    }

    @Override
    protected NamedArgumentFinder getNestedArgumentFinder(TypedValue value) {
        return new ObjectMethodArguments(null, value.getValue());
    }

    public String toString() {
        return "{lazy object functions arguments \"" + this.obj + "\"";
    }

    private static Method bridgeMethodMerge(Method a2, Method b2) {
        return a2.isBridge() ? b2 : a2;
    }
}

