/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public final class MethodList
implements Iterable<AnnotatedMethod> {
    private AnnotatedMethod[] methods;

    public MethodList(Class<?> c2) {
        this(c2, false);
    }

    public MethodList(Class<?> c2, boolean declaredMethods) {
        this(declaredMethods ? MethodList.getAllDeclaredMethods(c2) : MethodList.getMethods(c2));
    }

    private static List<Method> getAllDeclaredMethods(Class<?> c2) {
        ArrayList<Method> l2 = new ArrayList<Method>();
        while (c2 != null && c2 != Object.class) {
            l2.addAll(AccessController.doPrivileged(ReflectionHelper.getDeclaredMethodsPA(c2)));
            c2 = c2.getSuperclass();
        }
        return l2;
    }

    private static List<Method> getMethods(Class<?> c2) {
        return Arrays.asList(c2.getMethods());
    }

    public MethodList(Collection<Method> methods) {
        ArrayList<AnnotatedMethod> l2 = new ArrayList<AnnotatedMethod>(methods.size());
        for (Method m3 : methods) {
            if (m3.isSynthetic() || m3.getDeclaringClass() == Object.class) continue;
            l2.add(new AnnotatedMethod(m3));
        }
        this.methods = new AnnotatedMethod[l2.size()];
        this.methods = l2.toArray(this.methods);
    }

    public MethodList(Method ... methods) {
        this(Arrays.asList(methods));
    }

    public MethodList(AnnotatedMethod ... methods) {
        this.methods = methods;
    }

    @Override
    public Iterator<AnnotatedMethod> iterator() {
        return Arrays.asList(this.methods).iterator();
    }

    public MethodList isNotPublic() {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                return !Modifier.isPublic(m3.getMethod().getModifiers());
            }
        });
    }

    public MethodList hasNumParams(final int paramCount) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                return m3.getParameterTypes().length == paramCount;
            }
        });
    }

    public MethodList hasReturnType(final Class<?> returnType) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                return m3.getMethod().getReturnType() == returnType;
            }
        });
    }

    public MethodList nameStartsWith(final String prefix) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                return m3.getMethod().getName().startsWith(prefix);
            }
        });
    }

    public <T extends Annotation> MethodList withAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                return m3.getAnnotation(annotation) != null;
            }
        });
    }

    public <T extends Annotation> MethodList withMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                for (Annotation a2 : m3.getAnnotations()) {
                    if (a2.annotationType().getAnnotation(annotation) == null) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public <T extends Annotation> MethodList withoutAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                return m3.getAnnotation(annotation) == null;
            }
        });
    }

    public <T extends Annotation> MethodList withoutMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m3) {
                for (Annotation a2 : m3.getAnnotations()) {
                    if (a2.annotationType().getAnnotation(annotation) == null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public MethodList filter(Filter filter) {
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod m3 : this.methods) {
            if (!filter.keep(m3)) continue;
            result.add(m3);
        }
        return new MethodList(result.toArray(new AnnotatedMethod[result.size()]));
    }

    public static interface Filter {
        public boolean keep(AnnotatedMethod var1);
    }
}

