/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.ws.rs.ProcessingException;
import org.glassfish.jersey.internal.LocalizationMessages;

public class EntityInputStream
extends InputStream {
    private InputStream input;
    private boolean closed = false;

    public static EntityInputStream create(InputStream inputStream2) {
        if (inputStream2 instanceof EntityInputStream) {
            return (EntityInputStream)inputStream2;
        }
        return new EntityInputStream(inputStream2);
    }

    public EntityInputStream(InputStream input) {
        this.input = input;
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.input.read(b2);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        return this.input.read(b2, off, len);
    }

    @Override
    public long skip(long n2) throws IOException {
        return this.input.skip(n2);
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void mark(int readLimit) {
        this.input.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }

    @Override
    public void reset() {
        try {
            this.input.reset();
        }
        catch (IOException ex2) {
            throw new ProcessingException(LocalizationMessages.MESSAGE_CONTENT_BUFFER_RESET_FAILED(), ex2);
        }
    }

    @Override
    public void close() throws ProcessingException {
        InputStream in2 = this.input;
        if (in2 == null) {
            return;
        }
        if (!this.closed) {
            try {
                in2.close();
            }
            catch (IOException ex2) {
                throw new ProcessingException(LocalizationMessages.MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED(), ex2);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public boolean isEmpty() {
        this.ensureNotClosed();
        InputStream in2 = this.input;
        if (in2 == null) {
            return true;
        }
        try {
            PushbackInputStream pbis;
            if (in2.markSupported()) {
                in2.mark(1);
                int i2 = in2.read();
                in2.reset();
                return i2 == -1;
            }
            try {
                if (in2.available() > 0) {
                    return false;
                }
            }
            catch (IOException i2) {
                // empty catch block
            }
            int b2 = in2.read();
            if (b2 == -1) {
                return true;
            }
            if (in2 instanceof PushbackInputStream) {
                pbis = (PushbackInputStream)in2;
            } else {
                pbis = new PushbackInputStream(in2, 1);
                this.input = pbis;
            }
            pbis.unread(b2);
            return false;
        }
        catch (IOException ex2) {
            throw new ProcessingException(ex2);
        }
    }

    public void ensureNotClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException(LocalizationMessages.ERROR_ENTITY_STREAM_CLOSED());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final InputStream getWrappedStream() {
        return this.input;
    }

    public final void setWrappedStream(InputStream wrapped) {
        this.input = wrapped;
    }
}

