/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.jsr166;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.glassfish.jersey.internal.jsr166.Flow;
import org.glassfish.jersey.internal.jsr166.SubmittableFlowPublisher;
import org.glassfish.jersey.internal.jsr166.UnsafeAccessor;
import sun.misc.Contended;
import sun.misc.Unsafe;

public class SubmissionPublisher<T>
implements Flow.Publisher<T>,
SubmittableFlowPublisher<T>,
AutoCloseable {
    static final int BUFFER_CAPACITY_LIMIT = 0x40000000;
    private static final Executor ASYNC_POOL = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();
    BufferedSubscription<T> clients;
    volatile boolean closed;
    volatile Throwable closedException;
    final Executor executor;
    final BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler;
    final int maxBufferCapacity;

    static final int roundCapacity(int cap) {
        int n2 = cap - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return (n2 |= n2 >>> 16) <= 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity, BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> handler) {
        if (executor == null) {
            throw new NullPointerException();
        }
        if (maxBufferCapacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.executor = executor;
        this.onNextHandler = handler;
        this.maxBufferCapacity = SubmissionPublisher.roundCapacity(maxBufferCapacity);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity) {
        this(executor, maxBufferCapacity, null);
    }

    public SubmissionPublisher() {
        this(ASYNC_POOL, Flow.defaultBufferSize(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        BufferedSubscription<T> subscription = new BufferedSubscription<T>(subscriber, this.executor, this.onNextHandler, this.maxBufferCapacity);
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> b2 = this.clients;
            BufferedSubscription<T> pred = null;
            while (true) {
                if (b2 == null) {
                    subscription.onSubscribe();
                    Throwable ex2 = this.closedException;
                    if (ex2 != null) {
                        subscription.onError(ex2);
                        break;
                    }
                    if (this.closed) {
                        subscription.onComplete();
                        break;
                    }
                    if (pred == null) {
                        this.clients = subscription;
                        break;
                    }
                    pred.next = subscription;
                    break;
                }
                BufferedSubscription next = b2.next;
                if (b2.isDisabled()) {
                    b2.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (subscriber.equals(b2.subscriber)) {
                        b2.onError(new IllegalStateException("Duplicate subscribe"));
                        break;
                    }
                    pred = b2;
                }
                b2 = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int submit(T item) {
        boolean complete;
        if (item == null) {
            throw new NullPointerException();
        }
        int lag = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            complete = this.closed;
            BufferedSubscription<T> b2 = this.clients;
            if (!complete) {
                int stat;
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> r2 = null;
                BufferedSubscription<T> rtail = null;
                while (b2 != null) {
                    BufferedSubscription next = b2.next;
                    stat = b2.offer(item);
                    if (stat < 0) {
                        b2.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (stat > lag) {
                            lag = stat;
                        } else if (stat == 0) {
                            b2.nextRetry = null;
                            if (rtail == null) {
                                r2 = b2;
                            } else {
                                rtail.nextRetry = b2;
                            }
                            rtail = b2;
                        }
                        pred = b2;
                    }
                    b2 = next;
                }
                while (r2 != null) {
                    BufferedSubscription<T> nextRetry = r2.nextRetry;
                    r2.nextRetry = null;
                    stat = r2.submit(item);
                    if (stat > lag) {
                        lag = stat;
                    } else if (stat < 0 && this.clients == r2) {
                        this.clients = r2.next;
                    }
                    r2 = nextRetry;
                }
            }
        }
        if (complete) {
            throw new IllegalStateException("Closed");
        }
        return lag;
    }

    @Override
    public int offer(T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        return this.doOffer(0L, item, onDrop);
    }

    @Override
    public int offer(T item, long timeout2, TimeUnit unit, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        return this.doOffer(unit.toNanos(timeout2), item, onDrop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int doOffer(long nanos, T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        boolean complete;
        if (item == null) {
            throw new NullPointerException();
        }
        int lag = 0;
        int drops = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            complete = this.closed;
            BufferedSubscription<T> b2 = this.clients;
            if (!complete) {
                int stat;
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> r2 = null;
                BufferedSubscription<T> rtail = null;
                while (b2 != null) {
                    BufferedSubscription next = b2.next;
                    stat = b2.offer(item);
                    if (stat < 0) {
                        b2.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (stat > lag) {
                            lag = stat;
                        } else if (stat == 0) {
                            b2.nextRetry = null;
                            if (rtail == null) {
                                r2 = b2;
                            } else {
                                rtail.nextRetry = b2;
                            }
                            rtail = b2;
                        } else if (stat > lag) {
                            lag = stat;
                        }
                        pred = b2;
                    }
                    b2 = next;
                }
                while (r2 != null) {
                    BufferedSubscription nextRetry = r2.nextRetry;
                    r2.nextRetry = null;
                    int n2 = stat = nanos > 0L ? r2.timedOffer(item, nanos) : r2.offer(item);
                    if (stat == 0 && onDrop != null && onDrop.test(r2.subscriber, item)) {
                        stat = r2.offer(item);
                    }
                    if (stat == 0) {
                        ++drops;
                    } else if (stat > lag) {
                        lag = stat;
                    } else if (stat < 0 && this.clients == r2) {
                        this.clients = r2.next;
                    }
                    r2 = nextRetry;
                }
            }
        }
        if (complete) {
            throw new IllegalStateException("Closed");
        }
        return drops > 0 ? -drops : lag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            BufferedSubscription<T> b2;
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                b2 = this.clients;
                this.clients = null;
                this.closed = true;
            }
            while (b2 != null) {
                BufferedSubscription next = b2.next;
                b2.next = null;
                b2.onComplete();
                b2 = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeExceptionally(Throwable error) {
        if (error == null) {
            throw new NullPointerException();
        }
        if (!this.closed) {
            BufferedSubscription<T> b2;
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                b2 = this.clients;
                this.clients = null;
                this.closed = true;
                this.closedException = error;
            }
            while (b2 != null) {
                BufferedSubscription next = b2.next;
                b2.next = null;
                b2.onError(error);
                b2 = next;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Throwable getClosedException() {
        return this.closedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscribers() {
        boolean nonEmpty = false;
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> b2 = this.clients;
                while (b2 != null) {
                    BufferedSubscription next = b2.next;
                    if (b2.isDisabled()) {
                        b2.next = null;
                        this.clients = next;
                        b2 = this.clients;
                        continue;
                    }
                    nonEmpty = true;
                    break;
                }
            }
        }
        return nonEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSubscribers() {
        int count = 0;
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> b2 = this.clients;
                while (b2 != null) {
                    BufferedSubscription next = b2.next;
                    if (b2.isDisabled()) {
                        b2.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        pred = b2;
                        ++count;
                    }
                    b2 = next;
                }
            }
        }
        return count;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public int getMaxBufferCapacity() {
        return this.maxBufferCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Flow.Subscriber<? super T>> getSubscribers() {
        ArrayList<Flow.Subscriber<T>> subs = new ArrayList<Flow.Subscriber<T>>();
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            Object pred = null;
            BufferedSubscription<T> b2 = this.clients;
            while (b2 != null) {
                BufferedSubscription next = b2.next;
                if (b2.isDisabled()) {
                    b2.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    subs.add(b2.subscriber);
                }
                b2 = next;
            }
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        if (!this.closed) {
            SubmissionPublisher submissionPublisher = this;
            synchronized (submissionPublisher) {
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> b2 = this.clients;
                while (b2 != null) {
                    BufferedSubscription next = b2.next;
                    if (b2.isDisabled()) {
                        b2.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        if (subscriber.equals(b2.subscriber)) {
                            return true;
                        }
                        pred = b2;
                    }
                    b2 = next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long estimateMinimumDemand() {
        long min2 = Long.MAX_VALUE;
        boolean nonEmpty = false;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b2 = this.clients;
            while (b2 != null) {
                BufferedSubscription next = b2.next;
                int n2 = b2.estimateLag();
                if (n2 < 0) {
                    b2.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    long d2 = b2.demand - (long)n2;
                    if (d2 < min2) {
                        min2 = d2;
                    }
                    nonEmpty = true;
                    pred = b2;
                }
                b2 = next;
            }
        }
        return nonEmpty ? min2 : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int estimateMaximumLag() {
        int max = 0;
        SubmissionPublisher submissionPublisher = this;
        synchronized (submissionPublisher) {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b2 = this.clients;
            while (b2 != null) {
                BufferedSubscription next = b2.next;
                int n2 = b2.estimateLag();
                if (n2 < 0) {
                    b2.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (n2 > max) {
                        max = n2;
                    }
                    pred = b2;
                }
                b2 = next;
            }
        }
        return max;
    }

    @Override
    public CompletableFuture<Void> consume(Consumer<? super T> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> status = new CompletableFuture<Void>();
        this.subscribe(new ConsumerSubscriber<T>(status, consumer));
        return status;
    }

    @Contended
    private static final class BufferedSubscription<T>
    implements Flow.Subscription,
    ForkJoinPool.ManagedBlocker {
        long timeout;
        volatile long demand;
        int maxCapacity;
        int putStat;
        volatile int ctl;
        volatile int head;
        int tail;
        Object[] array;
        Flow.Subscriber<? super T> subscriber;
        Executor executor;
        BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler;
        volatile Throwable pendingError;
        volatile Thread waiter;
        T putItem;
        BufferedSubscription<T> next;
        BufferedSubscription<T> nextRetry;
        static final int ACTIVE = 1;
        static final int CONSUME = 2;
        static final int DISABLED = 4;
        static final int ERROR = 8;
        static final int SUBSCRIBE = 16;
        static final int COMPLETE = 32;
        static final long INTERRUPTED = -1L;
        static final int DEFAULT_INITIAL_CAP = 32;
        private static final Unsafe U = UnsafeAccessor.getUnsafe();
        private static final long CTL;
        private static final long TAIL;
        private static final long HEAD;
        private static final long DEMAND;
        private static final int ABASE;
        private static final int ASHIFT;

        BufferedSubscription(Flow.Subscriber<? super T> subscriber, Executor executor, BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler, int maxBufferCapacity) {
            this.subscriber = subscriber;
            this.executor = executor;
            this.onNextHandler = onNextHandler;
            this.maxCapacity = maxBufferCapacity;
            this.array = new Object[maxBufferCapacity < 32 ? (maxBufferCapacity < 2 ? 2 : maxBufferCapacity) : 32];
        }

        public String toString() {
            if (this.subscriber != null) {
                return this.subscriber.toString();
            }
            return super.toString();
        }

        final boolean isDisabled() {
            return this.ctl == 4;
        }

        final int estimateLag() {
            int n2;
            return this.ctl == 4 ? -1 : ((n2 = this.tail - this.head) > 0 ? n2 : 0);
        }

        final int offer(T item) {
            int stat;
            int size;
            int cap;
            int h2 = this.head;
            int t2 = this.tail;
            Object[] a2 = this.array;
            if (a2 != null && (cap = a2.length) > 0 && cap >= (size = t2 + 1 - h2)) {
                a2[cap - 1 & t2] = item;
                this.tail = t2 + 1;
                stat = size;
            } else {
                stat = this.growAndAdd(a2, item);
            }
            return stat > 0 && (this.ctl & 3) != 3 ? this.startOnOffer(stat) : stat;
        }

        private int growAndAdd(Object[] a2, T item) {
            boolean alloc;
            int stat;
            int cap;
            if ((this.ctl & 0xC) != 0) {
                cap = 0;
                stat = -1;
                alloc = false;
            } else if (a2 == null || (cap = a2.length) <= 0) {
                cap = 0;
                stat = 1;
                alloc = true;
            } else {
                U.fullFence();
                int h2 = this.head;
                int t2 = this.tail;
                int size = t2 + 1 - h2;
                if (cap >= size) {
                    a2[cap - 1 & t2] = item;
                    this.tail = t2 + 1;
                    stat = size;
                    alloc = false;
                } else if (cap >= this.maxCapacity) {
                    stat = 0;
                    alloc = false;
                } else {
                    stat = cap + 1;
                    alloc = true;
                }
            }
            if (alloc) {
                int newCap;
                int n2 = newCap = cap > 0 ? cap << 1 : 1;
                if (newCap <= cap) {
                    stat = 0;
                } else {
                    Object[] newArray = null;
                    try {
                        newArray = new Object[newCap];
                    }
                    catch (Throwable size) {
                        // empty catch block
                    }
                    if (newArray == null) {
                        if (cap > 0) {
                            this.maxCapacity = cap;
                        }
                        stat = 0;
                    } else {
                        this.array = newArray;
                        int t3 = this.tail;
                        int newMask = newCap - 1;
                        if (a2 != null && cap > 0) {
                            int mask = cap - 1;
                            for (int j2 = this.head; j2 != t3; ++j2) {
                                long k2 = ((long)(j2 & mask) << ASHIFT) + (long)ABASE;
                                Object x2 = U.getObjectVolatile(a2, k2);
                                if (x2 == null || !U.compareAndSwapObject(a2, k2, x2, null)) continue;
                                newArray[j2 & newMask] = x2;
                            }
                        }
                        newArray[t3 & newMask] = item;
                        this.tail = t3 + 1;
                    }
                }
            }
            return stat;
        }

        final int submit(T item) {
            int stat = this.offer(item);
            if (stat == 0) {
                this.putItem = item;
                this.timeout = 0L;
                this.putStat = 0;
                stat = this.putStat;
                if (stat == 0) {
                    try {
                        ForkJoinPool.managedBlock(this);
                    }
                    catch (InterruptedException ie2) {
                        this.timeout = -1L;
                    }
                    stat = this.putStat;
                }
                if (this.timeout < 0L) {
                    Thread.currentThread().interrupt();
                }
            }
            return stat;
        }

        final int timedOffer(T item, long nanos) {
            int stat = this.offer(item);
            if (stat == 0 && (this.timeout = nanos) > 0L) {
                this.putItem = item;
                this.putStat = 0;
                stat = this.putStat;
                if (stat == 0) {
                    try {
                        ForkJoinPool.managedBlock(this);
                    }
                    catch (InterruptedException ie2) {
                        this.timeout = -1L;
                    }
                    stat = this.putStat;
                }
                if (this.timeout < 0L) {
                    Thread.currentThread().interrupt();
                }
            }
            return stat;
        }

        private int startOnOffer(int stat) {
            block6: {
                Executor e2;
                int c2;
                while (true) {
                    if ((c2 = this.ctl) == 4 || (e2 = this.executor) == null) {
                        stat = -1;
                        break block6;
                    }
                    if ((c2 & 1) != 0) {
                        if ((c2 & 2) == 0 && !U.compareAndSwapInt(this, CTL, c2, c2 | 2)) continue;
                        break block6;
                    }
                    if (this.demand == 0L || this.tail == this.head) break block6;
                    if (U.compareAndSwapInt(this, CTL, c2, c2 | 3)) break;
                }
                try {
                    e2.execute(new ConsumerTask(this));
                }
                catch (Error | RuntimeException ex2) {
                    while (((c2 = this.ctl) & 4) == 0 && (c2 & 1) != 0 && !U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFFE)) {
                    }
                    throw ex2;
                }
            }
            return stat;
        }

        private void signalWaiter(Thread w2) {
            this.waiter = null;
            LockSupport.unpark(w2);
        }

        private void detach() {
            Thread w2 = this.waiter;
            this.executor = null;
            this.subscriber = null;
            this.pendingError = null;
            this.signalWaiter(w2);
        }

        final void onError(Throwable ex2) {
            int c2;
            while (((c2 = this.ctl) & 0xC) == 0) {
                if ((c2 & 1) != 0) {
                    this.pendingError = ex2;
                    if (!U.compareAndSwapInt(this, CTL, c2, c2 | 8)) continue;
                    break;
                }
                if (!U.compareAndSwapInt(this, CTL, c2, 4)) continue;
                Flow.Subscriber<T> s2 = this.subscriber;
                if (s2 != null && ex2 != null) {
                    try {
                        s2.onError(ex2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.detach();
                break;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void startOrDisable() {
            Executor e2 = this.executor;
            if (e2 == null) return;
            try {
                e2.execute(new ConsumerTask(this));
                return;
            }
            catch (Throwable ex2) {
                int c2;
                do {
                    if ((c2 = this.ctl) == 4) return;
                    if ((c2 & 1) != 0) continue;
                    return;
                } while (!U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFFE));
                this.onError(ex2);
                return;
            }
        }

        final void onComplete() {
            int c2;
            while ((c2 = this.ctl) != 4) {
                if (!U.compareAndSwapInt(this, CTL, c2, c2 | 0x23)) continue;
                if ((c2 & 1) != 0) break;
                this.startOrDisable();
                break;
            }
        }

        final void onSubscribe() {
            int c2;
            while ((c2 = this.ctl) != 4) {
                if (!U.compareAndSwapInt(this, CTL, c2, c2 | 0x13)) continue;
                if ((c2 & 1) != 0) break;
                this.startOrDisable();
                break;
            }
        }

        @Override
        public void cancel() {
            int c2;
            while ((c2 = this.ctl) != 4) {
                if ((c2 & 1) != 0) {
                    if (!U.compareAndSwapInt(this, CTL, c2, c2 | 0xA)) continue;
                    break;
                }
                if (!U.compareAndSwapInt(this, CTL, c2, 4)) continue;
                this.detach();
                break;
            }
        }

        @Override
        public void request(long n2) {
            if (n2 > 0L) {
                int c2;
                long d2;
                long prev;
                do {
                    if ((d2 = (prev = this.demand) + n2) >= prev) continue;
                    d2 = Long.MAX_VALUE;
                } while (!U.compareAndSwapLong(this, DEMAND, prev, d2));
                while ((c2 = this.ctl) != 4) {
                    if ((c2 & 1) != 0) {
                        if ((c2 & 2) != 0 || U.compareAndSwapInt(this, CTL, c2, c2 | 2)) {
                            break;
                        }
                    } else {
                        int h2 = this.head;
                        if (h2 != this.tail) {
                            if (U.compareAndSwapInt(this, CTL, c2, c2 | 3)) {
                                this.startOrDisable();
                                break;
                            }
                        } else if (this.head == h2 && this.tail == h2) break;
                    }
                    if (this.demand != 0L) continue;
                    break;
                }
            } else if (n2 < 0L) {
                this.onError(new IllegalArgumentException("negative subscription request"));
            }
        }

        @Override
        public final boolean isReleasable() {
            T item = this.putItem;
            if (item != null) {
                this.putStat = this.offer(item);
                if (this.putStat == 0) {
                    return false;
                }
                this.putItem = null;
            }
            return true;
        }

        @Override
        public final boolean block() {
            T item = this.putItem;
            if (item != null) {
                long deadline;
                this.putItem = null;
                long nanos = this.timeout;
                long l2 = deadline = nanos > 0L ? System.nanoTime() + nanos : 0L;
                while ((this.putStat = this.offer(item)) == 0) {
                    if (Thread.interrupted()) {
                        this.timeout = -1L;
                        if (nanos <= 0L) continue;
                        break;
                    }
                    if (nanos > 0L && (nanos = deadline - System.nanoTime()) <= 0L) break;
                    if (this.waiter == null) {
                        this.waiter = Thread.currentThread();
                        continue;
                    }
                    if (nanos > 0L) {
                        LockSupport.parkNanos(this, nanos);
                    } else {
                        LockSupport.park(this);
                    }
                    this.waiter = null;
                }
            }
            this.waiter = null;
            return true;
        }

        final void consume() {
            int h2 = this.head;
            Flow.Subscriber<Object> s2 = this.subscriber;
            if (s2 != null) {
                while (true) {
                    long i2;
                    Object x2;
                    int n2;
                    long d2 = this.demand;
                    int c2 = this.ctl;
                    if ((c2 & 0x1C) != 0) {
                        if (this.checkControl(s2, c2)) continue;
                        break;
                    }
                    Object[] a2 = this.array;
                    if (this.array == null || h2 == this.tail || (n2 = a2.length) == 0 || (x2 = U.getObjectVolatile(a2, i2 = ((long)(n2 - 1 & h2) << ASHIFT) + (long)ABASE)) == null) {
                        if (this.checkEmpty(s2, c2)) continue;
                        break;
                    }
                    if (d2 == 0L) {
                        if (this.checkDemand(c2)) continue;
                        break;
                    }
                    if ((c2 & 2) == 0 && !U.compareAndSwapInt(this, CTL, c2, c2 | 2) || !U.compareAndSwapObject(a2, i2, x2, null)) continue;
                    U.putOrderedInt(this, HEAD, ++h2);
                    U.getAndAddLong(this, DEMAND, -1L);
                    Thread w2 = this.waiter;
                    if (w2 != null) {
                        this.signalWaiter(w2);
                    }
                    try {
                        Object y2 = x2;
                        s2.onNext(y2);
                    }
                    catch (Throwable ex2) {
                        this.handleOnNext(s2, ex2);
                    }
                }
            }
        }

        private boolean checkControl(Flow.Subscriber<? super T> s2, int c2) {
            boolean stat = true;
            if ((c2 & 0x10) != 0) {
                if (U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFEF)) {
                    try {
                        if (s2 != null) {
                            s2.onSubscribe(this);
                        }
                    }
                    catch (Throwable ex2) {
                        this.onError(ex2);
                    }
                }
            } else if ((c2 & 8) != 0) {
                Throwable ex3 = this.pendingError;
                this.ctl = 4;
                if (ex3 != null) {
                    try {
                        if (s2 != null) {
                            s2.onError(ex3);
                        }
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.detach();
                stat = false;
            }
            return stat;
        }

        private boolean checkEmpty(Flow.Subscriber<? super T> s2, int c2) {
            boolean stat = true;
            if (this.head == this.tail) {
                if ((c2 & 2) != 0) {
                    U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFFD);
                } else if ((c2 & 0x20) != 0) {
                    if (U.compareAndSwapInt(this, CTL, c2, 4)) {
                        try {
                            if (s2 != null) {
                                s2.onComplete();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                } else if (U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFFE)) {
                    stat = false;
                }
            }
            return stat;
        }

        private boolean checkDemand(int c2) {
            boolean stat = true;
            if (this.demand == 0L) {
                if ((c2 & 2) != 0) {
                    U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFFD);
                } else if (U.compareAndSwapInt(this, CTL, c2, c2 & 0xFFFFFFFE)) {
                    stat = false;
                }
            }
            return stat;
        }

        private void handleOnNext(Flow.Subscriber<? super T> s2, Throwable ex2) {
            BiConsumer<Flow.Subscriber<Flow.Subscriber<? super T>>, Throwable> h2 = this.onNextHandler;
            if (h2 != null) {
                try {
                    h2.accept(s2, ex2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.onError(ex2);
        }

        static {
            try {
                CTL = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("ctl"));
                TAIL = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("tail"));
                HEAD = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("head"));
                DEMAND = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("demand"));
                ABASE = U.arrayBaseOffset(Object[].class);
                int scale = U.arrayIndexScale(Object[].class);
                if ((scale & scale - 1) != 0) {
                    throw new Error("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            }
            catch (ReflectiveOperationException e2) {
                throw new Error(e2);
            }
            Class<LockSupport> clazz = LockSupport.class;
        }
    }

    static final class ConsumerTask<T>
    extends ForkJoinTask<Void>
    implements Runnable,
    CompletableFuture.AsynchronousCompletionTask {
        final BufferedSubscription<T> consumer;

        ConsumerTask(BufferedSubscription<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v2) {
        }

        @Override
        public final boolean exec() {
            this.consumer.consume();
            return false;
        }

        @Override
        public final void run() {
            this.consumer.consume();
        }
    }

    private static final class ConsumerSubscriber<T>
    implements Flow.Subscriber<T> {
        final CompletableFuture<Void> status;
        final Consumer<? super T> consumer;
        Flow.Subscription subscription;

        ConsumerSubscriber(CompletableFuture<Void> status, Consumer<? super T> consumer) {
            this.status = status;
            this.consumer = consumer;
        }

        @Override
        public final void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.status.whenComplete((v2, e2) -> subscription.cancel());
            if (!this.status.isDone()) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public final void onError(Throwable ex2) {
            this.status.completeExceptionally(ex2);
        }

        @Override
        public final void onComplete() {
            this.status.complete(null);
        }

        @Override
        public final void onNext(T item) {
            try {
                this.consumer.accept(item);
            }
            catch (Throwable ex2) {
                this.subscription.cancel();
                this.status.completeExceptionally(ex2);
            }
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r2) {
            new Thread(r2).start();
        }
    }
}

